/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration$callable$create;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration$callable$edit;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration$callable$saveVirtualTPACertificate;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfigurationFile;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration_Base;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentController;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentImplementation;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentConfigurationBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ForwardPaymentConfiguration
extends ForwardPaymentConfiguration_Base {
    private static final Logger logger;
    public static final Advice advice$edit;
    public static final Advice advice$saveVirtualTPACertificate;
    public static final Advice advice$create;

    private ForwardPaymentConfiguration() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    private ForwardPaymentConfiguration(FinantialInstitution finantialInstitution, ForwardPaymentConfigurationBean bean) {
        this();
        this.setFinantialInstitution(finantialInstitution);
        this.setActive(bean.isActive());
        this.setName(bean.getName());
        this.setPaymentURL(bean.getPaymentURL());
        this.setReturnURL(bean.getReturnURL());
        this.setVirtualTPAMOXXURL(bean.getVirtualTPAMOXXURL());
        this.setVirtualTPAMerchantId(bean.getVirtualTPAMerchantId());
        this.setVirtualTPAId(bean.getVirtualTPAId());
        this.setVirtualTPAKeyStoreName(bean.getVirtualTPAKeyStoreName());
        this.setVirtualTPACertificateAlias(bean.getVirtualTPACertificateAlias());
        this.setVirtualTPACertificatePassword(bean.getVirtualTPACertificatePassword());
        this.setImplementation(bean.getImplementation());
        this.setPaylineMerchantId(bean.getPaylineMerchantId());
        this.setPaylineMerchantAccessKey(bean.getPaylineMerchantAccessKey());
        this.setPaylineContractNumber(bean.getPaylineContractNumber());
        this.setSeries(bean.getSeries());
        this.setPaymentMethod(bean.getPaymentMethod());
        this.setReimbursementPolicyJspFile(bean.getReimbursementPolicyJspFile());
        this.setPrivacyPolicyJspFile(bean.getPrivacyPolicyJspFile());
        this.setLogosJspPageFile(bean.getLogosJspPageFile());
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.ForwardPaymentConfiguration.finantialInstitution.required", new String[0]);
        }
        if (ForwardPaymentConfiguration.findActive(this.getFinantialInstitution()).count() > 1L) {
            throw new TreasuryDomainException("error.ForwardPaymentConfiguration.finantialInstitution.only.one.active.allowed", new String[0]);
        }
    }

    public void edit(ForwardPaymentConfigurationBean forwardPaymentConfigurationBean) {
        Object object = advice$edit.perform((Callable)new ForwardPaymentConfiguration$callable$edit(this, forwardPaymentConfigurationBean));
    }

    static /* synthetic */ void advised$edit(ForwardPaymentConfiguration this_, ForwardPaymentConfigurationBean bean) {
        this_.setActive(bean.isActive());
        this_.setName(bean.getName());
        this_.setPaymentURL(bean.getPaymentURL());
        this_.setReturnURL(bean.getReturnURL());
        this_.setVirtualTPAMOXXURL(bean.getVirtualTPAMOXXURL());
        this_.setVirtualTPAMerchantId(bean.getVirtualTPAMerchantId());
        this_.setVirtualTPAId(bean.getVirtualTPAId());
        this_.setVirtualTPAKeyStoreName(bean.getVirtualTPAKeyStoreName());
        this_.setVirtualTPACertificateAlias(bean.getVirtualTPACertificateAlias());
        this_.setVirtualTPACertificatePassword(bean.getVirtualTPACertificatePassword());
        this_.setImplementation(bean.getImplementation());
        this_.setPaylineMerchantId(bean.getPaylineMerchantId());
        this_.setPaylineMerchantAccessKey(bean.getPaylineMerchantAccessKey());
        this_.setPaylineContractNumber(bean.getPaylineContractNumber());
        this_.setSeries(bean.getSeries());
        this_.setPaymentMethod(bean.getPaymentMethod());
        this_.setReimbursementPolicyJspFile(bean.getReimbursementPolicyJspFile());
        this_.setPrivacyPolicyJspFile(bean.getPrivacyPolicyJspFile());
        this_.setLogosJspPageFile(bean.getLogosJspPageFile());
        this_.checkRules();
    }

    public void saveVirtualTPACertificate(String string, byte[] byArray) {
        Object object = advice$saveVirtualTPACertificate.perform((Callable)new ForwardPaymentConfiguration$callable$saveVirtualTPACertificate(this, string, byArray));
    }

    static /* synthetic */ void advised$saveVirtualTPACertificate(ForwardPaymentConfiguration this_, String filename, byte[] contents) {
        if (this_.getVirtualTPACertificate() != null) {
            ForwardPaymentConfigurationFile virtualTPACertificate = this_.getVirtualTPACertificate();
            this_.setVirtualTPACertificate(null);
            virtualTPACertificate.delete();
        }
        ForwardPaymentConfigurationFile file = ForwardPaymentConfigurationFile.create(filename, contents);
        this_.setVirtualTPACertificate(file);
    }

    public boolean isActive() {
        return this.getActive();
    }

    public boolean isLogosPageDefined() {
        return !Strings.isNullOrEmpty((String)this.implementation().getLogosJspPage(this));
    }

    public boolean isReimbursementPolicyTextDefined() {
        return !Strings.isNullOrEmpty((String)this.getReimbursementPolicyJspFile());
    }

    public boolean isPrivacyPolicyTextDefined() {
        return !Strings.isNullOrEmpty((String)this.getPrivacyPolicyJspFile());
    }

    public String formattedAmount(ForwardPayment forwardPayment) {
        return this.implementation().getFormattedAmount(forwardPayment);
    }

    public IForwardPaymentController getForwardPaymentController(ForwardPayment forwardPayment) {
        return this.implementation().getForwardPaymentController(forwardPayment);
    }

    public IForwardPaymentImplementation implementation() {
        try {
            return (IForwardPaymentImplementation)Class.forName(this.getImplementation()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getImplementationCode() {
        try {
            return this.implementation().getImplementationCode();
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static ForwardPaymentConfiguration create(FinantialInstitution finantialInstitution, ForwardPaymentConfigurationBean forwardPaymentConfigurationBean) {
        return (ForwardPaymentConfiguration)((Object)advice$create.perform((Callable)new ForwardPaymentConfiguration$callable$create(finantialInstitution, forwardPaymentConfigurationBean)));
    }

    static /* synthetic */ ForwardPaymentConfiguration advised$create(FinantialInstitution finantialInstitution, ForwardPaymentConfigurationBean bean) {
        return new ForwardPaymentConfiguration(finantialInstitution, bean);
    }

    public static Stream<ForwardPaymentConfiguration> findAll() {
        return FenixFramework.getDomainRoot().getForwardPaymentConfigurationsSet().stream();
    }

    public static Stream<ForwardPaymentConfiguration> find(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getForwardPaymentConfigurationsSet().stream();
    }

    public static Stream<ForwardPaymentConfiguration> findActive(FinantialInstitution finantialInstitution) {
        return ForwardPaymentConfiguration.find(finantialInstitution).filter(e -> e.isActive());
    }

    public static Optional<ForwardPaymentConfiguration> findUniqueActive(FinantialInstitution finantialInstitution) {
        return ForwardPaymentConfiguration.findActive(finantialInstitution).findFirst();
    }

    public static boolean isActive(FinantialInstitution finantialInstitution) {
        if (!ForwardPaymentConfiguration.findUniqueActive(finantialInstitution).isPresent()) {
            return false;
        }
        return ForwardPaymentConfiguration.findUniqueActive(finantialInstitution).get().isActive();
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$saveVirtualTPACertificate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(ForwardPaymentConfiguration.class);
    }
}

