/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$annulDebitEntry;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$annulOnEvent;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$clearInterestRate;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$createInterestRateDebitEntry;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$creditDebitEntry;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$markAcademicalActBlockingSuspension;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$markBlockAcademicActsOnDebt;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$removeFromDocument;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$revertEventAnnuled;
import org.fenixedu.treasury.domain.document.DebitEntry_Base;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.FinantialEntryType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.SettlementNote_Base;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DebitEntry
extends DebitEntry_Base {
    public static final Comparator<DebitEntry> COMPARE_BY_OPEN_AMOUNT_WITH_VAT;
    public static final Comparator<DebitEntry> COMPARE_BY_DUE_DATE;
    public static final Comparator<DebitEntry> COMPARE_BY_EVENT_ANNULED_AND_BY_DATE;
    public static final Comparator<DebitEntry> COMPARE_BY_EVENT_ANNULED_AND_DUE_DATE;
    public static Comparator<DebitEntry> COMPARE_BY_EXTERNAL_ID;
    public static final Advice advice$createInterestRateDebitEntry;
    public static final Advice advice$markAcademicalActBlockingSuspension;
    public static final Advice advice$markBlockAcademicActsOnDebt;
    public static final Advice advice$annulOnEvent;
    public static final Advice advice$revertEventAnnuled;
    public static final Advice advice$clearInterestRate;
    public static final Advice advice$annulDebitEntry;
    public static final Advice advice$creditDebitEntry;
    public static final Advice advice$removeFromDocument;

    protected DebitEntry(DebitNote debitNote, DebtAccount debtAccount, TreasuryEvent treasuryEvent, Vat vat, BigDecimal amount, LocalDate dueDate, Map<String, String> propertiesMap, Product product, String description, BigDecimal quantity, InterestRate interestRate, DateTime entryDateTime) {
        this.init(debitNote, debtAccount, treasuryEvent, product, vat, amount, dueDate, propertiesMap, description, quantity, interestRate, entryDateTime);
    }

    public boolean isDebitNoteEntry() {
        return true;
    }

    public boolean isDeletable() {
        ArrayList blockers = Lists.newArrayList();
        this.checkForDeletionBlockers(blockers);
        return blockers.isEmpty();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        this.getInterestDebitEntriesSet().stream().forEach(ide -> ide.checkForDeletionBlockers(blockers));
        if (!this.getCreditEntriesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.FenixeduTreasuryResources", (String)"error.DebitEntry.cannot.delete.has.creditentries", (String[])new String[0]));
        }
    }

    public void delete() {
        TreasuryDomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        if (this.getTreasuryExemption() != null) {
            this.getTreasuryExemption().delete();
        }
        if (this.getInterestRate() != null) {
            InterestRate oldRate = this.getInterestRate();
            this.setInterestRate(null);
            oldRate.delete();
        }
        this.setDebitEntry(null);
        this.setTreasuryEvent(null);
        this.getPaymentCodesSet().clear();
        super.delete();
    }

    protected void init(FinantialDocument finantialDocument, DebtAccount debtAccount, Product product, FinantialEntryType finantialEntryType, Vat vat, BigDecimal amount, String description, BigDecimal quantity, DateTime entryDateTime) {
        throw new RuntimeException("error.CreditEntry.use.init.without.finantialEntryType");
    }

    protected void init(DebitNote debitNote, DebtAccount debtAccount, TreasuryEvent treasuryEvent, Product product, Vat vat, BigDecimal amount, LocalDate dueDate, Map<String, String> propertiesMap, String description, BigDecimal quantity, InterestRate interestRate, DateTime entryDateTime) {
        super.init((FinantialDocument)((Object)debitNote), debtAccount, product, FinantialEntryType.DEBIT_ENTRY, vat, amount, description, quantity, entryDateTime);
        this.setTreasuryEvent(treasuryEvent);
        this.setDueDate(dueDate);
        this.setPropertiesJsonMap(TreasuryConstants.propertiesMapToJson(propertiesMap));
        this.setExemptedAmount(BigDecimal.ZERO);
        this.setInterestRate(interestRate);
        this.setAcademicalActBlockingSuspension(false);
        this.setBlockAcademicActsOnDebt(false);
        this.checkRules();
    }

    public InterestRateBean calculateAllInterestValue(LocalDate whenToCalculate) {
        if (this.getInterestRate() == null) {
            return new InterestRateBean();
        }
        if (!this.toCalculateInterests(whenToCalculate)) {
            return new InterestRateBean();
        }
        return this.getInterestRate().calculateInterests(whenToCalculate, true);
    }

    public InterestRateBean calculateUndebitedInterestValue(LocalDate whenToCalculate) {
        if (!this.isApplyInterests()) {
            return new InterestRateBean();
        }
        if (!this.toCalculateInterests(whenToCalculate)) {
            return new InterestRateBean();
        }
        InterestRateBean calculateInterest = this.getInterestRate().calculateInterests(whenToCalculate, false);
        calculateInterest.setDescription(TreasuryConstants.treasuryBundle(TreasuryConstants.DEFAULT_LANGUAGE, "label.InterestRateBean.interest.designation", this.getDescription()));
        return calculateInterest;
    }

    public boolean isApplyInterests() {
        return this.getInterestRate() != null;
    }

    private boolean toCalculateInterests(LocalDate whenToCalculate) {
        return !whenToCalculate.isBefore((ReadablePartial)this.getDueDate().plusDays(this.getInterestRate().getNumberOfDaysAfterDueDate()));
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getFinantialDocument() != null && !(this.getFinantialDocument() instanceof DebitNote)) {
            throw new TreasuryDomainException("error.DebitEntry.finantialDocument.not.debit.entry.type", new String[0]);
        }
        if (this.getDebtAccount() == null) {
            throw new TreasuryDomainException("error.DebitEntry.debtAccount.required", new String[0]);
        }
        if (this.getDueDate() == null) {
            throw new TreasuryDomainException("error.DebitEntry.dueDate.required", new String[0]);
        }
        if (this.getEntryDateTime() != null && this.getDueDate().isBefore((ReadablePartial)this.getEntryDateTime().toLocalDate())) {
            throw new TreasuryDomainException("error.DebitEntry.dueDate.invalid", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getDescription())) {
            throw new TreasuryDomainException("error.DebitEntry.description.required", new String[0]);
        }
        if (this.isPositive(this.getExemptedAmount()) && CreditEntry.findActive(this.getTreasuryEvent(), this.getProduct()).filter(c -> c.getDebitEntry() == this).count() > 0L) {
            throw new TreasuryDomainException("error.DebitEntry.exemption.cannot.be.on.debit.entry.and.with.credit.entry.at.same.time", new String[0]);
        }
        if (this.getTreasuryEvent() != null && this.getProduct().isTransferBalanceProduct()) {
            throw new TreasuryDomainException("error.DebitEntry.transferBalanceProduct.cannot.be.associated.to.academic.event", new String[0]);
        }
        if (this.isBlockAcademicActsOnDebt() && this.isAcademicalActBlockingSuspension()) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.suspend.and.also.block.academical.acts.on.debt", new String[0]);
        }
    }

    public boolean isFinantialDocumentRequired() {
        return false;
    }

    public boolean isEventAnnuled() {
        return this.isAnnulled() || this.getEventAnnuled();
    }

    public boolean isIncludedInEvent() {
        return !this.isEventAnnuled();
    }

    public BigDecimal getPendingInterestAmount() {
        return this.getPendingInterestAmount(new LocalDate());
    }

    public BigDecimal getPendingInterestAmount(LocalDate whenToCalculate) {
        return this.calculateUndebitedInterestValue(whenToCalculate).getInterestAmount();
    }

    public boolean isInDebt() {
        return TreasuryConstants.isPositive(this.getOpenAmount());
    }

    public boolean isDueDateExpired(LocalDate when) {
        return this.getDueDate().isBefore((ReadablePartial)when);
    }

    public DebitEntry createInterestRateDebitEntry(InterestRateBean interestRateBean, DateTime dateTime, Optional<DebitNote> optional) {
        return (DebitEntry)((Object)advice$createInterestRateDebitEntry.perform((Callable)new DebitEntry$callable$createInterestRateDebitEntry(this, interestRateBean, dateTime, optional)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ DebitEntry advised$createInterestRateDebitEntry(DebitEntry this_, InterestRateBean interest, DateTime when, Optional debitNote) {
        Product product = TreasurySettings.getInstance().getInterestProduct();
        if (product == null) {
            throw new TreasuryDomainException("error.SettlementNote.need.interest.product", new String[0]);
        }
        FinantialInstitution finantialInstitution = this_.getDebtAccount().getFinantialInstitution();
        Vat vat = Vat.findActiveUnique(product.getVatType(), finantialInstitution, when).orElse(null);
        String entryDescription = interest.getDescription();
        if (Strings.isNullOrEmpty((String)entryDescription)) {
            entryDescription = product.getName().getContent() + "-" + this_.getDescription();
        }
        DebitEntry interestEntry = DebitEntry._create(debitNote, this_.getDebtAccount(), this_.getTreasuryEvent(), vat, interest.getInterestAmount(), when.toLocalDate(), TreasuryConstants.propertiesJsonToMap(this_.getPropertiesJsonMap()), product, entryDescription, BigDecimal.ONE, null, when);
        this_.addInterestDebitEntries(interestEntry);
        return interestEntry;
    }

    public void edit(String description, TreasuryEvent treasuryEvent, LocalDate dueDate, boolean academicalActBlockingSuspension, boolean blockAcademicActsOnDebt) {
        this.setDescription(description);
        this.setTreasuryEvent(treasuryEvent);
        this.setDueDate(dueDate);
        this.setAcademicalActBlockingSuspension(academicalActBlockingSuspension);
        this.setBlockAcademicActsOnDebt(blockAcademicActsOnDebt);
        this.checkRules();
    }

    public boolean isAcademicalActBlockingSuspension() {
        return this.getAcademicalActBlockingSuspension();
    }

    public boolean isBlockAcademicActsOnDebt() {
        return this.getBlockAcademicActsOnDebt();
    }

    public boolean exempt(TreasuryExemption treasuryExemption, BigDecimal amountWithVat) {
        if (treasuryExemption.getTreasuryEvent() != this.getTreasuryEvent()) {
            throw new RuntimeException("wrong call");
        }
        if (treasuryExemption.getProduct() != this.getProduct()) {
            throw new RuntimeException("wrong call");
        }
        if (this.isEventAnnuled()) {
            throw new RuntimeException("error.DebitEntry.is.event.annuled.cannot.be.exempted");
        }
        BigDecimal amountWithoutVat = TreasuryConstants.divide(amountWithVat, BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)this))));
        if (this.isProcessedInClosedDebitNote()) {
            if (!this.getCreditEntriesSet().isEmpty()) {
                return false;
            }
            DateTime now = new DateTime();
            String reason = TreasuryConstants.treasuryBundle("label.TreasuryExemption.credit.entry.exemption.description", this.getDescription(), treasuryExemption.getTreasuryExemptionType().getName().getContent());
            CreditEntry creditEntryFromExemption = this.createCreditEntry(now, this.getDescription(), null, amountWithoutVat, treasuryExemption, null);
            this.closeCreditEntryIfPossible(reason, now, creditEntryFromExemption);
        } else {
            BigDecimal originalAmount = this.getAmount();
            if (TreasuryConstants.isPositive(this.getExemptedAmount())) {
                originalAmount = originalAmount.add(this.getExemptedAmount());
                this.setExemptedAmount(BigDecimal.ZERO);
            }
            this.setAmount(originalAmount.subtract(amountWithoutVat));
            this.setExemptedAmount(amountWithoutVat);
            this.recalculateAmountValues();
            if (this.getTreasuryEvent() != null) {
                this.getTreasuryEvent().invokeSettlementCallbacks();
            }
        }
        this.checkRules();
        return true;
    }

    public CreditEntry createCreditEntry(DateTime documentDate, String description, String documentObservations, BigDecimal amountForCreditWithoutVat, TreasuryExemption treasuryExemption, CreditNote creditNote) {
        DebitNote finantialDocument = (DebitNote)((Object)this.getFinantialDocument());
        if (finantialDocument == null) {
            throw new TreasuryDomainException("error.DebitEntry.createCreditEntry.requires.finantial.document", new String[0]);
        }
        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), finantialDocument.getDocumentNumberSeries().getSeries());
        if (creditNote == null) {
            creditNote = CreditNote.create(this.getDebtAccount(), documentNumberSeries, documentDate, finantialDocument, finantialDocument.getUiDocumentNumber());
        }
        if (!Strings.isNullOrEmpty((String)documentObservations)) {
            creditNote.setDocumentObservations(documentObservations);
        }
        if (!TreasuryConstants.isPositive(amountForCreditWithoutVat)) {
            throw new TreasuryDomainException("error.DebitEntry.createCreditEntry.amountForCredit.not.positive", new String[0]);
        }
        if (treasuryExemption != null) {
            return CreditEntry.createFromExemption(treasuryExemption, (FinantialDocument)((Object)creditNote), description, amountForCreditWithoutVat, new DateTime(), this);
        }
        return CreditEntry.create((FinantialDocument)((Object)creditNote), description, this.getProduct(), this.getVat(), amountForCreditWithoutVat, documentDate, this, BigDecimal.ONE);
    }

    public void closeCreditEntryIfPossible(String reason, DateTime now, CreditEntry creditEntry) {
        DocumentNumberSeries documentNumberSeriesSettlementNote = DocumentNumberSeries.find(FinantialDocumentType.findForSettlementNote(), this.getFinantialDocument().getDocumentNumberSeries().getSeries());
        if (!creditEntry.getFinantialDocument().isPreparing()) {
            return;
        }
        if (!TreasuryConstants.isPositive(this.getOpenAmount())) {
            return;
        }
        if (TreasuryConstants.isLessThan(this.getOpenAmount(), creditEntry.getOpenAmount())) {
            creditEntry.splitCreditEntry(creditEntry.getOpenAmount().subtract(this.getOpenAmount()));
        }
        creditEntry.getFinantialDocument().closeDocument();
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        String reasonDescription = TreasuryConstants.treasuryBundle(TreasuryConstants.DEFAULT_LANGUAGE, "label.TreasuryEvent.credit.by.annulAllDebitEntries.reason", new String[0]);
        SettlementNote settlementNote = SettlementNote.create(this.getDebtAccount(), documentNumberSeriesSettlementNote, now, now, "", null);
        settlementNote.setDocumentObservations(reason + " - [" + loggedUsername + "] " + new DateTime().toString("YYYY-MM-dd HH:mm"));
        SettlementEntry.create((InvoiceEntry)((Object)creditEntry), settlementNote, creditEntry.getOpenAmount(), reasonDescription + ": " + creditEntry.getDescription(), now, false);
        SettlementEntry.create((InvoiceEntry)((Object)this), settlementNote, creditEntry.getOpenAmount(), reasonDescription + ": " + this.getDescription(), now, false);
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && this.getFinantialDocument().isExportedInLegacyERP() != creditEntry.getFinantialDocument().isExportedInLegacyERP()) {
            throw new TreasuryDomainException("error.DebitEntry.closeCreditEntryIfPossible.exportedInLegacyERP.not.same", new String[0]);
        }
        if (((Invoice)((Object)this.getFinantialDocument())).getPayorDebtAccount() != ((Invoice)((Object)this.getFinantialDocument())).getPayorDebtAccount()) {
            throw new TreasuryDomainException("error.DebitEntry.closeCreditEntryIfPossible.payorDebtAccount.not.same", new String[0]);
        }
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && this.getFinantialDocument().isExportedInLegacyERP()) {
            settlementNote.setExportedInLegacyERP(true);
            settlementNote.setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
        }
        settlementNote.closeDocument();
    }

    public boolean isExportedInERPAndInRestrictedPaymentMixingLegacyInvoices() {
        return TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && this.getFinantialDocument() != null && this.getFinantialDocument().isExportedInLegacyERP();
    }

    public BigDecimal getAmountInDebt(LocalDate paymentDate) {
        TreeSet<SettlementEntry> entries = new TreeSet<SettlementEntry>(SettlementEntry.COMPARATOR_BY_ENTRY_DATE_TIME);
        entries.addAll(this.getSettlementEntriesSet());
        BigDecimal amountToPay = this.getAmountWithVat();
        for (SettlementEntry settlementEntry : entries) {
            if (settlementEntry.isAnnulled()) continue;
            if (settlementEntry.getEntryDateTime().toLocalDate().isAfter((ReadablePartial)paymentDate)) break;
            amountToPay = amountToPay.subtract(settlementEntry.getAmount());
        }
        return amountToPay;
    }

    public boolean revertExemptionIfPossible(TreasuryExemption treasuryExemption) {
        if (this.isAnnulled()) {
            return false;
        }
        if (this.isProcessedInClosedDebitNote()) {
            return false;
        }
        if (!treasuryExemption.getDebitEntry().getCreditEntriesSet().isEmpty()) {
            return false;
        }
        this.setAmount(this.getAmount().add(this.getExemptedAmount()));
        this.setExemptedAmount(BigDecimal.ZERO);
        this.recalculateAmountValues();
        this.checkRules();
        return true;
    }

    public void markAcademicalActBlockingSuspension() {
        Object object = advice$markAcademicalActBlockingSuspension.perform((Callable)new DebitEntry$callable$markAcademicalActBlockingSuspension(this));
    }

    static /* synthetic */ void advised$markAcademicalActBlockingSuspension(DebitEntry this_) {
        this_.setAcademicalActBlockingSuspension(true);
    }

    public void markBlockAcademicActsOnDebt() {
        Object object = advice$markBlockAcademicActsOnDebt.perform((Callable)new DebitEntry$callable$markBlockAcademicActsOnDebt(this));
    }

    static /* synthetic */ void advised$markBlockAcademicActsOnDebt(DebitEntry this_) {
        this_.setBlockAcademicActsOnDebt(true);
    }

    public void annulOnEvent() {
        Object object = advice$annulOnEvent.perform((Callable)new DebitEntry$callable$annulOnEvent(this));
    }

    static /* synthetic */ void advised$annulOnEvent(DebitEntry this_) {
        this_.setEventAnnuled(true);
    }

    public void revertEventAnnuled() {
        Object object = advice$revertEventAnnuled.perform((Callable)new DebitEntry$callable$revertEventAnnuled(this));
    }

    static /* synthetic */ void advised$revertEventAnnuled(DebitEntry this_) {
        this_.setEventAnnuled(false);
    }

    public DateTime getLastSettlementDate() {
        Optional<SettlementNote> settlementNote = this.getSettlementEntriesSet().stream().filter(s -> !s.getFinantialDocument().isAnnulled()).map(s -> (SettlementNote)((Object)((Object)((Object)s.getFinantialDocument())))).max(Comparator.comparing(SettlementNote_Base::getPaymentDate));
        if (!settlementNote.isPresent()) {
            return null;
        }
        return settlementNote.get().getPaymentDate();
    }

    public BigDecimal getExemptedAmountWithVat() {
        return this.getExemptedAmount().multiply(BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)this))));
    }

    public DateTime getLastPaymentDate() {
        Optional<SettlementNote> settlementNote = this.getSettlementEntriesSet().stream().filter(s -> !s.getFinantialDocument().isAnnulled() && !((SettlementNote)((Object)((Object)((Object)s.getFinantialDocument())))).getPaymentEntriesSet().isEmpty()).map(s -> (SettlementNote)((Object)((Object)((Object)s.getFinantialDocument())))).max(Comparator.comparing(SettlementNote_Base::getPaymentDate));
        if (!settlementNote.isPresent()) {
            return null;
        }
        return settlementNote.get().getPaymentDate();
    }

    public void editAmount(BigDecimal amount) {
        if (this.isProcessedInClosedDebitNote()) {
            throw new TreasuryDomainException("error.DebitEntry.editAmount.cannot.edit.amount.due.to.closed.in.debit.note", new String[0]);
        }
        if (this.isAnnulled()) {
            throw new TreasuryDomainException("error.DebitEntry.editAmount.cannot.edit.amount.due.to.annuled.state", new String[0]);
        }
        this.setAmount(amount);
        this.recalculateAmountValues();
    }

    public static DebitEntry copyDebitEntry(DebitEntry debitEntryToCopy, DebitNote debitNoteToAssociate, boolean applyExemption) {
        HashMap propertiesMap = Maps.newHashMap((Map)(debitEntryToCopy.getPropertiesMap() != null ? debitEntryToCopy.getPropertiesMap() : Maps.newHashMap()));
        propertiesMap.put(TreasuryEvent.TreasuryEventKeys.COPIED_FROM_DEBIT_ENTRY_ID.getDescriptionI18N().getContent(TreasuryConstants.DEFAULT_LANGUAGE), debitEntryToCopy.getExternalId());
        propertiesMap.put(TreasuryEvent.TreasuryEventKeys.COPY_DEBIT_ENTRY_RESPONSIBLE.getDescriptionI18N().getContent(TreasuryConstants.DEFAULT_LANGUAGE), Authenticate.getUser() != null ? Authenticate.getUser().getUsername() : "");
        DebitEntry result = DebitEntry.create(Optional.ofNullable(debitNoteToAssociate), debitEntryToCopy.getDebtAccount(), debitEntryToCopy.getTreasuryEvent(), debitEntryToCopy.getVat(), debitEntryToCopy.getAmount().add(debitEntryToCopy.getExemptedAmount()), debitEntryToCopy.getDueDate(), propertiesMap, debitEntryToCopy.getProduct(), debitEntryToCopy.getDescription(), debitEntryToCopy.getQuantity(), debitEntryToCopy.getInterestRate(), debitEntryToCopy.getEntryDateTime());
        result.edit(result.getDescription(), result.getTreasuryEvent(), result.getDueDate(), debitEntryToCopy.getAcademicalActBlockingSuspension(), debitEntryToCopy.getBlockAcademicActsOnDebt());
        result.setEventAnnuled(false);
        result.setPayorDebtAccount(debitEntryToCopy.getPayorDebtAccount());
        if (applyExemption && debitEntryToCopy.getTreasuryExemption() != null) {
            TreasuryExemption treasuryExemptionToCopy = debitEntryToCopy.getTreasuryExemption();
            TreasuryExemption.create(treasuryExemptionToCopy.getTreasuryExemptionType(), treasuryExemptionToCopy.getTreasuryEvent(), treasuryExemptionToCopy.getReason(), treasuryExemptionToCopy.getValueToExempt(), result);
        }
        return result;
    }

    public static Stream<? extends DebitEntry> findAll() {
        return FinantialDocumentEntry.findAll().filter(f -> f instanceof DebitEntry).map(DebitEntry.class::cast);
    }

    public static Stream<? extends DebitEntry> find(Customer customer) {
        return customer.getDebtAccountsSet().stream().flatMap(d -> DebitEntry.find(d));
    }

    public static Stream<? extends DebitEntry> find(DebtAccount debtAccount) {
        return debtAccount.getInvoiceEntrySet().stream().filter(i -> i.isDebitNoteEntry()).map(DebitEntry.class::cast);
    }

    public static Stream<? extends DebitEntry> find(DebitNote debitNote) {
        return debitNote.getFinantialDocumentEntriesSet().stream().filter(f -> f instanceof DebitEntry).map(DebitEntry.class::cast);
    }

    public static Stream<? extends DebitEntry> find(TreasuryEvent treasuryEvent) {
        return treasuryEvent.getDebitEntriesSet().stream();
    }

    public static Stream<? extends DebitEntry> findActive(DebtAccount debtAccount, Product product) {
        return DebitEntry.find(debtAccount).filter(d -> d.getProduct() == product && !d.isEventAnnuled());
    }

    public static Stream<? extends DebitEntry> findActive(TreasuryEvent treasuryEvent) {
        return DebitEntry.find(treasuryEvent).filter(d -> !d.isEventAnnuled());
    }

    public static Stream<? extends DebitEntry> findActive(TreasuryEvent treasuryEvent, Product product) {
        return DebitEntry.findActive(treasuryEvent).filter(d -> d.getProduct() == product);
    }

    public static Stream<? extends DebitEntry> findActiveByDescription(TreasuryEvent treasuryEvent, String description, boolean trimmed) {
        return DebitEntry.findActive(treasuryEvent).filter(d -> !trimmed && d.getDescription().equals(description) || trimmed && d.getDescription().trim().equals(description));
    }

    public static Stream<? extends DebitEntry> findEventAnnuled(TreasuryEvent treasuryEvent) {
        return DebitEntry.find(treasuryEvent).filter(d -> d.isEventAnnuled());
    }

    public static Stream<? extends DebitEntry> findEventAnnuled(TreasuryEvent treasuryEvent, Product product) {
        return DebitEntry.findEventAnnuled(treasuryEvent).filter(d -> d.getProduct() == product);
    }

    public static BigDecimal payedAmount(TreasuryEvent treasuryEvent) {
        return DebitEntry.findActive(treasuryEvent).map(d -> d.getPayedAmount()).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
    }

    public static BigDecimal remainingAmountToPay(TreasuryEvent treasuryEvent) {
        return DebitEntry.findActive(treasuryEvent).map(d -> d.getOpenAmount()).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
    }

    public static DebitEntry create(Optional<DebitNote> debitNote, DebtAccount debtAccount, TreasuryEvent treasuryEvent, Vat vat, BigDecimal amount, LocalDate dueDate, Map<String, String> propertiesMap, Product product, String description, BigDecimal quantity, InterestRate interestRate, DateTime entryDateTime) {
        if (!DebitEntry.isDebitEntryCreationAllowed(debtAccount, debitNote, product)) {
            throw new TreasuryDomainException("error.DebitEntry.customer.not.active", new String[0]);
        }
        return DebitEntry._create(debitNote, debtAccount, treasuryEvent, vat, amount, dueDate, propertiesMap, product, description, quantity, interestRate, entryDateTime);
    }

    private static boolean isDebitEntryCreationAllowed(DebtAccount debtAccount, Optional<DebitNote> debitNote, Product product) {
        if (debtAccount.getCustomer().isActive()) {
            return true;
        }
        return debitNote.isPresent() && debitNote.get().getDocumentNumberSeries().getSeries().isRegulationSeries();
    }

    private static DebitEntry _create(Optional<DebitNote> debitNote, DebtAccount debtAccount, TreasuryEvent treasuryEvent, Vat vat, BigDecimal amount, LocalDate dueDate, Map<String, String> propertiesMap, Product product, String description, BigDecimal quantity, InterestRate interestRate, DateTime entryDateTime) {
        DebitEntry entry = new DebitEntry(debitNote.orElse(null), debtAccount, treasuryEvent, vat, amount, dueDate, propertiesMap, product, description, quantity, null, entryDateTime);
        if (interestRate != null) {
            InterestRate.createForDebitEntry(entry, interestRate);
        }
        entry.recalculateAmountValues();
        return entry;
    }

    public void changeInterestRate(InterestRate oldInterestRate) {
        if (this.getInterestRate() != null && this.getInterestRate() != oldInterestRate) {
            oldInterestRate.delete();
        }
        this.checkRules();
    }

    public BigDecimal getTotalCreditedAmount() {
        BigDecimal totalCreditedAmount = BigDecimal.ZERO;
        for (CreditEntry credits : this.getCreditEntriesSet()) {
            if (credits.getFinantialDocument() != null && credits.getFinantialDocument().isAnnulled()) continue;
            totalCreditedAmount = totalCreditedAmount.add(credits.getTotalAmount());
        }
        return this.getCurrency().getValueWithScale(totalCreditedAmount);
    }

    public BigDecimal getAvailableAmountForCredit() {
        return this.getCurrency().getValueWithScale(this.getTotalAmount().subtract(this.getTotalCreditedAmount()));
    }

    public BigDecimal getOpenAmountWithInterests() {
        if (this.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        if (TreasuryConstants.isEqual(this.getOpenAmount(), BigDecimal.ZERO)) {
            return this.getOpenAmount();
        }
        return this.getOpenAmount().add(this.getPendingInterestAmount());
    }

    public void clearInterestRate() {
        Object object = advice$clearInterestRate.perform((Callable)new DebitEntry$callable$clearInterestRate(this));
    }

    static /* synthetic */ void advised$clearInterestRate(DebitEntry this_) {
        if (this_.getInterestRate() != null) {
            this_.getInterestRate().delete();
        }
    }

    public String getERPIntegrationMetadata() {
        String degreeCode = this.getDegreeCode();
        String executionYear = this.getExecutionYearName();
        return "{\"" + (Object)((Object)TreasuryEvent.TreasuryEventKeys.DEGREE_CODE) + "\":\"" + degreeCode + "\",\"" + (Object)((Object)TreasuryEvent.TreasuryEventKeys.EXECUTION_YEAR) + "\":\"" + executionYear + "\"}";
    }

    public String getExecutionYearName() {
        String executionYear = "";
        if (this.getTreasuryEvent() != null && !Strings.isNullOrEmpty((String)this.getTreasuryEvent().getExecutionYearName())) {
            executionYear = this.getTreasuryEvent().getExecutionYearName();
        } else if (this.getPropertiesMap() != null) {
            if (this.getPropertiesMap().containsKey((Object)TreasuryEvent.TreasuryEventKeys.EXECUTION_YEAR)) {
                executionYear = (String)this.getPropertiesMap().get((Object)TreasuryEvent.TreasuryEventKeys.EXECUTION_YEAR);
            } else if (this.getPropertiesMap().containsKey(TreasuryEvent.TreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent())) {
                executionYear = (String)this.getPropertiesMap().get(TreasuryEvent.TreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent());
            }
        }
        return executionYear;
    }

    public String getDegreeCode() {
        String degreeCode = "";
        if (this.getTreasuryEvent() != null && !Strings.isNullOrEmpty((String)this.getTreasuryEvent().getDegreeCode())) {
            degreeCode = this.getTreasuryEvent().getDegreeCode();
        } else if (this.getPropertiesMap() != null) {
            if (this.getPropertiesMap().containsKey((Object)TreasuryEvent.TreasuryEventKeys.DEGREE_CODE)) {
                degreeCode = (String)this.getPropertiesMap().get((Object)TreasuryEvent.TreasuryEventKeys.DEGREE_CODE);
            } else if (this.getPropertiesMap().containsKey(TreasuryEvent.TreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent())) {
                degreeCode = (String)this.getPropertiesMap().get(TreasuryEvent.TreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent());
            }
        }
        return degreeCode;
    }

    public DebitNote getDebitNote() {
        return (DebitNote)((Object)this.getFinantialDocument());
    }

    public void annulDebitEntry(String string) {
        Object object = advice$annulDebitEntry.perform((Callable)new DebitEntry$callable$annulDebitEntry(this, string));
    }

    static /* synthetic */ void advised$annulDebitEntry(DebitEntry this_, String reason) {
        if (this_.isAnnulled()) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.annul.is.already.annuled", new String[0]);
        }
        if (this_.getFinantialDocument() != null) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.annul.with.finantial.document", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)reason)) {
            throw new TreasuryDomainException("error.DebitEntry.annul.debit.entry,requires.reason", new String[0]);
        }
        DebitNote debitNote = DebitNote.create(this_.getDebtAccount(), DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), this_.getDebtAccount().getFinantialInstitution()).get(), new DateTime());
        this_.setFinantialDocument((FinantialDocument)((Object)debitNote));
        debitNote.anullDebitNoteWithCreditNote(reason, false);
    }

    public void creditDebitEntry(BigDecimal bigDecimal, String string) {
        Object object = advice$creditDebitEntry.perform((Callable)new DebitEntry$callable$creditDebitEntry(this, bigDecimal, string));
    }

    static /* synthetic */ void advised$creditDebitEntry(DebitEntry this_, BigDecimal amountToCreditWithVat, String reason) {
        if (this_.isAnnulled()) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.credit.is.already.annuled", new String[0]);
        }
        if (this_.getFinantialDocument() == null || this_.getFinantialDocument().isPreparing()) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.credit.without.or.preparing.finantial.document", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)reason)) {
            throw new TreasuryDomainException("error.DebitEntry.credit.debit.entry.requires.reason", new String[0]);
        }
        if (!TreasuryConstants.isPositive(amountToCreditWithVat)) {
            throw new TreasuryDomainException("error.DebitEntry.credit.debit.entry.amountToCreditWithVat.must.be.positive", new String[0]);
        }
        if (!TreasuryConstants.isLessOrEqualThan(amountToCreditWithVat, this_.getAvailableAmountForCredit())) {
            throw new TreasuryDomainException("error.DebitEntry.credit.debit.entry.amountToCreditWithVat.must.be.less.or.equal.than.amountAvailableForCredit", new String[0]);
        }
        BigDecimal amountForCreditWithoutVat = TreasuryConstants.divide(amountToCreditWithVat, BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)this_))));
        DateTime now = new DateTime();
        CreditEntry creditEntry = this_.createCreditEntry(now, this_.getDescription(), null, amountForCreditWithoutVat, null, null);
        this_.closeCreditEntryIfPossible(reason, now, creditEntry);
        Supplier<Boolean> openCreditEntriesExistsFunc = () -> this.getCreditEntriesSet().stream().filter(c -> TreasuryConstants.isPositive(c.getOpenAmount())).count() > 0L;
        Supplier<Boolean> openDebitEntriesExistsFunc = () -> this.getDebitNote().getDebitEntriesSet().stream().filter(d -> TreasuryConstants.isPositive(d.getOpenAmount())).count() > 0L;
        while (openCreditEntriesExistsFunc.get().booleanValue() && openDebitEntriesExistsFunc.get().booleanValue()) {
            CreditEntry openCreditEntry = this_.getCreditEntriesSet().stream().filter(c -> TreasuryConstants.isPositive(c.getOpenAmount())).findFirst().get();
            DebitEntry openDebitEntry = this_.getDebitNote().getDebitEntriesSet().stream().filter(d -> TreasuryConstants.isPositive(d.getOpenAmount())).filter(d -> TreasuryConstants.isGreaterOrEqualThan(d.getOpenAmount(), openCreditEntry.getOpenAmount())).findFirst().orElse(null);
            if (openDebitEntry == null) {
                openDebitEntry = this_.getDebitNote().getDebitEntriesSet().stream().filter(d -> TreasuryConstants.isPositive(d.getOpenAmount())).findFirst().orElse(null);
            }
            openDebitEntry.closeCreditEntryIfPossible(reason, now, openCreditEntry);
        }
    }

    public void removeFromDocument() {
        Object object = advice$removeFromDocument.perform((Callable)new DebitEntry$callable$removeFromDocument(this));
    }

    static /* synthetic */ void advised$removeFromDocument(DebitEntry this_) {
        if (this_.getFinantialDocument() == null || !this_.getFinantialDocument().isPreparing()) {
            throw new TreasuryDomainException("error.DebitEntry.removeFromDocument.invalid.state", new String[0]);
        }
        this_.setFinantialDocument(null);
    }

    static {
        advice$createInterestRateDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markAcademicalActBlockingSuspension = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markBlockAcademicActsOnDebt = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$annulOnEvent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$revertEventAnnuled = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$clearInterestRate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$annulDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$creditDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$removeFromDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_OPEN_AMOUNT_WITH_VAT = new Comparator<DebitEntry>(){

            @Override
            public int compare(DebitEntry o1, DebitEntry o2) {
                int c = o1.getAmountWithVat().compareTo(o2.getAmountWithVat());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
        COMPARE_BY_DUE_DATE = new Comparator<DebitEntry>(){

            @Override
            public int compare(DebitEntry o1, DebitEntry o2) {
                int c = o1.getDueDate().compareTo((ReadablePartial)o2.getDueDate());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
        COMPARE_BY_EVENT_ANNULED_AND_BY_DATE = new Comparator<DebitEntry>(){

            @Override
            public int compare(DebitEntry o1, DebitEntry o2) {
                if (!o1.isEventAnnuled() && o2.isEventAnnuled()) {
                    return -1;
                }
                if (o1.isEventAnnuled() && !o2.isEventAnnuled()) {
                    return 1;
                }
                int c = o1.getEntryDateTime().compareTo((ReadableInstant)o2.getEntryDateTime());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
        COMPARE_BY_EVENT_ANNULED_AND_DUE_DATE = new Comparator<DebitEntry>(){

            @Override
            public int compare(DebitEntry o1, DebitEntry o2) {
                if (!o1.isEventAnnuled() && o2.isEventAnnuled()) {
                    return 1;
                }
                if (o1.isEventAnnuled() && !o2.isEventAnnuled()) {
                    return -1;
                }
                int c = o1.getDueDate().compareTo((ReadablePartial)o2.getDueDate());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
        COMPARE_BY_EXTERNAL_ID = new Comparator<DebitEntry>(){

            @Override
            public int compare(DebitEntry o1, DebitEntry o2) {
                return o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

