/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Vat$callable$create;
import org.fenixedu.treasury.domain.Vat$callable$delete;
import org.fenixedu.treasury.domain.Vat$callable$edit;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.Vat_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Vat
extends Vat_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected Vat() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected Vat(VatType vatType, FinantialInstitution finantialInstitution, BigDecimal taxRate, DateTime beginDate, DateTime endDate) {
        this();
        this.setVatType(vatType);
        this.setFinantialInstitution(finantialInstitution);
        this.setTaxRate(taxRate);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getTaxRate() == null) {
            throw new TreasuryDomainException("error.Vat.taxRate.required", new String[0]);
        }
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.Vat.finantialInstitution.required", new String[0]);
        }
        if (this.getVatType() == null) {
            throw new TreasuryDomainException("error.Vat.vatType.required", new String[0]);
        }
        if (this.getTaxRate().compareTo(BigDecimal.ZERO) < 0) {
            throw new TreasuryDomainException("error.Vat.taxRate.cannot.be.negative", new String[0]);
        }
        if (this.getBeginDate() == null) {
            throw new TreasuryDomainException("error.Vat.beginDate.required", new String[0]);
        }
        if (this.getEndDate() == null) {
            throw new TreasuryDomainException("error.Vat.endDate.required", new String[0]);
        }
        if (!this.getEndDate().isAfter((ReadableInstant)this.getBeginDate())) {
            throw new TreasuryDomainException("error.Vat.endDate.end.date.must.be.after.begin.date", new String[0]);
        }
        if (Vat.findActive(this.getFinantialInstitution(), this.getVatType(), this.getBeginDate(), this.getEndDate()).count() > 1L) {
            throw new TreasuryDomainException("error.Vat.date.interval.overlap.with.another", new String[0]);
        }
    }

    public void edit(BigDecimal bigDecimal, DateTime dateTime, DateTime dateTime2) {
        Object object = advice$edit.perform((Callable)new Vat$callable$edit(this, bigDecimal, dateTime, dateTime2));
    }

    static /* synthetic */ void advised$edit(Vat this_, BigDecimal taxRate, DateTime beginDate, DateTime endDate) {
        if (!this_.getInvoiceEntriesSet().isEmpty()) {
            throw new TreasuryDomainException("error.Vat.edition.not.possible.due.to.existing.invoice.entries", new String[0]);
        }
        this_.setTaxRate(taxRate);
        this_.setBeginDate(beginDate);
        this_.setEndDate(endDate);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getInvoiceEntriesSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Vat$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Vat this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.Vat.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setVatType(null);
        this_.setFinantialInstitution(null);
        this_.deleteDomainObject();
    }

    public static Stream<Vat> findAll() {
        return FenixFramework.getDomainRoot().getVatsSet().stream();
    }

    public static Stream<Vat> find(VatType vatType) {
        return vatType.getVatsSet().stream();
    }

    protected static Stream<Vat> findActive(VatType vatType, DateTime when) {
        return Vat.find(vatType).filter(v -> v.interval().contains((ReadableInstant)when));
    }

    protected static Stream<Vat> findActive(FinantialInstitution finantialInstitution, VatType vatType, DateTime begin, DateTime end) {
        Interval interval = new Interval((ReadableInstant)begin, (ReadableInstant)end);
        return Vat.find(vatType).filter(v -> v.getFinantialInstitution().equals((Object)finantialInstitution)).filter(v -> v.interval().overlaps((ReadableInterval)interval));
    }

    public static Optional<Vat> findActiveUnique(VatType vatType, FinantialInstitution finantialInstiution, DateTime when) {
        return Vat.findActive(vatType, when).filter(x -> x.getFinantialInstitution().equals((Object)finantialInstiution)).findFirst();
    }

    public static Vat create(VatType vatType, FinantialInstitution finantialInstitution, BigDecimal bigDecimal, DateTime dateTime, DateTime dateTime2) {
        return (Vat)((Object)advice$create.perform((Callable)new Vat$callable$create(vatType, finantialInstitution, bigDecimal, dateTime, dateTime2)));
    }

    static /* synthetic */ Vat advised$create(VatType vatType, FinantialInstitution finantialInstitution, BigDecimal taxRate, DateTime beginDate, DateTime endDate) {
        return new Vat(vatType, finantialInstitution, taxRate, beginDate, endDate);
    }

    private Interval interval() {
        return new Interval((ReadableInstant)this.getBeginDate(), (ReadableInstant)(this.getEndDate() != null ? this.getEndDate() : TreasuryConstants.INFINITY_DATE));
    }

    public boolean isActiveNow() {
        return this.isActive(new DateTime());
    }

    public boolean isActive(DateTime when) {
        return this.getBeginDate().isBefore((ReadableInstant)when) && (this.getEndDate() == null || this.getEndDate().isAfter((ReadableInstant)when));
    }
}

