/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;

public interface IPaymentProcessorForInvoiceEntries {
    public DebtAccount getDebtAccount();

    public DocumentNumberSeries getDocumentSeriesForPayments();

    public DocumentNumberSeries getDocumentSeriesInterestDebits();

    public Map<String, String> fillPaymentEntryPropertiesMap(String var1);

    public Set<Customer> getReferencedCustomers();

    public PaymentMethod getPaymentMethod();

    public String fillPaymentEntryMethodId();

    default public Set<SettlementNote> internalProcessPaymentInNormalPaymentMixingLegacyInvoices(String username, BigDecimal amount, DateTime paymentDate, String sibsTransactionId, String comments, Set<InvoiceEntry> invoiceEntriesToPay) {
        TreeSet sortedInvoiceEntriesToPay = Sets.newTreeSet(InvoiceEntry.COMPARE_BY_AMOUNT_AND_DUE_DATE);
        sortedInvoiceEntriesToPay.addAll(invoiceEntriesToPay);
        BigDecimal availableAmount = amount;
        ArrayList<DebitEntry> interestRateEntries = new ArrayList<DebitEntry>();
        DebtAccount referenceDebtAccount = this.getDebtAccount();
        DocumentNumberSeries docNumberSeries = this.getDocumentSeriesForPayments();
        SettlementNote settlementNote = SettlementNote.create(referenceDebtAccount, docNumberSeries, new DateTime(), paymentDate, comments, null);
        if (this.getReferencedCustomers().size() == 1) {
            SettlementEntry newSettlementEntry;
            for (Object entry : sortedInvoiceEntriesToPay) {
                if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal amountToPay = ((InvoiceEntry)((Object)entry)).getOpenAmount();
                if (amountToPay.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (((InvoiceEntry)((Object)entry)).isDebitNoteEntry()) {
                    InterestRateBean calculateUndebitedInterestValue;
                    DebitEntry debitEntry = (DebitEntry)((Object)entry);
                    if (debitEntry.getFinantialDocument() == null) {
                        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), this.getDebtAccount().getFinantialInstitution()).get();
                        DebitNote debitNote = DebitNote.create(debitEntry.getDebtAccount(), documentNumberSeries, new DateTime());
                        debitNote.addDebitNoteEntries(Lists.newArrayList((Object[])new DebitEntry[]{debitEntry}));
                    }
                    if (debitEntry.getFinantialDocument().isPreparing()) {
                        debitEntry.getFinantialDocument().closeDocument();
                    }
                    if (amountToPay.compareTo(availableAmount) > 0) {
                        amountToPay = availableAmount;
                    }
                    if (debitEntry.getOpenAmount().equals(amountToPay) && TreasuryConstants.isPositive((calculateUndebitedInterestValue = debitEntry.calculateUndebitedInterestValue(paymentDate.toLocalDate())).getInterestAmount())) {
                        DebitEntry interestDebitEntry = debitEntry.createInterestRateDebitEntry(calculateUndebitedInterestValue, paymentDate, Optional.empty());
                        interestRateEntries.add(interestDebitEntry);
                    }
                    newSettlementEntry = SettlementEntry.create((InvoiceEntry)((Object)entry), settlementNote, amountToPay, entry.getDescription(), paymentDate, true);
                    availableAmount = availableAmount.subtract(amountToPay);
                    continue;
                }
                if (!((InvoiceEntry)((Object)entry)).isCreditNoteEntry()) continue;
                SettlementEntry newSettlementEntry2 = SettlementEntry.create((InvoiceEntry)((Object)entry), settlementNote, ((InvoiceEntry)((Object)entry)).getOpenAmount(), entry.getDescription(), paymentDate, true);
                availableAmount = availableAmount.add(amountToPay);
            }
            if (interestRateEntries.size() > 0) {
                DebitNote interestNote = DebitNote.create(referenceDebtAccount, this.getDocumentSeriesInterestDebits(), paymentDate);
                for (DebitEntry interestEntry : interestRateEntries) {
                    interestEntry.setFinantialDocument((FinantialDocument)((Object)interestNote));
                }
                interestNote.closeDocument();
                if (availableAmount.compareTo(BigDecimal.ZERO) > 0) {
                    for (DebitEntry interestEntry : interestRateEntries) {
                        if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                        BigDecimal amountToPay = interestEntry.getOpenAmount();
                        if (amountToPay.compareTo(availableAmount) > 0) {
                            amountToPay = availableAmount;
                        }
                        newSettlementEntry = SettlementEntry.create((InvoiceEntry)((Object)interestEntry), settlementNote, amountToPay, interestEntry.getDescription(), paymentDate, true);
                        availableAmount = availableAmount.subtract(amountToPay);
                    }
                }
                interestRateEntries.clear();
            }
        }
        if (availableAmount.compareTo(BigDecimal.ZERO) > 0) {
            settlementNote.createAdvancedPaymentCreditNote(availableAmount, TreasuryConstants.treasuryBundle("label.PaymentCodeTarget.advancedpayment", new String[0]) + comments + "-" + sibsTransactionId, sibsTransactionId);
        }
        Map<String, String> paymentEntryPropertiesMap = this.fillPaymentEntryPropertiesMap(sibsTransactionId);
        PaymentEntry paymentEntry = PaymentEntry.create(this.getPaymentMethod(), settlementNote, amount, this.fillPaymentEntryMethodId(), paymentEntryPropertiesMap);
        settlementNote.closeDocument();
        return Sets.newHashSet((Object[])new SettlementNote[]{settlementNote});
    }

    default public Set<SettlementNote> internalProcessPaymentInRestrictedPaymentMixingLegacyInvoices(String username, BigDecimal amount, DateTime paymentDate, String sibsTransactionId, String comments, Set<InvoiceEntry> invoiceEntriesToPay) {
        if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            throw new RuntimeException("invalid call");
        }
        SettlementNote.checkMixingOfInvoiceEntriesExportedInLegacyERP(invoiceEntriesToPay);
        if (invoiceEntriesToPay.stream().allMatch(e -> e.getFinantialDocument() == null || !e.getFinantialDocument().isExportedInLegacyERP())) {
            return this.internalProcessPaymentInNormalPaymentMixingLegacyInvoices(username, amount, paymentDate, sibsTransactionId, comments, invoiceEntriesToPay);
        }
        TreeSet sortedInvoiceEntriesToPay = Sets.newTreeSet(InvoiceEntry.COMPARE_BY_AMOUNT_AND_DUE_DATE);
        sortedInvoiceEntriesToPay.addAll(invoiceEntriesToPay);
        BigDecimal availableAmount = amount;
        DebtAccount referenceDebtAccount = this.getDebtAccount();
        DocumentNumberSeries docNumberSeries = this.getDocumentSeriesForPayments();
        SettlementNote settlementNote = SettlementNote.create(referenceDebtAccount, docNumberSeries, new DateTime(), paymentDate, comments, null);
        if (this.getReferencedCustomers().size() == 1) {
            for (InvoiceEntry entry : sortedInvoiceEntriesToPay) {
                if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal amountToPay = entry.getOpenAmount();
                if (amountToPay.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (entry.isDebitNoteEntry()) {
                    InterestRateBean calculateUndebitedInterestValue;
                    DebitEntry debitEntry = (DebitEntry)((Object)entry);
                    if (debitEntry.getFinantialDocument().isPreparing()) {
                        debitEntry.getFinantialDocument().closeDocument();
                    }
                    if (amountToPay.compareTo(availableAmount) > 0) {
                        amountToPay = availableAmount;
                    }
                    if (debitEntry.getOpenAmount().equals(amountToPay) && TreasuryConstants.isPositive((calculateUndebitedInterestValue = debitEntry.calculateUndebitedInterestValue(paymentDate.toLocalDate())).getInterestAmount())) {
                        debitEntry.createInterestRateDebitEntry(calculateUndebitedInterestValue, paymentDate, Optional.empty());
                    }
                    SettlementEntry.create(entry, settlementNote, amountToPay, entry.getDescription(), paymentDate, true);
                    availableAmount = availableAmount.subtract(amountToPay);
                    continue;
                }
                if (!entry.isCreditNoteEntry()) continue;
                SettlementEntry.create(entry, settlementNote, entry.getOpenAmount(), entry.getDescription(), paymentDate, true);
                availableAmount = availableAmount.add(amountToPay);
            }
        }
        if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) {
            availableAmount = BigDecimal.ZERO;
        }
        Map<String, String> paymentEntryPropertiesMap = this.fillPaymentEntryPropertiesMap(sibsTransactionId);
        PaymentEntry.create(this.getPaymentMethod(), settlementNote, amount.subtract(availableAmount), this.fillPaymentEntryMethodId(), paymentEntryPropertiesMap);
        settlementNote.closeDocument();
        HashSet result = Sets.newHashSet((Object[])new SettlementNote[]{settlementNote});
        if (availableAmount.compareTo(BigDecimal.ZERO) > 0) {
            SettlementNote advancedPaymentSettlementNote = SettlementNote.create(referenceDebtAccount, docNumberSeries, new DateTime(), paymentDate, comments, null);
            advancedPaymentSettlementNote.createAdvancedPaymentCreditNote(availableAmount, TreasuryConstants.treasuryBundle("label.PaymentCodeTarget.advancedpayment", new String[0]) + comments + "-" + sibsTransactionId, sibsTransactionId);
            PaymentEntry.create(this.getPaymentMethod(), advancedPaymentSettlementNote, availableAmount, this.fillPaymentEntryMethodId(), paymentEntryPropertiesMap);
            advancedPaymentSettlementNote.closeDocument();
            advancedPaymentSettlementNote.setExportedInLegacyERP(true);
            advancedPaymentSettlementNote.setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
            advancedPaymentSettlementNote.getAdvancedPaymentCreditNote().setExportedInLegacyERP(true);
            advancedPaymentSettlementNote.getAdvancedPaymentCreditNote().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
            result.add(advancedPaymentSettlementNote);
        }
        return result;
    }

    public static Set<Customer> getReferencedCustomers(Set<InvoiceEntry> invoiceEntrySet) {
        HashSet result = Sets.newHashSet();
        for (InvoiceEntry entry : invoiceEntrySet) {
            if (entry.getFinantialDocument() != null && ((Invoice)((Object)entry.getFinantialDocument())).isForPayorDebtAccount()) {
                result.add(((Invoice)((Object)entry.getFinantialDocument())).getPayorDebtAccount().getCustomer());
                continue;
            }
            result.add(entry.getDebtAccount().getCustomer());
        }
        return result;
    }
}

