/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.sibspay;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.payments.IMbwayPaymentPlatformService;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.sibspay.MbwayMandate;
import org.fenixedu.treasury.domain.sibspay.MbwayMandatePaymentSchedule$callable$chargePayment;
import org.fenixedu.treasury.domain.sibspay.MbwayMandatePaymentSchedule$callable$updateStateToError;
import org.fenixedu.treasury.domain.sibspay.MbwayMandatePaymentSchedule$callable$updateStateToPaymentCharged;
import org.fenixedu.treasury.domain.sibspay.MbwayMandatePaymentScheduleState;
import org.fenixedu.treasury.domain.sibspay.MbwayMandatePaymentSchedule_Base;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MbwayMandatePaymentSchedule
extends MbwayMandatePaymentSchedule_Base {
    public static final Advice advice$chargePayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$updateStateToPaymentCharged = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateStateToError = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public MbwayMandatePaymentSchedule() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
        this.setState(MbwayMandatePaymentScheduleState.SCHEDULED);
        this.setUpdateStateDate(new DateTime());
    }

    public MbwayMandatePaymentSchedule(MbwayMandate mbwayMandate, LocalDate sendNotificationDate, LocalDate paymentChargeDate, Set<DebitEntry> debitEntriesSet, Set<Installment> installmentSet) {
        this();
        this.setMbwayMandate(mbwayMandate);
        this.setSendNotificationDate(sendNotificationDate);
        this.setPaymentChargeDate(paymentChargeDate);
        this.getDebitEntriesSet().addAll(debitEntriesSet);
        this.getInstallmentsSet().addAll(installmentSet);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new IllegalStateException("error.MbwayMandatePaymentSchedule.domainRoot.required");
        }
        if (this.getCreationDate() == null) {
            throw new IllegalStateException("error.MbwayMandatePaymentSchedule.creationDate.required");
        }
        if (this.getMbwayMandate() == null) {
            throw new IllegalStateException("error.MbwayMandatePaymentSchedule.mbwayMandate.required");
        }
        if (PaymentRequest.getReferencedCustomers(this.getDebitEntriesSet(), this.getInstallmentsSet()).size() != 1) {
            throw new IllegalStateException("error.MbwayMandatePaymentSchedule.only.one.customer.allowed");
        }
        if (Stream.concat(Stream.concat(this.getDebitEntriesSet().stream().map(InvoiceEntry_Base::getDebtAccount), this.getInstallmentsSet().stream().map(i -> i.getPaymentPlan().getDebtAccount())), Stream.of(this.getMbwayMandate().getDebtAccount())).distinct().count() != 1L) {
            throw new IllegalStateException("error.MbwayMandatePaymentSchedule.debitEntries.from.different.debt.accounts");
        }
        FinantialEntity finantialEntity = this.getMbwayMandate().getDigitalPaymentPlatform().getFinantialEntity();
        Set finantialEntitySet = Stream.concat(this.getDebitEntriesSet().stream().map(DebitEntry::getFinantialEntity), this.getInstallmentsSet().stream().map(i -> i.getPaymentPlan().getFinantialEntity())).collect(Collectors.toSet());
        if (finantialEntitySet.size() != 1 || finantialEntitySet.iterator().next() != finantialEntity) {
            throw new IllegalStateException("error.MbwayMandatePaymentSchedule.debitEntries.from.different.finantial.entities");
        }
    }

    public BigDecimal getOpenAmount() {
        BigDecimal result = this.getDebitEntriesSet().stream().map(de -> de.getOpenAmountWithInterests()).reduce(BigDecimal.ZERO, BigDecimal::add);
        result = result.add(this.getInstallmentsSet().stream().map(i -> i.getOpenAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
        return result;
    }

    public boolean isInProgress() {
        return this.getState().isScheduled() || this.getState().isNotificationSent();
    }

    public boolean isCanceled() {
        return this.getState().isCanceled();
    }

    public void sendNotification() {
        this.setState(MbwayMandatePaymentScheduleState.NOTIFICATION_SENT);
        this.setUpdateStateDate(new DateTime());
        this.checkRules();
    }

    public void cancel(String reason) {
        if (!this.isInProgress()) {
            throw new TreasuryDomainException("error.MbwayMandatePaymentSchedule.cancel.not.in.progress", new String[0]);
        }
        super.setState(MbwayMandatePaymentScheduleState.CANCELED);
        this.setUpdateStateDate(new DateTime());
        this.setCancelReason(reason);
        this.setCancelDate(new DateTime());
        this.setCancelResponsible(TreasuryConstants.getAuthenticatedUsername());
        this.checkRules();
    }

    public void reschedule() {
        if (!this.getState().isError()) {
            throw new IllegalStateException("error.MbwayMandatePaymentSchedule.reschedule.not.error.state");
        }
        this.getDebitEntriesSet().forEach(d -> {
            if (MbwayMandatePaymentSchedule.findSchedulesInProgressForDebitEntry(d).count() > 0L) {
                throw new TreasuryDomainException("error.MbwayMandatePaymentSchedule.debitEntry.already.has.schedule.in.progress", d.getDescription());
            }
        });
        this.getInstallmentsSet().stream().forEach(i -> {
            if (MbwayMandatePaymentSchedule.findSchedulesInProgressForInstallment(i).count() > 0L) {
                throw new TreasuryDomainException("error.MbwayMandatePaymentSchedule.installment.already.has.schedule.in.progress", i.getDescription().getContent());
            }
        });
        IMbwayPaymentPlatformService service = this.getMbwayMandate().getDigitalPaymentPlatform().castToMbwayPaymentPlatformService();
        if (!service.isMbwayAuthorizedPaymentsActive()) {
            throw new TreasuryDomainException("error.MbwayMandate.create.platform.not.active", new String[0]);
        }
        super.setState(MbwayMandatePaymentScheduleState.SCHEDULED);
        this.setUpdateStateDate(new DateTime());
        this.checkRules();
    }

    public MbwayRequest chargePayment() {
        return (MbwayRequest)((Object)advice$chargePayment.perform((Callable)new MbwayMandatePaymentSchedule$callable$chargePayment(this)));
    }

    static /* synthetic */ MbwayRequest advised$chargePayment(MbwayMandatePaymentSchedule this_) {
        Set debitEntriesToCharge = this_.getDebitEntriesSet().stream().filter(DebitEntry::isInDebt).collect(Collectors.toSet());
        Set installmentsToCharge = this_.getInstallmentsSet().stream().filter(i -> !i.isPaid()).collect(Collectors.toSet());
        if (debitEntriesToCharge.isEmpty() && installmentsToCharge.isEmpty()) {
            throw new IllegalStateException("nothing to charge in this schedule");
        }
        try {
            MbwayRequest mbwayRequest = this_.getMbwayMandate().getDigitalPaymentPlatform().castToMbwayPaymentPlatformService().createMbwayRequest(this_, this_.getDebitEntriesSet(), this_.getInstallmentsSet());
            this_.updateStateToPaymentCharged();
            return mbwayRequest;
        }
        catch (TreasuryDomainException e) {
            this_.updateStateToError();
            throw e;
        }
    }

    private void updateStateToPaymentCharged() {
        Object object = advice$updateStateToPaymentCharged.perform((Callable)new MbwayMandatePaymentSchedule$callable$updateStateToPaymentCharged(this));
    }

    static /* synthetic */ void advised$updateStateToPaymentCharged(MbwayMandatePaymentSchedule this_) {
        this_.setState(MbwayMandatePaymentScheduleState.PAYMENT_CHARGED);
        this_.setUpdateStateDate(new DateTime());
    }

    private void updateStateToError() {
        Object object = advice$updateStateToError.perform((Callable)new MbwayMandatePaymentSchedule$callable$updateStateToError(this));
    }

    static /* synthetic */ void advised$updateStateToError(MbwayMandatePaymentSchedule this_) {
        this_.setState(MbwayMandatePaymentScheduleState.ERROR);
        this_.setUpdateStateDate(new DateTime());
    }

    public void updateStateToPaid() {
        this.setState(MbwayMandatePaymentScheduleState.PAID);
        this.setUpdateStateDate(new DateTime());
    }

    public static MbwayMandatePaymentSchedule create(MbwayMandate mbwayMandate, LocalDate sendEmailDate, LocalDate paymentChargeDate, Set<DebitEntry> debitEntriesSet, Set<Installment> installmentSet) {
        debitEntriesSet.stream().forEach(d -> {
            if (MbwayMandatePaymentSchedule.findSchedulesInProgressForDebitEntry(d).count() > 0L) {
                throw new TreasuryDomainException("error.MbwayMandatePaymentSchedule.debitEntry.already.has.schedule.in.progress", d.getDescription());
            }
        });
        installmentSet.stream().forEach(i -> {
            if (MbwayMandatePaymentSchedule.findSchedulesInProgressForInstallment(i).count() > 0L) {
                throw new TreasuryDomainException("error.MbwayMandatePaymentSchedule.installment.already.has.schedule.in.progress", i.getDescription().getContent());
            }
        });
        IMbwayPaymentPlatformService service = mbwayMandate.getDigitalPaymentPlatform().castToMbwayPaymentPlatformService();
        if (!service.isMbwayAuthorizedPaymentsActive()) {
            throw new TreasuryDomainException("error.MbwayMandate.create.platform.not.active", new String[0]);
        }
        return new MbwayMandatePaymentSchedule(mbwayMandate, sendEmailDate, paymentChargeDate, debitEntriesSet, installmentSet);
    }

    public static Stream<MbwayMandatePaymentSchedule> findAll() {
        return FenixFramework.getDomainRoot().getMbwayMandatePaymentSchedulesSet().stream();
    }

    public static Stream<MbwayMandatePaymentSchedule> findSchedulesInProgressForDebitEntry(DebitEntry debitEntry) {
        return debitEntry.getMbwayMandatePaymentScheduleSet().stream().filter(s -> s.isInProgress());
    }

    public static Stream<MbwayMandatePaymentSchedule> findSchedulesInProgressForInstallment(Installment installment) {
        return installment.getMbwayMandatePaymentScheduleSet().stream().filter(s -> s.isInProgress());
    }

    public static Stream<MbwayMandatePaymentSchedule> findActive() {
        return MbwayMandatePaymentSchedule.findAll().filter(s -> !s.isCanceled());
    }

    public void transferScheduleToOtherDebtAccount(MbwayMandate newMandate, Map<DebitEntry, DebitEntry> debitEntriesTransferMap, Map<Installment, Installment> installmentsTransferMap) {
        Set<DebitEntry> newDebitEntriesSet = this.getDebitEntriesSet().stream().filter(d -> debitEntriesTransferMap.get(d) != null).filter(d -> ((DebitEntry)((Object)((Object)debitEntriesTransferMap.get(d)))).isInDebt()).map(d -> (DebitEntry)((Object)((Object)debitEntriesTransferMap.get(d)))).collect(Collectors.toSet());
        Set<Installment> newInstallmentsSet = this.getInstallmentsSet().stream().filter(i -> installmentsTransferMap.get(i) != null).filter(i -> TreasuryConstants.isPositive(((Installment)((Object)((Object)installmentsTransferMap.get(i)))).getOpenAmount())).map(i -> (Installment)((Object)((Object)installmentsTransferMap.get(i)))).collect(Collectors.toSet());
        MbwayMandatePaymentScheduleState originalState = this.getState();
        DateTime originalUpdateStateDate = this.getUpdateStateDate();
        this.setState(MbwayMandatePaymentScheduleState.TRANSFERRED);
        this.setUpdateStateDate(new DateTime());
        if (!newDebitEntriesSet.isEmpty() || !newInstallmentsSet.isEmpty()) {
            MbwayMandatePaymentSchedule newSchedule = new MbwayMandatePaymentSchedule(newMandate, this.getSendNotificationDate(), this.getPaymentChargeDate(), newDebitEntriesSet, newInstallmentsSet);
            newSchedule.setState(originalState);
            newSchedule.setUpdateStateDate(originalUpdateStateDate);
            newSchedule.setCreationDate(this.getCreationDate());
            newSchedule.setSendNotificationDate(this.getSendNotificationDate());
            newSchedule.setPaymentChargeDate(this.getPaymentChargeDate());
            newSchedule.checkRules();
        }
        this.checkRules();
    }
}

