/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.interestrate;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.text.StrSubstitutor;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.interestrate.MonthlyInterestRateConfig;
import org.fenixedu.treasury.domain.interestrate.MonthlyInterestRateType_Base;
import org.fenixedu.treasury.domain.tariff.InterestRateEntry;
import org.fenixedu.treasury.domain.tariff.InterestRateType;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.ReadablePartial;

public class MonthlyInterestRateType
extends MonthlyInterestRateType_Base {
    private static final int DEFAULT_MAXIMUM_MONTHS_TO_APPLY_INTEREST = 10;

    public MonthlyInterestRateType() {
    }

    public MonthlyInterestRateType(LocalizedString description) {
        this();
        super.init(description);
        super.setCode(UUID.randomUUID().toString());
        this.checkRules();
    }

    public List<InterestRateBean> calculateInterests(DebitEntry debitEntry, LocalDate paymentDate, boolean withAllInterestValues) {
        DateTime entryDateTime = debitEntry.getEntryDateTime();
        final InterestRateEntry rateEntry = InterestRateEntry.findUniqueAppliedForDate((InterestRateType)((Object)this), entryDateTime.toLocalDate()).orElseThrow(() -> new TreasuryDomainException("error.InterestRate.rate.not.defined.for.date", entryDateTime.toLocalDate().toString("yyyy/MM/dd")));
        MonthlyInterestRateConfig config = new MonthlyInterestRateConfig(){

            @Override
            public boolean isPostponePaymentLimitDateToFirstWorkDate() {
                return rateEntry.getApplyInFirstWorkday();
            }

            @Override
            public boolean isApplyPenaltyInFirstWorkday() {
                return rateEntry.getApplyInFirstWorkday();
            }

            @Override
            public int getMaximumMonthsToApplyInterests() {
                return 10;
            }

            @Override
            public BigDecimal getInterestsPercentage() {
                return rateEntry.getRate();
            }

            @Override
            public LocalDate getOverridenFirstDayToApplyInterests(int month) {
                return null;
            }

            @Override
            public LocalizedString getInterestDebitEntryFormat() {
                return new LocalizedString(TreasuryConstants.getDefaultLocale(), "${debitEntryDescription} (in ${monthOfPenaltyDate})");
            }
        };
        return this.calculateInterests(debitEntry, paymentDate, withAllInterestValues, config);
    }

    public List<InterestRateBean> calculateAllInterestsByLockingAtDate(DebitEntry debitEntry, LocalDate lockDate) {
        return this.calculateInterests(debitEntry, lockDate, true);
    }

    public List<InterestRateBean> calculateInterests(DebitEntry debitEntry, LocalDate paymentDate, boolean withAllInterestValues, MonthlyInterestRateConfig monthlyInterestRateConfig) {
        BigDecimal interestsPercentage = monthlyInterestRateConfig.getInterestsPercentage();
        boolean postponePaymentLimitDateToFirstWorkDate = monthlyInterestRateConfig.isPostponePaymentLimitDateToFirstWorkDate();
        boolean applyPenaltyInFirstWorkday = monthlyInterestRateConfig.isApplyPenaltyInFirstWorkday();
        int maximumMonthsToApplyInterests = monthlyInterestRateConfig.getMaximumMonthsToApplyInterests();
        List<LocalDate> monthsIterationList = this.getMonthlyDueDateIterations(debitEntry.getDueDate(), paymentDate, maximumMonthsToApplyInterests);
        return monthsIterationList.stream().map(monthIteration -> this.calculateInterestRateBean(debitEntry, paymentDate, withAllInterestValues, (LocalDate)monthIteration, interestsPercentage, postponePaymentLimitDateToFirstWorkDate, applyPenaltyInFirstWorkday, monthlyInterestRateConfig.getOverridenFirstDayToApplyInterests(monthIteration.getMonthOfYear()), monthlyInterestRateConfig.getInterestDebitEntryFormat())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private InterestRateBean calculateInterestRateBean(DebitEntry debitEntry, LocalDate paymentDate, boolean withAllInterestValues, LocalDate dueDate, BigDecimal interestsPercentage, boolean postponePaymentLimitDateToFirstWorkDate, boolean applyPenaltyInFirstWorkday, LocalDate overridenFirstDayToApplyPenalty, LocalizedString interestDebitEntryFormat) {
        LocalDate firstDayToApplyInterests = this.calculateFirstDateToApplyInterests(debitEntry, postponePaymentLimitDateToFirstWorkDate, applyPenaltyInFirstWorkday);
        LocalDate firstDayToApplyInterestsInMonth = overridenFirstDayToApplyPenalty;
        if (firstDayToApplyInterestsInMonth == null) {
            firstDayToApplyInterestsInMonth = this.calculateFirstDateToApplyInterests(debitEntry, dueDate, postponePaymentLimitDateToFirstWorkDate, applyPenaltyInFirstWorkday);
        }
        if (firstDayToApplyInterestsInMonth.isAfter((ReadablePartial)paymentDate)) {
            return null;
        }
        BigDecimal interestAmount = Currency.getValueWithScale(debitEntry.getAmountInDebt(firstDayToApplyInterestsInMonth).multiply(TreasuryConstants.divide(interestsPercentage, TreasuryConstants.HUNDRED_PERCENT)));
        String interestRateBeanDescription = TreasuryConstants.getAvailableLocales().stream().map(locale -> {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("debitEntryDescription", debitEntry.getDescription());
            valueMap.put("monthOfPenaltyDate", firstDayToApplyInterests.toString("MMMM", locale));
            return new LocalizedString(locale, StrSubstitutor.replace((Object)interestDebitEntryFormat.getContent(locale), valueMap));
        }).reduce((a, c) -> a.append(c)).get().getContent(TreasuryConstants.getDefaultLocale());
        InterestRateBean interestRateBean = new InterestRateBean((InterestRateType)((Object)this));
        BigDecimal remainingInterestAmount = interestAmount;
        if (!withAllInterestValues) {
            BigDecimal totalCreatedInterestDebitAmount = debitEntry.getInterestDebitEntriesSet().stream().filter(d -> !d.isAnnulled()).filter(d -> d.getEntryDateTime().getMonthOfYear() == dueDate.getMonthOfYear()).map(d -> d.getAvailableNetAmountForCredit().add(d.getNetExemptedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
            remainingInterestAmount = interestAmount.subtract(totalCreatedInterestDebitAmount);
            if (TreasuryConstants.isPositive(totalCreatedInterestDebitAmount)) {
                interestRateBean.addCreatedInterestEntry(firstDayToApplyInterests, totalCreatedInterestDebitAmount);
            }
        }
        interestRateBean.addDetail(interestAmount, firstDayToApplyInterestsInMonth, null, BigDecimal.ZERO, debitEntry.getNetAmount(), interestsPercentage);
        if (remainingInterestAmount.compareTo(BigDecimal.ZERO) < 0) {
            remainingInterestAmount = BigDecimal.ZERO;
        }
        interestRateBean.setDescription(interestRateBeanDescription);
        interestRateBean.setInterestAmount(remainingInterestAmount);
        interestRateBean.setInterestDebitEntryDateTime(firstDayToApplyInterestsInMonth.toDateTimeAtStartOfDay());
        interestRateBean.setNumberOfDays(0);
        interestRateBean.setNumberOfMonths(1);
        return interestRateBean;
    }

    private List<LocalDate> getMonthlyDueDateIterations(LocalDate dueDate, LocalDate paymentDate, int maximumMonthsToApplyInterests) {
        int numberOfMonthsToCalculate = Months.monthsBetween((ReadablePartial)dueDate, (ReadablePartial)paymentDate).getMonths() + 1;
        if (numberOfMonthsToCalculate > maximumMonthsToApplyInterests) {
            numberOfMonthsToCalculate = maximumMonthsToApplyInterests;
        }
        return IntStream.range(0, numberOfMonthsToCalculate).boxed().map(i -> dueDate.plusMonths(i.intValue())).collect(Collectors.toList());
    }

    public static LocalizedString getPresentationName() {
        return TreasuryConstants.treasuryBundleI18N("label.MonthlyInterestRateType.presentationName", new String[0]);
    }
}

