/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplate;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFile$callable$create;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFile$callable$delete;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFile$callable$edit;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFile_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasuryDocumentTemplateFile
extends TreasuryDocumentTemplateFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "application/vnd.oasis.opendocument.text";
    public static final String FILE_EXTENSION = ".odt";
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public TreasuryDocumentTemplateFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    protected TreasuryDocumentTemplateFile(TreasuryDocumentTemplate documentTemplate, boolean active, String displayName, String fileName, byte[] content) {
        this();
        TreasuryPlataformDependentServicesFactory.implementation().createFile(this, fileName, CONTENT_TYPE, content);
        this.setTreasuryDocumentTemplate(documentTemplate);
        this.setActive(active);
        documentTemplate.activateFile(this);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getTreasuryDocumentTemplate() == null) {
            throw new TreasuryDomainException("error.TreasuryDocumentTemplateFile.documentTemplate.required", new String[0]);
        }
    }

    public void edit(TreasuryDocumentTemplate treasuryDocumentTemplate, boolean bl) {
        Object object = advice$edit.perform((Callable)new TreasuryDocumentTemplateFile$callable$edit(this, treasuryDocumentTemplate, bl));
    }

    static /* synthetic */ void advised$edit(TreasuryDocumentTemplateFile this_, TreasuryDocumentTemplate documentTemplate, boolean active) {
        this_.setTreasuryDocumentTemplate(documentTemplate);
        this_.setActive(active);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return true;
    }

    @Override
    public void delete() {
        Object object = advice$delete.perform((Callable)new TreasuryDocumentTemplateFile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TreasuryDocumentTemplateFile this_) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.TreasuryDocumentTemplateFileDomainObject.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setTreasuryDocumentTemplate(null);
        services.deleteFile(this_);
        super.deleteDomainObject();
    }

    static TreasuryDocumentTemplateFile create(TreasuryDocumentTemplate treasuryDocumentTemplate, String string, String string2, byte[] byArray) {
        return (TreasuryDocumentTemplateFile)advice$create.perform((Callable)new TreasuryDocumentTemplateFile$callable$create(treasuryDocumentTemplate, string, string2, byArray));
    }

    static /* synthetic */ TreasuryDocumentTemplateFile advised$create(TreasuryDocumentTemplate documentTemplate, String displayName, String fileName, byte[] content) {
        TreasuryDocumentTemplateFile documentTemplateFile = new TreasuryDocumentTemplateFile(documentTemplate, false, displayName, fileName, content);
        return documentTemplateFile;
    }

    public static Stream<TreasuryDocumentTemplateFile> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryDocumentTemplateFilesSet().stream();
    }

    public static Stream<TreasuryDocumentTemplateFile> findByDocumentTemplate(TreasuryDocumentTemplate documentTemplate) {
        return documentTemplate.getTreasuryDocumentTemplateFilesSet().stream();
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember(username, this.getTreasuryDocumentTemplate().getFinantialEntity());
    }
}

