/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public class SettlementDebitEntryBean
implements ISettlementInvoiceEntryBean,
ITreasuryBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private DebitEntry debitEntry;
    private boolean isIncluded;
    private boolean isNotValid;
    private BigDecimal debtAmount;

    public SettlementDebitEntryBean() {
    }

    public SettlementDebitEntryBean(DebitEntry debitEntry) {
        this.debitEntry = debitEntry;
        this.isIncluded = false;
        this.isNotValid = false;
        this.debtAmount = debitEntry.getOpenAmount();
    }

    public DebitEntry getDebitEntry() {
        return this.debitEntry;
    }

    public void setDebitEntry(DebitEntry debitEntry) {
        this.debitEntry = debitEntry;
    }

    public String getDocumentNumber() {
        return this.debitEntry.getFinantialDocument() != null ? this.debitEntry.getFinantialDocument().getDocumentNumber() : null;
    }

    @Deprecated
    public LocalDate getDocumentDueDate() {
        return this.debitEntry.getDueDate();
    }

    @Deprecated
    public BigDecimal getDebtAmount() {
        if (this.debtAmount == null) {
            return null;
        }
        this.debitEntry.getDebtAccount().getFinantialInstitution().getCurrency();
        return Currency.getValueWithScale(this.debtAmount);
    }

    @Deprecated
    public BigDecimal getDebtAmountWithVat() {
        if (this.debtAmount == null) {
            return null;
        }
        this.debitEntry.getDebtAccount().getFinantialInstitution().getCurrency();
        return Currency.getValueWithScale(this.debtAmount);
    }

    @Deprecated
    public void setDebtAmount(BigDecimal debtAmount) {
        this.debtAmount = debtAmount;
    }

    @Override
    public InvoiceEntry getInvoiceEntry() {
        return this.debitEntry;
    }

    @Override
    public String getDescription() {
        return this.debitEntry.getDescription();
    }

    @Override
    public LocalDate getDueDate() {
        return this.debitEntry.getDueDate();
    }

    @Override
    public BigDecimal getEntryAmount() {
        return this.debitEntry.getAmount();
    }

    @Override
    public BigDecimal getEntryOpenAmount() {
        return this.debitEntry.getOpenAmount();
    }

    @Override
    public BigDecimal getSettledAmount() {
        return this.debtAmount;
    }

    @Override
    public void setSettledAmount(BigDecimal debtAmount) {
        this.debtAmount = debtAmount;
    }

    @Override
    public Vat getVat() {
        return this.debitEntry.getVat();
    }

    @Override
    public BigDecimal getVatRate() {
        return this.debitEntry.getVatRate();
    }

    @Override
    public boolean isIncluded() {
        return this.isIncluded;
    }

    @Override
    public void setIncluded(boolean isIncluded) {
        this.isIncluded = isIncluded;
    }

    @Override
    public boolean isNotValid() {
        return this.isNotValid;
    }

    @Override
    public void setNotValid(boolean notValid) {
        this.isNotValid = notValid;
    }

    @Override
    public FinantialDocument getFinantialDocument() {
        return this.debitEntry.getFinantialDocument();
    }

    @Override
    public Set<Customer> getPaymentCustomer() {
        return this.debitEntry.getFinantialDocument() != null && ((Invoice)((Object)this.debitEntry.getFinantialDocument())).getPayorDebtAccount() != null ? Collections.singleton(((Invoice)((Object)this.debitEntry.getFinantialDocument())).getPayorDebtAccount().getCustomer()) : Collections.singleton(this.debitEntry.getDebtAccount().getCustomer());
    }

    @Override
    public boolean isForDebitEntry() {
        return true;
    }

    @Override
    public boolean isForFinantialEntity(FinantialEntity finantialEntity) {
        return this.debitEntry.getFinantialEntity() == null || this.debitEntry.getFinantialEntity() == finantialEntity;
    }

    @Override
    public String serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(this.getClass().getName()));
        jsonObject.add("debitEntryId", (JsonElement)new JsonPrimitive(this.getInvoiceEntry().getExternalId()));
        jsonObject.add("included", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.isIncluded)));
        jsonObject.add("notValid", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.isNotValid)));
        jsonObject.add("amount", (JsonElement)new JsonPrimitive(this.getSettledAmount().toPlainString()));
        return jsonObject.toString();
    }

    @Override
    public void fillSerializable(JsonObject jsonObject) {
        this.debitEntry = (DebitEntry)FenixFramework.getDomainObject((String)jsonObject.get("debitEntryId").getAsString());
        this.isIncluded = jsonObject.get("included").getAsBoolean();
        this.isNotValid = jsonObject.get("notValid").getAsBoolean();
        this.debtAmount = jsonObject.get("amount").getAsBigDecimal();
    }
}

