/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.paymentscodegenerator;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.integration.SibsPaymentCodePool;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.dto.document.managepayments.PaymentReferenceCodeBean;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.IPaymentCodeGenerator;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.SequentialPaymentCodeGenerator$callable$createPaymentReferenceCode;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.SequentialPaymentCodeGenerator$callable$generateNewCodeFor;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.SequentialPaymentCodeGenerator$callable$generateNewCodeFor$1;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Deprecated
public class SequentialPaymentCodeGenerator
implements IPaymentCodeGenerator {
    private final PaymentCodePool referenceCodePool;
    private static final String CODE_FILLER = "0";
    private static final int NUM_CONTROL_DIGITS = 2;
    private static final int NUM_SEQUENTIAL_NUMBERS = 7;
    public static final Advice advice$generateNewCodeFor = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$generateNewCodeFor$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createPaymentReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public SequentialPaymentCodeGenerator(PaymentCodePool pool) {
        this.referenceCodePool = pool;
    }

    protected Set<PaymentReferenceCode> allPaymentCodes() {
        return this.referenceCodePool.getPaymentReferenceCodesSet();
    }

    public PaymentReferenceCode generateNewCodeFor(BigDecimal bigDecimal, LocalDate localDate, LocalDate localDate2, boolean bl) {
        return (PaymentReferenceCode)((Object)advice$generateNewCodeFor.perform((Callable)new SequentialPaymentCodeGenerator$callable$generateNewCodeFor(this, bigDecimal, localDate, localDate2, bl)));
    }

    static /* synthetic */ PaymentReferenceCode advised$generateNewCodeFor(SequentialPaymentCodeGenerator this_, BigDecimal amount, LocalDate validFrom, LocalDate validTo, boolean useFixedAmount) {
        return this_.generateNewCodeFor(amount, validFrom, validTo, useFixedAmount, false);
    }

    public PaymentReferenceCode generateNewCodeFor(BigDecimal bigDecimal, LocalDate localDate, LocalDate localDate2, boolean bl, boolean bl2) {
        return (PaymentReferenceCode)((Object)advice$generateNewCodeFor$1.perform((Callable)new SequentialPaymentCodeGenerator$callable$generateNewCodeFor$1(this, bigDecimal, localDate, localDate2, bl, bl2)));
    }

    static /* synthetic */ PaymentReferenceCode advised$generateNewCodeFor(SequentialPaymentCodeGenerator this_, BigDecimal amount, LocalDate validFrom, LocalDate validTo, boolean useFixedAmount, boolean forceGeneration) {
        if (!forceGeneration) {
            for (PaymentReferenceCode paymentReferenceCode : this_.referenceCodePool.getPaymentReferenceCodesSet()) {
                if (!paymentReferenceCode.isNew() || TreasuryConstants.isGreaterThan(amount, paymentReferenceCode.getMaxAmount()) || TreasuryConstants.isLessThan(amount, paymentReferenceCode.getMinAmount()) || paymentReferenceCode.getTargetPayment() != null || validTo != null && !paymentReferenceCode.getValidInterval().contains((ReadableInstant)validTo.toDateTimeAtStartOfDay()) || !paymentReferenceCode.getValidInterval().contains((ReadableInstant)new DateTime()) || validFrom != null && !paymentReferenceCode.getValidInterval().contains((ReadableInstant)validFrom.toDateTimeAtStartOfDay()) || !paymentReferenceCode.getValidInterval().contains((ReadableInstant)new DateTime())) continue;
                paymentReferenceCode.setPayableAmount(amount);
                return paymentReferenceCode;
            }
        }
        if (!this_.canGenerateNewCode(forceGeneration)) {
            throw new TreasuryDomainException("error.SequentialPaymentCodeGenerator.generateNewCodeFor.cannot.generate.new.code", new String[0]);
        }
        Long nextSequentialNumber = this_.referenceCodePool.getAndIncrementNextReferenceCode();
        String sequentialNumberPadded = StringUtils.leftPad((String)String.valueOf(nextSequentialNumber), (int)7, (String)CODE_FILLER);
        String controDigitsPadded = StringUtils.leftPad((String)String.valueOf(new Random().nextInt(99)), (int)2, (String)CODE_FILLER);
        String referenceCodeString = sequentialNumberPadded + controDigitsPadded;
        BigDecimal minAmount = this_.referenceCodePool.getMinAmount();
        BigDecimal maxAmount = this_.referenceCodePool.getMaxAmount();
        if (useFixedAmount) {
            minAmount = amount;
            maxAmount = amount;
        } else if (TreasuryConstants.isGreaterThan(amount, maxAmount)) {
            maxAmount = amount;
        }
        PaymentReferenceCode newPaymentReference = PaymentReferenceCode.create(referenceCodeString, validFrom, validTo, PaymentReferenceCodeStateType.UNUSED, this_.referenceCodePool, minAmount, maxAmount);
        newPaymentReference.setPayableAmount(amount);
        return newPaymentReference;
    }

    @Override
    public PaymentCodePool getReferenceCodePool() {
        return this.referenceCodePool;
    }

    @Override
    public PaymentReferenceCode createPaymentReferenceCode(DebtAccount debtAccount, PaymentReferenceCodeBean paymentReferenceCodeBean) {
        return (PaymentReferenceCode)((Object)advice$createPaymentReferenceCode.perform((Callable)new SequentialPaymentCodeGenerator$callable$createPaymentReferenceCode(this, debtAccount, paymentReferenceCodeBean)));
    }

    static /* synthetic */ PaymentReferenceCode advised$createPaymentReferenceCode(SequentialPaymentCodeGenerator this_, DebtAccount debtAccount, PaymentReferenceCodeBean bean) {
        long activePaymentCodesOnDebitEntryCount;
        for (DebitEntry debitEntry : bean.getSelectedDebitEntries()) {
            activePaymentCodesOnDebitEntryCount = MultipleEntriesPaymentCode.findNewByDebitEntry(debitEntry).count() + MultipleEntriesPaymentCode.findUsedByDebitEntry(debitEntry).count();
            if (activePaymentCodesOnDebitEntryCount < 2L) continue;
            throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.debit.entry.with.active.payment.code", debitEntry.getDescription());
        }
        for (Installment installment : bean.getSelectedInstallments()) {
            activePaymentCodesOnDebitEntryCount = MultipleEntriesPaymentCode.findNewByInstallment(installment).count() + MultipleEntriesPaymentCode.findUsedByInstallment(installment).count();
            if (activePaymentCodesOnDebitEntryCount < 2L) continue;
            throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.debit.entry.with.active.payment.code", installment.getDescription().getContent());
        }
        PaymentReferenceCode paymentReferenceCode = this_.generateNewCodeFor(bean.getPaymentAmount(), bean.getValidFrom(), bean.getValidTo(), this_.getIsFixedAmount(bean.getPaymentCodePool()));
        paymentReferenceCode.createPaymentTargetTo(Sets.newHashSet(bean.getSelectedDebitEntries()), Sets.newHashSet(bean.getSelectedInstallments()), bean.getPaymentAmount());
        return paymentReferenceCode;
    }

    private boolean getIsFixedAmount(DigitalPaymentPlatform platform) {
        return ((SibsPaymentCodePool)((Object)platform)).getUseCheckDigit();
    }

    @Override
    public boolean isSibsMerchantTransactionAndReferenceIdRequired() {
        return false;
    }
}

