/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.ProductGroup$callable$create;
import org.fenixedu.treasury.domain.ProductGroup$callable$delete;
import org.fenixedu.treasury.domain.ProductGroup$callable$edit;
import org.fenixedu.treasury.domain.ProductGroup_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ProductGroup
extends ProductGroup_Base {
    public static final int MAX_PRODUCT_CODE_LENGHT = 50;
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected ProductGroup() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected ProductGroup(String code, LocalizedString name) {
        this();
        this.setCode(code);
        this.setName(name);
        this.checkRules();
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.ProductGroup.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.ProductGroup.name.required", new String[0]);
        }
        if (this.getCode().length() > 50) {
            throw new TreasuryDomainException("error.ProductGroup.code.max.length", new String[0]);
        }
        ProductGroup.findByCode(this.getCode());
        this.getName().getLocales().stream().forEach(l -> ProductGroup.findByName(this.getName().getContent(l)));
    }

    public void edit(String string, LocalizedString localizedString) {
        Object object = advice$edit.perform((Callable)new ProductGroup$callable$edit(this, string, localizedString));
    }

    static /* synthetic */ void advised$edit(ProductGroup this_, String code, LocalizedString name) {
        this_.setCode(code);
        this_.setName(name);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getProductsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ProductGroup$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ProductGroup this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.ProductGroup.cannot.delete", new String[0]);
        }
        this_.getVatTypesSet().clear();
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static Set<ProductGroup> readAll() {
        return FenixFramework.getDomainRoot().getProductGroupsSet();
    }

    public static ProductGroup findByCode(String code) {
        ProductGroup result = null;
        for (ProductGroup it : ProductGroup.readAll()) {
            if (!it.getCode().equalsIgnoreCase(code)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.ProductGroup.duplicated.code", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static ProductGroup findByName(String name) {
        ProductGroup result = null;
        for (ProductGroup it : ProductGroup.readAll()) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.ProductGroup.duplicated.name", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static ProductGroup create(String string, LocalizedString localizedString) {
        return (ProductGroup)((Object)advice$create.perform((Callable)new ProductGroup$callable$create(string, localizedString)));
    }

    static /* synthetic */ ProductGroup advised$create(String code, LocalizedString name) {
        return new ProductGroup(code, name);
    }
}

