/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.groups;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.groups.CustomGroup;
import org.fenixedu.treasury.domain.accesscontrol.PersistentTreasuryBackOfficeGroup;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;

@GroupOperator(value="treasuryBackOffice")
public class TreasuryBackOfficeGroup
extends CustomGroup {
    private static final long serialVersionUID = -933441447959188208L;
    private static final TreasuryBackOfficeGroup INSTANCE = new TreasuryBackOfficeGroup();

    private TreasuryBackOfficeGroup() {
    }

    public static TreasuryBackOfficeGroup get() {
        return INSTANCE;
    }

    public String getPresentationName() {
        return TreasuryConstants.treasuryBundle("label.TreasuryBackOfficeGroup.description", new String[0]);
    }

    public Stream<User> getMembers() {
        HashSet result = Sets.newHashSet();
        for (String username : TreasuryAccessControlAPI.getBackOfficeMemberUsernames()) {
            User user = User.findByUsername((String)username);
            if (user == null) continue;
            result.add(user);
        }
        return result.stream();
    }

    public boolean isMember(User user) {
        return this.getMembers().anyMatch(u -> u == user);
    }

    public Stream<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public boolean equals(Object object) {
        return object instanceof TreasuryBackOfficeGroup;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{TreasuryBackOfficeGroup.class});
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentTreasuryBackOfficeGroup.getInstance();
    }
}

