/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile$callable$processSIBSIncommingFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile$callable$updateLogMessages;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile_Base;
import org.fenixedu.treasury.domain.paymentcodes.SibsSpreadsheetRowReportBean;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationFileDTO;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationLineDTO;
import org.fenixedu.treasury.services.payments.sibs.SIBSPaymentsImporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.fenixedu.treasury.util.streaming.spreadsheet.ExcelSheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsReportFile
extends SibsReportFile_Base
implements IGenericFile {
    public static final Comparator<SibsReportFile> COMPARATOR_BY_CREATION_DATE;
    public static final String CONTENT_TYPE = "text/plain";
    public static final String FILE_EXTENSION = ".idm";
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$updateLogMessages;
    public static final Advice advice$create;
    public static final Advice advice$processSIBSIncommingFile;

    protected SibsReportFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    protected SibsReportFile(String sibsEntityCode, DateTime whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost, String displayName, String fileName, byte[] content) {
        this();
        this.init(sibsEntityCode, whenProcessedBySibs, transactionsTotalAmount, totalCost, displayName, fileName, content);
        this.checkRules();
    }

    protected void init(String sibsEntityCode, DateTime whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost, String displayName, String fileName, byte[] content) {
        TreasuryPlataformDependentServicesFactory.implementation().createFile(this, fileName, CONTENT_TYPE, content);
        this.setSibsEntityCode(sibsEntityCode);
        this.setWhenProcessedBySibs(whenProcessedBySibs);
        this.setTransactionsTotalAmount(transactionsTotalAmount);
        this.setTotalCost(totalCost);
        this.checkRules();
    }

    private void checkRules() {
    }

    public void edit(DateTime dateTime, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Object object = advice$edit.perform((Callable)new SibsReportFile$callable$edit(this, dateTime, bigDecimal, bigDecimal2));
    }

    static /* synthetic */ void advised$edit(SibsReportFile this_, DateTime whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost) {
        this_.setWhenProcessedBySibs(whenProcessedBySibs);
        this_.setTransactionsTotalAmount(transactionsTotalAmount);
        this_.setTotalCost(totalCost);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getReferenceCodesSet().isEmpty() && this.getSibsTransactionsSet().isEmpty();
    }

    @Override
    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsReportFile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsReportFile this_) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.SibsReportFile.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        services.deleteFile(this_);
        super.deleteDomainObject();
    }

    public static Stream<SibsReportFile> findAll() {
        return FenixFramework.getDomainRoot().getSibsReportFilesSet().stream();
    }

    public static Stream<SibsReportFile> findByWhenProcessedBySibs(LocalDate whenProcessedBySibs) {
        return SibsReportFile.findAll().filter(i -> whenProcessedBySibs.equals((Object)i.getWhenProcessedBySibs()));
    }

    public static Stream<SibsReportFile> findByTransactionsTotalAmount(BigDecimal transactionsTotalAmount) {
        return SibsReportFile.findAll().filter(i -> transactionsTotalAmount.equals(i.getTransactionsTotalAmount()));
    }

    public static Stream<SibsReportFile> findByTotalCost(BigDecimal totalCost) {
        return SibsReportFile.findAll().filter(i -> totalCost.equals(i.getTotalCost()));
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember(username);
    }

    public void updateLogMessages(SIBSPaymentsImporter.ProcessResult processResult) {
        Object object = advice$updateLogMessages.perform((Callable)new SibsReportFile$callable$updateLogMessages(this, processResult));
    }

    static /* synthetic */ void advised$updateLogMessages(SibsReportFile this_, SIBSPaymentsImporter.ProcessResult result) {
        StringBuilder build = new StringBuilder();
        for (String s : result.getErrorMessages()) {
            build.append(s + "\n");
        }
        this_.setErrorLog(build.toString());
        build = new StringBuilder();
        for (String s : result.getActionMessages()) {
            build.append(s + "\n");
        }
        this_.setInfoLog(build.toString());
    }

    public static SibsReportFile create(String string, DateTime dateTime, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string2, String string3, byte[] byArray) {
        return (SibsReportFile)advice$create.perform((Callable)new SibsReportFile$callable$create(string, dateTime, bigDecimal, bigDecimal2, string2, string3, byArray));
    }

    static /* synthetic */ SibsReportFile advised$create(String sibsEntityCode, DateTime whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost, String displayName, String fileName, byte[] content) {
        return new SibsReportFile(sibsEntityCode, whenProcessedBySibs, transactionsTotalAmount, totalCost, displayName, fileName, content);
    }

    protected static byte[] buildContentFor(SIBSImportationFileDTO reportFileDTO) {
        final Stream<SibsSpreadsheetRowReportBean> lines = reportFileDTO.getLines().stream().map(l -> new SibsSpreadsheetRowReportBean((SIBSImportationLineDTO)l));
        return Spreadsheet.buildSpreadsheetContent(new Spreadsheet(){

            @Override
            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{ExcelSheet.create(TreasuryConstants.treasuryBundle("label.SibsReportFile.spreadsheet.name", new String[0]), SibsSpreadsheetRowReportBean.SPREADSHEET_HEADERS, lines)};
            }
        }, null);
    }

    protected static String filenameFor(SIBSImportationFileDTO reportFileDTO) {
        String date = new DateTime().toString("yyyyMMddHHmm");
        return "Relatorio-SIBS-" + date + ".xlsx";
    }

    protected static String displayNameFor(SIBSImportationFileDTO reportFileDTO) {
        String date = new DateTime().toString("yyyyMMddHHmm");
        return "Relatorio-SIBS-" + date;
    }

    public static SibsReportFile processSIBSIncommingFile(SIBSImportationFileDTO sIBSImportationFileDTO) {
        return (SibsReportFile)advice$processSIBSIncommingFile.perform((Callable)new SibsReportFile$callable$processSIBSIncommingFile(sIBSImportationFileDTO));
    }

    static /* synthetic */ SibsReportFile advised$processSIBSIncommingFile(SIBSImportationFileDTO reportDTO) {
        byte[] content = SibsReportFile.buildContentFor(reportDTO);
        SibsReportFile result = SibsReportFile.create(reportDTO.getSibsEntityCode(), reportDTO.getWhenProcessedBySibs(), reportDTO.getTransactionsTotalAmount(), reportDTO.getTotalCost(), SibsReportFile.displayNameFor(reportDTO), SibsReportFile.filenameFor(reportDTO), content);
        return result;
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$updateLogMessages = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$processSIBSIncommingFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_CREATION_DATE = (o1, o2) -> {
            int c = o1.getCreationDate().compareTo((ReadableInstant)o2.getCreationDate());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

