/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanNumberGenerator;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanSettings$callable$create;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanSettings$callable$delete;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanSettings$callable$setActive;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanSettings_Base;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Deprecated
public class PaymentPlanSettings
extends PaymentPlanSettings_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$setActive = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PaymentPlanSettings() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        super.setActive(Boolean.FALSE);
        this.setTreasurySettings(TreasurySettings.getInstance());
    }

    private PaymentPlanSettings(LocalizedString installmentDescriptionFormat, Boolean interestCalculationOfDebitsInPlans, Product emolumentProduct, Integer numberOfPaymentPlansActives, PaymentPlanNumberGenerator numberGenerator) {
        this();
        this.setInstallmentDescriptionFormat(installmentDescriptionFormat);
        this.setInterestCalculationOfDebitsInPlans(interestCalculationOfDebitsInPlans);
        this.setEmolumentProduct(emolumentProduct);
        this.setNumberOfPaymentPlansActives(numberOfPaymentPlansActives);
        this.setNumberGenerators(numberGenerator);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getTreasurySettings() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.treasurySettings.required", new String[0]);
        }
        if (this.getInstallmentDescriptionFormat() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.InstallmentDescriptionFormat.required", new String[0]);
        }
        if (this.getInterestCalculationOfDebitsInPlans() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.InterestCalculationOfDebitsInPlans.required", new String[0]);
        }
        if (this.getEmolumentProduct() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.EmolumentProduct.required", new String[0]);
        }
        if (Boolean.TRUE.equals(this.getActive()) && this.getTreasurySettings().getPaymentPlanSettingsSet().stream().anyMatch(p -> p != this && Boolean.TRUE.equals(p.getActive()))) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.only.one.can.be.active", new String[0]);
        }
        if (this.getNumberOfPaymentPlansActives() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.numberOfPaymentPlansActives.required", new String[0]);
        }
        if (this.getInstallmentDescriptionFormat().anyMatch(o -> !o.contains("${paymentPlanId}"))) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.installmentDescriptionFormat.payment.plan.id.required", new String[0]);
        }
        if (this.getInstallmentDescriptionFormat().anyMatch(o -> !o.contains("${installmentNumber}"))) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.installmentDescriptionFormat.installment.number.required", new String[0]);
        }
        if (this.getNumberGenerators() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.NumberGenerators.required", new String[0]);
        }
    }

    public static PaymentPlanSettings create(LocalizedString localizedString, Boolean bl, Product product, Integer n, PaymentPlanNumberGenerator paymentPlanNumberGenerator) {
        return (PaymentPlanSettings)((Object)advice$create.perform((Callable)new PaymentPlanSettings$callable$create(localizedString, bl, product, n, paymentPlanNumberGenerator)));
    }

    static /* synthetic */ PaymentPlanSettings advised$create(LocalizedString installmentDescriptionFormat, Boolean interestCalculationOfDebitsInPlans, Product emolumentProduct, Integer numberOfPaymentPlansActives, PaymentPlanNumberGenerator numberGenerator) {
        return new PaymentPlanSettings(installmentDescriptionFormat, interestCalculationOfDebitsInPlans, emolumentProduct, numberOfPaymentPlansActives, numberGenerator);
    }

    public void setActive(Boolean bl) {
        Object object = advice$setActive.perform((Callable)new PaymentPlanSettings$callable$setActive(this, bl));
    }

    static /* synthetic */ void advised$setActive(PaymentPlanSettings this_, Boolean active) {
        super.setActive(active);
        this_.checkRules();
    }

    public static Stream<PaymentPlanSettings> findAll() {
        return FenixFramework.getDomainRoot().getPaymentPlanSettingsSet().stream();
    }

    public static PaymentPlanSettings getActiveInstance() {
        return TreasurySettings.getInstance().getPaymentPlanSettingsSet().stream().filter(p -> Boolean.TRUE.equals(p.getActive())).findFirst().orElse(null);
    }

    public Boolean isActive() {
        return Boolean.TRUE.equals(this.getActive());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentPlanSettings$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentPlanSettings this_) {
        if (this_.getActive().booleanValue()) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.active.cannot.be.deleted", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setTreasurySettings(null);
        this_.setEmolumentProduct(null);
        this_.setNumberGenerators(null);
        super.deleteDomainObject();
    }
}

