/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.services.payments.virtualpaymententries.IVirtualPaymentEntryHandler;
import org.fenixedu.treasury.services.payments.virtualpaymententries.VirtualPaymentEntryFactory;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public class PaymentPenaltyEntryBean
implements ISettlementInvoiceEntryBean,
ITreasuryBean,
Serializable {
    private static final String VIRTUAL_PAYMENT_ENTRY_HANDLER = "virtualPaymentEntryHandler";
    private static final String DESCRIPTION = "description";
    private static final String CALCULATED_DESCRIPTION = "calculatedDescription";
    private static final String DUE_DATE = "dueDate";
    private DebitEntry originDebitEntry;
    private boolean isIncluded;
    private boolean isNotValid;
    private String description;
    private LocalDate dueDate;
    private BigDecimal amount;
    private IVirtualPaymentEntryHandler virtualPaymentEntryHandler;
    private Map<String, List<String>> calculationDescription;

    public PaymentPenaltyEntryBean() {
        this.isIncluded = false;
    }

    public PaymentPenaltyEntryBean(DebitEntry originDebitEntry, String description, LocalDate dueDate, BigDecimal amount) {
        this.originDebitEntry = originDebitEntry;
        this.description = description;
        this.dueDate = dueDate;
        this.amount = amount;
    }

    public DebitEntry getDebitEntry() {
        return this.originDebitEntry;
    }

    @Override
    public InvoiceEntry getInvoiceEntry() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public LocalDate getDueDate() {
        return this.dueDate;
    }

    @Override
    public BigDecimal getEntryAmount() {
        return this.amount;
    }

    @Override
    public BigDecimal getEntryOpenAmount() {
        return this.amount;
    }

    @Override
    public BigDecimal getSettledAmount() {
        return this.amount;
    }

    @Override
    public void setSettledAmount(BigDecimal debtAmount) {
        this.amount = debtAmount;
    }

    @Override
    public Vat getVat() {
        return null;
    }

    @Override
    public BigDecimal getVatRate() {
        return null;
    }

    @Override
    public boolean isIncluded() {
        return this.isIncluded;
    }

    @Override
    public void setIncluded(boolean isIncluded) {
        this.isIncluded = isIncluded;
    }

    @Override
    public boolean isNotValid() {
        return this.isNotValid;
    }

    @Override
    public void setNotValid(boolean notValid) {
        this.isNotValid = notValid;
    }

    @Override
    public FinantialDocument getFinantialDocument() {
        return null;
    }

    @Override
    public Set<Customer> getPaymentCustomer() {
        return this.originDebitEntry.getFinantialDocument() != null && ((Invoice)((Object)this.originDebitEntry.getFinantialDocument())).getPayorDebtAccount() != null ? Collections.singleton(((Invoice)((Object)this.originDebitEntry.getFinantialDocument())).getPayorDebtAccount().getCustomer()) : Collections.singleton(this.originDebitEntry.getDebtAccount().getCustomer());
    }

    @Override
    public boolean isForPaymentPenalty() {
        return true;
    }

    @Override
    public IVirtualPaymentEntryHandler getVirtualPaymentEntryHandler() {
        return this.virtualPaymentEntryHandler;
    }

    public void setVirtualPaymentEntryHandler(IVirtualPaymentEntryHandler virtualPaymentEntryHandler) {
        this.virtualPaymentEntryHandler = virtualPaymentEntryHandler;
    }

    @Override
    public Map<String, List<String>> getCalculationDescription() {
        return this.calculationDescription;
    }

    public void setCalculationDescription(Map<String, List<String>> calculationDescription) {
        this.calculationDescription = calculationDescription;
    }

    @Override
    public String serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(this.getClass().getName()));
        jsonObject.add("amount", (JsonElement)new JsonPrimitive(this.getSettledAmount().toPlainString()));
        jsonObject.add(CALCULATED_DESCRIPTION, (JsonElement)new JsonPrimitive(this.serializeCalculationDescription(this.calculationDescription)));
        jsonObject.add(DESCRIPTION, (JsonElement)new JsonPrimitive(this.description));
        jsonObject.add(DUE_DATE, (JsonElement)new JsonPrimitive(this.dueDate.toString()));
        jsonObject.add("included", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.isIncluded)));
        jsonObject.add("notValid", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.isNotValid)));
        jsonObject.add("debitEntryId", (JsonElement)new JsonPrimitive(this.originDebitEntry.getExternalId()));
        jsonObject.add(VIRTUAL_PAYMENT_ENTRY_HANDLER, (JsonElement)new JsonPrimitive(this.virtualPaymentEntryHandler != null ? this.virtualPaymentEntryHandler.getClass().getName() : ""));
        return jsonObject.toString();
    }

    @Override
    public void fillSerializable(JsonObject jsonObject) {
        this.amount = jsonObject.get("amount").getAsBigDecimal();
        this.calculationDescription = this.deserializeCalculationDescription(jsonObject.get(CALCULATED_DESCRIPTION).getAsString());
        this.description = jsonObject.get(DESCRIPTION).getAsString();
        this.dueDate = LocalDate.parse((String)jsonObject.get(DUE_DATE).getAsString());
        this.isIncluded = jsonObject.get("included").getAsBoolean();
        this.isNotValid = jsonObject.get("notValid").getAsBoolean();
        this.originDebitEntry = (DebitEntry)FenixFramework.getDomainObject((String)jsonObject.get("debitEntryId").getAsString());
        for (IVirtualPaymentEntryHandler handler : VirtualPaymentEntryFactory.implementation().getHandlers()) {
            String className = jsonObject.get(VIRTUAL_PAYMENT_ENTRY_HANDLER).getAsString();
            if (!className.equals(handler.getClass().getName())) continue;
            this.virtualPaymentEntryHandler = handler;
        }
    }

    private String serializeCalculationDescription(Map<String, List<String>> calculationDescription2) {
        Gson gson = new Gson();
        Type listType = new TypeToken<Map<String, List<String>>>(){}.getType();
        return gson.toJson(calculationDescription2, listType);
    }

    private Map<String, List<String>> deserializeCalculationDescription(String asString) {
        Gson gson = new Gson();
        Type listType = new TypeToken<Map<String, List<String>>>(){}.getType();
        return (Map)gson.fromJson(asString, listType);
    }
}

