/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import com.qubit.terra.framework.tools.excel.ExcelUtil;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationLineDTO;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;

public class SibsSpreadsheetRowReportBean
implements SpreadsheetRow {
    public static String[] SPREADSHEET_HEADERS = new String[]{TreasuryConstants.treasuryBundle("label.SibsReportFile.whenProcessedBySibs", new String[0]), TreasuryConstants.treasuryBundle("label.SibsReportFile.filename", new String[0]), TreasuryConstants.treasuryBundle("label.SibsReportFile.transactionsTotalAmount", new String[0]), TreasuryConstants.treasuryBundle("label.SibsReportFile.totalCost", new String[0]), TreasuryConstants.treasuryBundle("label.SibsReportFile.fileVersion", new String[0]), TreasuryConstants.treasuryBundle("label.SibsReportFile.sibsTransactionId", new String[0]), TreasuryConstants.treasuryBundle("label.SibsReportFile.transactionTotalAmount", new String[0]), TreasuryConstants.treasuryBundle("label.SibsReportFile.paymentCode", new String[0]), TreasuryConstants.treasuryBundle("label.SibsReportFile.transactionWhenRegistered", new String[0]), TreasuryConstants.treasuryBundle("label.SibsReportFile.studentNumber", new String[0]), TreasuryConstants.treasuryBundle("label.SibsReportFile.personName", new String[0]), TreasuryConstants.treasuryBundle("label.SibsReportFile.description", new String[0])};
    private SIBSImportationLineDTO line;

    public SibsSpreadsheetRowReportBean(SIBSImportationLineDTO line) {
        this.line = line;
    }

    @Override
    public void writeCellValues(Row row, IErrorsLog errorsLog) {
        int i = 0;
        try {
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.line.getWhenProcessedBySibs().toString("yyyy-MM-dd HH:mm:ss"));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.line.getFilename());
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.line.getTransactionsTotalAmount().toPlainString());
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.line.getTotalCost().toPlainString());
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (Number)this.line.getFileVersion());
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.line.getSibsTransactionId());
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.line.getTransactionTotalAmount().toPlainString());
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.line.getCode());
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.line.getTransactionWhenRegistered().toString("yyyy-MM-dd HH:mm:ss"));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.line.getStudentNumber());
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.line.getPersonName());
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.line.getDescription());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)TreasuryConstants.treasuryBundle("error.SibsSpreadsheetRowReportBean.report.generation.verify.line", new String[0]));
            return;
        }
    }
}

