/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.integration;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.IntegrationOperation;
import org.fenixedu.treasury.domain.integration.OperationFile$callable$create;
import org.fenixedu.treasury.domain.integration.OperationFile$callable$createLog;
import org.fenixedu.treasury.domain.integration.OperationFile$callable$delete;
import org.fenixedu.treasury.domain.integration.OperationFile_Base;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class OperationFile
extends OperationFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "application/octet-stream";
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public OperationFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    public OperationFile(String fileName, byte[] content) {
        this();
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        services.createFile(this, fileName, CONTENT_TYPE, content);
        this.checkRules();
    }

    @Override
    public boolean isAccessible(String username) {
        throw new RuntimeException("not implemented");
    }

    private void checkRules() {
    }

    public boolean isDeletable() {
        return true;
    }

    @Override
    public void delete() {
        Object object = advice$delete.perform((Callable)new OperationFile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(OperationFile this_) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.OperationFile.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setLogIntegrationOperation(null);
        this_.setIntegrationOperation(null);
        services.deleteFile(this_);
        super.deleteDomainObject();
    }

    public static OperationFile create(String string, byte[] byArray, IntegrationOperation integrationOperation) {
        return (OperationFile)advice$create.perform((Callable)new OperationFile$callable$create(string, byArray, integrationOperation));
    }

    static /* synthetic */ OperationFile advised$create(String fileName, byte[] content, IntegrationOperation operation) {
        OperationFile operationFile = new OperationFile(fileName, content);
        operationFile.setIntegrationOperation(operation);
        return operationFile;
    }

    public static OperationFile createLog(String string, byte[] byArray, IntegrationOperation integrationOperation) {
        return (OperationFile)advice$createLog.perform((Callable)new OperationFile$callable$createLog(string, byArray, integrationOperation));
    }

    static /* synthetic */ OperationFile advised$createLog(String fileName, byte[] content, IntegrationOperation operation) {
        OperationFile operationFile = new OperationFile(fileName, content);
        operationFile.setLogIntegrationOperation(operation);
        return operationFile;
    }

    public static Stream<OperationFile> findAll() {
        return FenixFramework.getDomainRoot().getOperationFilesSet().stream();
    }
}

