/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.ERPCustomerFieldsBean;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStateLog;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.domain.integration.IntegrationOperationLogBean;
import org.fenixedu.treasury.domain.integration.OperationFile;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager$callable$exportCustomersToIntegration;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager$callable$exportFinantialDocumentToXML;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager$callable$exportFinantialDocumentToXML$1;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager$callable$exportProductsToIntegration;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager$callable$exportSingleDocument;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager$callable$saveSaftContentToOperationFile;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.ReimbursementStateBean;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import org.fenixedu.treasury.services.integration.erp.ISaftExporterConfiguration;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentStatusWS;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationInput;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationOutput;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ERPExporterManager {
    private static ERPExporterManager _INSTANCE;
    private static Logger logger;
    private static final int WAIT_TRANSACTION_TO_FINISH_MS = 500;
    public static final Comparator<FinantialDocument> COMPARE_BY_DOCUMENT_TYPE;
    private static final int LIMIT = 200;
    public static final Advice advice$exportFinantialDocumentToXML;
    public static final Advice advice$exportFinantialDocumentToXML$1;
    public static final Advice advice$exportSingleDocument;
    public static final Advice advice$saveSaftContentToOperationFile;
    public static final Advice advice$exportCustomersToIntegration;
    public static final Advice advice$exportProductsToIntegration;

    public static final ERPExporterManager getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new ERPExporterManager();
        }
        return _INSTANCE;
    }

    public static String saftEncoding(FinantialInstitution finantialInstitution) {
        IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        return erpExporter.saftEncoding();
    }

    public static String exportFinantialDocumentToXML(FinantialDocument finantialDocument) {
        return (String)advice$exportFinantialDocumentToXML.perform((Callable)new ERPExporterManager$callable$exportFinantialDocumentToXML(finantialDocument));
    }

    static /* synthetic */ String advised$exportFinantialDocumentToXML(FinantialDocument finantialDocument) {
        return ERPExporterManager.exportFinantialDocumentToXML(finantialDocument, true);
    }

    public static String exportFinantialDocumentToXML(FinantialDocument finantialDocument, boolean bl) {
        return (String)advice$exportFinantialDocumentToXML$1.perform((Callable)new ERPExporterManager$callable$exportFinantialDocumentToXML$1(finantialDocument, bl));
    }

    static /* synthetic */ String advised$exportFinantialDocumentToXML(FinantialDocument finantialDocument, boolean validateDocument) {
        FinantialInstitution finantialInstitution = finantialDocument.getDebtAccount().getFinantialInstitution();
        ERPConfiguration erpIntegrationConfiguration = finantialDocument.getDebtAccount().getFinantialInstitution().getErpIntegrationConfiguration();
        IERPExporter erpExporter = erpIntegrationConfiguration.getERPExternalServiceImplementation().getERPExporter();
        if (TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration) != null) {
            ISaftExporterConfiguration saftExporterConfiguration = TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration);
            List<FinantialDocument> documentsToExport = new ArrayList<FinantialDocument>();
            documentsToExport.add(finantialDocument);
            documentsToExport = erpExporter.processCreditNoteSettlementsInclusion(documentsToExport);
            documentsToExport.stream().forEach(document -> ERPExporterManager.validateDocumentWithERPConfiguration(document, erpIntegrationConfiguration));
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                saftExporterConfiguration.generateSaftForFinantialDocuments(documentsToExport, true, baos, validateDocument);
                return new String(baos.toByteArray(), saftExporterConfiguration.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return erpExporter.exportFinantialDocumentToXML(finantialInstitution, Lists.newArrayList((Object[])new FinantialDocument[]{finantialDocument}));
    }

    public static List<ERPExportOperation> exportPendingDocumentsForFinantialInstitution(FinantialInstitution finantialInstitution) {
        return ERPExporterManager.exportPendingDocumentsForFinantialInstitution(finantialInstitution, null);
    }

    public static List<ERPExportOperation> exportPendingDocumentsForFinantialInstitution(FinantialInstitution finantialInstitution, Runnable runnable) {
        List<FinantialDocument> sortedDocuments;
        IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        if (!finantialInstitution.getErpIntegrationConfiguration().getActive()) {
            return Lists.newArrayList();
        }
        Stream<FinantialDocument> stream = finantialInstitution.getFinantialDocumentsPendingForExportationSet().stream();
        if (ERPExporterManager.isUsingSaftConfiguration(finantialInstitution)) {
            stream = ERPExporterManager.applyAdditionalFilterForSaftConfiguration(stream);
        }
        if ((sortedDocuments = erpExporter.filterDocumentsToExport(stream)).isEmpty()) {
            return Lists.newArrayList();
        }
        if (finantialInstitution.getErpIntegrationConfiguration().getExportOnlyRelatedDocumentsPerExport()) {
            ArrayList result = Lists.newArrayList();
            while (!sortedDocuments.isEmpty()) {
                ArrayList errorMessages;
                FinantialDocument doc = sortedDocuments.iterator().next();
                sortedDocuments.remove((Object)doc);
                Customer customer = doc.getDebtAccount().getCustomer();
                if (!ERPCustomerFieldsBean.validateAddress(customer, (List<String>)(errorMessages = Lists.newArrayList())) && !doc.getErpExportOperationsSet().isEmpty()) continue;
                if (runnable != null) {
                    runnable.run();
                }
                result.add(ERPExporterManager.exportSingleDocument(doc));
            }
            return result;
        }
        return Lists.newArrayList();
    }

    private static boolean isUsingSaftConfiguration(FinantialInstitution finantialInstitution) {
        return TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(finantialInstitution.getErpIntegrationConfiguration()) != null;
    }

    private static Stream<FinantialDocument> applyAdditionalFilterForSaftConfiguration(Stream<FinantialDocument> stream) {
        return stream;
    }

    public static List<ReimbursementProcessStateLog> updatePendingReimbursementNotes(FinantialInstitution finantialInstitution) {
        List settlementNotes = FinantialDocument.find(FinantialDocumentType.findForReimbursementNote()).map(SettlementNote.class::cast).filter(s -> s.getDebtAccount().getFinantialInstitution() == finantialInstitution).filter(s -> !s.isDocumentToExport()).filter(s -> s.isReimbursementPending()).collect(Collectors.toList());
        for (SettlementNote note : settlementNotes) {
            try {
                ReimbursementProcessStateLog log2 = ERPExporterManager.updateReimbursementState(note);
                logger.info("Reimbursement update %s => %s", (Object)note.getUiDocumentNumber(), (Object)log2.getReimbursementProcessStatusType().getCode());
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static List<ERPExportOperation> exportPendingDocumentsForDebtAccount(DebtAccount debtAccount) {
        FinantialInstitution finantialInstitution = debtAccount.getFinantialInstitution();
        IERPExporter erpExporter = debtAccount.getFinantialInstitution().getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        List<FinantialDocument> sortedDocuments = erpExporter.filterDocumentsToExport(debtAccount.getFinantialDocumentsSet().stream());
        if (sortedDocuments.isEmpty()) {
            return Lists.newArrayList();
        }
        if (finantialInstitution.getErpIntegrationConfiguration().getExportOnlyRelatedDocumentsPerExport()) {
            ArrayList result = Lists.newArrayList();
            int i = 0;
            while (!sortedDocuments.isEmpty()) {
                FinantialDocument doc = sortedDocuments.iterator().next();
                sortedDocuments.remove((Object)doc);
                result.add(ERPExporterManager.exportSingleDocument(doc));
                if (++i < 200) continue;
                System.out.println("ERPExporterManager: Limit 200 finantial documents.");
                break;
            }
            return result;
        }
        return Lists.newArrayList();
    }

    public static void scheduleSingleDocument(FinantialDocument finantialDocument) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        services.scheduleDocumentForExportation(finantialDocument);
    }

    public static ERPExportOperation exportSingleDocument(FinantialDocument finantialDocument) {
        return (ERPExportOperation)((Object)advice$exportSingleDocument.perform((Callable)new ERPExporterManager$callable$exportSingleDocument(finantialDocument)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ERPExportOperation advised$exportSingleDocument(FinantialDocument finantialDocument) {
        FinantialInstitution finantialInstitution = finantialDocument.getDebtAccount().getFinantialInstitution();
        ERPConfiguration erpIntegrationConfiguration = finantialInstitution.getErpIntegrationConfiguration();
        IERPExporter erpExporter = erpIntegrationConfiguration.getERPExternalServiceImplementation().getERPExporter();
        List<FinantialDocument> documentsToExport = erpExporter.filterDocumentsToExport(Collections.singletonList(finantialDocument).stream());
        if (documentsToExport.isEmpty()) {
            return null;
        }
        if (TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration) != null) {
            ISaftExporterConfiguration saftExporterConfiguration = TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration);
            ERPExporterManager.checkForUnsetDocumentSeriesNumberInDocumentsToExport(documentsToExport);
            if (!finantialInstitution.getErpIntegrationConfiguration().isIntegratedDocumentsExportationEnabled()) {
                documentsToExport = documentsToExport.stream().filter(x -> x.isDocumentToExport()).collect(Collectors.toList());
            }
            IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
            ERPExportOperation operation = ERPExportOperation.createSaftExportOperation(null, finantialInstitution, new DateTime());
            documentsToExport.forEach(document -> operation.addFinantialDocuments((FinantialDocument)((Object)document)));
            try {
                documentsToExport = erpExporter.processCreditNoteSettlementsInclusion(documentsToExport);
                documentsToExport.stream().forEach(document -> {
                    if (!erpIntegrationConfiguration.isIntegratedDocumentsExportationEnabled() && !document.isDocumentToExport()) {
                        throw new TreasuryDomainException("error.ERPExporter.document.already.exported", document.getUiDocumentNumber());
                    }
                    ERPExporterManager.validateDocumentWithERPConfiguration(document, erpIntegrationConfiguration);
                });
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.starting.finantialdocuments.integration", new String[0]));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                saftExporterConfiguration.generateSaftForFinantialDocuments(documentsToExport, false, baos);
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.erp.xml.content.generated", new String[0]));
                byte[] contents = baos.toByteArray();
                ERPExporterManager.saveSaftContentToOperationFile(contents, operation);
                boolean success = ERPExporterManager.sendDocumentsInformationToIntegration(finantialInstitution, contents, logBean);
                operation.getFinantialDocumentsSet().addAll(documentsToExport);
                operation.setSuccess(success);
            }
            catch (Exception ex) {
                ERPExporterManager.writeError(operation, logBean, ex);
            }
            finally {
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.finished.finantialdocuments.integration", new String[0]));
                operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
            }
            return operation;
        }
        return erpExporter.exportFinantialDocumentToIntegration(finantialInstitution, documentsToExport);
    }

    private static boolean validateDocumentWithERPConfiguration(FinantialDocument document, ERPConfiguration erpIntegrationConfiguration) {
        CreditNote creditNote;
        if (!erpIntegrationConfiguration.isCreditsOfLegacyDebitWithoutLegacyInvoiceExportEnabled() && document.isCreditNote() && !(creditNote = (CreditNote)((Object)document)).isAdvancePayment() && !creditNote.isExportedInLegacyERP() && creditNote.getDebitNote() != null && creditNote.getDebitNote().isExportedInLegacyERP() && StringUtils.isEmpty((String)creditNote.getDebitNote().getLegacyERPCertificateDocumentReference())) {
            throw new TreasuryDomainException("error.ERPExporter.credit.note.of.legacy.debit.note.without.legacyERPCertificateDocumentReference", new String[]{creditNote.getDebitNote().getUiDocumentNumber(), creditNote.getUiDocumentNumber()});
        }
        return true;
    }

    public static ERPExportOperation exportSettlementNote(SettlementNote settlementNote) {
        FinantialInstitution finantialInstitution = settlementNote.getDebtAccount().getFinantialInstitution();
        ERPConfiguration erpIntegrationConfiguration = finantialInstitution.getErpIntegrationConfiguration();
        IERPExporter erpExporter = erpIntegrationConfiguration.getERPExternalServiceImplementation().getERPExporter();
        List<FinantialDocument> documentsToExport = erpExporter.filterDocumentsToExport(Collections.singletonList(settlementNote).stream());
        if (documentsToExport.isEmpty()) {
            return null;
        }
        for (SettlementEntry settlementEntry : settlementNote.getSettlemetEntriesSet()) {
            if (!settlementEntry.getInvoiceEntry().isDebitNoteEntry()) continue;
            documentsToExport.add(settlementEntry.getInvoiceEntry().getFinantialDocument());
        }
        documentsToExport = erpExporter.filterDocumentsToExport(documentsToExport.stream());
        if (finantialInstitution.getErpIntegrationConfiguration().getExportOnlyRelatedDocumentsPerExport()) {
            ERPExportOperation settlementExportOperation = null;
            while (!documentsToExport.isEmpty()) {
                FinantialDocument doc = documentsToExport.iterator().next();
                documentsToExport.remove((Object)doc);
                ERPExportOperation exportOperation = ERPExporterManager.exportSingleDocument(doc);
                if (settlementNote != doc) continue;
                settlementExportOperation = exportOperation;
            }
            return settlementExportOperation;
        }
        return null;
    }

    public static void requestPendingDocumentStatus(FinantialInstitution finantialInstitution) {
        IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        erpExporter.requestPendingDocumentStatus(finantialInstitution);
    }

    public static ERPExportOperation retryExportToIntegration(ERPExportOperation eRPExportOperation) {
        FinantialInstitution finantialInstitution = eRPExportOperation.getFinantialInstitution();
        ERPConfiguration erpIntegrationConfiguration = finantialInstitution.getErpIntegrationConfiguration();
        IERPExporter erpExporter = erpIntegrationConfiguration.getERPExternalServiceImplementation().getERPExporter();
        List<FinantialDocument> documentsToExport = erpExporter.filterDocumentsToExport(eRPExportOperation.getFinantialDocumentsSet().stream());
        return ERPExporterManager.exportSingleDocument(documentsToExport.iterator().next());
    }

    public static byte[] downloadCertifiedDocumentPrint(FinantialDocument finantialDocument) {
        FinantialInstitution finantialInstitution = finantialDocument.getDebtAccount().getFinantialInstitution();
        IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        if (!finantialInstitution.getErpIntegrationConfiguration().getActive()) {
            throw new TreasuryDomainException("error.ERPExporterManager.integration.not.active", new String[0]);
        }
        return erpExporter.downloadCertifiedDocumentPrint(finantialDocument);
    }

    public static ReimbursementProcessStateLog updateReimbursementState(SettlementNote reimbursementNote) {
        FinantialInstitution finantialInstitution = reimbursementNote.getDebtAccount().getFinantialInstitution();
        IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        if (!finantialInstitution.getErpIntegrationConfiguration().getActive()) {
            throw new TreasuryDomainException("error.ERPExporterManager.integration.not.active", new String[0]);
        }
        if (!reimbursementNote.isReimbursement()) {
            throw new RuntimeException("error");
        }
        ReimbursementStateBean reimbursementStateBean = erpExporter.checkReimbursementState(reimbursementNote);
        if (reimbursementStateBean == null) {
            throw new TreasuryDomainException("error.ERPExporterManager.reimbursementStatusBean.null", new String[0]);
        }
        if (reimbursementStateBean.getReimbursementProcessStatus() == null) {
            throw new TreasuryDomainException("error.ERPExporterManager.reimbursementStatus.unknown", new String[0]);
        }
        ReimbursementProcessStateLog stateLog = ReimbursementProcessStateLog.create(reimbursementNote, reimbursementStateBean.getReimbursementProcessStatus(), UUID.randomUUID().toString(), reimbursementStateBean.getReimbursementStateDate(), reimbursementStateBean.getExerciseYear());
        erpExporter.processReimbursementStateChange(reimbursementNote, reimbursementStateBean.getReimbursementProcessStatus(), reimbursementStateBean.getExerciseYear(), reimbursementStateBean.getReimbursementStateDate());
        return stateLog;
    }

    public static void checkForUnsetDocumentSeriesNumberInDocumentsToExport(List<? extends FinantialDocument> documents) {
        for (FinantialDocument finantialDocument : documents) {
            if (finantialDocument.isDocumentSeriesNumberSet()) continue;
            throw new TreasuryDomainException("error.ERPExporter.document.without.number.series", new String[0]);
        }
    }

    public static OperationFile saveSaftContentToOperationFile(byte[] byArray, ERPExportOperation eRPExportOperation) {
        return (OperationFile)advice$saveSaftContentToOperationFile.perform((Callable)new ERPExporterManager$callable$saveSaftContentToOperationFile(byArray, eRPExportOperation));
    }

    static /* synthetic */ OperationFile advised$saveSaftContentToOperationFile(byte[] content, ERPExportOperation operation) {
        String fileName = operation.getFinantialInstitution().getFiscalNumber() + "_" + operation.getExecutionDate().toString("ddMMyyyy_hhmm") + ".xml";
        OperationFile binaryStream = new OperationFile(fileName, content);
        if (operation.getFile() != null) {
            operation.getFile().delete();
        }
        operation.setFile(binaryStream);
        return binaryStream;
    }

    private static boolean sendDocumentsInformationToIntegration(FinantialInstitution institution, byte[] contents, IntegrationOperationLogBean logBean) throws MalformedURLException {
        DocumentsInformationOutput sendInfoOnlineResult;
        boolean success = true;
        ERPConfiguration erpIntegrationConfiguration = institution.getErpIntegrationConfiguration();
        if (erpIntegrationConfiguration == null) {
            throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
        }
        if (!erpIntegrationConfiguration.getActive()) {
            logBean.appendErrorLog(TreasuryConstants.treasuryBundle("info.ERPExporter.configuration.inactive", new String[0]));
            return false;
        }
        IERPExternalService service = erpIntegrationConfiguration.getERPExternalServiceImplementation();
        logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("info.ERPExporter.sending.inforation", new String[0]));
        DocumentsInformationInput input = new DocumentsInformationInput();
        if ((long)contents.length <= erpIntegrationConfiguration.getMaxSizeBytesToExportOnline()) {
            input.setData(contents);
            sendInfoOnlineResult = service.sendInfoOnline(institution, input);
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("info.ERPExporter.sucess.sending.inforation.online", sendInfoOnlineResult.getRequestId()));
            logBean.setErpOperationId(sendInfoOnlineResult.getRequestId());
            for (DocumentStatusWS status : sendInfoOnlineResult.getDocumentStatus()) {
                String message;
                FinantialDocument document = FinantialDocument.findByUiDocumentNumber(institution, status.getDocumentNumber());
                boolean integratedWithSuccess = status.isIntegratedWithSuccess();
                if (ERPExporterManager.isToIgnoreWsDocument(institution, status)) {
                    if (integratedWithSuccess) {
                        message = TreasuryConstants.treasuryBundle("info.ERPExporter.sucess.integrating.document", status.getDocumentNumber());
                        logBean.appendIntegrationLog(message);
                        continue;
                    }
                    success = false;
                    logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
                    logBean.appendErrorLog(TreasuryConstants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
                    continue;
                }
                if (document != null && integratedWithSuccess) {
                    message = TreasuryConstants.treasuryBundle("info.ERPExporter.sucess.integrating.document", document.getUiDocumentNumber());
                    logBean.appendIntegrationLog(message);
                    document.clearDocumentToExportAndSaveERPCertificationData(message, new LocalDate(), status.getSapDocumentNumber());
                    continue;
                }
                success = false;
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
                logBean.appendErrorLog(TreasuryConstants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
            }
            for (String m : sendInfoOnlineResult.getOtherMessages()) {
                logBean.appendIntegrationLog(m);
            }
            for (String m : sendInfoOnlineResult.getOtherErrorMessages()) {
                logBean.appendErrorLog(m);
            }
        } else {
            throw new TreasuryDomainException("error.ERPExporter.sendDocumentsInformationToIntegration.maxSizeBytesToExportOnline.exceeded", new String[0]);
        }
        logBean.defineSoapInboundMessage(sendInfoOnlineResult.getSoapInboundMessage());
        logBean.defineSoapOutboundMessage(sendInfoOnlineResult.getSoapOutboundMessage());
        return success;
    }

    private static boolean isToIgnoreWsDocument(FinantialInstitution finantialInstitution, DocumentStatusWS status) {
        String documentNumber = status.getDocumentNumber();
        if (documentNumber != null) {
            Optional<Product> product = Product.findUniqueByCode(documentNumber);
            if (product.isPresent()) {
                return true;
            }
            Stream<? extends Customer> customers = Customer.findByCode(documentNumber);
            if (customers.findAny().isPresent()) {
                return true;
            }
        }
        return false;
    }

    private static void writeError(ERPExportOperation operation, IntegrationOperationLogBean logBean, Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        t.printStackTrace(writer);
        logBean.appendErrorLog(out.toString());
        operation.setProcessed(true);
    }

    public static String exportsCustomersToXML(FinantialInstitution finantialInstitution) {
        ERPConfiguration erpIntegrationConfiguration = finantialInstitution.getErpIntegrationConfiguration();
        IERPExporter erpExporter = erpIntegrationConfiguration.getERPExternalServiceImplementation().getERPExporter();
        if (TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration) != null) {
            ISaftExporterConfiguration saftExporterConfiguration = TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                saftExporterConfiguration.generateSaftForCustomers(Customer.find(finantialInstitution).collect(Collectors.toSet()), true, baos);
                return new String(baos.toByteArray(), saftExporterConfiguration.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return erpExporter.exportsCustomersToXML(finantialInstitution);
    }

    public static String exportsProductsToXML(FinantialInstitution finantialInstitution) {
        ERPConfiguration erpIntegrationConfiguration = finantialInstitution.getErpIntegrationConfiguration();
        IERPExporter erpExporter = erpIntegrationConfiguration.getERPExternalServiceImplementation().getERPExporter();
        if (TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration) != null) {
            ISaftExporterConfiguration saftExporterConfiguration = TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                saftExporterConfiguration.generateSaftForProducts(finantialInstitution.getAvailableProductsSet(), true, baos);
                return new String(baos.toByteArray(), saftExporterConfiguration.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return erpExporter.exportsProductsToXML(finantialInstitution);
    }

    public static String exportPendingDocumentsForFinantialInstitutionToXML(FinantialInstitution finantialInstitution) {
        ERPConfiguration erpIntegrationConfiguration = finantialInstitution.getErpIntegrationConfiguration();
        IERPExporter erpExporter = erpIntegrationConfiguration.getERPExternalServiceImplementation().getERPExporter();
        if (TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration) != null) {
            ISaftExporterConfiguration saftExporterConfiguration = TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration);
            try {
                List<FinantialDocument> sortedDocuments = erpExporter.filterDocumentsToExport(finantialInstitution.getFinantialDocumentsPendingForExportationSet().stream());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                saftExporterConfiguration.generateSaftForFinantialDocuments(sortedDocuments, true, baos);
                return new String(baos.toByteArray(), saftExporterConfiguration.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Operation.not.supported");
    }

    public static ERPExportOperation exportCustomersToIntegration(FinantialInstitution finantialInstitution) {
        return (ERPExportOperation)((Object)advice$exportCustomersToIntegration.perform((Callable)new ERPExporterManager$callable$exportCustomersToIntegration(finantialInstitution)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ERPExportOperation advised$exportCustomersToIntegration(FinantialInstitution institution) {
        ERPConfiguration erpIntegrationConfiguration = institution.getErpIntegrationConfiguration();
        if (TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration) != null) {
            IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
            ERPExportOperation operation = ERPExportOperation.createSaftExportOperation(null, institution, new DateTime());
            try {
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.starting.products.integration", new String[0]));
                ISaftExporterConfiguration saftExporterConfiguration = TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                saftExporterConfiguration.generateSaftForCustomers(Customer.find(institution).collect(Collectors.toSet()), false, baos);
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.erp.xml.content.generated", new String[0]));
                byte[] contents = baos.toByteArray();
                ERPExporterManager.saveSaftContentToOperationFile(contents, operation);
                boolean success = ERPExporterManager.sendDocumentsInformationToIntegration(institution, contents, logBean);
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.finished.products.integration", new String[0]));
                operation.setSuccess(success);
            }
            catch (Exception ex) {
                ERPExporterManager.writeError(operation, logBean, ex);
            }
            finally {
                operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
            }
            return operation;
        }
        IERPExporter erpExporter = erpIntegrationConfiguration.getERPExternalServiceImplementation().getERPExporter();
        return erpExporter.exportCustomersToIntegration(institution);
    }

    public static ERPExportOperation exportProductsToIntegration(FinantialInstitution finantialInstitution) {
        return (ERPExportOperation)((Object)advice$exportProductsToIntegration.perform((Callable)new ERPExporterManager$callable$exportProductsToIntegration(finantialInstitution)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ERPExportOperation advised$exportProductsToIntegration(FinantialInstitution institution) {
        ERPConfiguration erpIntegrationConfiguration = institution.getErpIntegrationConfiguration();
        if (TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration) != null) {
            IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
            ERPExportOperation operation = ERPExportOperation.createSaftExportOperation(null, institution, new DateTime());
            try {
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.starting.products.integration", new String[0]));
                ISaftExporterConfiguration saftExporterConfiguration = TreasuryPlataformDependentServicesFactory.implementation().getSaftExporterConfiguration(erpIntegrationConfiguration);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                saftExporterConfiguration.generateSaftForProducts(institution.getAvailableProductsSet(), false, baos);
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.erp.xml.content.generated", new String[0]));
                byte[] contents = baos.toByteArray();
                ERPExporterManager.saveSaftContentToOperationFile(contents, operation);
                boolean success = ERPExporterManager.sendDocumentsInformationToIntegration(institution, contents, logBean);
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.finished.products.integration", new String[0]));
                operation.setSuccess(success);
            }
            catch (Exception ex) {
                ERPExporterManager.writeError(operation, logBean, ex);
            }
            finally {
                operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
            }
            return operation;
        }
        IERPExporter erpExporter = erpIntegrationConfiguration.getERPExternalServiceImplementation().getERPExporter();
        return erpExporter.exportProductsToIntegration(institution);
    }

    static {
        advice$exportFinantialDocumentToXML = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$exportFinantialDocumentToXML$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$exportSingleDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$saveSaftContentToOperationFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$exportCustomersToIntegration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$exportProductsToIntegration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        _INSTANCE = null;
        logger = LoggerFactory.getLogger(ERPExporterManager.class);
        COMPARE_BY_DOCUMENT_TYPE = new Comparator<FinantialDocument>(){

            @Override
            public int compare(FinantialDocument o1, FinantialDocument o2) {
                if (o1.getFinantialDocumentType().equals((Object)o2.getFinantialDocumentType())) {
                    return o1.getUiDocumentNumber().compareTo(o2.getUiDocumentNumber());
                }
                if (o1.isDebitNote()) {
                    return -2;
                }
                if (o1.isCreditNote()) {
                    return -1;
                }
                if (o1.isSettlementNote()) {
                    return 1;
                }
                return 0;
            }
        };
    }
}

