/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.tariff.InterestRateType$callable$createInterestDebitEntriesForOriginDebitEntry;
import org.fenixedu.treasury.domain.tariff.InterestRateType$callable$createInterestDebitNoteForDebitNote;
import org.fenixedu.treasury.domain.tariff.InterestRateType_Base;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class InterestRateType
extends InterestRateType_Base {
    public static Comparator<InterestRateType> COMPARE_BY_NAME;
    public static final Advice advice$createInterestDebitNoteForDebitNote;
    public static final Advice advice$createInterestDebitEntriesForOriginDebitEntry;

    public InterestRateType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setRequiresInterestFixedAmount(false);
    }

    public void init(LocalizedString description) {
        this.setCode(UUID.randomUUID().toString());
        this.setDescription(description);
    }

    protected void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new RuntimeException("error.InterestRateType.domainRoot.required");
        }
        if (this.getCode() == null) {
            throw new RuntimeException("error.InterestRateType.code.required");
        }
        if (this.getDescription() == null) {
            throw new RuntimeException("error.InterestRateType.description.required");
        }
    }

    public abstract List<InterestRateBean> calculateInterests(DebitEntry var1, LocalDate var2, boolean var3);

    public abstract List<InterestRateBean> calculateAllInterestsByLockingAtDate(DebitEntry var1, LocalDate var2);

    public boolean isInterestRateTypeDefault() {
        return TreasurySettings.getInstance().getDefaultInterestRateType() == this;
    }

    public boolean isInterestRateTypeActive() {
        return InterestRateType.getAvailableInterestRateTypesSortedByName().contains((Object)this);
    }

    public boolean isInterestFixedAmountRequired() {
        return Boolean.TRUE.equals(this.getRequiresInterestFixedAmount());
    }

    public LocalizedString getInterestRateTypePresentationName() {
        return InterestRateType.getPresentationName(((Object)((Object)this)).getClass());
    }

    public LocalizedString getUiVirtualInterestHandlerCreatedInterestsTitle() {
        return TreasuryConstants.treasuryBundleI18N("label.VirtualInterestHandler.Created_interests", new String[0]);
    }

    public LocalizedString getUiVirtualInterestHandlerCalculatedInterestsTitle() {
        return TreasuryConstants.treasuryBundleI18N("label.VirtualInterestHandler.Calculated_interests", new String[0]);
    }

    public void activate() {
        TreasurySettings.getInstance().getAvailableInterestRateTypesSet().add(this);
    }

    public void deactivate() {
        TreasurySettings.getInstance().getAvailableInterestRateTypesSet().remove((Object)this);
    }

    public void makeDefault() {
        TreasurySettings.getInstance().setDefaultInterestRateType(this);
    }

    public void delete() {
        super.setDomainRoot(null);
        this.getInterestRateEntriesSet().forEach(e -> e.delete());
        super.deleteDomainObject();
    }

    protected TreeMap<LocalDate, BigDecimal> createdInterestEntriesMap(DebitEntry debitEntry) {
        TreeMap<LocalDate, BigDecimal> result = new TreeMap<LocalDate, BigDecimal>();
        for (DebitEntry interestDebitEntry : debitEntry.getInterestDebitEntriesSet()) {
            if (interestDebitEntry.isAnnulled() || !TreasuryConstants.isPositive(interestDebitEntry.getAvailableAmountWithVatForCredit())) continue;
            LocalDate interestEntryDateTime = interestDebitEntry.getEntryDateTime().toLocalDate();
            result.putIfAbsent(interestEntryDateTime, BigDecimal.ZERO);
            result.put(interestEntryDateTime, result.get(interestEntryDateTime).add(interestDebitEntry.getAvailableAmountWithVatForCredit()));
        }
        return result;
    }

    protected LocalDate calculateFirstDateToApplyInterests(DebitEntry debitEntry, boolean postponePaymentLimitDateToFirstWorkDate, boolean applyPenaltyInFirstWorkday) {
        LocalDate dueDate = debitEntry.getDueDate();
        return this.calculateFirstDateToApplyInterests(debitEntry, dueDate, postponePaymentLimitDateToFirstWorkDate, applyPenaltyInFirstWorkday);
    }

    protected LocalDate calculateFirstDateToApplyInterests(DebitEntry debitEntry, LocalDate dueDate, boolean postponePaymentLimitDateToFirstWorkDate, boolean applyPenaltyInFirstWorkday) {
        LocalDate lastDayToPay = dueDate;
        if (postponePaymentLimitDateToFirstWorkDate) {
            while (!this.isWorkday(debitEntry, lastDayToPay)) {
                lastDayToPay = lastDayToPay.plusDays(1);
            }
        }
        int numberOfDaysAfterDueDate = 1;
        LocalDate firstDayToApplyPenalty = lastDayToPay.plusDays(numberOfDaysAfterDueDate);
        if (applyPenaltyInFirstWorkday) {
            while (!this.isWorkday(debitEntry, firstDayToApplyPenalty)) {
                firstDayToApplyPenalty = firstDayToApplyPenalty.plusDays(1);
            }
        }
        return firstDayToApplyPenalty;
    }

    protected boolean isSaturday(LocalDate date) {
        return date.getDayOfWeek() == 6;
    }

    protected boolean isSunday(LocalDate date) {
        return date.getDayOfWeek() == 7;
    }

    protected boolean isWorkday(DebitEntry debitEntry, LocalDate date) {
        return !this.isWeekend(date) && !this.isHoliday(debitEntry, date);
    }

    private boolean isHoliday(DebitEntry debitEntry, LocalDate date) {
        FinantialEntity finantialEntity = this.getFinantialEntity(debitEntry);
        return false;
    }

    private boolean isWeekend(LocalDate date) {
        return this.isSaturday(date) || this.isSunday(date);
    }

    private FinantialEntity getFinantialEntity(DebitEntry debitEntry) {
        return null;
    }

    public static LocalizedString getPresentationName(Class<? extends InterestRateType> interestRateTypeClass) {
        try {
            Method method = interestRateTypeClass.getMethod("getPresentationName", new Class[0]);
            return (LocalizedString)method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<? extends InterestRateType> findAll() {
        return FenixFramework.getDomainRoot().getInterestRateTypesSet().stream();
    }

    public static Stream<? extends InterestRateType> findByCode(String code) {
        return InterestRateType.findAll().filter(t -> t.getCode().equals(code));
    }

    public static Optional<? extends InterestRateType> findUniqueByCode(String code) {
        return InterestRateType.findByCode(code).findFirst();
    }

    public static Optional<? extends InterestRateType> findUniqueByDescription(String description) {
        return InterestRateType.getAvailableInterestRateTypesSortedByName().stream().filter(type -> type.getDescription().anyMatch(content -> description.equals(content))).findFirst();
    }

    public static List<? extends InterestRateType> getAvailableInterestRateTypesSortedByName() {
        return TreasurySettings.getInstance().getAvailableInterestRateTypesSet().stream().sorted(COMPARE_BY_NAME).collect(Collectors.toList());
    }

    public static InterestRateType getDefaultInterestRateType() {
        return TreasurySettings.getInstance().getDefaultInterestRateType();
    }

    public static <T extends InterestRateType> T create(Class<T> clazz, LocalizedString description) {
        try {
            return (T)((Object)((InterestRateType)((Object)clazz.getConstructor(LocalizedString.class).newInstance(description))));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<DebitNote> createInterestDebitNoteForDebitNote(DebitNote debitNote, DocumentNumberSeries documentNumberSeries, LocalDate localDate, String string, String string2, boolean bl) {
        return (Set)advice$createInterestDebitNoteForDebitNote.perform((Callable)new InterestRateType$callable$createInterestDebitNoteForDebitNote(debitNote, documentNumberSeries, localDate, string, string2, bl));
    }

    static /* synthetic */ Set<DebitNote> advised$createInterestDebitNoteForDebitNote(DebitNote debitNote, DocumentNumberSeries documentNumberSeries, LocalDate paymentDate, String documentObservations, String documentTermsAndConditions, boolean createDebitNoteForEachInterestDebitEntry) {
        Set<DebitNote> interestDebitNotesSet = InterestRateType.createInterestDebitNoteForDebitNote(debitNote, documentNumberSeries, new DateTime(), paymentDate, createDebitNoteForEachInterestDebitEntry);
        interestDebitNotesSet.forEach(d -> {
            d.setDocumentObservations(documentObservations);
            d.setDocumentTermsAndConditions(documentTermsAndConditions);
        });
        return interestDebitNotesSet;
    }

    private static Set<DebitNote> createInterestDebitNoteForDebitNote(DebitNote debitNote, DocumentNumberSeries documentNumberSeries, DateTime documentDate, LocalDate paymentDate, boolean createDebitNoteForEachInterestDebitEntry) {
        HashSet<DebitNote> result = new HashSet<DebitNote>();
        DebtAccount debtAccount = debitNote.getDebtAccount();
        DebitNote interestDebitNoteForAllInterests = createDebitNoteForEachInterestDebitEntry ? null : DebitNote.create(debitNote.getFinantialEntity(), debtAccount, debitNote.getPayorDebtAccount(), documentNumberSeries, documentDate, documentDate.toLocalDate(), null, Collections.emptyMap(), null, null);
        for (DebitEntry debitEntry : debitNote.getDebitEntriesSet()) {
            if (debitEntry.getInterestRate() == null || debitEntry.getInterestRate().getInterestRateType() == null) continue;
            InterestRateType interestRateType = debitEntry.getInterestRate().getInterestRateType();
            if (createDebitNoteForEachInterestDebitEntry) {
                Set<DebitEntry> createInterestDebitEntriesForOriginDebitEntry2 = interestRateType.createInterestDebitEntriesForOriginDebitEntry(debitEntry, documentDate, paymentDate, null);
                for (DebitEntry interestDebitEntry : createInterestDebitEntriesForOriginDebitEntry2) {
                    DebitNote d = DebitNote.create(debitNote.getFinantialEntity(), debtAccount, debitNote.getPayorDebtAccount(), documentNumberSeries, documentDate, documentDate.toLocalDate(), null, Collections.emptyMap(), null, null);
                    result.add(d);
                    interestDebitEntry.addToFinantialDocument((FinantialDocument)((Object)d));
                }
                continue;
            }
            result.add(interestDebitNoteForAllInterests);
            interestRateType.createInterestDebitEntriesForOriginDebitEntry(debitEntry, documentDate, paymentDate, interestDebitNoteForAllInterests);
        }
        if (!TreasuryConstants.isPositive(result.stream().map(FinantialDocument::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add))) {
            throw new TreasuryDomainException(TreasuryConstants.treasuryBundle("error.DebitNote.no.interest.to.generate", new String[0]), new String[0]);
        }
        return result;
    }

    public Set<DebitEntry> createInterestDebitEntriesForOriginDebitEntry(DebitEntry debitEntry, DateTime dateTime, LocalDate localDate, DebitNote debitNote) {
        return (Set)advice$createInterestDebitEntriesForOriginDebitEntry.perform((Callable)new InterestRateType$callable$createInterestDebitEntriesForOriginDebitEntry(this, debitEntry, dateTime, localDate, debitNote));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ Set advised$createInterestDebitEntriesForOriginDebitEntry(InterestRateType this_, DebitEntry originDebitEntry, DateTime documentDate, LocalDate paymentDate, DebitNote interestDebitNote) {
        if (TreasuryDebtProcessMainService.isDebitEntryInterestCreationInAdvanceBlocked(originDebitEntry)) {
            throw new TreasuryDomainException("error.DebitNote.createInterestDebitNoteForDebitNote.not.possible.due.to.some.debt.process", new String[0]);
        }
        HashSet<DebitEntry> result = new HashSet<DebitEntry>();
        List<InterestRateBean> undebitedInterestRateBeansList = originDebitEntry.calculateUndebitedInterestValue(paymentDate);
        for (InterestRateBean calculateUndebitedInterestValue : undebitedInterestRateBeansList) {
            if (!TreasuryConstants.isGreaterThan(calculateUndebitedInterestValue.getInterestAmount(), BigDecimal.ZERO)) continue;
            DateTime whenInterestDebitEntryDateTime = calculateUndebitedInterestValue.getInterestDebitEntryDateTime() != null ? calculateUndebitedInterestValue.getInterestDebitEntryDateTime() : documentDate;
            DebitEntry interestDebitEntry = originDebitEntry.createInterestRateDebitEntry(calculateUndebitedInterestValue, whenInterestDebitEntryDateTime, interestDebitNote);
            result.add(interestDebitEntry);
        }
        return result;
    }

    public void checkDebitEntryRequirementsForInterestCalculation(DebitEntry debitEntry) {
    }

    static {
        advice$createInterestDebitNoteForDebitNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createInterestDebitEntriesForOriginDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME = (o1, o2) -> o1.getDescription().getContent().compareTo(o2.getDescription().getContent());
    }
}

