/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRateType_Base;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.InterestRateEntry;
import org.fenixedu.treasury.domain.tariff.InterestRateType;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.fenixframework.FenixFramework;

public class GlobalInterestRateType
extends GlobalInterestRateType_Base {
    public static final String DEFAULT_CODE = "GLOBAL_RATE";
    private static final int MAX_YEARS = 5;

    public GlobalInterestRateType() {
    }

    public GlobalInterestRateType(LocalizedString description) {
        this();
        super.init(description);
        super.setCode(DEFAULT_CODE);
        this.checkRules();
    }

    protected void checkRules() {
        super.checkRules();
        if (GlobalInterestRateType.findAll().count() > 1L) {
            throw new TreasuryDomainException("error.GlobalInterestRateType.already.exists", new String[0]);
        }
    }

    public List<InterestRateBean> calculateInterests(DebitEntry debitEntry, LocalDate paymentDate, boolean withAllInterestValues) {
        return this.calculateInterestAmount(debitEntry, withAllInterestValues, this.calculateEvents(debitEntry, paymentDate));
    }

    public List<InterestRateBean> calculateAllInterestsByLockingAtDate(DebitEntry debitEntry, LocalDate lockDate) {
        return this.calculateInterestAmount(debitEntry, true, this.calculateEvents(debitEntry, lockDate, lockDate.toDateTimeAtStartOfDay()));
    }

    private List<InterestRateBean> calculateInterestAmount(DebitEntry debitEntry, boolean withAllInterestValues, NavigableMap<LocalDate, InterestCalculationEvent> orderedEvents) {
        InterestRateBean result = new InterestRateBean();
        BigDecimal totalInterestAmount = BigDecimal.ZERO;
        int totalOfDays = 0;
        LocalDate key = (LocalDate)orderedEvents.firstKey();
        while (orderedEvents.higherKey(key) != null) {
            LocalDate eventDate = orderedEvents.higherKey(key);
            InterestCalculationEvent event = (InterestCalculationEvent)orderedEvents.get(key);
            BigDecimal daysInYear = new BigDecimal(TreasuryConstants.numberOfDaysInYear(key.getYear()));
            BigDecimal amountPerDay = TreasuryConstants.divide(event.amountToPay, daysInYear);
            BigDecimal numberOfDays = new BigDecimal(Days.daysBetween((ReadablePartial)key, (ReadablePartial)eventDate).getDays());
            BigDecimal partialInterestAmount = event.interestRate.multiply(amountPerDay).multiply(numberOfDays);
            result.addDetail(partialInterestAmount, key, eventDate.minusDays(1), amountPerDay, event.amountToPay, TreasuryConstants.defaultScale(event.interestRate).multiply(TreasuryConstants.HUNDRED_PERCENT).setScale(4, RoundingMode.HALF_UP));
            totalInterestAmount = totalInterestAmount.add(partialInterestAmount);
            totalOfDays += numberOfDays.intValue();
            key = eventDate;
        }
        if (!withAllInterestValues) {
            for (Map.Entry entry : this.createdInterestEntriesMap(debitEntry).entrySet()) {
                result.addCreatedInterestEntry((LocalDate)entry.getKey(), (BigDecimal)entry.getValue());
                totalInterestAmount = totalInterestAmount.subtract((BigDecimal)entry.getValue());
            }
        }
        if (TreasuryConstants.isNegative(totalInterestAmount)) {
            totalInterestAmount = BigDecimal.ZERO;
        }
        result.setInterestAmount(Currency.getValueWithScale(totalInterestAmount));
        result.setNumberOfDays(totalOfDays);
        result.setDescription(TreasuryConstants.treasuryBundle(TreasuryConstants.DEFAULT_LANGUAGE, "label.InterestRateBean.interest.designation", debitEntry.getDescription()));
        return Collections.singletonList(result);
    }

    private NavigableMap<LocalDate, InterestCalculationEvent> calculateEvents(DebitEntry debitEntry, LocalDate paymentDate) {
        return this.calculateEvents(debitEntry, paymentDate, null);
    }

    private NavigableMap<LocalDate, InterestCalculationEvent> calculateEvents(DebitEntry debitEntry, LocalDate paymentDate, DateTime ignorePaymentsAfterDate) {
        NavigableMap<LocalDate, BigDecimal> paymentsMap = this.createPaymentsMap(debitEntry, paymentDate, ignorePaymentsAfterDate);
        LocalDate lastPayment = (LocalDate)paymentsMap.lastKey();
        LocalDate firstDayToChargeInterests = this.calculateFirstDayToChargeInterests(debitEntry, lastPayment);
        LocalDate nextDayOfInterestsCharge = this.calculateLastDayToChargeInterests(debitEntry, lastPayment, firstDayToChargeInterests).plusDays(1);
        BigDecimal amountToPayAtFirstDay = this.amountInDebtAtDay(debitEntry, paymentsMap, firstDayToChargeInterests);
        BigDecimal interestRateAtFirstDay = this.interestRateValue(firstDayToChargeInterests);
        TreeMap<LocalDate, InterestCalculationEvent> result = new TreeMap<LocalDate, InterestCalculationEvent>();
        result.put(firstDayToChargeInterests, new InterestCalculationEvent(amountToPayAtFirstDay, interestRateAtFirstDay));
        result.put(nextDayOfInterestsCharge, new InterestCalculationEvent(BigDecimal.ZERO, this.interestRateValue(nextDayOfInterestsCharge)));
        paymentsMap.forEach((settlementPaymentDate, paidAmount) -> {
            LocalDate eventDate = settlementPaymentDate.plusDays(1);
            if (eventDate.isBefore((ReadablePartial)firstDayToChargeInterests)) {
                return;
            }
            if (eventDate.isAfter((ReadablePartial)nextDayOfInterestsCharge)) {
                return;
            }
            result.putIfAbsent(eventDate, new InterestCalculationEvent(this.amountInDebtAtDay(debitEntry, paymentsMap, eventDate), this.interestRateValue(eventDate)));
        });
        this.getInterestRateEntriesSet().stream().filter(r -> !r.getStartDate().isBefore((ReadablePartial)firstDayToChargeInterests)).filter(r -> !r.getStartDate().isAfter((ReadablePartial)nextDayOfInterestsCharge)).forEach(r -> {
            LocalDate eventDate = r.getStartDate();
            result.putIfAbsent(eventDate, new InterestCalculationEvent(this.amountInDebtAtDay(debitEntry, paymentsMap, eventDate), this.interestRateValue(eventDate)));
        });
        return result;
    }

    private NavigableMap<LocalDate, BigDecimal> createPaymentsMap(DebitEntry debitEntry, LocalDate paymentDate) {
        return this.createPaymentsMap(debitEntry, paymentDate, null);
    }

    private NavigableMap<LocalDate, BigDecimal> createPaymentsMap(DebitEntry debitEntry, LocalDate paymentDate, DateTime ignorePaymentsAfterDate) {
        TreeMap<LocalDate, BigDecimal> result = new TreeMap<LocalDate, BigDecimal>();
        debitEntry.getSettlementEntriesSet().stream().filter(s -> !s.isAnnulled()).forEach(s -> {
            if (ignorePaymentsAfterDate != null && s.getSettlementNote().getPaymentDate().isAfter((ReadableInstant)ignorePaymentsAfterDate)) {
                return;
            }
            LocalDate settlementPaymentDate = s.getSettlementNote().getPaymentDate().toLocalDate();
            result.putIfAbsent(settlementPaymentDate, BigDecimal.ZERO);
            result.put(settlementPaymentDate, ((BigDecimal)result.get(settlementPaymentDate)).add(s.getAmount()));
        });
        result.putIfAbsent(paymentDate, BigDecimal.ZERO);
        result.put(paymentDate, ((BigDecimal)result.get(paymentDate)).add(debitEntry.getOpenAmount()));
        return result;
    }

    private LocalDate calculateFirstDayToChargeInterests(DebitEntry debitEntry, LocalDate lastPayment) {
        LocalDate firstDayToChargeInterests = this.applyOnFirstWorkdayIfNecessary(debitEntry, debitEntry.getDueDate().plusDays(this.numberOfDaysAfterDueDate()));
        if (firstDayToChargeInterests.isBefore((ReadablePartial)lastPayment.minusYears(5))) {
            firstDayToChargeInterests = lastPayment.minusYears(5).plusDays(1);
        }
        return firstDayToChargeInterests;
    }

    private LocalDate calculateLastDayToChargeInterests(DebitEntry debitEntry, LocalDate lastPayment, LocalDate firstDayToChargeInterests) {
        InterestRate interestRate = debitEntry.getInterestRate();
        LocalDate nextDayOfPaymentDate = lastPayment;
        if (!this.isApplyPaymentMonth(lastPayment)) {
            nextDayOfPaymentDate = nextDayOfPaymentDate.withDayOfMonth(1).minusDays(1);
        }
        if (interestRate.isMaximumDaysToApplyPenaltyApplied() && Days.daysBetween((ReadablePartial)firstDayToChargeInterests, (ReadablePartial)nextDayOfPaymentDate).getDays() > interestRate.getMaximumDaysToApplyPenalty()) {
            nextDayOfPaymentDate = firstDayToChargeInterests.plusDays(interestRate.getMaximumDaysToApplyPenalty() - 1);
        }
        return nextDayOfPaymentDate;
    }

    private BigDecimal amountInDebtAtDay(DebitEntry debitEntry, NavigableMap<LocalDate, BigDecimal> paymentsMap, LocalDate eventDate) {
        BigDecimal amountToPay = debitEntry.getAmountWithVat();
        for (Map.Entry entry : paymentsMap.entrySet()) {
            if (!((LocalDate)entry.getKey()).isBefore((ReadablePartial)eventDate)) break;
            amountToPay = amountToPay.subtract((BigDecimal)entry.getValue());
        }
        return amountToPay;
    }

    private int numberOfDaysAfterDueDate() {
        return 1;
    }

    private LocalDate applyOnFirstWorkdayIfNecessary(DebitEntry debitEntry, LocalDate date) {
        Optional<InterestRateEntry> globalRate = InterestRateEntry.findUniqueAppliedForDate((InterestRateType)((Object)this), date);
        if (!globalRate.isPresent()) {
            throw new TreasuryDomainException("error.InterestRate.rate.not.defined.for.date", date.toString("yyyy/MM/dd"));
        }
        boolean applyInFirstWorkday = globalRate.get().getApplyInFirstWorkday();
        if (applyInFirstWorkday && this.isSaturday(date)) {
            return date.plusDays(2);
        }
        if (applyInFirstWorkday && this.isSunday(date)) {
            return date.plusDays(1);
        }
        return date;
    }

    private boolean isApplyPaymentMonth(LocalDate date) {
        Optional<InterestRateEntry> globalRate = InterestRateEntry.findUniqueAppliedForDate((InterestRateType)((Object)this), date);
        if (!globalRate.isPresent()) {
            throw new TreasuryDomainException("error.InterestRate.rate.not.defined.for.date", date.toString("yyyy/MM/dd"));
        }
        return Boolean.TRUE.equals(globalRate.get().getApplyPaymentMonth());
    }

    private BigDecimal interestRateValue(LocalDate date) {
        Optional<InterestRateEntry> globalRate = InterestRateEntry.findUniqueAppliedForDate((InterestRateType)((Object)this), date);
        if (!globalRate.isPresent()) {
            throw new TreasuryDomainException("error.InterestRate.rate.not.defined.for.date", date.toString("yyyy/MM/dd"));
        }
        return TreasuryConstants.divide(globalRate.get().getRate(), TreasuryConstants.HUNDRED_PERCENT);
    }

    public static LocalizedString getPresentationName() {
        return TreasuryConstants.treasuryBundleI18N("label.GlobalInterestRateType.default.description", new String[0]);
    }

    public static GlobalInterestRateType create(LocalizedString description) {
        return new GlobalInterestRateType(description);
    }

    public static Stream<GlobalInterestRateType> findAll() {
        return FenixFramework.getDomainRoot().getInterestRateTypesSet().stream().filter(type -> type instanceof GlobalInterestRateType).map(GlobalInterestRateType.class::cast);
    }

    public static Optional<GlobalInterestRateType> findUnique() {
        return GlobalInterestRateType.findAll().findFirst();
    }

    private class InterestCalculationEvent {
        private BigDecimal amountToPay;
        private BigDecimal interestRate;

        InterestCalculationEvent(BigDecimal amountToPay, BigDecimal interestRateAtEventDate) {
            this.amountToPay = amountToPay;
            this.interestRate = interestRateAtEventDate;
        }
    }
}

