/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.PaymentMethodReference$callable$delete;
import org.fenixedu.treasury.domain.PaymentMethodReference_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaymentMethodReference
extends PaymentMethodReference_Base {
    public static Comparator<PaymentMethodReference> COMPARE_BY_NAME;
    public static final Advice advice$delete;

    public PaymentMethodReference() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected PaymentMethodReference(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution, String name, String paymentReferenceId, boolean forDigitalPayments) {
        this();
        this.setPaymentMethod(paymentMethod);
        this.setFinantialInstitution(finantialInstitution);
        this.setName(name);
        this.setPaymentReferenceId(paymentReferenceId);
        this.setPaymentMethodReferenceActive(true);
        this.setForDigitalPayments(forDigitalPayments);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.PaymentMethodReference.domainRoot.required", new String[0]);
        }
        if (this.getPaymentMethod() == null) {
            throw new TreasuryDomainException("error.PaymentMethodReference.paymentMethod.required", new String[0]);
        }
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.PaymentMethodReference.finantialInstitution.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getName())) {
            throw new TreasuryDomainException("error.PaymentMethodReference.name.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getPaymentReferenceId())) {
            throw new TreasuryDomainException("error.PaymentMethodReference.paymentReferenceId.required", new String[0]);
        }
        if (this.getForDigitalPayments() == null) {
            throw new TreasuryDomainException("error.PaymentMethodReference.forDigitalPayments.required", new String[0]);
        }
        if (PaymentMethodReference.findActiveAndForDigitalPayments(this.getPaymentMethod(), this.getFinantialInstitution()).count() > 1L) {
            throw new TreasuryDomainException("error.PaymentMethodReference.forDigitalPayments.active.more.than.one", new String[0]);
        }
    }

    public boolean isActive() {
        return Boolean.TRUE.equals(this.getPaymentMethodReferenceActive());
    }

    public void activate() {
        this.setPaymentMethodReferenceActive(true);
        this.checkRules();
    }

    public void deactivate() {
        this.setPaymentMethodReferenceActive(false);
        this.checkRules();
    }

    public void edit(String name, String paymentReferenceId, boolean forDigitalPayments) {
        this.setName(name);
        this.setPaymentReferenceId(paymentReferenceId);
        this.setForDigitalPayments(forDigitalPayments);
        this.checkRules();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentMethodReference$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentMethodReference this_) {
        this_.setDomainRoot(null);
        this_.setPaymentMethod(null);
        this_.setFinantialInstitution(null);
        super.deleteDomainObject();
    }

    public String buildPaymentReferenceId(PaymentRequest paymentRequest) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        if (paymentRequest instanceof SibsPaymentRequest) {
            valueMap.put("sibsEntityReferenceCode", ((SibsPaymentRequest)((Object)paymentRequest)).getEntityReferenceCode());
            valueMap.put("sibsReferenceCode", ((SibsPaymentRequest)((Object)paymentRequest)).getReferenceCode());
        }
        return StrSubstitutor.replace((Object)this.getPaymentReferenceId(), valueMap);
    }

    public static boolean isPaymentMethodReferencesApplied() {
        return PaymentMethodReference.findAll().filter(p -> p.isActive() && !Boolean.TRUE.equals(p.getForDigitalPayments())).count() > 0L;
    }

    public static Stream<PaymentMethodReference> findAll() {
        return FenixFramework.getDomainRoot().getPaymentMethodReferencesSet().stream();
    }

    public static Stream<PaymentMethodReference> find(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution) {
        return paymentMethod.getPaymentMethodReferencesSet().stream().filter(p -> p.getFinantialInstitution() == finantialInstitution);
    }

    public static Stream<PaymentMethodReference> findActive(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution) {
        return PaymentMethodReference.find(paymentMethod, finantialInstitution).filter(p -> p.isActive());
    }

    public static Stream<PaymentMethodReference> findActiveForSettlementNoteRegistrationInBackoffice(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution) {
        return PaymentMethodReference.findActive(paymentMethod, finantialInstitution).filter(p -> !Boolean.TRUE.equals(p.getForDigitalPayments()));
    }

    public static Stream<PaymentMethodReference> findActiveAndForDigitalPayments(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution) {
        return PaymentMethodReference.findActive(paymentMethod, finantialInstitution).filter(p -> Boolean.TRUE.equals(p.getForDigitalPayments()));
    }

    public static Optional<PaymentMethodReference> findUniqueActiveAndForDigitalPayments(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution) {
        return PaymentMethodReference.findActiveAndForDigitalPayments(paymentMethod, finantialInstitution).findFirst();
    }

    public static Stream<PaymentMethodReference> findByPaymentReferenceId(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution, String paymentReferenceId) {
        return PaymentMethodReference.find(paymentMethod, finantialInstitution).filter(p -> paymentReferenceId.equals(p.getPaymentReferenceId()));
    }

    public static PaymentMethodReference create(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution, String name, String paymentReferenceId, boolean forDigitalPayments) {
        return new PaymentMethodReference(paymentMethod, finantialInstitution, name, paymentReferenceId, forDigitalPayments);
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName()) * 10 + o1.getExternalId().compareTo(o2.getExternalId());
    }
}

