/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paypal;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.paypal.core.PayPalEnvironment;
import com.paypal.core.PayPalHttpClient;
import com.paypal.http.HttpClient;
import com.paypal.http.HttpRequest;
import com.paypal.http.HttpResponse;
import com.paypal.http.serializer.Json;
import com.paypal.orders.AmountBreakdown;
import com.paypal.orders.AmountWithBreakdown;
import com.paypal.orders.ApplicationContext;
import com.paypal.orders.Item;
import com.paypal.orders.Money;
import com.paypal.orders.Order;
import com.paypal.orders.OrderRequest;
import com.paypal.orders.OrdersCaptureRequest;
import com.paypal.orders.OrdersCreateRequest;
import com.paypal.orders.OrdersGetRequest;
import com.paypal.orders.PurchaseUnitRequest;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode;
import org.fenixedu.treasury.domain.paypal.PayPal$callable$captureOrder;
import org.fenixedu.treasury.domain.paypal.PayPal$callable$processPaymentStatus;
import org.fenixedu.treasury.domain.paypal.PayPalLog;
import org.fenixedu.treasury.domain.paypal.PayPal_Base;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.services.payments.paypal.PayPalWebhookBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PayPal
extends PayPal_Base
implements IForwardPaymentPlatformService {
    public static final String STATUS_PAID = "COMPLETED";
    public static final String STATUS_FAIL = "VOIDED";
    private static final Gson GSON;
    public static final Advice advice$processPaymentStatus;
    public static final Advice advice$captureOrder;

    public PayPal() {
    }

    private PayPal(FinantialInstitution finantialInstitution, FinantialEntity finantialEntity, String name, boolean active, String accountId, String secret, String mode) {
        this();
        this.init(finantialInstitution, finantialEntity, name, active);
        this.setAccountId(accountId);
        this.setSecret(secret);
        this.setMode(mode);
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getCreditCardPaymentMethod());
        this.checkRules();
    }

    public static PayPal create(FinantialInstitution finantialInstitution, FinantialEntity finantialEntity, String name, boolean active, String accountId, String secret, String mode) {
        return new PayPal(finantialInstitution, finantialEntity, name, active, accountId, secret, mode);
    }

    public static String getPresentationName() {
        return TreasuryConstants.treasuryBundle("label.PayPal.presentationName", new String[0]);
    }

    @Override
    public ForwardPaymentRequest createForwardPaymentRequest(SettlementNoteBean bean, Function<ForwardPaymentRequest, String> successUrlFunction, Function<ForwardPaymentRequest, String> insuccessUrlFunction) {
        Set<DebitEntry> debitEntries = bean.getIncludedInvoiceEntryBeans().stream().map(ISettlementInvoiceEntryBean::getInvoiceEntry).filter(i -> i != null).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = bean.getIncludedInvoiceEntryBeans().stream().filter(i -> i instanceof InstallmentPaymenPlanBean && i.isIncluded()).map(InstallmentPaymenPlanBean.class::cast).map(ib -> ib.getInstallment()).collect(Collectors.toSet());
        ForwardPaymentRequest forwardPaymentRequest = ForwardPaymentRequest.create(bean.getDigitalPaymentPlatform(), bean.getDebtAccount(), debitEntries, installments, bean.getTotalAmountToPay(), successUrlFunction, insuccessUrlFunction);
        this.prepareCheckout(forwardPaymentRequest);
        return forwardPaymentRequest;
    }

    private ForwardPaymentStatusBean prepareCheckout(ForwardPaymentRequest forwardPayment) {
        String merchantTransactionId = UUID.randomUUID().toString().replace("-", "");
        FenixFramework.atomic(() -> {
            if (!StringUtils.isEmpty((String)forwardPayment.getMerchantTransactionId())) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.sibsMerchantTransactionId.already.filled", new String[0]);
            }
            forwardPayment.setMerchantTransactionId(merchantTransactionId);
        });
        try {
            DateTime requestSendDate = new DateTime();
            ArrayList items = new ArrayList();
            forwardPayment.getDebitEntriesSet().stream().forEach(d -> items.add(new Item().name(d.getDescription()).unitAmount(new Money().currencyCode(d.getCurrency().getIsoCode()).value(Currency.getValueWithScale(d.getOpenAmountWithInterests()).toString())).quantity(d.getQuantity().toString())));
            forwardPayment.getInstallmentsSet().stream().forEach(d -> items.add(new Item().name(d.getDescription().getContent()).unitAmount(new Money().currencyCode(d.getSortedOpenInstallmentEntries().get(0).getDebitEntry().getCurrency().getCode()).value(Currency.getValueWithScale(d.getOpenAmount()).toString())).quantity("1")));
            OrderRequest orderRequest = new OrderRequest();
            orderRequest.checkoutPaymentIntent("CAPTURE");
            ApplicationContext applicationContext = new ApplicationContext().brandName("FenixEdu").landingPage("LOGIN").cancelUrl(forwardPayment.getForwardPaymentInsuccessUrl()).returnUrl(forwardPayment.getForwardPaymentSuccessUrl()).userAction("PAY_NOW").shippingPreference("NO_SHIPPING");
            orderRequest.applicationContext(applicationContext);
            ArrayList<PurchaseUnitRequest> purchaseUnitRequests = new ArrayList<PurchaseUnitRequest>();
            PurchaseUnitRequest purchaseUnitRequest = new PurchaseUnitRequest();
            purchaseUnitRequest.amountWithBreakdown(new AmountWithBreakdown().currencyCode(((Item)items.get(0)).unitAmount().currencyCode()).value(forwardPayment.getPayableAmount().toString()).amountBreakdown(new AmountBreakdown().itemTotal(new Money().currencyCode(((Item)items.get(0)).unitAmount().currencyCode()).value(forwardPayment.getPayableAmount().toString()))));
            purchaseUnitRequest.items(items);
            purchaseUnitRequest.customId(merchantTransactionId);
            purchaseUnitRequests.add(purchaseUnitRequest);
            orderRequest.purchaseUnits(purchaseUnitRequests);
            orderRequest.processingInstruction("ORDER_COMPLETE_ON_PAYMENT_APPROVAL");
            OrdersCreateRequest request = new OrdersCreateRequest();
            request.header("prefer", "return=representation");
            request.requestBody(orderRequest);
            HttpResponse response = this.getClient().execute((HttpRequest)request);
            Order order = (Order)response.result();
            String links = order.links().stream().filter(link -> "approve".equals(link.rel())).findFirst().get().href();
            FenixFramework.atomic(() -> {
                forwardPayment.setCheckoutId(order.id());
                forwardPayment.setRedirectUrl(links);
            });
            DateTime requestReceiveDate = new DateTime();
            JsonObject requestObject = GSON.toJsonTree((Object)new Json().serialize((Object)orderRequest)).getAsJsonObject();
            String requestLog = GSON.toJson((JsonElement)requestObject);
            JsonObject responseObject = GSON.toJsonTree((Object)new Json().serialize(response.result())).getAsJsonObject();
            String responseLog = GSON.toJson((JsonElement)responseObject);
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(order.status());
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, order.status(), order.status(), requestLog, responseLog);
            FenixFramework.atomic(() -> {
                if (!result.isOperationSuccess() || result.getStateType() == ForwardPaymentStateType.REJECTED) {
                    PayPalLog log2 = (PayPalLog)((Object)((Object)((Object)this.log((PaymentRequest)((Object)((Object)((Object)forwardPayment))), "prepareCheckout", order.status(), order.status(), requestLog, responseLog))));
                    forwardPayment.reject();
                    log2.setRequestSendDate(requestSendDate);
                    log2.setRequestReceiveDate(requestReceiveDate);
                } else {
                    PayPalLog log3 = (PayPalLog)((Object)((Object)((Object)forwardPayment.advanceToRequestState("prepareCheckout", order.status(), order.status(), requestLog, responseLog))));
                    log3.setOperationSuccess(result.isOperationSuccess());
                    log3.setRequestSendDate(requestSendDate);
                    log3.setRequestReceiveDate(requestReceiveDate);
                }
            });
            return result;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                this.logException((PaymentRequest)((Object)((Object)((Object)forwardPayment))), e, "prepareCheckout", "error", "error", requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    public PaymentRequestLog log(PaymentRequest paymentRequest, String operationCode, String statusCode, String statusMessage, String requestBody, String responseBody) {
        PayPalLog log2 = PayPalLog.createPaymentRequestLog(paymentRequest, paymentRequest.getCurrentState().getCode(), paymentRequest.getCurrentState().getLocalizedName());
        log2.setOperationCode(operationCode);
        log2.setPayPalId(paymentRequest.getTransactionId());
        log2.setStatusCode(statusCode);
        log2.setStatusMessage(statusMessage);
        if (!Strings.isNullOrEmpty((String)requestBody)) {
            log2.saveRequest(requestBody);
        }
        if (!Strings.isNullOrEmpty((String)responseBody)) {
            log2.saveResponse(responseBody);
        }
        return log2;
    }

    private ForwardPaymentStateType translateForwardPaymentStateType(String status) {
        if (status == null) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.unknown.payment.state", new String[0]);
        }
        if (status.equals(STATUS_PAID)) {
            return ForwardPaymentStateType.PAYED;
        }
        if (STATUS_FAIL.equals(status)) {
            return ForwardPaymentStateType.REJECTED;
        }
        return ForwardPaymentStateType.REQUESTED;
    }

    @Override
    public String getPaymentURL(ForwardPaymentRequest request) {
        return request.getRedirectUrl();
    }

    @Override
    public String getLogosJspPage() {
        return null;
    }

    @Override
    public ForwardPaymentStatusBean paymentStatus(ForwardPaymentRequest paymentRequest) {
        try {
            OrdersGetRequest request = new OrdersGetRequest(paymentRequest.getCheckoutId());
            HttpResponse response = this.getClient().execute((HttpRequest)request);
            Order order = (Order)response.result();
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(order.status());
            String requestLog = paymentRequest.getCheckoutId();
            JsonObject responseObject = GSON.toJsonTree((Object)new Json().serialize(response.result())).getAsJsonObject();
            String responseLog = GSON.toJson((JsonElement)responseObject);
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, order.status(), order.status(), requestLog, responseLog);
            result.editTransactionDetails(order.id(), DateTime.parse((String)(order.updateTime() == null ? order.createTime() : order.updateTime())), order.purchaseUnits().stream().map(unit -> new BigDecimal(unit.amountWithBreakdown().value())).reduce(BigDecimal.ZERO, BigDecimal::add));
            return result;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                if (!"ERRO".equals(e.getMessage())) {
                    this.logException((PaymentRequest)((Object)((Object)((Object)paymentRequest))), e, "paymentStatus", "error", "error", requestBody, responseBody);
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private HttpClient getClient() {
        Object environment = null;
        environment = "LIVE".equals(this.getMode()) ? new PayPalEnvironment.Live(this.getAccountId(), this.getSecret()) : new PayPalEnvironment.Sandbox(this.getAccountId(), this.getSecret());
        return new PayPalHttpClient((PayPalEnvironment)environment);
    }

    @Override
    public PostProcessPaymentStatusBean postProcessPayment(ForwardPaymentRequest forwardPayment, String justification, Optional<String> specificTransactionId) {
        if (specificTransactionId.isEmpty()) {
            ForwardPaymentStatusBean statusBean = new ForwardPaymentStatusBean(false, forwardPayment.getState(), "N/A", "N/A", null, null);
            return new PostProcessPaymentStatusBean(statusBean, forwardPayment.getState(), false);
        }
        try {
            DateTime requestSendDate = new DateTime();
            OrdersGetRequest request = new OrdersGetRequest(forwardPayment.getCheckoutId());
            HttpResponse response = this.getClient().execute((HttpRequest)request);
            Order order = (Order)response.result();
            String requestLog = forwardPayment.getCheckoutId();
            JsonObject responseObject = GSON.toJsonTree((Object)new Json().serialize(response.result())).getAsJsonObject();
            String responseLog = GSON.toJson((JsonElement)responseObject);
            Order resultOrder = order;
            if ("APPROVED".equals(order.status())) {
                resultOrder = this.captureOrder(order);
            }
            DateTime requestReceiveDate = new DateTime();
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(resultOrder.status());
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, resultOrder.status(), resultOrder.status(), requestLog, responseLog);
            result.editTransactionDetails(resultOrder.id(), DateTime.parse((String)(order.updateTime() == null ? order.createTime() : order.updateTime())), this.getOrderAmount(resultOrder));
            if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains(result.getStateType())) {
                return new PostProcessPaymentStatusBean(result, forwardPayment.getState(), false);
            }
            PostProcessPaymentStatusBean returnBean = new PostProcessPaymentStatusBean(result, forwardPayment.getState(), result.isInPayedState());
            returnBean.getForwardPaymentStatusBean().defineSibsOnlinePaymentBrands("TODO");
            String orderId = resultOrder.id();
            PayPalLog log2 = (PayPalLog)((Object)FenixFramework.atomic(() -> {
                PayPalLog log2 = new PayPalLog("processPaymentStatus", orderId);
                log2.setRequestSendDate(requestSendDate);
                log2.setRequestReceiveDate(requestReceiveDate);
                log2.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)forwardPayment))));
                return log2;
            }));
            this.processPaymentStatus(log2, forwardPayment, returnBean);
            return returnBean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                this.logException((PaymentRequest)((Object)((Object)((Object)forwardPayment))), e, "processPaymentStatus", "error", "error", requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private BigDecimal getOrderAmount(Order order) {
        if (STATUS_PAID.equals(order.status())) {
            return order.purchaseUnits().stream().flatMap(unit -> unit.payments().captures().stream()).map(capture -> new BigDecimal(capture.amount().value())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return order.purchaseUnits().stream().map(unit -> new BigDecimal(unit.amountWithBreakdown().value())).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void processPaymentStatus(PayPalLog payPalLog, ForwardPaymentRequest forwardPaymentRequest, PostProcessPaymentStatusBean postProcessPaymentStatusBean) {
        Object object = advice$processPaymentStatus.perform((Callable)new PayPal$callable$processPaymentStatus(this, payPalLog, forwardPaymentRequest, postProcessPaymentStatusBean));
    }

    static /* synthetic */ void advised$processPaymentStatus(PayPal this_, PayPalLog log2, ForwardPaymentRequest forwardPayment, PostProcessPaymentStatusBean returnBean) {
        ForwardPaymentStatusBean result = returnBean.getForwardPaymentStatusBean();
        log2.setStateCode(result.getStatusCode());
        log2.setStateDescription(result.getStateType().getLocalizedName());
        log2.setStatusMessage(result.getStatusMessage());
        if (forwardPayment.getState().isPayed() || forwardPayment.getState().isRejected()) {
            log2.setTransactionWithPayment(forwardPayment.getState().isPayed());
            log2.setOperationCode("processDuplicated");
            log2.setOperationSuccess(true);
            return;
        }
        forwardPayment.setTransactionId(result.getTransactionId());
        if (result.isInPayedState()) {
            PaymentTransaction paymentTransaction = forwardPayment.advanceToPaidState(result.getStatusCode(), result.getPayedAmount(), result.getTransactionDate(), result.getTransactionId(), null);
            log2.setOperationCode("advanceToPaidState");
            log2.setOperationSuccess(true);
            log2.setTransactionWithPayment(true);
            log2.setPaymentTransaction(paymentTransaction);
            log2.saveRequest(result.getRequestBody());
            log2.saveResponse(result.getResponseBody());
            log2.setPayPalId(result.getTransactionId());
            log2.savePaymentInfo(result.getPayedAmount(), result.getTransactionDate());
            log2.setPaymentMethod(result.getSibsOnlinePaymentBrands());
        } else if (result.isInRejectedState()) {
            forwardPayment.reject();
            log2.setOperationCode("postProcessPayment");
            log2.setOperationSuccess(false);
            log2.setTransactionWithPayment(false);
            log2.setPayPalId(result.getTransactionId());
        }
    }

    public List<? extends DigitalPlatformResultBean> getPaymentTransactionsReportListByMerchantId(String merchantTransationId) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPayment(ForwardPaymentRequest forwardPayment) {
        return this.postProcessPayment(forwardPayment, "", Optional.of(forwardPayment.getCheckoutId()));
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPaymentFromWebhook(PaymentRequestLog paymentRequestLog, DigitalPlatformResultBean digitalPlatformResultBean) {
        ForwardPaymentRequest forwardPayment = (ForwardPaymentRequest)((Object)paymentRequestLog.getPaymentRequest());
        PayPalLog log2 = (PayPalLog)((Object)paymentRequestLog);
        PayPalWebhookBean bean = (PayPalWebhookBean)digitalPlatformResultBean;
        try {
            Order order = bean.getOrder();
            Order resultOrder = bean.getOrder();
            if ("APPROVED".equals(order.status())) {
                resultOrder = this.captureOrder(order);
            }
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(resultOrder.status());
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, resultOrder.status(), resultOrder.status(), "", "");
            result.editTransactionDetails(resultOrder.id(), bean.getPaymentDate(), bean.getAmount());
            if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains(result.getStateType())) {
                return new PostProcessPaymentStatusBean(result, forwardPayment.getState(), false);
            }
            PostProcessPaymentStatusBean returnBean = new PostProcessPaymentStatusBean(result, forwardPayment.getState(), result.isInPayedState());
            returnBean.getForwardPaymentStatusBean().defineSibsOnlinePaymentBrands(bean.getEvent_type());
            this.processPaymentStatus(log2, forwardPayment, returnBean);
            return returnBean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                this.logException((PaymentRequest)((Object)((Object)((Object)forwardPayment))), e, "processForwardPaymentFromWebhook", "error", "error", requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private Order captureOrder(Order order) throws IOException {
        return (Order)advice$captureOrder.perform((Callable)new PayPal$callable$captureOrder(this, order));
    }

    static /* synthetic */ Order advised$captureOrder(PayPal this_, Order order) throws IOException {
        try {
            OrdersCaptureRequest captureRequest = new OrdersCaptureRequest(order.id());
            captureRequest.requestBody((Object)new OrderRequest());
            HttpResponse captureResponse = this_.getClient().execute((HttpRequest)captureRequest);
            Order resultOrder = (Order)captureResponse.result();
            return resultOrder;
        }
        catch (Exception e) {
            if (e.getMessage().contains("\"issue\":\"ORDER_ALREADY_CAPTURED\"")) {
                OrdersGetRequest request = new OrdersGetRequest(order.id());
                HttpResponse response = this_.getClient().execute((HttpRequest)request);
                return (Order)response.result();
            }
            throw e;
        }
    }

    public int getMaximumLengthForAddressStreetFieldOne() {
        return 50;
    }

    public int getMaximumLengthForAddressCity() {
        return 50;
    }

    public int getMaximumLengthForPostalCode() {
        return 16;
    }

    static {
        advice$processPaymentStatus = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$captureOrder = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

