/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.VatExemptionReason$callable$delete;
import org.fenixedu.treasury.domain.VatExemptionReason$callable$edit;
import org.fenixedu.treasury.domain.VatExemptionReason_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class VatExemptionReason
extends VatExemptionReason_Base {
    public static final Comparator<VatExemptionReason> COMPARE_BY_CODE;
    public static final Advice advice$edit;
    public static final Advice advice$delete;

    protected VatExemptionReason() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected VatExemptionReason(String code, LocalizedString name, String legalArticle, boolean active) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setLegalArticle(legalArticle);
        this.setActive(active);
        this.checkRules();
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.VatExemptionReason.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.VatExemptionReason.name.required", new String[0]);
        }
        if (this.getActive() == null) {
            throw new TreasuryDomainException("error.VatExemptionReason.active.required", new String[0]);
        }
        VatExemptionReason.findByCode(this.getCode());
    }

    public void edit(String string, LocalizedString localizedString, String string2, boolean bl) {
        Object object = advice$edit.perform((Callable)new VatExemptionReason$callable$edit(this, string, localizedString, string2, bl));
    }

    static /* synthetic */ void advised$edit(VatExemptionReason this_, String code, LocalizedString name, String legalArticle, boolean active) {
        this_.setCode(code);
        this_.setName(name);
        this_.setLegalArticle(legalArticle);
        this_.setActive(active);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getProductsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new VatExemptionReason$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(VatExemptionReason this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.VatExemptionReason.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static Stream<VatExemptionReason> findAll() {
        return FenixFramework.getDomainRoot().getVatExemptionReasonsSet().stream();
    }

    public static VatExemptionReason findByCode(String code) {
        VatExemptionReason result = null;
        for (VatExemptionReason it : VatExemptionReason.findAll().collect(Collectors.toList())) {
            if (!it.getCode().equalsIgnoreCase(code)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.VatExemptionReason.duplicated.code", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static VatExemptionReason findByName(String name) {
        VatExemptionReason result = null;
        for (VatExemptionReason it : VatExemptionReason.findAll().collect(Collectors.toList())) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            result = it;
        }
        return result;
    }

    public static VatExemptionReason create(String code, LocalizedString name, String legalArticle, boolean active) {
        return new VatExemptionReason(code, name, legalArticle, active);
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_CODE = (o1, o2) -> {
            int c = o1.getCode().compareTo(o2.getCode());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

