/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.services.payments.virtualpaymententries.IVirtualPaymentEntryHandler;
import org.joda.time.LocalDate;

public interface ISettlementInvoiceEntryBean {
    public static final String DUE_DATE = "dueDate";
    public static final String CREATION_DATE = "creationDate";
    public static final String DESCRITPION = "descritpion";
    public static final String AMOUNT = "amount";
    public static final String PRODUCT_ID = "productId";
    public static final String INCLUDED = "included";
    public static final String NOT_VALID = "notValid";
    public static final String DEBIT_ENTRY_ID = "debitEntryId";
    public static final String TYPE = "type";

    public InvoiceEntry getInvoiceEntry();

    public String getDescription();

    public LocalDate getDueDate();

    public BigDecimal getEntryAmount();

    public BigDecimal getEntryOpenAmount();

    public BigDecimal getSettledAmount();

    public void setSettledAmount(BigDecimal var1);

    public Vat getVat();

    public BigDecimal getVatRate();

    public boolean isIncluded();

    public void setIncluded(boolean var1);

    public boolean isNotValid();

    public void setNotValid(boolean var1);

    public FinantialDocument getFinantialDocument();

    public Set<Customer> getPaymentCustomer();

    default public boolean isForDebitEntry() {
        return false;
    }

    default public boolean isForInstallment() {
        return false;
    }

    default public boolean isForCreditEntry() {
        return false;
    }

    default public boolean isForPendingInterest() {
        return false;
    }

    default public boolean isForPaymentPenalty() {
        return false;
    }

    default public boolean isForPendingDebitEntry() {
        return false;
    }

    default public IVirtualPaymentEntryHandler getVirtualPaymentEntryHandler() {
        return null;
    }

    default public Map<String, List<String>> getCalculationDescription() {
        return Collections.emptyMap();
    }

    default public boolean isForFinantialEntity(FinantialEntity finantialEntity) {
        return true;
    }

    public String serialize();

    public void fillSerializable(JsonObject var1);

    public static ISettlementInvoiceEntryBean deserialize(String serializedObject) {
        try {
            JsonObject jsonObject = (JsonObject)new Gson().fromJson(serializedObject, JsonObject.class);
            Class<?> objectClass = Class.forName(jsonObject.get(TYPE).getAsString());
            ISettlementInvoiceEntryBean newInstance = (ISettlementInvoiceEntryBean)objectClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            newInstance.fillSerializable(jsonObject);
            return newInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }
}

