/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibs.incomming;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFileDetailLine;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFileFooter;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFileHeader;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;

public class SibsIncommingPaymentFile {
    private static final String HEADER_REGISTER_TYPE = "0";
    private static final String DETAIL_REGISTER_TYPE = "2";
    private static final String FOOTER_REGISTER_TYPE = "9";
    private SibsIncommingPaymentFileHeader header;
    private List<SibsIncommingPaymentFileDetailLine> detailLines;
    private SibsIncommingPaymentFileFooter footer;
    private String filename;

    public SibsIncommingPaymentFile(String filename, SibsIncommingPaymentFileHeader header, SibsIncommingPaymentFileFooter footer, List<SibsIncommingPaymentFileDetailLine> detailLines) {
        this.filename = filename;
        this.header = header;
        this.footer = footer;
        this.detailLines = detailLines;
        this.checkIfDetailLinesTotalAmountMatchesFooterTotalAmount();
    }

    private void checkIfDetailLinesTotalAmountMatchesFooterTotalAmount() {
        BigDecimal totalEntriesAmount = BigDecimal.ZERO;
        for (SibsIncommingPaymentFileDetailLine detailLine : this.getDetailLines()) {
            totalEntriesAmount = totalEntriesAmount.add(detailLine.getAmount());
        }
        if (!TreasuryConstants.isEqual(totalEntriesAmount, this.footer.getTransactionsTotalAmount())) {
            throw new RuntimeException("Footer total amount does not match detail lines total amount");
        }
    }

    public static SibsIncommingPaymentFile parse(String filename, InputStream stream) throws IOException {
        return SibsIncommingPaymentFile.parse(filename, IOUtils.toByteArray((InputStream)stream));
    }

    public static SibsIncommingPaymentFile parse(String filename, byte[] content) {
        SibsIncommingPaymentFileHeader header = null;
        SibsIncommingPaymentFileFooter footer = null;
        ArrayList<SibsIncommingPaymentFileDetailLine> detailLines = new ArrayList<SibsIncommingPaymentFileDetailLine>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(content)));
        try {
            String line = reader.readLine();
            while (line != null) {
                if (SibsIncommingPaymentFile.isHeader(line)) {
                    header = SibsIncommingPaymentFileHeader.buildFrom(line);
                } else if (SibsIncommingPaymentFile.isDetail(line)) {
                    detailLines.add(SibsIncommingPaymentFileDetailLine.buildFrom(line));
                } else if (SibsIncommingPaymentFile.isFooter(line)) {
                    footer = SibsIncommingPaymentFileFooter.buildFrom(line);
                } else {
                    throw new RuntimeException("Unknown sibs incomming payment file line type");
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new SibsIncommingPaymentFile(filename, header, footer, detailLines);
    }

    private static boolean isFooter(String line) {
        return line.startsWith(FOOTER_REGISTER_TYPE);
    }

    private static boolean isHeader(String line) {
        return line.startsWith(HEADER_REGISTER_TYPE);
    }

    private static boolean isDetail(String line) {
        return line.startsWith(DETAIL_REGISTER_TYPE);
    }

    public List<SibsIncommingPaymentFileDetailLine> getDetailLines() {
        return Collections.unmodifiableList(this.detailLines);
    }

    public SibsIncommingPaymentFileFooter getFooter() {
        return this.footer;
    }

    public SibsIncommingPaymentFileHeader getHeader() {
        return this.header;
    }

    public String getFilename() {
        return this.filename;
    }

    public LocalDate getWhenProcessedBySibs() {
        return this.getHeader().getWhenProcessedBySibs();
    }

    public Integer getVersion() {
        return this.getHeader().getVersion();
    }
}

