/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration;

import com.google.common.base.Strings;
import com.qubit.solution.fenixedu.bennu.webservices.domain.webservice.WebServiceAuthenticationLevel;
import com.qubit.solution.fenixedu.bennu.webservices.domain.webservice.WebServiceClientConfiguration;
import com.qubit.solution.fenixedu.bennu.webservices.domain.webservice.WebServiceConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.TaskRunner;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.TreasuryFile;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PaylineWebServiceClient;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineWebServiceResponse;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.services.integration.FenixEDUTreasuryPlatformDependentServices$1$callable$run;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import org.fenixedu.treasury.services.integration.erp.ISaftExporterConfiguration;
import org.fenixedu.treasury.services.integration.erp.tasks.ERPExportSingleDocumentsTask;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Address;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Buyer;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Details;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.DoWebPaymentRequest;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.DoWebPaymentResponse;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.GetWebPaymentDetailsRequest;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.GetWebPaymentDetailsResponse;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Order;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.OrderDetail;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Payment;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.WebPaymentAPI;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class FenixEDUTreasuryPlatformDependentServices
implements ITreasuryPlatformDependentServices {
    private static final int WAIT_TRANSACTION_TO_FINISH_MS = 500;

    @Override
    public IERPExternalService getERPExternalServiceImplementation(ERPConfiguration erpConfiguration) {
        String className = erpConfiguration.getImplementationClassName();
        try {
            Class<?> cl = Class.forName(className);
            WebServiceClientConfiguration clientConfiguration = (WebServiceClientConfiguration)WebServiceConfiguration.readByImplementationClass((String)className);
            IERPExternalService client = (IERPExternalService)clientConfiguration.getClient();
            return client;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TreasuryDomainException("error.ERPConfiguration.invalid.external.service", new String[0]);
        }
    }

    @Override
    public byte[] getFileContent(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getContent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getFileSize(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getSize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DateTime getFileCreationDate(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getCreationDate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getFilename(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getFilename();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getFileStream(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getFileContentType(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getContentType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createFile(IGenericFile genericFile, String fileName, String contentType, byte[] content) {
        try {
            TreasuryFile file = TreasuryFile.create(fileName, contentType, content);
            PropertyUtils.setProperty((Object)genericFile, (String)"treasuryFile", (Object)((Object)file));
            genericFile.setFileId(file.getExternalId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteFile(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            file.delete();
            PropertyUtils.setProperty((Object)genericFile, (String)"treasuryFile", null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getLoggedUsername() {
        if (Authenticate.getUser() == null) {
            return null;
        }
        return Authenticate.getUser().getUsername();
    }

    @Override
    public String getCustomerEmail(Customer customer) {
        return null;
    }

    @Override
    public void setCurrentApplicationUser(String username) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void removeCurrentApplicationUser() {
        throw new RuntimeException("not supported");
    }

    @Override
    public Locale defaultLocale() {
        return Locale.forLanguageTag(CoreConfiguration.getConfiguration().defaultLocale());
    }

    @Override
    public Locale currentLocale() {
        return I18N.getLocale();
    }

    @Override
    public Set<Locale> availableLocales() {
        return CoreConfiguration.supportedLocales();
    }

    @Override
    public String bundle(String bundleName, String key, String ... args) {
        return BundleUtil.getString((String)bundleName, (String)key, (String[])args);
    }

    @Override
    public String bundle(Locale locale, String bundleName, String key, String ... args) {
        return BundleUtil.getString((String)bundleName, (Locale)locale, (String)key, (String[])args);
    }

    @Override
    public LocalizedString bundleI18N(String bundleName, String key, String ... args) {
        return BundleUtil.getLocalizedString((String)bundleName, (String)key, (String[])args);
    }

    @Override
    public LocalizedString getDynamicApplicationMessage(String key) {
        throw new RuntimeException("not supported");
    }

    @Override
    public <T> String versioningCreatorUsername(T obj) {
        return FenixEDUTreasuryPlatformDependentServices.readVersioningCreatorUsername(obj);
    }

    @Override
    public <T> DateTime versioningCreationDate(T obj) {
        return FenixEDUTreasuryPlatformDependentServices.readVersioningCreationDate(obj);
    }

    @Override
    public <T> String versioningUpdatorUsername(T obj) {
        return FenixEDUTreasuryPlatformDependentServices.readVersioningUpdatorUsername(obj);
    }

    @Override
    public <T> DateTime versioningUpdateDate(T obj) {
        return FenixEDUTreasuryPlatformDependentServices.readVersioningUpdateDate(obj);
    }

    public static <T> String readVersioningCreatorUsername(T obj) {
        try {
            String username = (String)PropertyUtils.getProperty(obj, (String)"versioningCreator");
            return username;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> DateTime readVersioningCreationDate(T obj) {
        try {
            DateTime creationDate = (DateTime)PropertyUtils.getProperty(obj, (String)"versioningCreationDate");
            return creationDate;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String readVersioningUpdatorUsername(T obj) {
        try {
            Object versioningUpdatedBy = PropertyUtils.getProperty(obj, (String)"versioningUpdatedBy");
            if (versioningUpdatedBy == null) {
                return null;
            }
            return (String)PropertyUtils.getProperty((Object)versioningUpdatedBy, (String)"username");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> DateTime readVersioningUpdateDate(T obj) {
        try {
            Object versioningUpdateDate = PropertyUtils.getProperty(obj, (String)"versioningUpdateDate");
            if (versioningUpdateDate == null) {
                return null;
            }
            return (DateTime)PropertyUtils.getProperty((Object)versioningUpdateDate, (String)"date");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getFileContent(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFileContent(String): not supported");
    }

    @Override
    public long getFileSize(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFileSize(String): not supported");
    }

    @Override
    public String getFilename(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFilename(String): not supported");
    }

    @Override
    public InputStream getFileStream(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFileStream(String): not supported");
    }

    @Override
    public DateTime getFileCreationDate(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFileCreationDate(String): not supported");
    }

    @Override
    public String getFileContentType(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFileContentType(String): not supported");
    }

    @Override
    public String createFile(String fileName, String contentType, byte[] content) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.createFile(): not supported");
    }

    @Override
    public void deleteFile(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.deleteFile(String): not supported");
    }

    @Override
    public void scheduleDocumentForExportation(FinantialDocument finantialDocument) {
        FinantialInstitution finantialInstitution = finantialDocument.getDebtAccount().getFinantialInstitution();
        if (finantialInstitution.getErpIntegrationConfiguration() == null) {
            return;
        }
        if (StringUtils.isEmpty((String)finantialInstitution.getErpIntegrationConfiguration().getImplementationClassName())) {
            return;
        }
        IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        if (erpExporter == null) {
            return;
        }
        List<FinantialDocument> documentsToExport = erpExporter.filterDocumentsToExport(Collections.singletonList(finantialDocument).stream());
        if (documentsToExport.isEmpty()) {
            return;
        }
        final String externalId = documentsToExport.iterator().next().getExternalId();
        new Thread(){
            public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

            @Override
            public void run() {
                Object object = advice$run.perform((Callable)new FenixEDUTreasuryPlatformDependentServices$1$callable$run(this));
            }

            static /* synthetic */ void advised$run(1 this_) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SchedulerSystem.queue((TaskRunner)new TaskRunner((CronTask)new ERPExportSingleDocumentsTask(this_.externalId)));
            }
        }.start();
    }

    @Override
    public PaylineWebServiceResponse paylineGetWebPaymentDetails(ForwardPaymentRequest forwardPaymentRequest) {
        DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm");
        GetWebPaymentDetailsRequest request = new GetWebPaymentDetailsRequest();
        request.setToken(forwardPaymentRequest.getCheckoutId());
        GetWebPaymentDetailsResponse response = ((WebPaymentAPI)new PaylineWebServiceClient().getClient()).getWebPaymentDetails(request);
        PaylineWebServiceResponse result = new PaylineWebServiceResponse();
        if (response.getResult() != null) {
            result.setResultCode(response.getResult().getCode());
            result.setResultLongMessage(response.getResult().getLongMessage());
        }
        if (response.getAuthorization() != null) {
            result.setAuthorizationNumber(response.getAuthorization().getNumber());
        }
        if (response.getAuthorization() != null && !Strings.isNullOrEmpty((String)response.getAuthorization().getDate())) {
            result.setAuthorizationDate(DATE_TIME_PATTERN.parseDateTime(response.getAuthorization().getDate()));
        }
        if (response.getPayment() != null && !Strings.isNullOrEmpty((String)response.getPayment().getAmount())) {
            result.setPaymentAmount(new BigDecimal(response.getPayment().getAmount()).divide(new BigDecimal("100")));
        }
        if (response.getTransaction() != null) {
            result.setTransactionId(response.getTransaction().getId());
        }
        if (response.getTransaction() != null && !Strings.isNullOrEmpty((String)response.getTransaction().getDate())) {
            result.setTransactionDate(DATE_TIME_PATTERN.parseDateTime(response.getTransaction().getDate()));
        }
        result.setJsonRequest(TreasuryConstants.json(request));
        result.setJsonResponse(TreasuryConstants.json(response));
        return result;
    }

    @Override
    public PaylineWebServiceResponse paylineDoWebPayment(ForwardPaymentRequest forwardPaymentRequest, String returnUrl, String cancelUrl) {
        int PAYLINE_MAX_PHONE_SIZE = 14;
        DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm");
        String SECURITY_MODE = "SSL";
        String PT = "PT";
        String EURO_CURRENCY = "978";
        String ACTION_AUTHORIZATION_AND_VALIDATION = "101";
        String MODE_CPT = "CPT";
        String TRANSACTION_APPROVED_CODE = "00000";
        String TRANSACTION_PENDING_FORM_FILL = "02306";
        String ACTION_RETURN_URL = "return";
        String ACTION_CANCEL_URL = "cancel";
        String LANG_PT = "pt";
        String LANG_EN = "en";
        String formattedAmount = forwardPaymentRequest.getPayableAmount().multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_EVEN).toString();
        Payment paymentDetails = new Payment();
        paymentDetails.setAmount(formattedAmount);
        paymentDetails.setCurrency("978");
        paymentDetails.setAction("101");
        paymentDetails.setMode("CPT");
        paymentDetails.setContractNumber(((PaylineConfiguration)((Object)forwardPaymentRequest.getDigitalPaymentPlatform())).getPaylineContractNumber());
        Order order = new Order();
        order.setRef(String.valueOf(forwardPaymentRequest.getOrderNumber()));
        order.setAmount(formattedAmount);
        order.setCurrency("978");
        order.setDate(TreasuryPlataformDependentServicesFactory.implementation().versioningCreationDate(forwardPaymentRequest).toString("dd/MM/yyyy HH:mm"));
        order.setCountry("PT");
        Customer customer = forwardPaymentRequest.getDebtAccount().getCustomer();
        Buyer buyerDetails = new Buyer();
        buyerDetails.setFirstName(customer.getFirstNames());
        buyerDetails.setLastName(customer.getLastNames());
        if (!Strings.isNullOrEmpty((String)customer.getEmail()) && EmailValidator.getInstance().isValid(customer.getEmail())) {
            buyerDetails.setEmail(customer.getEmail());
        }
        if (!Strings.isNullOrEmpty((String)customer.getPhoneNumber())) {
            String phone = customer.getPhoneNumber().replaceAll("[^\\d]", "");
            if (phone.length() > 14) {
                phone = phone.substring(0, 14);
            }
            buyerDetails.setMobilePhone(phone);
        }
        DoWebPaymentRequest request = new DoWebPaymentRequest();
        request.setPayment(paymentDetails);
        request.setOrder(order);
        request.setReturnURL(returnUrl);
        request.setCancelURL(cancelUrl);
        String languageToUse = "en".equals(I18N.getLocale().getLanguage()) ? "en" : "pt";
        request.setLanguageCode(languageToUse);
        request.setBuyer(buyerDetails);
        request.setSecurityMode("SSL");
        DoWebPaymentResponse response = ((WebPaymentAPI)new PaylineWebServiceClient().getClient()).doWebPayment(request);
        PaylineWebServiceResponse result = new PaylineWebServiceResponse();
        if (response.getResult() != null) {
            result.setResultCode(response.getResult().getCode());
            result.setResultLongMessage(response.getResult().getLongMessage());
        }
        result.setToken(response.getToken());
        result.setRedirectURL(response.getRedirectURL());
        result.setJsonRequest(TreasuryConstants.json(request));
        result.setJsonResponse(TreasuryConstants.json(response));
        return result;
    }

    private void fillAddress(Customer customer, Buyer buyerDetails) {
        Address address = new Address();
        address.setStreet1(customer.getAddress());
        address.setZipCode(customer.getZipCode());
        address.setCountry(customer.getAddressCountryCode());
        buyerDetails.setShippingAdress(address);
    }

    private void fillOrderDetails(ForwardPaymentRequest forwardPayment, Order order) {
        Currency currency = forwardPayment.getDebtAccount().getFinantialInstitution().getCurrency();
        Details details = new Details();
        for (DebitEntry debitEntry : forwardPayment.getDebitEntriesSet()) {
            OrderDetail orderDetail = new OrderDetail();
            orderDetail.setRef(debitEntry.getExternalId());
            orderDetail.setPrice(Currency.getValueWithScale(debitEntry.getOpenAmount()).multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_EVEN).toString());
            orderDetail.setQuantity("1");
            orderDetail.setComment(debitEntry.getDescription());
            details.getDetails().add(orderDetail);
        }
        order.setDetails(details);
    }

    @Override
    public void paylineConfigureWebservice(PaylineConfiguration paylineConfiguration) {
        if (WebServiceConfiguration.readByImplementationClass((String)"org.fenixedu.treasury.domain.forwardpayments.implementations.PaylineWebServiceClient") == null) {
            new WebServiceClientConfiguration("org.fenixedu.treasury.domain.forwardpayments.implementations.PaylineWebServiceClient");
        }
        WebServiceClientConfiguration configuration = (WebServiceClientConfiguration)WebServiceConfiguration.readByImplementationClass((String)"org.fenixedu.treasury.domain.forwardpayments.implementations.PaylineWebServiceClient");
        configuration.setAuthenticationLevel(WebServiceAuthenticationLevel.BASIC_AUTH);
        configuration.setUrl(paylineConfiguration.getPaymentURL());
        configuration.setClientUsername(paylineConfiguration.getPaylineMerchantId());
        configuration.setClientPassword(paylineConfiguration.getPaylineMerchantAccessKey());
    }

    @Override
    public String calculateURLChecksum(String urlToChecksum, HttpSession session) {
        return GenericChecksumRewriter.calculateChecksum((String)urlToChecksum, (HttpSession)session);
    }

    @Override
    public String getForwardPaymentURL(String contextPath, Class screenClass, boolean isSuccess, String forwardPaymentId, boolean isException) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void signalsRegisterHandlerForKey(String signalKey, Object handler) {
        Signal.register((String)signalKey, (Object)handler);
    }

    @Override
    public void signalsUnregisterHandlerForKey(String signalKey, Object handler) {
        Signal.unregister((String)signalKey, (Object)handler);
    }

    @Override
    public void signalsEmitForObject(String signalKey, DomainObject obj) {
        Signal.emit((String)signalKey, (Object)new DomainObjectEvent(obj));
    }

    @Override
    public InputStream exportDocuments(String templateCode, FinantialInstitution finantialInstitution, FinantialEntity finantialEntity, LocalDate documentDateFrom, LocalDate documentDateTo, String username) {
        throw new RuntimeException("not supported");
    }

    @Override
    public String exportDocumentFileExtension() {
        throw new RuntimeException("not supported");
    }

    @Override
    public InputStream exportPaymentReceipt(String templateCode, SettlementNote settlementNote) {
        throw new RuntimeException("not supported");
    }

    @Override
    public ISaftExporterConfiguration getSaftExporterConfiguration(ERPConfiguration configuration) {
        return null;
    }

    @Override
    public Set<Partial> getHolidays() {
        throw new RuntimeException("not supported");
    }

    @Override
    public void certifyDocument(FinantialDocument finantialDocument) {
    }

    @Override
    public void updateCertifiedDocument(FinantialDocument finantialDocument) {
    }

    @Override
    public void annulCertifiedDocument(FinantialDocument finantialDocument) {
    }

    @Override
    public boolean hasCertifiedDocument(FinantialDocument finantialDocument) {
        return false;
    }

    @Override
    public boolean isProductCertified(Product product) {
        return false;
    }

    @Override
    public String getCertifiedDocumentNumber(FinantialDocument finantialDocument) {
        return null;
    }

    @Override
    public LocalDate getCertifiedDocumentDate(FinantialDocument finantialDocument) {
        return null;
    }

    @Override
    public boolean isQualityOrDevelopmentMode() {
        return CoreConfiguration.getConfiguration().developmentMode() != false || this.isQualityMode();
    }

    private boolean isQualityMode() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/configuration.properties"));
            return Boolean.valueOf(properties.getProperty("quality.mode", "true"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

