/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator;

import java.util.List;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.PaymentPlanValidator;
import org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.WithoutConsecutiveInstallmentsOverdueValidator_Base;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;

public class WithoutConsecutiveInstallmentsOverdueValidator
extends WithoutConsecutiveInstallmentsOverdueValidator_Base {
    public WithoutConsecutiveInstallmentsOverdueValidator() {
    }

    public WithoutConsecutiveInstallmentsOverdueValidator(Integer numberInstallments, Integer numberDaysToTakeEffect) {
        this();
        this.setNumberDaysToTakeEffect(numberDaysToTakeEffect);
        this.setNumberInstallments(numberInstallments);
    }

    public WithoutConsecutiveInstallmentsOverdueValidator create(Integer numberInstallments, Integer numberDaysToTakeEffect) {
        return new WithoutConsecutiveInstallmentsOverdueValidator(numberInstallments, numberDaysToTakeEffect);
    }

    public String getDescription() {
        return TreasuryConstants.treasuryBundle("org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.WithoutConsecutiveInstallmentsOverdueValidator.description", String.valueOf(this.getNumberInstallments()), String.valueOf(this.getNumberDaysToTakeEffect()));
    }

    public Boolean validate(LocalDate date, List<Installment> sortedInstallments) {
        int count = 0;
        for (Installment installment : sortedInstallments) {
            int numberOfWorkDaysBetween = TreasuryConstants.countNumberOfWorkDaysBetween(installment.getDueDate(), date);
            if (installment.isOverdue(date) && numberOfWorkDaysBetween > this.getNumberDaysToTakeEffect()) {
                boolean isNotCompliant;
                if (!(isNotCompliant = ++count == this.getNumberInstallments() || count == installment.getPaymentPlan().getSortedOpenInstallments().size())) continue;
                return false;
            }
            count = 0;
        }
        return true;
    }

    protected PaymentPlanValidator clone() {
        return new WithoutConsecutiveInstallmentsOverdueValidator(this.getNumberInstallments(), this.getNumberDaysToTakeEffect());
    }
}

