/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.PaymentPlanGroupValidator_Base;
import org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.PaymentPlanValidator;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

public class PaymentPlanGroupValidator
extends PaymentPlanGroupValidator_Base {
    public PaymentPlanGroupValidator() {
        this.setConjunction(Boolean.TRUE);
    }

    protected PaymentPlanGroupValidator(Set<PaymentPlanValidator> childs, Boolean isConjunction) {
        this();
        this.getChildValidatorsSet().addAll(childs);
        this.setConjunction(isConjunction);
    }

    public static PaymentPlanGroupValidator create(Set<PaymentPlanValidator> childs, Boolean isConjunction) {
        return new PaymentPlanGroupValidator(childs, isConjunction);
    }

    public Boolean validate(LocalDate date, List<Installment> sortedInstallments) {
        if (this.getParentValidator() == null || Boolean.TRUE.equals(this.getConjunction())) {
            return this.getChildValidatorsSet().stream().allMatch(v -> v.validate(date, sortedInstallments));
        }
        return this.getChildValidatorsSet().stream().anyMatch(v -> v.validate(date, sortedInstallments));
    }

    public String getDescription() {
        if (this.getConjunction().booleanValue()) {
            return TreasuryConstants.treasuryBundle("org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.PaymentPlanGroupValidator.GroupofrulesAND", new String[0]);
        }
        return TreasuryConstants.treasuryBundle("org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.PaymentPlanGroupValidator.GroupofrulesOR", new String[0]);
    }

    public void delete() {
        if (!this.getPaymentPlansSet().isEmpty()) {
            throw new IllegalArgumentException(TreasuryConstants.treasuryBundle("PaymentPlanGroupValidator.Cannot.delete.PaymentPlanValidator.withAssocietedPlans", new String[0]));
        }
        if (this.getParentValidator() == null) {
            this.getChildValidatorsSet().forEach(v -> v.delete(true));
            this.setDomainRoot(null);
            this.deleteDomainObject();
        } else {
            this.getChildValidatorsSet().forEach(v -> v.setParentValidator(this.getParentValidator()));
            this.setParentValidator(null);
            this.setDomainRoot(null);
            this.deleteDomainObject();
        }
    }

    public void delete(boolean deleteChilds) {
        if (!this.getPaymentPlansSet().isEmpty()) {
            throw new IllegalArgumentException(TreasuryConstants.treasuryBundle("PaymentPlanGroupValidator.Cannot.delete.PaymentPlanValidator.withAssocietedPlans", new String[0]));
        }
        if (this.getParentValidator() == null) {
            this.getChildValidatorsSet().forEach(v -> v.delete(true));
            this.setDomainRoot(null);
            this.deleteDomainObject();
        } else {
            if (deleteChilds) {
                this.getChildValidatorsSet().forEach(v -> v.delete(deleteChilds));
            } else {
                this.getChildValidatorsSet().forEach(v -> v.setParentValidator(this.getParentValidator()));
            }
            this.setParentValidator(null);
            this.setDomainRoot(null);
            this.deleteDomainObject();
        }
    }

    public static Set<PaymentPlanGroupValidator> findRootGroupValidators() {
        return FenixFramework.getDomainRoot().getPaymentPlanValidatorsSet().stream().filter(PaymentPlanGroupValidator.class::isInstance).map(PaymentPlanGroupValidator.class::cast).filter(p -> p.getParentValidator() == null).collect(Collectors.toSet());
    }

    public static Set<PaymentPlanGroupValidator> findActiveGroupValidators() {
        return PaymentPlanGroupValidator.findRootGroupValidators().stream().filter(p -> Boolean.TRUE.equals(p.getActive())).collect(Collectors.toSet());
    }

    public static PaymentPlanGroupValidator create(LocalizedString newName, Boolean active) {
        PaymentPlanGroupValidator result = new PaymentPlanGroupValidator();
        result.setName(newName);
        result.setActive(active);
        result.setConjunction(Boolean.TRUE);
        return result;
    }

    public static PaymentPlanGroupValidator create(LocalizedString newName, Boolean active, PaymentPlanGroupValidator base) {
        PaymentPlanGroupValidator result = new PaymentPlanGroupValidator();
        result.setName(newName);
        result.setActive(active);
        result.setConjunction(Boolean.TRUE);
        for (PaymentPlanValidator validator : base.getChildValidatorsSet()) {
            result.addChildValidators(validator.clone());
        }
        return result;
    }

    protected PaymentPlanValidator clone() {
        PaymentPlanGroupValidator result = new PaymentPlanGroupValidator();
        result.setConjunction(this.getConjunction());
        for (PaymentPlanValidator validator : this.getChildValidatorsSet()) {
            result.addChildValidators(validator.clone());
        }
        return result;
    }

    public static enum ConjunctionWidget {
        AND(Boolean.TRUE),
        OR(Boolean.FALSE);

        private Boolean conjuction;

        private ConjunctionWidget(Boolean conjuction) {
            this.conjuction = conjuction;
        }

        public Boolean getConjuction() {
            return this.conjuction;
        }
    }
}

