/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.treasurydebtprocess;

import java.util.Set;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.treasurydebtprocess.ITreasuryDebtProcess;

public interface ITreasuryDebtProcessService {
    public LocalizedString getServiceDescription();

    public boolean isBlockingPaymentInFrontend(InvoiceEntry var1);

    public boolean isBlockingPaymentInBackoffice(InvoiceEntry var1);

    public LocalizedString getBlockingPaymentReasonForFrontend(DebtAccount var1);

    public LocalizedString getBlockingPaymentReasonForFrontend(InvoiceEntry var1);

    public LocalizedString getBlockingPaymentReasonForBackoffice(InvoiceEntry var1);

    public Set<? extends ITreasuryDebtProcess> getDebtProcesses(InvoiceEntry var1);

    public boolean isInterestCreationWhenTotalSettledPrevented(InvoiceEntry var1);

    public boolean isFinantialDocumentAnnullmentActionBlocked(FinantialDocument var1);

    public boolean isFinantialDocumentEntryAnnullmentActionBlocked(FinantialDocumentEntry var1);

    public Set<? extends ITreasuryDebtProcess> getDebtProcesses(SettlementNote var1);

    public boolean isDebitEntryInterestCreationInAdvanceBlocked(DebitEntry var1);

    default public boolean isCustomerFiscalNumberInvalid(Customer customer) {
        return false;
    }

    default public LocalizedString getCustomerFiscalNumberInvalidReason(Customer customer) {
        return null;
    }
}

