/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.sibspaymentsgateway;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.payments.IMbwayPaymentPlatformService;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest$callable$create;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest$callable$processPayment;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest_Base;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MbwayRequest
extends MbwayRequest_Base {
    public static final Advice advice$processPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public MbwayRequest() {
    }

    protected MbwayRequest(IMbwayPaymentPlatformService platform, DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, BigDecimal payableAmount, String phoneNumber, String merchantTransactionId) {
        this();
        this.init((DigitalPaymentPlatform)((Object)platform), debtAccount, debitEntries, installments, payableAmount, TreasurySettings.getInstance().getMbWayPaymentMethod());
        this.setPhoneNumber(phoneNumber);
        this.setMerchantTransactionId(merchantTransactionId);
        this.setState(PaymentReferenceCodeStateType.USED);
        this.checkRules();
    }

    public void checkRules() {
        super.checkRules();
        if (StringUtils.isEmpty((String)this.getPhoneNumber())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phoneNumber.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getMerchantTransactionId())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.sibsMerchantTransaction.required", new String[0]);
        }
    }

    public Set<SettlementNote> processPayment(BigDecimal bigDecimal, DateTime dateTime, String string, String string2) {
        return (Set)advice$processPayment.perform((Callable)new MbwayRequest$callable$processPayment(this, bigDecimal, dateTime, string, string2));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ Set advised$processPayment(MbwayRequest this_, BigDecimal paidAmount, DateTime paymentDate, String sibsTransactionId, String comments) {
        Function<PaymentRequest, Map> additionalPropertiesMapFunction = o -> this.fillPaymentEntryPropertiesMap(sibsTransactionId);
        this_.setState(PaymentReferenceCodeStateType.PROCESSED);
        if (this_.getMbwayMandatePaymentSchedule() != null && this_.getMbwayMandatePaymentSchedule().getState().isPaymentCharged()) {
            this_.getMbwayMandatePaymentSchedule().updateStateToPaid();
        }
        if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            return this_.internalProcessPaymentInNormalPaymentMixingLegacyInvoices(paidAmount, paymentDate, sibsTransactionId, comments, additionalPropertiesMapFunction);
        }
        return this_.internalProcessPaymentInRestrictedPaymentMixingLegacyInvoices(paidAmount, paymentDate, sibsTransactionId, comments, additionalPropertiesMapFunction);
    }

    private Map<String, String> fillPaymentEntryPropertiesMap(String sibsTransactionId) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("SibsTransactionId", sibsTransactionId);
        return result;
    }

    public PaymentReferenceCodeStateType getCurrentState() {
        return super.getState();
    }

    public boolean isInCreatedState() {
        return false;
    }

    public boolean isInRequestedState() {
        return this.getState() == PaymentReferenceCodeStateType.USED;
    }

    public boolean isInPaidState() {
        return this.getState() == PaymentReferenceCodeStateType.PROCESSED;
    }

    public boolean isInAnnuledState() {
        return this.getState() == PaymentReferenceCodeStateType.ANNULLED;
    }

    public void anull() {
        this.setState(PaymentReferenceCodeStateType.ANNULLED);
    }

    public static Stream<MbwayRequest> findAll() {
        return PaymentRequest.findAll().filter(p -> p instanceof MbwayRequest).map(MbwayRequest.class::cast);
    }

    public static Stream<MbwayRequest> findBySibsGatewayMerchantTransactionId(String sibsGatewayMerchantTransactionId) {
        return PaymentRequest.findBySibsGatewayMerchantTransactionId(sibsGatewayMerchantTransactionId).filter(p -> p instanceof MbwayRequest).map(MbwayRequest.class::cast);
    }

    public static Optional<MbwayRequest> findUniqueBySibsGatewayMerchantTransactionId(String sibsGatewayMerchantTransactionId) {
        return MbwayRequest.findBySibsGatewayMerchantTransactionId(sibsGatewayMerchantTransactionId).findAny();
    }

    public static Stream<? extends PaymentRequest> findBySibsGatewayTransactionId(String sibsGatewayTransactionId) {
        return PaymentRequest.findBySibsGatewayTransactionId(sibsGatewayTransactionId).filter(p -> p instanceof MbwayRequest).map(MbwayRequest.class::cast);
    }

    public static Optional<? extends PaymentRequest> findUniqueBySibsGatewayTransactionId(String sibsGatewayTransactionId) {
        return MbwayRequest.findBySibsGatewayTransactionId(sibsGatewayTransactionId).findAny();
    }

    public static MbwayRequest create(IMbwayPaymentPlatformService iMbwayPaymentPlatformService, DebtAccount debtAccount, Set<DebitEntry> set, Set<Installment> set2, String string, BigDecimal bigDecimal, String string2) {
        return (MbwayRequest)((Object)advice$create.perform((Callable)new MbwayRequest$callable$create(iMbwayPaymentPlatformService, debtAccount, set, set2, string, bigDecimal, string2)));
    }

    static /* synthetic */ MbwayRequest advised$create(IMbwayPaymentPlatformService paymentPlatform, DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, String phoneNumber, BigDecimal payableAmount, String merchantTransactionId) {
        return new MbwayRequest(paymentPlatform, debtAccount, debitEntries, installments, payableAmount, phoneNumber, merchantTransactionId);
    }

    public String getUiDescription() {
        return String.format("%s ( %s )", this.getPaymentMethod().getName().getContent(), this.getPhoneNumber());
    }
}

