/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.payments;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.payments.PaymentInvoiceEntriesGroup_Base;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

public class PaymentInvoiceEntriesGroup
extends PaymentInvoiceEntriesGroup_Base {
    public PaymentInvoiceEntriesGroup() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
        this.setResponsible(TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername());
    }

    protected PaymentInvoiceEntriesGroup(FinantialEntity finantialEntity, DebtAccount debtAccount, Set<? extends InvoiceEntry> invoiceEntrySet, String groupKey) {
        this();
        this.setFinantialEntity(finantialEntity);
        this.setDebtAccount(debtAccount);
        invoiceEntrySet.forEach(e -> {
            if (TreasuryDebtProcessMainService.isBlockingPaymentInBackoffice(e) || TreasuryDebtProcessMainService.isBlockingPaymentInFrontend(e)) {
                throw new TreasuryDomainException("error.PaymentInvoiceEntriesGroup.invoiceEntry.blocked.for.payment", e.getDescription());
            }
        });
        this.getInvoiceEntriesSet().addAll(invoiceEntrySet);
        if (StringUtils.isEmpty((String)groupKey)) {
            groupKey = this.getCreationDate().toString("yyyyMMddHHmmss");
        }
        this.setGroupKey(groupKey.trim());
        this.checkRules();
    }

    public void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new IllegalStateException("error.PaymentInvoiceEntriesGroup.domainRoot.required");
        }
        if (this.getDebtAccount() == null) {
            throw new IllegalStateException("error.PaymentInvoiceEntriesGroup.debtAccount.required");
        }
        if (this.getFinantialEntity() == null) {
            throw new IllegalStateException("error.PaymentInvoiceEntriesGroup.finantialEntity.required");
        }
        if (this.getInvoiceEntriesSet().isEmpty()) {
            throw new IllegalStateException("error.PaymentInvoiceEntriesGroup.invoiceEntries.required");
        }
        if (this.getInvoiceEntriesSet().stream().map(e -> e.getFinantialEntity()).distinct().count() != 1L) {
            throw new TreasuryDomainException("error.PaymentInvoiceEntriesGroup.different.finantialEntities.from.invoiceEntries", new String[0]);
        }
        if (this.getInvoiceEntriesSet().stream().anyMatch(i -> i.getDebtAccount() != this.getDebtAccount())) {
            throw new TreasuryDomainException("error.PaymentInvoiceEntriesGroup.different.debtAccounts.from.invoiceEntries", new String[0]);
        }
        if (this.getReferencedCustomers().size() != 1) {
            throw new TreasuryDomainException("error.PaymentInvoiceEntriesGroup.referencedCustomers.only.one.allowed", new String[0]);
        }
        if (this.getDebtAccount().getPaymentInvoiceEntriesGroupsSet().stream().filter(g -> g.getGroupKey().equals(this.getGroupKey())).count() > 1L) {
            throw new TreasuryDomainException("error.PaymentInvoiceEntriesGroup.groupKey.already.exists", new String[0]);
        }
    }

    public void delete() {
        this.setDomainRoot(null);
        this.setDebtAccount(null);
        this.setFinantialEntity(null);
        this.getInvoiceEntriesSet().clear();
        super.deleteDomainObject();
    }

    public Set<Customer> getReferencedCustomers() {
        return InvoiceEntry.getReferencedCustomers(this.getInvoiceEntriesSet());
    }

    public void editRemarks(String remarks) {
        super.setRemarks(remarks);
        this.checkRules();
    }

    public void addInvoiceEntries(InvoiceEntry invoiceEntry) {
        super.addInvoiceEntries(invoiceEntry);
        this.checkRules();
    }

    public void transferPaymentGroupToNewDebtAccount(DebtAccount destinyDebtAccount, Map<DebitEntry, DebitEntry> debitEntriesTransferMap) {
        Set<DebitEntry> newDebitEntrySet = this.getInvoiceEntriesSet().stream().filter(d -> debitEntriesTransferMap.containsKey(d)).map(d -> (DebitEntry)((Object)((Object)debitEntriesTransferMap.get(d)))).filter(d -> TreasuryConstants.isPositive(d.getOpenAmount())).collect(Collectors.toSet());
        if (newDebitEntrySet.isEmpty()) {
            return;
        }
        PaymentInvoiceEntriesGroup group = PaymentInvoiceEntriesGroup.findUniqueByGroupKey(destinyDebtAccount, StringUtils.isNotEmpty((String)this.getGroupKey()) ? this.getGroupKey() : UUID.randomUUID().toString()).orElseGet(() -> PaymentInvoiceEntriesGroup.create(this.getFinantialEntity(), destinyDebtAccount, newDebitEntrySet, this.getGroupKey()));
        newDebitEntrySet.forEach(d -> group.addInvoiceEntries((InvoiceEntry)((Object)((Object)d))));
    }

    public static PaymentInvoiceEntriesGroup create(FinantialEntity finantialEntity, DebtAccount debtAccount, Set<? extends InvoiceEntry> invoiceEntrySet, String groupKey) {
        invoiceEntrySet.stream().filter(i -> i.isDebitNoteEntry()).map(i -> (DebitEntry)((Object)((Object)i))).flatMap(i -> i.getActiveSibsPaymentRequests().stream()).forEach(i -> i.anull());
        return new PaymentInvoiceEntriesGroup(finantialEntity, debtAccount, invoiceEntrySet, groupKey);
    }

    public static Stream<PaymentInvoiceEntriesGroup> findAll() {
        return FenixFramework.getDomainRoot().getPaymentInvoiceEntriesGroupsSet().stream();
    }

    public static Stream<PaymentInvoiceEntriesGroup> find(DebtAccount debtAccount) {
        return debtAccount.getPaymentInvoiceEntriesGroupsSet().stream();
    }

    public static Stream<PaymentInvoiceEntriesGroup> find(InvoiceEntry invoiceEntry) {
        return invoiceEntry.getPaymentInvoiceEntriesGroupsSet().stream();
    }

    public static Stream<PaymentInvoiceEntriesGroup> findByGroupKey(DebtAccount debtAccount, String groupKey) {
        return PaymentInvoiceEntriesGroup.find(debtAccount).filter(d -> groupKey.equals(d.getGroupKey()));
    }

    public static Optional<PaymentInvoiceEntriesGroup> findUniqueByGroupKey(DebtAccount debtAccount, String groupKey) {
        return PaymentInvoiceEntriesGroup.findByGroupKey(debtAccount, groupKey).findFirst();
    }

    public static Set<InvoiceEntry> getAllPaymentRelatableInvoiceEntries(InvoiceEntry invoiceEntry) {
        return invoiceEntry.getPaymentInvoiceEntriesGroupsSet().stream().flatMap(g -> g.getInvoiceEntriesSet().stream()).collect(Collectors.toSet());
    }
}

