/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.onlinepaymentsgateway.api.PaymentStateBean;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentcodes.FinantialDocumentPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentCodeTarget;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$anullPaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$bruteForceSetReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$createPaymentReferenceCodeForMultipleDebitEntries;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$createPaymentTargetTo;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$createPaymentTargetTo$1;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$processPayment;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$processPaymentReferenceCodeTransaction;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$setState;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode_Base;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGatewayLog;
import org.fenixedu.treasury.dto.document.managepayments.PaymentReferenceCodeBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Deprecated
public class PaymentReferenceCode
extends PaymentReferenceCode_Base {
    private static final int LENGTH_REFERENCE_CODE = 9;
    private static final BigDecimal SIBS_IGNORE_MAX_AMOUNT;
    public static final String TREASURY_OPERATION_LOG_TYPE = "TREASURY_OPERATION_LOG_TYPE";
    public static final Advice advice$delete;
    public static final Advice advice$create;
    public static final Advice advice$bruteForceSetReferenceCode;
    public static final Advice advice$setState;
    public static final Advice advice$processPayment;
    public static final Advice advice$processPaymentReferenceCodeTransaction;
    public static final Advice advice$createPaymentTargetTo;
    public static final Advice advice$createPaymentTargetTo$1;
    public static final Advice advice$anullPaymentReferenceCode;
    public static final Advice advice$createPaymentReferenceCodeForMultipleDebitEntries;

    protected void init(String referenceCode, LocalDate beginDate, LocalDate endDate, PaymentReferenceCodeStateType state, PaymentCodePool pool, BigDecimal minAmount, BigDecimal maxAmount, String sibsMerchantTransactionId, String sibsReferenceId) {
        this.setReferenceCode(Strings.padStart((String)referenceCode, (int)9, (char)'0'));
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setState(state);
        this.setPaymentCodePool(pool);
        this.setMinAmount(minAmount);
        this.setMaxAmount(maxAmount);
        this.setSibsMerchantTransactionId(sibsMerchantTransactionId);
        this.setSibsReferenceId(sibsReferenceId);
        this.checkRules();
    }

    public Interval getValidInterval() {
        return new Interval((ReadableInstant)this.getBeginDate().toDateTimeAtStartOfDay(), (ReadableInstant)this.getEndDate().plusDays(1).toDateTimeAtStartOfDay().minusSeconds(1));
    }

    private void checkRules() {
        if (this.getMinAmount() == null) {
            this.setMinAmount(BigDecimal.ZERO);
        }
        if (this.getMaxAmount() == null) {
            this.setMaxAmount(BigDecimal.ZERO);
        }
        if (PaymentReferenceCode.findByReferenceCode(this.getPaymentCodePool().getEntityReferenceCode(), this.getReferenceCode(), this.getPaymentCodePool().getFinantialInstitution()).count() > 1L) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.referenceCode.duplicated", new String[0]);
        }
        if (this.getPaymentCodePool().getPaymentCodeGenerator().isSibsMerchantTransactionAndReferenceIdRequired() && StringUtils.isEmpty((String)this.getSibsMerchantTransactionId())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.sibsMerchantTransactionId.required", new String[0]);
        }
        if (this.getPaymentCodePool().getPaymentCodeGenerator().isSibsMerchantTransactionAndReferenceIdRequired() && StringUtils.isEmpty((String)this.getSibsReferenceId())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.sibsReferenceId.required", new String[0]);
        }
    }

    public boolean isDeletable() {
        return this.getReportedInFilesSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentReferenceCode$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentReferenceCode this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.cannot.delete", new String[0]);
        }
        this_.setPaymentCodePool(null);
        this_.setTargetPayment(null);
        this_.deleteDomainObject();
    }

    public static PaymentReferenceCode create(String string, LocalDate localDate, LocalDate localDate2, PaymentReferenceCodeStateType paymentReferenceCodeStateType, PaymentCodePool paymentCodePool, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return (PaymentReferenceCode)((Object)advice$create.perform((Callable)new PaymentReferenceCode$callable$create(string, localDate, localDate2, paymentReferenceCodeStateType, paymentCodePool, bigDecimal, bigDecimal2)));
    }

    static /* synthetic */ PaymentReferenceCode advised$create(String referenceCode, LocalDate beginDate, LocalDate endDate, PaymentReferenceCodeStateType state, PaymentCodePool pool, BigDecimal minAmount, BigDecimal maxAmount) {
        PaymentReferenceCode paymentReferenceCode = new PaymentReferenceCode();
        paymentReferenceCode.init(referenceCode, beginDate, endDate, state, pool, minAmount, maxAmount, null, null);
        return paymentReferenceCode;
    }

    public static PaymentReferenceCode createForSibsOnlinePaymentGateway(String referenceCode, LocalDate beginDate, LocalDate endDate, PaymentReferenceCodeStateType state, PaymentCodePool pool, BigDecimal amount, String sibsMerchantTransactionId, String sibsReferenceId) {
        PaymentReferenceCode paymentReferenceCode = new PaymentReferenceCode();
        paymentReferenceCode.init(referenceCode, beginDate, endDate, state, pool, amount, amount, sibsMerchantTransactionId, sibsReferenceId);
        return paymentReferenceCode;
    }

    public static Stream<PaymentReferenceCode> findAll() {
        HashSet result = new HashSet();
        for (PaymentCodePool pool : PaymentCodePool.findAll().collect(Collectors.toList())) {
            result.addAll(pool.getPaymentReferenceCodesSet());
        }
        return result.stream();
    }

    public static Stream<PaymentReferenceCode> findByReferenceCode(String entityReferenceCode, String referenceCode, FinantialInstitution finantialInstitution) {
        return PaymentReferenceCode.findByReferenceCode(referenceCode, finantialInstitution).filter(x -> x.getPaymentCodePool().getEntityReferenceCode().equals(entityReferenceCode));
    }

    private static Stream<PaymentReferenceCode> find(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getPaymentCodePoolsSet().stream().flatMap(i -> i.getPaymentReferenceCodesSet().stream());
    }

    public static Stream<PaymentReferenceCode> findByReferenceCode(String referenceCode, FinantialInstitution finantialInstitution) {
        return PaymentReferenceCode.find(finantialInstitution).filter(i -> referenceCode.equalsIgnoreCase(i.getReferenceCode()));
    }

    public static Stream<PaymentReferenceCode> findByBeginDate(LocalDate beginDate, FinantialInstitution finantialInstitution) {
        return PaymentReferenceCode.find(finantialInstitution).filter(i -> beginDate.equals((Object)i.getBeginDate()));
    }

    public static Stream<PaymentReferenceCode> findByEndDate(LocalDate endDate, FinantialInstitution finantialInstitution) {
        return PaymentReferenceCode.find(finantialInstitution).filter(i -> endDate.equals((Object)i.getEndDate()));
    }

    public static Stream<PaymentReferenceCode> findByState(PaymentReferenceCodeStateType state, FinantialInstitution finantialInstitution) {
        return PaymentReferenceCode.find(finantialInstitution).filter(i -> state.equals(i.getState()));
    }

    public static Stream<PaymentReferenceCode> findBySibsReferenceId(String sibsReferenceId) {
        return PaymentReferenceCode.findAll().filter(p -> !StringUtils.isEmpty((String)p.getSibsReferenceId())).filter(p -> sibsReferenceId.equals(p.getSibsReferenceId()));
    }

    public static Optional<PaymentReferenceCode> findUniqueBySibsReferenceId(String sibsReferenceId) {
        return PaymentReferenceCode.findBySibsReferenceId(sibsReferenceId).findFirst();
    }

    public static Stream<PaymentReferenceCode> findBySibsMerchantTransactionId(String sibsMerchantTransactionId) {
        return PaymentReferenceCode.findAll().filter(p -> !StringUtils.isEmpty((String)p.getSibsMerchantTransactionId())).filter(p -> sibsMerchantTransactionId.equals(p.getSibsMerchantTransactionId()));
    }

    public static Optional<PaymentReferenceCode> findUniqueBySibsMerchantTransactionId(String sibsMerchantTransactionId) {
        return PaymentReferenceCode.findBySibsMerchantTransactionId(sibsMerchantTransactionId).findFirst();
    }

    public String getFormattedCode() {
        StringBuilder result = new StringBuilder();
        int i = 1;
        for (char character : this.getReferenceCode().toCharArray()) {
            result.append(character);
            if (i % 3 == 0) {
                result.append(" ");
            }
            ++i;
        }
        return result.charAt(result.length() - 1) == ' ' ? result.deleteCharAt(result.length() - 1).toString() : result.toString();
    }

    public void setReferenceCode(String code) {
        super.setReferenceCode(code);
    }

    public void bruteForceSetReferenceCode(String string) {
        Object object = advice$bruteForceSetReferenceCode.perform((Callable)new PaymentReferenceCode$callable$bruteForceSetReferenceCode(this, string));
    }

    static /* synthetic */ void advised$bruteForceSetReferenceCode(PaymentReferenceCode this_, String code) {
        super.setReferenceCode(code);
    }

    public void setState(PaymentReferenceCodeStateType paymentReferenceCodeStateType) {
        Object object = advice$setState.perform((Callable)new PaymentReferenceCode$callable$setState(this, paymentReferenceCodeStateType));
    }

    static /* synthetic */ void advised$setState(PaymentReferenceCode this_, PaymentReferenceCodeStateType state) {
        super.setState(state);
    }

    public boolean isNew() {
        return this.getState() == PaymentReferenceCodeStateType.UNUSED;
    }

    protected void reuseCode() {
        this.setState(PaymentReferenceCodeStateType.UNUSED);
    }

    public boolean isUsed() {
        return this.getState() == PaymentReferenceCodeStateType.USED;
    }

    public boolean isAnnulled() {
        return this.getState() == PaymentReferenceCodeStateType.ANNULLED;
    }

    public boolean isProcessed() {
        return this.getState() == PaymentReferenceCodeStateType.PROCESSED;
    }

    public void anull() {
        this.setState(PaymentReferenceCodeStateType.ANNULLED);
    }

    public boolean isFixedAmount() {
        return this.getPaymentCodePool().getIsFixedAmount();
    }

    public boolean isAvailableForReuse() {
        return !this.isNew();
    }

    public void update(LocalDate startDate, LocalDate endDate, BigDecimal minAmount, BigDecimal maxAmount) {
        super.setBeginDate(startDate);
        super.setEndDate(endDate);
        super.setMinAmount(minAmount);
        super.setMaxAmount(maxAmount != null ? maxAmount : SIBS_IGNORE_MAX_AMOUNT);
        this.checkRules();
    }

    public Set<SettlementNote> processPayment(String string, BigDecimal bigDecimal, DateTime dateTime, String string2, String string3, DateTime dateTime2, SibsReportFile sibsReportFile, boolean bl) {
        return (Set)advice$processPayment.perform((Callable)new PaymentReferenceCode$callable$processPayment(this, string, bigDecimal, dateTime, string2, string3, dateTime2, sibsReportFile, bl));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ Set advised$processPayment(PaymentReferenceCode this_, String responsibleUsername, BigDecimal amountToPay, DateTime paymentDate, String sibsTransactionId, String comments, DateTime whenProcessedBySibs, SibsReportFile sibsReportFile, boolean checkSibsTransactionIdDuplication) {
        if (!this_.isNew() && SibsTransactionDetail.isReferenceProcessingDuplicate(this_.getReferenceCode(), this_.getPaymentCodePool().getEntityReferenceCode(), paymentDate)) {
            return null;
        }
        if (checkSibsTransactionIdDuplication && SibsTransactionDetail.isSibsOppwaReferenceProcessingDuplicate(sibsTransactionId)) {
            throw new RuntimeException("Duplicate transaction id: " + sibsTransactionId);
        }
        Set<SettlementNote> noteSet = this_.getTargetPayment().processPayment(responsibleUsername, amountToPay, paymentDate, sibsTransactionId, comments);
        DebtAccount referenceDebtAccount = this_.getTargetPayment().getDebtAccount();
        String debtAccountId = referenceDebtAccount.getExternalId();
        String customerId = referenceDebtAccount.getCustomer().getExternalId();
        String businessIdentification = referenceDebtAccount.getCustomer().getBusinessIdentification();
        String fiscalNumber = this_.valueOrEmpty(referenceDebtAccount.getCustomer().getAddressCountryCode()) + ":" + this_.valueOrEmpty(referenceDebtAccount.getCustomer().getFiscalNumber());
        String customerName = referenceDebtAccount.getCustomer().getName();
        for (SettlementNote settlementNote : noteSet) {
            String settlementDocumentNumber = settlementNote.getUiDocumentNumber();
            SibsTransactionDetail sibsTransactionDetail = SibsTransactionDetail.create(sibsReportFile, comments, whenProcessedBySibs, paymentDate, amountToPay, this_.getPaymentCodePool().getEntityReferenceCode(), this_.getReferenceCode(), sibsTransactionId, debtAccountId, customerId, businessIdentification, fiscalNumber, customerName, settlementDocumentNumber);
        }
        return noteSet;
    }

    public void processPaymentReferenceCodeTransaction(SibsOnlinePaymentsGatewayLog sibsOnlinePaymentsGatewayLog, PaymentStateBean paymentStateBean) {
        Object object = advice$processPaymentReferenceCodeTransaction.perform((Callable)new PaymentReferenceCode$callable$processPaymentReferenceCodeTransaction(this, sibsOnlinePaymentsGatewayLog, paymentStateBean));
    }

    static /* synthetic */ void advised$processPaymentReferenceCodeTransaction(PaymentReferenceCode this_, SibsOnlinePaymentsGatewayLog log2, PaymentStateBean bean) {
        if (!bean.getMerchantTransactionId().equals(this_.getSibsMerchantTransactionId())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.merchantTransactionId.not.equal", new String[0]);
        }
        FenixFramework.atomic(() -> {
            SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway = this.getPaymentCodePool().getSibsOnlinePaymentsGateway();
            DebtAccount debtAccount = this.getTargetPayment().getDebtAccount();
            log2.associateSibsOnlinePaymentGatewayAndDebtAccount(sibsOnlinePaymentsGateway, debtAccount);
            log2.setPaymentCode(this.getReferenceCode());
        });
        BigDecimal amount = bean.getAmount();
        DateTime paymentDate = bean.getPaymentDate();
        FenixFramework.atomic(() -> log2.savePaymentInfo(amount, paymentDate));
        if (amount == null || !TreasuryConstants.isPositive(amount)) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.invalid.amount", new String[0]);
        }
        if (paymentDate == null) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.invalid.payment.date", new String[0]);
        }
        if (SibsTransactionDetail.isReferenceProcessingDuplicate(this_.getReferenceCode(), this_.getPaymentCodePool().getEntityReferenceCode(), paymentDate)) {
            FenixFramework.atomic(() -> log2.markAsDuplicatedTransaction());
        } else if (SibsTransactionDetail.isSibsOppwaReferenceProcessingDuplicate(bean.getTransactionId())) {
            FenixFramework.atomic(() -> log2.markAsDuplicatedTransaction());
        } else {
            String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
            Set<SettlementNote> settlementNotes = this_.processPayment(StringUtils.isNotEmpty((String)loggedUsername) ? loggedUsername : "unknown", amount, paymentDate, bean.getTransactionId(), bean.getMerchantTransactionId(), new DateTime(), null, true);
            FenixFramework.atomic(() -> log2.markSettlementNotesCreated(settlementNotes));
        }
    }

    public String getDescription() {
        return this.getPaymentCodePool().getEntityReferenceCode() + " " + this.getReferenceCode();
    }

    public static PaymentReferenceCode readByCode(String code, FinantialInstitution finantialInstitution) {
        PaymentCodePool pool;
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        PaymentReferenceCode paymentReferenceCode = null;
        Iterator iterator = finantialInstitution.getPaymentCodePoolsSet().iterator();
        while (iterator.hasNext() && (paymentReferenceCode = (PaymentReferenceCode)(pool = (PaymentCodePool)((Object)iterator.next())).getPaymentReferenceCodesSet().stream().filter(y -> y.getReferenceCode().equals(code)).findFirst().orElse(null)) == null) {
        }
        return paymentReferenceCode;
    }

    public String getReferenceCodeWithoutCheckDigits() {
        if (Boolean.TRUE.equals(this.getPaymentCodePool().getUseCheckDigit())) {
            if (this.getReferenceCode().length() >= 2) {
                return this.getReferenceCode().substring(0, this.getReferenceCode().length() - 2);
            }
            return this.getReferenceCode();
        }
        throw new TreasuryDomainException("error.PaymentReferenceCode.not.from.pool.with.checkdigit", new String[0]);
    }

    public SibsReportFile getReportOnDate(DateTime transactionWhenRegistered) {
        return this.getReportedInFilesSet().stream().filter(x -> x.getWhenProcessedBySibs().equals((Object)transactionWhenRegistered)).findFirst().orElse(null);
    }

    public void createPaymentTargetTo(FinantialDocument finantialDocument) {
        Object object = advice$createPaymentTargetTo.perform((Callable)new PaymentReferenceCode$callable$createPaymentTargetTo(this, finantialDocument));
    }

    static /* synthetic */ void advised$createPaymentTargetTo(PaymentReferenceCode this_, FinantialDocument finantialDocument) {
        if (this_.getTargetPayment() != null && Boolean.TRUE.equals(this_.getTargetPayment().getValid())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.payment.target.already.exists", new String[0]);
        }
        FinantialDocumentPaymentCode targetToFinantialDocument = FinantialDocumentPaymentCode.create(finantialDocument, this_, true);
        this_.setTargetPayment((PaymentCodeTarget)((Object)targetToFinantialDocument));
        this_.setState(PaymentReferenceCodeStateType.USED);
        this_.setPayableAmount(finantialDocument.getOpenAmount());
        this_.checkRules();
    }

    public void createPaymentTargetTo(Set<DebitEntry> set, Set<Installment> set2, BigDecimal bigDecimal) {
        Object object = advice$createPaymentTargetTo$1.perform((Callable)new PaymentReferenceCode$callable$createPaymentTargetTo$1(this, set, set2, bigDecimal));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$createPaymentTargetTo(PaymentReferenceCode this_, Set debitNoteEntries, Set installments, BigDecimal payableAmount) {
        if (this_.getTargetPayment() != null && Boolean.TRUE.equals(this_.getTargetPayment().getValid())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.payment.target.already.exists", new String[0]);
        }
        MultipleEntriesPaymentCode target = MultipleEntriesPaymentCode.create(debitNoteEntries, installments, this_, true);
        this_.setTargetPayment((PaymentCodeTarget)((Object)target));
        this_.setState(PaymentReferenceCodeStateType.USED);
        this_.setPayableAmount(payableAmount);
        this_.checkRules();
    }

    public void anullPaymentReferenceCode() {
        Object object = advice$anullPaymentReferenceCode.perform((Callable)new PaymentReferenceCode$callable$anullPaymentReferenceCode(this));
    }

    static /* synthetic */ void advised$anullPaymentReferenceCode(PaymentReferenceCode this_) {
        if (PaymentReferenceCodeStateType.PROCESSED == this_.getState()) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.anullPaymentReferenceCode.cannot.anull.processed.references", new String[0]);
        }
        if (!this_.getState().equals(PaymentReferenceCodeStateType.ANNULLED)) {
            this_.setState(PaymentReferenceCodeStateType.ANNULLED);
        }
        this_.checkRules();
    }

    private String valueOrEmpty(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return "";
        }
        return value;
    }

    @Deprecated
    public static PaymentReferenceCode createPaymentReferenceCodeForMultipleDebitEntries(DebtAccount debtAccount, PaymentReferenceCodeBean paymentReferenceCodeBean) {
        return (PaymentReferenceCode)((Object)advice$createPaymentReferenceCodeForMultipleDebitEntries.perform((Callable)new PaymentReferenceCode$callable$createPaymentReferenceCodeForMultipleDebitEntries(debtAccount, paymentReferenceCodeBean)));
    }

    static /* synthetic */ PaymentReferenceCode advised$createPaymentReferenceCodeForMultipleDebitEntries(DebtAccount debtAccount, PaymentReferenceCodeBean bean) {
        throw new RuntimeException("deprecated");
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$bruteForceSetReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$setState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$processPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$processPaymentReferenceCodeTransaction = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$createPaymentTargetTo = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createPaymentTargetTo$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$anullPaymentReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createPaymentReferenceCodeForMultipleDebitEntries = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        SIBS_IGNORE_MAX_AMOUNT = BigDecimal.ZERO;
    }
}

