/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibs;

import java.math.BigDecimal;
import org.fenixedu.treasury.domain.paymentcodes.SibsReferenceCode;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationFileDTO;
import org.fenixedu.treasury.services.payments.sibs.SIBSPaymentsImporter;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFileDetailLine;
import org.joda.time.DateTime;

public class SIBSImportationLineDTO {
    protected SibsIncommingPaymentFileDetailLine line;
    protected SibsReferenceCode paymentCode;
    private SIBSImportationFileDTO sibsImportationFileDTO;

    public SIBSImportationLineDTO(SIBSImportationFileDTO sibsImportationFileDTO, SibsIncommingPaymentFileDetailLine line) {
        this.line = line;
        this.paymentCode = SIBSPaymentsImporter.getPaymentCode(sibsImportationFileDTO.getSibsEntityCode(), line.getCode());
        this.setSibsImportationFileDTO(sibsImportationFileDTO);
    }

    public DateTime getWhenProcessedBySibs() {
        return this.getSibsImportationFileDTO().getWhenProcessedBySibs();
    }

    public String getFilename() {
        return this.getSibsImportationFileDTO().getFilename();
    }

    public BigDecimal getTransactionsTotalAmount() {
        return this.getSibsImportationFileDTO().getTransactionsTotalAmount();
    }

    public BigDecimal getTotalCost() {
        return this.getSibsImportationFileDTO().getTotalCost();
    }

    public Integer getFileVersion() {
        return this.getSibsImportationFileDTO().getFileVersion();
    }

    public String getSibsTransactionId() {
        return this.line.getSibsTransactionId();
    }

    public BigDecimal getTransactionTotalAmount() {
        return this.line.getAmount();
    }

    public DateTime getTransactionWhenRegistered() {
        return this.line.getWhenOccuredTransaction();
    }

    public String getCode() {
        return this.line.getCode();
    }

    public String getPersonName() {
        if (this.paymentCode == null || this.paymentCode.getSibsPaymentRequest() == null) {
            return null;
        }
        return this.paymentCode.getSibsPaymentRequest().getDebtAccount().getCustomer().getName();
    }

    public String getStudentNumber() {
        if (this.paymentCode == null || this.paymentCode.getSibsPaymentRequest() == null) {
            return null;
        }
        return this.paymentCode.getSibsPaymentRequest().getDebtAccount().getCustomer().getBusinessIdentification();
    }

    public String getDescription() {
        if (this.paymentCode == null || this.paymentCode.getSibsPaymentRequest() == null) {
            return null;
        }
        return this.paymentCode.getSibsPaymentRequest().getDescription();
    }

    public SIBSImportationFileDTO getSibsImportationFileDTO() {
        return this.sibsImportationFileDTO;
    }

    public void setSibsImportationFileDTO(SIBSImportationFileDTO sibsImportationFileDTO) {
        this.sibsImportationFileDTO = sibsImportationFileDTO;
    }
}

