/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.sibspay;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.payments.IMbwayPaymentPlatformService;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.sibspay.MbwayMandate$callable$scheduleMbwayPayment;
import org.fenixedu.treasury.domain.sibspay.MbwayMandate$callable$scheduleNextPaymentForMandate;
import org.fenixedu.treasury.domain.sibspay.MbwayMandatePaymentSchedule;
import org.fenixedu.treasury.domain.sibspay.MbwayMandateState;
import org.fenixedu.treasury.domain.sibspay.MbwayMandate_Base;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MbwayMandate
extends MbwayMandate_Base {
    public static final Advice advice$scheduleNextPaymentForMandate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$scheduleMbwayPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public MbwayMandate() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setState(MbwayMandateState.CREATED);
        this.setRequestDate(new DateTime());
    }

    protected MbwayMandate(DigitalPaymentPlatform digitalPaymentPlatform, DebtAccount debtAccount, String merchantTransactionId, String countryPrefix, String localPhoneNumber) {
        this();
        this.setDigitalPaymentPlatform(digitalPaymentPlatform);
        this.setDebtAccount(debtAccount);
        this.setMerchantTransactionId(merchantTransactionId);
        this.setCountryPrefix(countryPrefix);
        this.setLocalPhoneNumber(localPhoneNumber);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.MbwayMandate.domainRoot.required", new String[0]);
        }
        if (this.getDigitalPaymentPlatform() == null) {
            throw new TreasuryDomainException("error.MbwayMandate.digitalPaymentPlatform.required", new String[0]);
        }
        if (this.getDebtAccount() == null) {
            throw new TreasuryDomainException("error.MbwayMandate.debtAccount.required", new String[0]);
        }
        if (this.getState() == null) {
            throw new TreasuryDomainException("error.MbwayMandate.state.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getCountryPrefix())) {
            throw new TreasuryDomainException("error.MbwayMandate.countryPrefix.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getLocalPhoneNumber())) {
            throw new TreasuryDomainException("error.MbwayMandate.localPhoneNumber.required", new String[0]);
        }
        if (this.getState().isWaitingAuthorization() || this.getState().isSuspended()) {
            if (StringUtils.isEmpty((String)this.getMandateId())) {
                throw new TreasuryDomainException("error.MbwayMandate.mandateId.required", new String[0]);
            }
            if (StringUtils.isEmpty((String)this.getTransactionId())) {
                throw new TreasuryDomainException("error.MbwayMandate.transactionId.required", new String[0]);
            }
        }
    }

    public boolean isMandateProcessActiveInPaymentPlatform() {
        return this.getState().isActive() || this.getState().isSuspended();
    }

    public void waitAuthorization(String mandateId, String transactionId) {
        this.setUpdateDate(new DateTime());
        this.setState(MbwayMandateState.WAITING_AUTHORIZATION);
        this.setMandateId(mandateId);
        this.setTransactionId(transactionId);
        this.checkRules();
    }

    public void authorize() {
        this.setUpdateDate(new DateTime());
        this.setState(MbwayMandateState.ACTIVE);
        this.setAuthorizationDate(new DateTime());
        this.checkRules();
    }

    public void reactivate() {
        this.setUpdateDate(new DateTime());
        if (!this.getState().isSuspended()) {
            throw new IllegalStateException("mandate should in suspended state, in order to be to be reactivated");
        }
        this.setState(MbwayMandateState.ACTIVE);
        this.checkRules();
    }

    public void markAsNotAuthorized(String reason) {
        this.setUpdateDate(new DateTime());
        this.setState(MbwayMandateState.NOT_AUTHORIZED);
        this.setAuthorizationDate(new DateTime());
        this.setCancelReason(reason);
        this.setCancelResponsible(TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername());
        this.checkRules();
    }

    public void cancel(String reason) {
        if (this.getState().isCanceled()) {
            throw new IllegalStateException("error.MbwayMandate.cancel.already.canceled");
        }
        this.setUpdateDate(new DateTime());
        this.setState(MbwayMandateState.CANCELED);
        this.setCancelReason(reason);
        this.setCancelResponsible(TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername());
        this.getMbwayMandatePaymentSchedulesSet().stream().filter(s -> s.isInProgress()).forEach(s -> s.cancel(reason));
        this.checkRules();
    }

    public void expire() {
        this.setUpdateDate(new DateTime());
        this.setState(MbwayMandateState.EXPIRED);
        this.checkRules();
    }

    public void suspend() {
        this.setUpdateDate(new DateTime());
        this.setState(MbwayMandateState.SUSPENDED);
        this.checkRules();
    }

    public void updatePlafondAndExpirationDate(BigDecimal newPlafond, LocalDate expirationDate) {
        this.setUpdateDate(new DateTime());
        this.setPlafond(newPlafond);
        this.setExpirationDate(expirationDate);
        this.checkRules();
    }

    public void scheduleForCancellationInPlatform() {
        this.setPendingMbwayMandateCancellationPlatform(this.getDigitalPaymentPlatform());
    }

    public void clearScheduledCancellationInPlatform() {
        this.setPendingMbwayMandateCancellationPlatform(null);
    }

    public Set<MbwayMandatePaymentSchedule> scheduleNextPaymentForMandate(LocalDate localDate) {
        return (Set)advice$scheduleNextPaymentForMandate.perform((Callable)new MbwayMandate$callable$scheduleNextPaymentForMandate(this, localDate));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ Set advised$scheduleNextPaymentForMandate(MbwayMandate this_, LocalDate dateToCheckAgainstDueDate) {
        FinantialEntity finantialEntity = this_.getDigitalPaymentPlatform().getFinantialEntity();
        IMbwayPaymentPlatformService service = this_.getDigitalPaymentPlatform().castToMbwayPaymentPlatformService();
        Set resultValue = this_.getPossibleDebitEntriesToCharge(dateToCheckAgainstDueDate).map(this_::scheduleMbwayPayment).collect(Collectors.toSet());
        return resultValue;
    }

    private Stream<DebitEntry> getPossibleDebitEntriesToCharge(LocalDate dateToCheckAgainstDueDate) {
        FinantialEntity finantialEntity = this.getDigitalPaymentPlatform().getFinantialEntity();
        IMbwayPaymentPlatformService service = this.getDigitalPaymentPlatform().castToMbwayPaymentPlatformService();
        return this.getDebtAccount().getPendingInvoiceEntriesSet().stream().filter(i -> i.getFinantialEntity() == finantialEntity).filter(i -> i.isDebitNoteEntry()).filter(i -> i.getDebtAccount().getCustomer().isActive()).filter(i -> service.getMbwayMandatePossibleProductsToChargeSet().contains((Object)i.getProduct())).map(DebitEntry.class::cast).filter(this::isToBePaidByDebtAccountOwner).filter(d -> d.getDueDate().isEqual((ReadablePartial)dateToCheckAgainstDueDate.plusDays(service.getMbwayMandateDaysToScheduleDebts()))).filter(d -> d.getMbwayMandatePaymentScheduleSet().stream().allMatch(schedule -> schedule.isCanceled() || schedule.getState().isTransferred()));
    }

    private MbwayMandatePaymentSchedule scheduleMbwayPayment(DebitEntry debitEntry) {
        return (MbwayMandatePaymentSchedule)((Object)advice$scheduleMbwayPayment.perform((Callable)new MbwayMandate$callable$scheduleMbwayPayment(this, debitEntry)));
    }

    static /* synthetic */ MbwayMandatePaymentSchedule advised$scheduleMbwayPayment(MbwayMandate this_, DebitEntry debitEntry) {
        IMbwayPaymentPlatformService service = this_.getDigitalPaymentPlatform().castToMbwayPaymentPlatformService();
        LocalDate minimumDayToSendEmail = this_.getMinimumDateToSendNotification(debitEntry, service);
        LocalDate minimumDayToCharge = this_.getMinimumDateToChargePayment(debitEntry, service);
        MbwayMandatePaymentSchedule schedule = MbwayMandatePaymentSchedule.create(this_, minimumDayToSendEmail, minimumDayToCharge, Set.of(debitEntry), Set.of());
        return schedule;
    }

    private LocalDate getMinimumDateToChargePayment(DebitEntry debitEntry, IMbwayPaymentPlatformService service) {
        LocalDate result = debitEntry.getDueDate().minusDays(service.getMbwayMandateDaysToChargePayment());
        return result;
    }

    private LocalDate getMinimumDateToSendNotification(DebitEntry debitEntry, IMbwayPaymentPlatformService service) {
        LocalDate result = debitEntry.getDueDate().minusDays(service.getMbwayMandateDaysToSendNotification());
        return result;
    }

    private boolean isToBePaidByDebtAccountOwner(DebitEntry debitEntry) {
        return debitEntry.getFinantialDocument() == null || debitEntry.getDebitNote().getPayorDebtAccount() == null;
    }

    public boolean isPossibleToSchedulePayment() {
        return this.isMandateProcessActiveInPaymentPlatform();
    }

    public void transferMandateToOtherDebtAccount(DebtAccount destinyDebtAccount, Map<DebitEntry, DebitEntry> debitEntriesTransferMap, Map<Installment, Installment> installmentsTransferMap) {
        MbwayMandate newMandate = new MbwayMandate(this.getDigitalPaymentPlatform(), destinyDebtAccount, this.getMerchantTransactionId(), this.getCountryPrefix(), this.getLocalPhoneNumber());
        newMandate.setState(this.getState());
        newMandate.setRequestDate(this.getRequestDate());
        newMandate.setUpdateDate(this.getUpdateDate());
        newMandate.setAuthorizationDate(this.getAuthorizationDate());
        newMandate.setMandateId(this.getMandateId());
        newMandate.setTransactionId(this.getTransactionId());
        newMandate.setPlafond(this.getPlafond());
        newMandate.setExpirationDate(this.getExpirationDate());
        this.setState(MbwayMandateState.TRANSFERRED);
        this.setUpdateDate(new DateTime());
        this.getMbwayMandatePaymentSchedulesSet().stream().filter(s -> s.isInProgress()).forEach(s -> s.transferScheduleToOtherDebtAccount(newMandate, debitEntriesTransferMap, installmentsTransferMap));
        this.checkRules();
        newMandate.checkRules();
    }

    public BigDecimal getRemainingPlafondForMonthAndYear(LocalDate when) {
        BigDecimal remainingPlafond = this.getPlafond();
        BigDecimal paidWithMbwayTotalAmount = this.getMbwayMandatePaymentSchedulesSet().stream().flatMap(s -> s.getMbwayRequestsSet().stream()).filter(p -> p.getState().isProcessed()).filter(p -> p.getRequestDate().getYear() == when.getYear() && p.getRequestDate().getMonthOfYear() == when.getMonthOfYear()).flatMap(p -> p.getPaymentTransactionsSet().stream()).flatMap(t -> t.getSettlementNotesSet().stream()).filter(s -> s.isClosed()).flatMap(s -> s.getPaymentEntriesSet().stream()).filter(p -> p.getPaymentMethod() == TreasurySettings.getInstance().getMbWayPaymentMethod()).map(p -> p.getPayedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        remainingPlafond = remainingPlafond.subtract(paidWithMbwayTotalAmount);
        return remainingPlafond;
    }

    public BigDecimal getAmountScheduledToBeCharged(LocalDate when) {
        IMbwayPaymentPlatformService service = this.getDigitalPaymentPlatform().castToMbwayPaymentPlatformService();
        BigDecimal scheduleAmountToCharge = this.getMbwayMandatePaymentSchedulesSet().stream().filter(s -> s.isInProgress()).filter(s -> s.getPaymentChargeDate().getMonthOfYear() == when.getMonthOfYear() && s.getPaymentChargeDate().getYear() == when.getYear()).map(s -> s.getOpenAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        return scheduleAmountToCharge;
    }

    public static MbwayMandate create(DigitalPaymentPlatform digitalPaymentPlatform, DebtAccount debtAccount, String merchantTransactionId, String countryPrefix, String localPhoneNumber) {
        Stream<MbwayMandate> allMandatesActiveOrToBeActivated = MbwayMandate.findAllFromCustomer(debtAccount.getCustomer(), digitalPaymentPlatform.getFinantialInstitution()).filter(m -> m.getState().isCreated() || m.getState().isWaitingAuthorization() || m.isMandateProcessActiveInPaymentPlatform());
        if (allMandatesActiveOrToBeActivated.count() > 0L) {
            throw new TreasuryDomainException("error.MbwayMandate.create.customer.already.has.mandate.alive", new String[0]);
        }
        if (!digitalPaymentPlatform.castToMbwayPaymentPlatformService().isMbwayAuthorizedPaymentsActive()) {
            throw new TreasuryDomainException("error.MbwayMandate.create.platform.not.active", new String[0]);
        }
        return new MbwayMandate(digitalPaymentPlatform, debtAccount, merchantTransactionId, countryPrefix, localPhoneNumber);
    }

    public static Stream<MbwayMandate> findAll() {
        return FenixFramework.getDomainRoot().getMbwayMandatesSet().stream();
    }

    public static Stream<MbwayMandate> find(DebtAccount debtAccount) {
        return debtAccount.getMbwayMandatesSet().stream();
    }

    public static Stream<MbwayMandate> findAllFromCustomer(Customer customer, FinantialInstitution finantialInstitution) {
        return customer.getAllCustomers().stream().map(c -> c.getDebtAccountFor(finantialInstitution)).flatMap(d -> d.getMbwayMandatesSet().stream());
    }

    public static Optional<MbwayMandate> findUniqueByMandateIdExcludingTransferred(String mandateId) {
        return FenixFramework.getDomainRoot().getMbwayMandatesSet().stream().filter(m -> mandateId.equals(m.getMandateId())).filter(m -> !m.getState().isTransferred()).findFirst();
    }
}

