/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.exemption;

import java.math.BigDecimal;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.CreditTreasuryExemption_Base;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.util.TreasuryConstants;
import pt.ist.fenixframework.FenixFramework;

public class CreditTreasuryExemption
extends CreditTreasuryExemption_Base {
    public CreditTreasuryExemption() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected CreditTreasuryExemption(CreditEntry creditEntry, TreasuryExemption treasuryExemption, BigDecimal creditedNetExemptedAmount) {
        this();
        this.setCreditEntry(creditEntry);
        this.setTreasuryExemption(treasuryExemption);
        this.setCreditedNetExemptedAmount(creditedNetExemptedAmount);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.CreditTreasuryExemption.domainRoot.required", new String[0]);
        }
        if (this.getCreditEntry() == null) {
            throw new TreasuryDomainException("error.CreditTreasuryExemption.creditEntry.required", new String[0]);
        }
        if (this.getTreasuryExemption() == null) {
            throw new TreasuryDomainException("error.CreditTreasuryExemption.treasuryExemption.required", new String[0]);
        }
        if (this.getTreasuryExemption().getCreditEntry() != null) {
            throw new TreasuryDomainException("error.CreditTreasuryExemption.treasuryExemption.from.closed.debitEntry.not.supported", new String[0]);
        }
        if (this.getCreditedNetExemptedAmount() == null) {
            throw new TreasuryDomainException("error.CreditTreasuryExemption.creditedNetExemptedAmount.required", new String[0]);
        }
        if (!TreasuryConstants.isPositive(this.getCreditedNetExemptedAmount()) || this.getCreditedNetExemptedAmount().scale() > 2) {
            throw new TreasuryDomainException("error.CreditTreasuryExemption.creditedNetExemptedAmount.invalid", new String[0]);
        }
        if (TreasuryConstants.isGreaterThan(this.getTreasuryExemption().getTotalCreditedNetExemptedAmount(), this.getTreasuryExemption().getNetExemptedAmount())) {
            throw new TreasuryDomainException("error.CreditTreasuryExemption.totalCreditedNetExemption.greater.than.treasuryExemption.netExemptedAmount", new String[0]);
        }
        if (this.getCreditEntry().getCreditTreasuryExemptionsSet().stream().anyMatch(cte -> cte != this && cte.getTreasuryExemption() == this.getTreasuryExemption())) {
            throw new TreasuryDomainException("error.CreditTreasuryExemption.duplicated", new String[0]);
        }
        if (this.getCreditEntry().getDebitEntry() != this.getTreasuryExemption().getDebitEntry()) {
            throw new TreasuryDomainException("error.CreditTreasuryExemption.debitEntry.mismatch", new String[0]);
        }
    }

    public void editCreditedNetExemptedAmount(BigDecimal newCreditedNetExemptedAmount) {
        if (this.getCreditEntry().isProcessedInClosedDebitNote()) {
            throw new RuntimeException("error.CreditTreasuryExemption.creditEntry.is.closed");
        }
        if (this.getCreditEntry().isAnnulled()) {
            throw new RuntimeException("error.CreditTreasuryExemption.creditEntry.is.annuled");
        }
        super.setCreditedNetExemptedAmount(newCreditedNetExemptedAmount);
        this.checkRules();
    }

    public static CreditTreasuryExemption create(CreditEntry creditEntry, TreasuryExemption treasuryExemption, BigDecimal creditedNetExemptedAmount) {
        return new CreditTreasuryExemption(creditEntry, treasuryExemption, creditedNetExemptedAmount);
    }

    public static CreditTreasuryExemption createForImportation(CreditEntry creditEntry, TreasuryExemption treasuryExemption, BigDecimal creditedNetExemptedAmount) {
        CreditTreasuryExemption result = new CreditTreasuryExemption();
        result.setCreditEntry(creditEntry);
        result.setTreasuryExemption(treasuryExemption);
        result.setCreditedNetExemptedAmount(creditedNetExemptedAmount);
        return result;
    }
}

