/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.payments.integration;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.StandardSibsPaymentExpiryStrategy_Base;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class StandardSibsPaymentExpiryStrategy
extends StandardSibsPaymentExpiryStrategy_Base {
    public StandardSibsPaymentExpiryStrategy() {
    }

    public StandardSibsPaymentExpiryStrategy(DigitalPaymentPlatform digitalPaymentPlatform) {
        this();
        super.init(digitalPaymentPlatform);
        this.setUseEntriesMaximumDueDate(false);
        this.setMinimumExpiryDaysFromRequestDate(0);
        this.setMaximumExpiryDaysFromRequestDate(7);
        this.checkRules();
    }

    protected void checkRules() {
        super.checkRules();
    }

    public LocalDate calculateSibsPaymentRequestExpiryDate(Set<DebitEntry> debitEntries, Set<Installment> installments, boolean limitSibsPaymentRequestToCustomDueDate, LocalDate customSibsPaymentRequestDueDate) {
        Days days;
        if (limitSibsPaymentRequestToCustomDueDate) {
            if (customSibsPaymentRequestDueDate == null) {
                throw new IllegalArgumentException("error.StandardSibsPaymentExpiryStrategy.customSibsPaymentRequestDueDate.required");
            }
            return customSibsPaymentRequestDueDate;
        }
        LocalDate validTo = null;
        HashSet dueDatesSet = new HashSet();
        debitEntries.stream().map(db -> db.getDueDate()).collect(Collectors.toCollection(() -> dueDatesSet));
        installments.stream().map(i -> i.getDueDate()).collect(Collectors.toCollection(() -> dueDatesSet));
        validTo = Boolean.TRUE.equals(this.getUseEntriesMaximumDueDate()) ? (LocalDate)dueDatesSet.stream().max((o1, o2) -> o1.compareTo((ReadablePartial)o2)).get() : (LocalDate)dueDatesSet.stream().min((o1, o2) -> o1.compareTo((ReadablePartial)o2)).get();
        if (validTo.isBefore((ReadablePartial)new LocalDate())) {
            validTo = new LocalDate();
        }
        if (this.getMinimumExpiryDaysFromRequestDate() != null && (days = Days.daysBetween((ReadablePartial)new LocalDate(), (ReadablePartial)validTo)).getDays() < this.getMinimumExpiryDaysFromRequestDate()) {
            validTo = validTo.plusDays(this.getMinimumExpiryDaysFromRequestDate() - days.getDays());
        }
        if (this.getMaximumExpiryDaysFromRequestDate() != null && (days = Days.daysBetween((ReadablePartial)new LocalDate(), (ReadablePartial)validTo)).getDays() > this.getMaximumExpiryDaysFromRequestDate()) {
            validTo = validTo.minusDays(days.getDays() - this.getMaximumExpiryDaysFromRequestDate());
        }
        return validTo;
    }
}

