/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.sibspay;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentCodeTransaction;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.SibsReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxTreasuryEvent;
import org.fenixedu.treasury.domain.payments.IMbwayPaymentPlatformService;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode;
import org.fenixedu.treasury.domain.payments.integration.StandardSibsPaymentExpiryStrategy;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.sibspay.SibsPayPlatform$callable$createForwardPaymentRequest;
import org.fenixedu.treasury.domain.sibspay.SibsPayPlatform$callable$createLogForSibsPaymentRequest;
import org.fenixedu.treasury.domain.sibspay.SibsPayPlatform$callable$createMbwayRequest;
import org.fenixedu.treasury.domain.sibspay.SibsPayPlatform$callable$createMbwayRequest$1;
import org.fenixedu.treasury.domain.sibspay.SibsPayPlatform$callable$postProcessPayment;
import org.fenixedu.treasury.domain.sibspay.SibsPayPlatform$callable$prepareCheckout;
import org.fenixedu.treasury.domain.sibspay.SibsPayPlatform$callable$saveExceptionLog;
import org.fenixedu.treasury.domain.sibspay.SibsPayPlatform_Base;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.PaymentPenaltyEntryBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.services.payments.sibspay.SibsPayAPIService;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayCancellationResponse;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayResponseInquiryWrapper;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayReturnCheckout;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayWebhookNotificationWrapper;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsPayPlatform
extends SibsPayPlatform_Base
implements ISibsPaymentCodePoolService,
IForwardPaymentPlatformService,
IMbwayPaymentPlatformService {
    public static final String CONTROLLER_URL = "/treasury/document/forwardpayments/sibspayplatform";
    private static final String RETURN_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/sibspayplatform/returnforwardpayment";
    public static final Advice advice$createMbwayRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$createMbwayRequest$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$createForwardPaymentRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$prepareCheckout = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$postProcessPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$saveExceptionLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createLogForSibsPaymentRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public SibsPayPlatform() {
        new StandardSibsPaymentExpiryStrategy((DigitalPaymentPlatform)((Object)this));
    }

    public SibsPayPlatform(FinantialInstitution finantialInstitution, FinantialEntity finantialEntity, String name, boolean active, String clientId, String bearerToken, Integer terminalId, String entityReferenceCode, String endpoint, String assetsEndpointUrl) {
        this();
        super.init(finantialInstitution, finantialEntity, name, active);
        super.setClientId(clientId);
        super.setTerminalId(terminalId);
        super.setBearerToken(bearerToken);
        super.setEntityReferenceCode(entityReferenceCode);
        super.setEndpointUrl(endpoint);
        super.setAssetsEndpointUrl(assetsEndpointUrl);
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getCreditCardPaymentMethod());
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getMbPaymentMethod());
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getMbWayPaymentMethod());
        this.checkRules();
    }

    @Override
    public PaymentTransaction processMbwayTransaction(PaymentRequestLog log2, DigitalPlatformResultBean bean) {
        MbwayRequest request = (MbwayRequest)((Object)log2.getPaymentRequest());
        if (!bean.getTransactionId().equals(request.getTransactionId())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.merchantTransactionId.not.equal", new String[0]);
        }
        BigDecimal paidAmount = bean.getAmount();
        DateTime paymentDate = bean.getPaymentDate() != null ? bean.getPaymentDate() : request.getRequestDate();
        FenixFramework.atomic(() -> {
            log2.savePaymentTypeAndBrand(bean.getPaymentType(), bean.getPaymentBrand());
            log2.savePaymentInfo(paidAmount, paymentDate);
        });
        if (paidAmount == null || !TreasuryConstants.isPositive(paidAmount)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.invalid.amount", new String[0]);
        }
        if (paymentDate == null) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.invalid.payment.date", new String[0]);
        }
        if (PaymentTransaction.isTransactionDuplicate(bean.getTransactionId())) {
            FenixFramework.atomic(() -> log2.markAsDuplicatedTransaction());
            return null;
        }
        try {
            return (PaymentTransaction)((Object)FenixFramework.atomic(() -> {
                Set<SettlementNote> settlementNotes = request.processPayment(paidAmount, paymentDate, bean.getTransactionId(), bean.getMerchantTransactionId());
                PaymentTransaction transaction = PaymentTransaction.create((PaymentRequest)((Object)((Object)((Object)request))), bean.getTransactionId(), paymentDate, paidAmount, settlementNotes);
                return transaction;
            }));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MbwayRequest createMbwayRequest(SettlementNoteBean settlementNoteBean, String string, String string2) {
        return (MbwayRequest)((Object)advice$createMbwayRequest.perform((Callable)new SibsPayPlatform$callable$createMbwayRequest(this, settlementNoteBean, string, string2)));
    }

    static /* synthetic */ MbwayRequest advised$createMbwayRequest(SibsPayPlatform this_, SettlementNoteBean settlementNoteBean, String countryPrefix, String localPhoneNumber) {
        DebtAccount debtAccount = settlementNoteBean.getDebtAccount();
        Set<DebitEntry> debitEntries = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.getInvoiceEntry() != null).map(s -> s.getInvoiceEntry()).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.isForInstallment()).map(InstallmentPaymenPlanBean.class::cast).map(s -> s.getInstallment()).collect(Collectors.toSet());
        return this_.createMbwayRequest(debtAccount, debitEntries, installments, countryPrefix, localPhoneNumber);
    }

    @Override
    public MbwayRequest createMbwayRequest(DebtAccount debtAccount, Set<DebitEntry> set, Set<Installment> set2, String string, String string2) {
        return (MbwayRequest)((Object)advice$createMbwayRequest$1.perform((Callable)new SibsPayPlatform$callable$createMbwayRequest$1(this, debtAccount, set, set2, string, string2)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ MbwayRequest advised$createMbwayRequest(SibsPayPlatform this_, DebtAccount debtAccount, Set debitEntries, Set installments, String countryPrefix, String localPhoneNumber) {
        Function<DebitEntry, BigDecimal> getExtraAmount = debitEntry -> {
            PaymentPenaltyEntryBean penaltyTax = PaymentPenaltyTaxTreasuryEvent.calculatePaymentPenaltyTax(debitEntry, LocalDate.now());
            BigDecimal penaltyTaxAmount = penaltyTax != null ? penaltyTax.getSettledAmount() : BigDecimal.ZERO;
            return debitEntry.getOpenAmountWithInterests().add(penaltyTaxAmount);
        };
        if (PaymentRequest.getReferencedCustomers(debitEntries, installments).size() > 1) {
            throw new TreasuryDomainException("error.PaymentRequest.referencedCustomers.only.one.allowed", new String[0]);
        }
        if (StringUtils.isEmpty((String)countryPrefix)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.countryPrefix.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)localPhoneNumber)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.required", new String[0]);
        }
        if (!countryPrefix.matches("\\d+")) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.countryPrefix.number.format.required", new String[0]);
        }
        if (!localPhoneNumber.matches("\\d+")) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.format.required", new String[0]);
        }
        String phoneNumber = String.format("%s#%s", countryPrefix, localPhoneNumber);
        BigDecimal payableAmountDebitEntries = debitEntries.stream().map(e -> (BigDecimal)getExtraAmount.apply((DebitEntry)((Object)e))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmountInstallments = installments.stream().map(i -> i.getOpenAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmount = payableAmountDebitEntries.add(payableAmountInstallments);
        String merchantTransactionId = this_.generateNewMerchantTransactionId();
        Optional<Object> transactionIdOptional = Optional.empty();
        Optional<Object> transactionSignatureOptional = Optional.empty();
        SibsPayAPIService sibsPayService = new SibsPayAPIService(this_.getEndpointUrl(), this_.getAssetsEndpointUrl(), this_.getClientId(), this_.getBearerToken(), this_.getTerminalId(), this_.getEntityReferenceCode());
        MbwayRequest mbwayRequest = MbwayRequest.create(this_, debtAccount, debitEntries, installments, phoneNumber, payableAmount, merchantTransactionId);
        PaymentRequestLog log2 = this_.log((PaymentRequest)((Object)mbwayRequest), "createMbwayRequest", null, null, null, null);
        try {
            DateTime requestSendDate = new DateTime();
            SibsPayReturnCheckout sibsPayReturnCheckout = sibsPayService.processSibsPaymentRequestOrMbwayCheckout(debtAccount, payableAmount, new DateTime(), new DateTime().plusMinutes(3), merchantTransactionId);
            DateTime requestReceiveDate = new DateTime();
            boolean isOperationSuccess = SibsPayAPIService.isOperationSuccess(sibsPayReturnCheckout.getReturnStatus().getStatusCode());
            FenixFramework.atomic(() -> {
                mbwayRequest.setTransactionId(sibsPayReturnCheckout.getTransactionID());
                log2.setRequestSendDate(requestSendDate);
                log2.setRequestReceiveDate(requestReceiveDate);
                log2.logRequestReceiveDateAndData(sibsPayReturnCheckout.getTransactionID(), isOperationSuccess, false, sibsPayReturnCheckout.getReturnStatus().getStatusCode(), sibsPayReturnCheckout.getReturnStatus().getStatusDescription());
                log2.saveRequest(sibsPayReturnCheckout.getRequestLog());
                log2.saveResponse(sibsPayReturnCheckout.getResponseLog());
            });
            if (!isOperationSuccess) {
                throw new TreasuryDomainException("error.MbwayPaymentRequest.request.in.gateway.failed", new String[0]);
            }
            transactionIdOptional = Optional.ofNullable(sibsPayReturnCheckout.getTransactionID());
            transactionSignatureOptional = Optional.ofNullable(sibsPayReturnCheckout.getTransactionSignature());
        }
        catch (Exception e2) {
            boolean isOnlinePaymentsGatewayException = e2 instanceof OnlinePaymentsGatewayCommunicationException;
            FenixFramework.atomic(() -> {
                mbwayRequest.anull();
                log2.logRequestReceiveDateAndData(null, false, false, null, null);
                log2.logException(e2);
                if (isOnlinePaymentsGatewayException) {
                    OnlinePaymentsGatewayCommunicationException onlineException = (OnlinePaymentsGatewayCommunicationException)((Object)((Object)e2));
                    log2.saveRequest(onlineException.getRequestLog());
                    log2.saveResponse(onlineException.getResponseLog());
                }
            });
            if (e2 instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)e2;
            }
            String message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor." + (isOnlinePaymentsGatewayException ? "gateway.communication" : "unknown");
            throw new TreasuryDomainException((Throwable)e2, message, new String[0]);
        }
        log2 = this_.log((PaymentRequest)((Object)mbwayRequest), "createMbwayRequest", null, null, null, null);
        try {
            if (transactionIdOptional.isEmpty() || StringUtils.isEmpty((String)((String)transactionIdOptional.get()))) {
                throw new TreasuryDomainException("error.SibsPayPlatform.transactionId.required.to.generate.reference", new String[0]);
            }
            if (transactionSignatureOptional.isEmpty() || StringUtils.isEmpty((String)((String)transactionSignatureOptional.get()))) {
                throw new TreasuryDomainException("error.SibsPayPlatform.transactionSignature.required.to.generate.mbway.request", new String[0]);
            }
            String transactionId = (String)transactionIdOptional.get();
            String transactionSignature = (String)transactionSignatureOptional.get();
            SibsPayResponseInquiryWrapper responseInquiryWrapper = sibsPayService.generateMbwayRequestTransaction(transactionId, transactionSignature, countryPrefix, localPhoneNumber);
            FenixFramework.atomic(() -> {
                log2.logRequestReceiveDateAndData(transactionId, responseInquiryWrapper.isOperationSuccess(), false, responseInquiryWrapper.getOperationStatusCode(), responseInquiryWrapper.getOperationStatusDescription());
                log2.saveRequest(responseInquiryWrapper.getRequestLog());
                log2.saveResponse(responseInquiryWrapper.getResponseLog());
            });
            if (!responseInquiryWrapper.isOperationSuccess()) {
                throw new TreasuryDomainException("error.MbwayPaymentRequest.request.in.gateway.failed", new String[0]);
            }
            return mbwayRequest;
        }
        catch (Exception e3) {
            boolean isOnlinePaymentsGatewayException = e3 instanceof OnlinePaymentsGatewayCommunicationException;
            FenixFramework.atomic(() -> {
                mbwayRequest.anull();
                log2.logRequestReceiveDateAndData(null, false, false, null, null);
                log2.logException(e3);
                if (isOnlinePaymentsGatewayException) {
                    OnlinePaymentsGatewayCommunicationException onlineException = (OnlinePaymentsGatewayCommunicationException)((Object)((Object)e3));
                    log2.saveRequest(onlineException.getRequestLog());
                    log2.saveResponse(onlineException.getResponseLog());
                }
            });
            if (e3 instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)e3;
            }
            String message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor." + (isOnlinePaymentsGatewayException ? "gateway.communication" : "unknown");
            throw new TreasuryDomainException((Throwable)e3, message, new String[0]);
        }
    }

    @Override
    public ForwardPaymentRequest createForwardPaymentRequest(SettlementNoteBean settlementNoteBean, Function<ForwardPaymentRequest, String> function, Function<ForwardPaymentRequest, String> function2) {
        return (ForwardPaymentRequest)((Object)advice$createForwardPaymentRequest.perform((Callable)new SibsPayPlatform$callable$createForwardPaymentRequest(this, settlementNoteBean, function, function2)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ ForwardPaymentRequest advised$createForwardPaymentRequest(SibsPayPlatform this_, SettlementNoteBean bean, Function successUrlFunction, Function insuccessUrlFunction) {
        Set debitEntries = bean.getIncludedInvoiceEntryBeans().stream().map(ISettlementInvoiceEntryBean::getInvoiceEntry).filter(i -> i != null).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set installments = bean.getIncludedInvoiceEntryBeans().stream().filter(i -> i instanceof InstallmentPaymenPlanBean && i.isIncluded()).map(InstallmentPaymenPlanBean.class::cast).map(ib -> ib.getInstallment()).collect(Collectors.toSet());
        ForwardPaymentRequest forwardPayment = null;
        try {
            forwardPayment = (ForwardPaymentRequest)((Object)FenixFramework.atomic(() -> ForwardPaymentRequest.create(bean.getDigitalPaymentPlatform(), bean.getDebtAccount(), debitEntries, installments, bean.getTotalAmountToPay(), successUrlFunction, insuccessUrlFunction)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this_.prepareCheckout(bean, forwardPayment);
        return forwardPayment;
    }

    public void prepareCheckout(SettlementNoteBean settlementNoteBean, ForwardPaymentRequest forwardPaymentRequest) {
        Object object = advice$prepareCheckout.perform((Callable)new SibsPayPlatform$callable$prepareCheckout(this, settlementNoteBean, forwardPaymentRequest));
    }

    static /* synthetic */ void advised$prepareCheckout(SibsPayPlatform this_, SettlementNoteBean bean, ForwardPaymentRequest forwardPayment) {
        String merchantTransactionId = this_.generateNewMerchantTransactionId();
        FenixFramework.atomic(() -> {
            if (!StringUtils.isEmpty((String)forwardPayment.getMerchantTransactionId())) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.sibsMerchantTransactionId.already.filled", new String[0]);
            }
            forwardPayment.setMerchantTransactionId(merchantTransactionId);
        });
        try {
            DateTime requestSendDate = new DateTime();
            SibsPayAPIService sibsPayService = new SibsPayAPIService(this_.getEndpointUrl(), this_.getAssetsEndpointUrl(), this_.getClientId(), this_.getBearerToken(), this_.getTerminalId(), this_.getEntityReferenceCode());
            SibsPayReturnCheckout returnCheckout = sibsPayService.processForwardPaymentCheckout(forwardPayment, bean.getAddressBean());
            DateTime requestReceiveDate = new DateTime();
            boolean isOperationSuccess = SibsPayAPIService.isOperationSuccess(returnCheckout.getReturnStatus().getStatusCode());
            ForwardPaymentStateType stateType = isOperationSuccess ? ForwardPaymentStateType.REQUESTED : ForwardPaymentStateType.REJECTED;
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(isOperationSuccess, stateType, returnCheckout.getReturnStatus().getStatusCode(), returnCheckout.getReturnStatus().getStatusDescription(), returnCheckout.getRequestLog(), returnCheckout.getResponseLog());
            FenixFramework.atomic(() -> {
                forwardPayment.setTransactionId(returnCheckout.getTransactionID());
                forwardPayment.setFormContext(returnCheckout.getFormContext());
                PaymentRequestLog log2 = this.log((PaymentRequest)((Object)((Object)((Object)forwardPayment))), "createForwardPaymentRequest", result.getStatusCode(), result.getStatusMessage(), result.getRequestBody(), result.getResponseBody());
                log2.setInternalMerchantTransactionId(forwardPayment.getMerchantTransactionId());
                log2.setExternalTransactionId(forwardPayment.getTransactionId());
                log2.setRequestSendDate(requestSendDate);
                log2.setRequestReceiveDate(requestReceiveDate);
                log2.setOperationSuccess(result.isOperationSuccess());
                if (result.getStateType() == ForwardPaymentStateType.REQUESTED) {
                    forwardPayment.advanceToRequestState();
                } else {
                    forwardPayment.reject();
                }
            });
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                this.logException((PaymentRequest)((Object)((Object)((Object)forwardPayment))), e, "createForwardPaymentRequest", "error", "error", requestBody, responseBody);
                forwardPayment.reject();
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    @Override
    public PostProcessPaymentStatusBean postProcessPayment(ForwardPaymentRequest forwardPaymentRequest, String string, Optional<String> optional) {
        return (PostProcessPaymentStatusBean)advice$postProcessPayment.perform((Callable)new SibsPayPlatform$callable$postProcessPayment(this, forwardPaymentRequest, string, optional));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ PostProcessPaymentStatusBean advised$postProcessPayment(SibsPayPlatform this_, ForwardPaymentRequest forwardPayment, String justification, Optional specificTransactionId) {
        if (specificTransactionId.isEmpty()) {
            return null;
        }
        try {
            SibsPayAPIService sibsPayService = new SibsPayAPIService(this_.getEndpointUrl(), this_.getAssetsEndpointUrl(), this_.getClientId(), this_.getBearerToken(), this_.getTerminalId(), this_.getEntityReferenceCode());
            DateTime requestSendDate = new DateTime();
            SibsPayResponseInquiryWrapper responseInquiryWrapper = sibsPayService.getPaymentStatusBySibsTransactionId((String)specificTransactionId.get());
            DateTime requestReceiveDate = new DateTime();
            String requestLog = responseInquiryWrapper.getRequestLog();
            String responseLog = responseInquiryWrapper.getResponseLog();
            if (!responseInquiryWrapper.isOperationSuccess()) {
                throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, String.format("%s - %s", responseInquiryWrapper.getOperationStatusMessage(), responseInquiryWrapper.getOperationStatusDescription()));
            }
            ForwardPaymentStateType type = this_.translateForwardPaymentStateType(responseInquiryWrapper);
            ForwardPaymentStatusBean bean = new ForwardPaymentStatusBean(responseInquiryWrapper.isOperationSuccess(), type, responseInquiryWrapper.getPaymentResultCode(), responseInquiryWrapper.getPaymentResultDescription(), requestLog, responseLog);
            bean.editTransactionDetails(responseInquiryWrapper.getTransactionId(), forwardPayment.getRequestDate(), responseInquiryWrapper.getAmount());
            if (List.of(ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED).contains(bean.getStateType())) {
                return new PostProcessPaymentStatusBean(bean, forwardPayment.getState(), false);
            }
            PostProcessPaymentStatusBean returnBean = new PostProcessPaymentStatusBean(bean, forwardPayment.getState(), bean.isInPayedState());
            FenixFramework.atomic(() -> {
                PaymentRequestLog log2 = this.log((PaymentRequest)((Object)((Object)((Object)forwardPayment))), "postProcessPayment", bean.getStatusCode(), bean.getStatusMessage(), requestLog, responseLog);
                log2.setInternalMerchantTransactionId(forwardPayment.getMerchantTransactionId());
                log2.setExternalTransactionId(bean.getTransactionId());
                log2.setRequestSendDate(requestSendDate);
                log2.setRequestReceiveDate(requestReceiveDate);
                log2.setOperationSuccess(true);
                log2.setTransactionWithPayment(bean.isInPayedState());
                if (!forwardPayment.isInRequestedState()) {
                    return;
                }
                if (bean.isInPayedState()) {
                    forwardPayment.advanceToPaidState(bean.getStatusCode(), bean.getPayedAmount(), bean.getTransactionDate(), bean.getTransactionId(), justification);
                } else if (bean.isInRejectedState()) {
                    forwardPayment.reject();
                }
            });
            return returnBean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                this.logException((PaymentRequest)((Object)((Object)((Object)forwardPayment))), e, "postProcessPayment", "error", "error", requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPayment(ForwardPaymentRequest forwardPayment) {
        return this.postProcessPayment(forwardPayment, "", Optional.of(forwardPayment.getTransactionId()));
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPaymentFromWebhook(PaymentRequestLog log2, DigitalPlatformResultBean bean) {
        ForwardPaymentRequest forwardPaymentRequest = (ForwardPaymentRequest)((Object)log2.getPaymentRequest());
        return this.postProcessPayment(forwardPaymentRequest, "", Optional.of(bean.getTransactionId()));
    }

    public String getReturnURL(ForwardPaymentRequest forwardPayment) {
        String forwardPaymentReturnDefaultURL = TreasurySettings.getInstance().getForwardPaymentReturnDefaultURL();
        return String.format("%s/%s/%s", forwardPaymentReturnDefaultURL, RETURN_FORWARD_PAYMENT_URL, forwardPayment.getExternalId());
    }

    public String generateNewMerchantTransactionId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public String getPaymentURL(ForwardPaymentRequest request) {
        return new SibsPayAPIService(this.getEndpointUrl(), this.getAssetsEndpointUrl(), this.getClientId(), this.getBearerToken(), this.getTerminalId(), this.getEntityReferenceCode()).getJsScriptURL(request.getTransactionId());
    }

    @Override
    public String getLogosJspPage() {
        return null;
    }

    @Override
    public ForwardPaymentStatusBean paymentStatus(ForwardPaymentRequest request) {
        SibsPayAPIService sibsPayService = new SibsPayAPIService(this.getEndpointUrl(), this.getAssetsEndpointUrl(), this.getClientId(), this.getBearerToken(), this.getTerminalId(), this.getEntityReferenceCode());
        try {
            SibsPayResponseInquiryWrapper responseInquiryWrapper = null;
            responseInquiryWrapper = !StringUtils.isEmpty((String)request.getTransactionId()) ? sibsPayService.getPaymentStatusBySibsTransactionId(request.getTransactionId()) : sibsPayService.getPaymentStatusByMerchantTransactionId(request.getMerchantTransactionId());
            String requestLog = responseInquiryWrapper.getRequestLog();
            String responseLog = responseInquiryWrapper.getResponseLog();
            ForwardPaymentStateType paymentStateType = this.translateForwardPaymentStateType(responseInquiryWrapper);
            ForwardPaymentStatusBean bean = new ForwardPaymentStatusBean(responseInquiryWrapper.isOperationSuccess(), paymentStateType, responseInquiryWrapper.getPaymentResultCode(), responseInquiryWrapper.getPaymentResultDescription(), requestLog, responseLog);
            bean.editTransactionDetails(responseInquiryWrapper.getTransactionId(), request.getRequestDate(), responseInquiryWrapper.getAmount());
            return bean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                this.logException((PaymentRequest)((Object)((Object)((Object)request))), e, "paymentStatus", "error", "error", requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.gateway.communication", new String[0]);
        }
    }

    private ForwardPaymentStateType translateForwardPaymentStateType(SibsPayResponseInquiryWrapper responseInquiryWrapper) {
        if (responseInquiryWrapper.isPaid()) {
            return ForwardPaymentStateType.PAYED;
        }
        if (responseInquiryWrapper.isPending()) {
            return ForwardPaymentStateType.REQUESTED;
        }
        return ForwardPaymentStateType.REJECTED;
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments) {
        BigDecimal payableAmountDebitEntries = debitEntries.stream().map(InvoiceEntry::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmountInstallments = installments.stream().map(Installment::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmount = payableAmountDebitEntries.add(payableAmountInstallments);
        LocalDate validTo = this.getSibsPaymentExpiryStrategy().calculateSibsPaymentRequestExpiryDate(debitEntries, installments, false, null);
        return this.createSibsPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequest(SettlementNoteBean settlementNoteBean) {
        DebtAccount debtAccount = settlementNoteBean.getDebtAccount();
        Set<DebitEntry> debitEntries = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.getInvoiceEntry() != null).map(s -> s.getInvoiceEntry()).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.isForInstallment()).map(InstallmentPaymenPlanBean.class::cast).map(s -> s.getInstallment()).collect(Collectors.toSet());
        BigDecimal payableAmount = settlementNoteBean.getTotalAmountToPay();
        LocalDate validTo = this.getSibsPaymentExpiryStrategy().calculateSibsPaymentRequestExpiryDate(debitEntries, installments, settlementNoteBean.isLimitSibsPaymentRequestToCustomDueDate(), settlementNoteBean.getCustomSibsPaymentRequestDueDate());
        return this.createSibsPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    @Override
    @Deprecated
    public SibsPaymentRequest createSibsPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, BigDecimal payableAmount) {
        LocalDate validTo = this.getSibsPaymentExpiryStrategy().calculateSibsPaymentRequestExpiryDate(debitEntries, installments, false, null);
        return this.createSibsPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequestWithInterests(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, LocalDate interestsCalculationDate) {
        BigDecimal payableAmountDebitEntries = debitEntries.stream().map(d -> d.getOpenAmountWithInterestsAtDate(interestsCalculationDate)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmountInstallments = installments.stream().map(Installment::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmount = payableAmountDebitEntries.add(payableAmountInstallments);
        LocalDate validTo = this.getSibsPaymentExpiryStrategy().calculateSibsPaymentRequestExpiryDate(debitEntries, installments, false, null);
        return this.createSibsPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    private SibsPaymentRequest createSibsPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, LocalDate validTo, BigDecimal payableAmount) {
        if (!this.isActive()) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.paymentCodePool.not.active", new String[0]);
        }
        if (PaymentRequest.getReferencedCustomers(debitEntries, installments).size() > 1) {
            throw new TreasuryDomainException("error.PaymentRequest.referencedCustomers.only.one.allowed", new String[0]);
        }
        String merchantTransactionId = this.generateNewMerchantTransactionId();
        Optional<Object> transactionIdOptional = Optional.empty();
        Optional<Object> transactionSignatureOptional = Optional.empty();
        SibsPayAPIService sibsPayService = new SibsPayAPIService(this.getEndpointUrl(), this.getAssetsEndpointUrl(), this.getClientId(), this.getBearerToken(), this.getTerminalId(), this.getEntityReferenceCode());
        DateTime sibsValidFrom = new DateTime();
        DateTime sibsValidTo = this.calculateSibsValidTo(sibsValidFrom, validTo);
        ArrayList<PaymentRequestLog> logsList = new ArrayList<PaymentRequestLog>();
        PaymentRequestLog log2 = SibsPayPlatform.createLogForSibsPaymentRequest(merchantTransactionId);
        logsList.add(log2);
        try {
            SibsPayReturnCheckout sibsPayReturnCheckout = sibsPayService.processSibsPaymentRequestOrMbwayCheckout(debtAccount, payableAmount, sibsValidFrom, sibsValidTo, merchantTransactionId);
            boolean isOperationSuccess = SibsPayAPIService.isOperationSuccess(sibsPayReturnCheckout.getReturnStatus().getStatusCode());
            FenixFramework.atomic(() -> {
                log2.logRequestReceiveDateAndData(sibsPayReturnCheckout.getTransactionID(), isOperationSuccess, false, sibsPayReturnCheckout.getReturnStatus().getStatusCode(), sibsPayReturnCheckout.getReturnStatus().getStatusDescription());
                log2.saveRequest(sibsPayReturnCheckout.getRequestLog());
                log2.saveResponse(sibsPayReturnCheckout.getResponseLog());
            });
            if (!isOperationSuccess) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.request.not.successful", new String[0]);
            }
            transactionIdOptional = Optional.ofNullable(sibsPayReturnCheckout.getTransactionID());
            transactionSignatureOptional = Optional.ofNullable(sibsPayReturnCheckout.getTransactionSignature());
        }
        catch (Exception e) {
            boolean isOnlinePaymentsGatewayException = e instanceof OnlinePaymentsGatewayCommunicationException;
            this.saveExceptionLog(log2, e, isOnlinePaymentsGatewayException);
            if (e instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)e;
            }
            String message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.unknown";
            if (isOnlinePaymentsGatewayException) {
                message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.gateway.communication";
            }
            throw new TreasuryDomainException((Throwable)e, message, new String[0]);
        }
        log2 = SibsPayPlatform.createLogForSibsPaymentRequest(merchantTransactionId);
        logsList.add(log2);
        try {
            if (transactionIdOptional.isEmpty() || StringUtils.isEmpty((String)((String)transactionIdOptional.get()))) {
                throw new TreasuryDomainException("error.SibsPayPlatform.transactionId.required.to.generate.reference", new String[0]);
            }
            if (transactionSignatureOptional.isEmpty() || StringUtils.isEmpty((String)((String)transactionSignatureOptional.get()))) {
                throw new TreasuryDomainException("error.SibsPayPlatform.transactionSignature.required.to.generate.reference", new String[0]);
            }
            String transactionId = (String)transactionIdOptional.get();
            String transactionSignature = (String)transactionSignatureOptional.get();
            SibsPayResponseInquiryWrapper responseInquiryWrapper = sibsPayService.generateSibsPaymentRequestTransaction(transactionId, transactionSignature);
            FenixFramework.atomic(() -> {
                log2.logRequestReceiveDateAndData(transactionId, responseInquiryWrapper.isOperationSuccess(), false, responseInquiryWrapper.getOperationStatusCode(), responseInquiryWrapper.getOperationStatusDescription());
                log2.saveRequest(responseInquiryWrapper.getRequestLog());
                log2.saveResponse(responseInquiryWrapper.getResponseLog());
            });
            if (!responseInquiryWrapper.isOperationSuccess()) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.request.not.successful", new String[0]);
            }
            String referenceCode = responseInquiryWrapper.getReferenceCode();
            if (StringUtils.isEmpty((String)referenceCode)) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.reference.not.empty", new String[0]);
            }
            if (SibsReferenceCode.findByReferenceCode(this.getEntityReferenceCode(), referenceCode).count() >= 1L) {
                throw new TreasuryDomainException("error.PaymentReferenceCode.referenceCode.duplicated", new String[0]);
            }
            if (PaymentRequest.findBySibsGatewayTransactionId(transactionId).count() >= 1L) {
                throw new TreasuryDomainException("error.PaymentReferenceCode.sibsReferenceId.found.duplicated", new String[0]);
            }
            SibsPaymentRequest sibsPaymentRequest = (SibsPaymentRequest)((Object)FenixFramework.atomic(() -> {
                SibsPaymentRequest request = SibsPaymentRequest.create((DigitalPaymentPlatform)((Object)((Object)this)), debtAccount, debitEntries, installments, payableAmount, this.getEntityReferenceCode(), referenceCode, merchantTransactionId, transactionId);
                request.setPaymentDueDate(validTo);
                request.setExpiresDate(sibsValidTo);
                logsList.forEach(l -> l.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)((Object)request))))));
                return request;
            }));
            return sibsPaymentRequest;
        }
        catch (Exception e) {
            boolean isOnlinePaymentsGatewayException = e instanceof OnlinePaymentsGatewayCommunicationException;
            this.saveExceptionLog(log2, e, isOnlinePaymentsGatewayException);
            if (e instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)e;
            }
            String message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.unknown";
            if (isOnlinePaymentsGatewayException) {
                message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.gateway.communication";
            }
            throw new TreasuryDomainException((Throwable)e, message, new String[0]);
        }
    }

    private DateTime calculateSibsValidTo(DateTime sibsValidFrom, LocalDate validTo) {
        Duration duration;
        DateTime sibsValidTo = validTo.plusDays(1).toDateTimeAtStartOfDay().minusSeconds(1);
        if (this.getReferenceMinimumValidityInHours() != null && this.getReferenceMinimumValidityInHours() > 0 && (duration = new Duration((ReadableInstant)sibsValidFrom, (ReadableInstant)sibsValidTo)).getStandardHours() < (long)this.getReferenceMinimumValidityInHours().intValue()) {
            int incrementHours = this.getReferenceMinimumValidityInHours() - (int)duration.getStandardHours();
            sibsValidTo = sibsValidTo.plusHours(incrementHours);
        }
        return sibsValidTo;
    }

    private void saveExceptionLog(PaymentRequestLog paymentRequestLog, Exception exception, boolean bl) {
        Object object = advice$saveExceptionLog.perform((Callable)new SibsPayPlatform$callable$saveExceptionLog(this, paymentRequestLog, exception, bl));
    }

    static /* synthetic */ void advised$saveExceptionLog(SibsPayPlatform this_, PaymentRequestLog log2, Exception e, boolean isOnlinePaymentsGatewayException) {
        log2.logException(e);
        if (isOnlinePaymentsGatewayException) {
            log2.saveRequest(((OnlinePaymentsGatewayCommunicationException)((Object)e)).getRequestLog());
            log2.saveResponse(((OnlinePaymentsGatewayCommunicationException)((Object)e)).getResponseLog());
        }
    }

    @Override
    public PaymentTransaction processPaymentReferenceCodeTransaction(PaymentRequestLog log2, DigitalPlatformResultBean bean) {
        DateTime paymentDate = bean.getPaymentDate() != null ? bean.getPaymentDate() : DateTime.now();
        return this.processPaymentReferenceCodeTransaction(log2, bean, paymentDate);
    }

    public PaymentTransaction processPaymentReferenceCodeTransaction(PaymentRequestLog log2, DigitalPlatformResultBean bean, DateTime customPaymentDate) {
        SibsPaymentRequest paymentRequest = (SibsPaymentRequest)((Object)log2.getPaymentRequest());
        if (!bean.getTransactionId().equals(paymentRequest.getTransactionId())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.transactionId.not.equal", new String[0]);
        }
        BigDecimal paidAmount = bean.getAmount();
        FenixFramework.atomic(() -> {
            log2.savePaymentTypeAndBrand(bean.getPaymentType(), bean.getPaymentBrand());
            log2.savePaymentInfo(paidAmount, customPaymentDate);
        });
        if (paidAmount == null || !TreasuryConstants.isPositive(paidAmount)) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.invalid.amount", new String[0]);
        }
        if (customPaymentDate == null) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.invalid.payment.date", new String[0]);
        }
        String entityReferenceCode = this.getEntityReferenceCode();
        if (SibsPaymentCodeTransaction.isReferenceProcessingDuplicate(entityReferenceCode, paymentRequest.getReferenceCode(), customPaymentDate)) {
            FenixFramework.atomic(() -> log2.markAsDuplicatedTransaction());
            return null;
        }
        if (PaymentTransaction.isTransactionDuplicate(bean.getTransactionId())) {
            FenixFramework.atomic(() -> log2.markAsDuplicatedTransaction());
            return null;
        }
        return paymentRequest.processPayment(paidAmount, customPaymentDate, bean.getTransactionId(), null, bean.getMerchantTransactionId(), new DateTime(), null, true);
    }

    public List<? extends DigitalPlatformResultBean> getPaymentTransactionsReportListByMerchantId(String merchantTransationId) {
        SibsPayAPIService sibsPayService = new SibsPayAPIService(this.getEndpointUrl(), this.getAssetsEndpointUrl(), this.getClientId(), this.getBearerToken(), this.getTerminalId(), this.getEntityReferenceCode());
        try {
            SibsPayResponseInquiryWrapper responseInquiryWrapper = sibsPayService.getPaymentStatusByMerchantTransactionId(merchantTransationId);
            return List.of(responseInquiryWrapper);
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                PaymentRequestLog log2 = PaymentRequestLog.create(null, "getPaymentTransactionsReportListByMerchantId", null, null);
                log2.setInternalMerchantTransactionId(merchantTransationId);
                log2.logException(e);
                log2.setOperationSuccess(false);
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    log2.saveRequest(((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog());
                    log2.saveResponse(((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog());
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    @Override
    @Deprecated
    public PaymentRequestLog createLogForWebhookNotification() {
        throw new RuntimeException("deprecated");
    }

    @Override
    public void fillLogForWebhookNotification(PaymentRequestLog log2, DigitalPlatformResultBean bean) {
        log2.setStatusCode(bean.getPaymentResultCode());
        log2.setStatusMessage(bean.getPaymentResultDescription());
        log2.setInternalMerchantTransactionId(bean.getMerchantTransactionId());
        log2.setExternalTransactionId(bean.getTransactionId());
        log2.setOperationSuccess(bean.isOperationSuccess());
        log2.setTransactionWithPayment(bean.isPaid());
        if (bean instanceof SibsPayResponseInquiryWrapper) {
            log2.saveRequest(((SibsPayResponseInquiryWrapper)bean).getRequestLog());
            log2.saveResponse(((SibsPayResponseInquiryWrapper)bean).getResponseLog());
        }
    }

    public void rejectRequest(PaymentRequest paymentRequest, PaymentRequestLog log2, SibsPayWebhookNotificationWrapper webhookNotificationWrapper) {
        if (paymentRequest instanceof ForwardPaymentRequest) {
            ((ForwardPaymentRequest)((Object)paymentRequest)).reject();
        } else if (paymentRequest instanceof SibsPaymentRequest) {
            ((SibsPaymentRequest)((Object)paymentRequest)).anull();
        } else if (paymentRequest instanceof MbwayRequest) {
            ((MbwayRequest)((Object)paymentRequest)).anull();
        } else {
            throw new RuntimeException("unknown payment request type");
        }
    }

    public void delete() {
        super.delete();
        super.deleteDomainObject();
    }

    @Override
    public boolean annulPaymentRequestInPlatform(SibsPaymentRequest sibsPaymentRequest) {
        SibsPayAPIService sibsPayService = new SibsPayAPIService(this.getEndpointUrl(), this.getAssetsEndpointUrl(), this.getClientId(), this.getBearerToken(), this.getTerminalId(), this.getEntityReferenceCode());
        try {
            SibsPayResponseInquiryWrapper responseInquiryWrapper = sibsPayService.getPaymentStatusBySibsTransactionId(sibsPaymentRequest.getTransactionId());
            if (responseInquiryWrapper == null) {
                throw new IllegalStateException("unable to check the payment request status");
            }
            if (responseInquiryWrapper.isDeclined()) {
                FenixFramework.atomic(() -> {
                    sibsPaymentRequest.setDigitalPaymentPlatformPendingForAnnulment(null);
                    this.log((PaymentRequest)((Object)((Object)((Object)sibsPaymentRequest))), "annulPaymentRequestInPlatform", "DECLINED_REMOVE_FROM_PENDING", "declined, remove from pending", "", "").setOperationSuccess(true);
                });
                return true;
            }
            if (responseInquiryWrapper.isExpired()) {
                FenixFramework.atomic(() -> {
                    sibsPaymentRequest.setDigitalPaymentPlatformPendingForAnnulment(null);
                    this.log((PaymentRequest)((Object)((Object)((Object)sibsPaymentRequest))), "annulPaymentRequestInPlatform", "EXPIRED_REMOVE_FROM_PENDING", "expired, remove from pending", "", "").setOperationSuccess(true);
                });
                return true;
            }
            if (responseInquiryWrapper.isPaid()) {
                if (!sibsPaymentRequest.getPaymentTransactionsSet().isEmpty()) {
                    FenixFramework.atomic(() -> {
                        sibsPaymentRequest.setDigitalPaymentPlatformPendingForAnnulment(null);
                        this.log((PaymentRequest)((Object)((Object)((Object)sibsPaymentRequest))), "annulPaymentRequestInPlatform", "PAID_REMOVE_FROM_PENDING", "paid, remove from pending", "", "").setOperationSuccess(true);
                    });
                    return true;
                }
                FenixFramework.atomic(() -> this.log((PaymentRequest)((Object)((Object)((Object)sibsPaymentRequest))), "annulPaymentRequestInPlatform", "PAID_CHECK", "paid, check pending payment", "", "").setOperationSuccess(false));
                return false;
            }
            if (responseInquiryWrapper.isPending()) {
                SibsPayCancellationResponse cancellationResponse = sibsPayService.cancelTransaction(sibsPaymentRequest.getMerchantTransactionId(), sibsPaymentRequest.getTransactionId(), sibsPaymentRequest.getPayableAmount());
                cancellationResponse.getReturnStatus().getStatusCode();
                String statusCode = cancellationResponse.getReturnStatus() != null ? cancellationResponse.getReturnStatus().getStatusCode() : "";
                String statusMessage = cancellationResponse.getReturnStatus() != null ? cancellationResponse.getReturnStatus().getStatusDescription() : "";
                FenixFramework.atomic(() -> {
                    sibsPaymentRequest.setDigitalPaymentPlatformPendingForAnnulment(null);
                    this.log((PaymentRequest)((Object)((Object)((Object)sibsPaymentRequest))), "annulPaymentRequestInPlatform", statusCode, statusMessage, cancellationResponse.getRequestLog(), cancellationResponse.getResponseLog()).setOperationSuccess(true);
                });
                return true;
            }
            FenixFramework.atomic(() -> this.log((PaymentRequest)((Object)((Object)((Object)sibsPaymentRequest))), "annulPaymentRequestInPlatform", "UNKNOWN_STATE", "unknown payment result code, please check: " + responseInquiryWrapper.getPaymentResultCode(), "", "").setOperationSuccess(false));
            return false;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                this.logException((PaymentRequest)((Object)((Object)((Object)sibsPaymentRequest))), e, "annulPaymentRequestInPlatform", "error", "error", requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsPayPlatform.annulPaymentRequestInPlatform", new String[0]);
        }
    }

    public int getMaximumLengthForAddressStreetFieldOne() {
        return 50;
    }

    public int getMaximumLengthForAddressCity() {
        return 35;
    }

    public int getMaximumLengthForPostalCode() {
        return 16;
    }

    private static PaymentRequestLog createLogForSibsPaymentRequest(String string) {
        return (PaymentRequestLog)((Object)advice$createLogForSibsPaymentRequest.perform((Callable)new SibsPayPlatform$callable$createLogForSibsPaymentRequest(string)));
    }

    static /* synthetic */ PaymentRequestLog advised$createLogForSibsPaymentRequest(String merchantTransactionId) {
        PaymentRequestLog log2 = PaymentRequestLog.create(null, "createSibsPaymentRequest", PaymentReferenceCodeStateType.UNUSED.getCode(), PaymentReferenceCodeStateType.UNUSED.getDescriptionI18N());
        log2.setInternalMerchantTransactionId(merchantTransactionId);
        return log2;
    }

    public static String getPresentationName() {
        return "SIBS Pay (SPG)";
    }

    public static SibsPayPlatform create(FinantialInstitution finantialInstitution, FinantialEntity finantialEntity, String name, boolean active, String clientId, String bearerToken, Integer terminalId, String entityReferenceCode, String endpointUrl, String assetsEndpointUrl) {
        return new SibsPayPlatform(finantialInstitution, finantialEntity, name, active, clientId, bearerToken, terminalId, entityReferenceCode, endpointUrl, assetsEndpointUrl);
    }

    public static Stream<SibsPayPlatform> findAllActive() {
        return DigitalPaymentPlatform.findAll().filter(p -> p instanceof SibsPayPlatform).filter(p -> p.isActive()).map(SibsPayPlatform.class::cast);
    }
}

