/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.payments.integration;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.domain.payments.IMbwayPaymentPlatformService;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform$callable$log;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform_Base;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class DigitalPaymentPlatform
extends DigitalPaymentPlatform_Base {
    public static final Comparator<DigitalPaymentPlatform> COMPARE_BY_NAME;
    public static final Advice advice$log;

    protected DigitalPaymentPlatform() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected void init(FinantialInstitution finantialInstitution, FinantialEntity finantialEntity, String name, boolean active) {
        this.setFinantialInstitution(finantialInstitution);
        this.setFinantialEntity(finantialEntity);
        this.setName(name);
        this.setActive(active);
    }

    protected void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.DigitalPaymentPlatform.domainRoot.required", new String[0]);
        }
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.DigitalPaymentPlatform.finantialInstitution.required", new String[0]);
        }
        if (this.getFinantialEntity() == null) {
            throw new TreasuryDomainException("error.DigitalPaymentPlatform.finantialEntity.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getName())) {
            throw new TreasuryDomainException("error.DigitalPaymentPlatform.name.required", new String[0]);
        }
    }

    public boolean isSibsPaymentCodeServiceSupported() {
        return this.getDigitalPaymentPlatformPaymentModesSet().stream().anyMatch(m -> m.getPaymentMethod() == TreasurySettings.getInstance().getMbPaymentMethod());
    }

    public boolean isForwardPaymentServiceSupported() {
        return this.getDigitalPaymentPlatformPaymentModesSet().stream().anyMatch(m -> m.getPaymentMethod() == TreasurySettings.getInstance().getCreditCardPaymentMethod());
    }

    public boolean isMbwayServiceSupported() {
        return this.getDigitalPaymentPlatformPaymentModesSet().stream().anyMatch(m -> m.getPaymentMethod() == TreasurySettings.getInstance().getMbWayPaymentMethod());
    }

    public boolean isActive() {
        return this.getActive();
    }

    public boolean isActive(PaymentMethod paymentMethod) {
        Optional<DigitalPaymentPlatformPaymentMode> optional = this.getDigitalPaymentPlatformPaymentModesSet().stream().filter(p -> p.getPaymentMethod() == paymentMethod).findAny();
        return this.isActive() && optional.isPresent() && optional.get().isActive();
    }

    public ISibsPaymentCodePoolService castToSibsPaymentCodePoolService() {
        return (ISibsPaymentCodePoolService)((Object)this);
    }

    public IForwardPaymentPlatformService castToForwardPaymentPlatformService() {
        return (IForwardPaymentPlatformService)((Object)this);
    }

    public IMbwayPaymentPlatformService castToMbwayPaymentPlatformService() {
        return (IMbwayPaymentPlatformService)((Object)this);
    }

    public Set<? extends PaymentRequest> getAssociatedPaymentRequestsSet() {
        return super.getPaymentRequestsSet();
    }

    public Set<DigitalPaymentPlatformPaymentMode> getActiveDigitalPaymentModesSet() {
        return this.getDigitalPaymentPlatformPaymentModesSet().stream().filter(p -> p.isActive()).collect(Collectors.toSet());
    }

    public void delete() {
        if (!super.getPaymentRequestsSet().isEmpty()) {
            throw new TreasuryDomainException("error.DigitalPaymentPlatform.cannot.delete.due.to.requests", new String[0]);
        }
        super.setDomainRoot(null);
        super.setFinantialInstitution(null);
        super.setFinantialEntity(null);
        while (!this.getDigitalPaymentPlatformPaymentModesSet().isEmpty()) {
            ((DigitalPaymentPlatformPaymentMode)((Object)this.getDigitalPaymentPlatformPaymentModesSet().iterator().next())).delete();
        }
        if (this.getSibsPaymentExpiryStrategy() != null) {
            this.getSibsPaymentExpiryStrategy().delete();
        }
    }

    public PaymentRequestLog log(PaymentRequest paymentRequest, String string, String string2, String string3, String string4, String string5) {
        return (PaymentRequestLog)((Object)advice$log.perform((Callable)new DigitalPaymentPlatform$callable$log(this, paymentRequest, string, string2, string3, string4, string5)));
    }

    static /* synthetic */ PaymentRequestLog advised$log(DigitalPaymentPlatform this_, PaymentRequest paymentRequest, String operationCode, String statusCode, String statusMessage, String requestBody, String responseBody) {
        PaymentRequestLog log2 = PaymentRequestLog.create(paymentRequest, operationCode, paymentRequest.getCurrentState().getCode(), paymentRequest.getCurrentState().getLocalizedName());
        log2.setStatusCode(statusCode);
        log2.setStatusMessage(statusMessage);
        if (!Strings.isNullOrEmpty((String)requestBody)) {
            log2.saveRequest(requestBody);
        }
        if (!Strings.isNullOrEmpty((String)responseBody)) {
            log2.saveResponse(responseBody);
        }
        return log2;
    }

    public PaymentRequestLog logException(PaymentRequest paymentRequest, Exception e, String operationCode, String statusCode, String statusMessage, String requestBody, String responseBody) {
        PaymentRequestLog log2 = this.log(paymentRequest, operationCode, statusCode, statusMessage, requestBody, responseBody);
        log2.logException(e);
        return log2;
    }

    public void updateFinantialInstitutionInfoHeader(boolean overrideFinantialInstitutionInfoHeader, LocalizedString finantialInstitutionInfoHeader) {
        if (finantialInstitutionInfoHeader != null) {
            finantialInstitutionInfoHeader.forEach((locale, text) -> {
                String startTag = "<script>";
                String endTag = "</script>";
                if (text.indexOf(startTag) > 0 && text.indexOf(endTag) > 0) {
                    String textToRemove = text.substring(text.indexOf(startTag) + startTag.length(), text.indexOf(endTag));
                    text = text.replace(textToRemove, "");
                }
                text = text.replace(startTag, "").replace(endTag, "");
                finantialInstitutionInfoHeader.getOrDefault(locale, text);
            });
        }
        super.setOverrideFinantialInstitutionInfoHeader(Boolean.valueOf(overrideFinantialInstitutionInfoHeader));
        super.setFinantialInstitutionInfoHeader(finantialInstitutionInfoHeader);
    }

    public abstract List<? extends DigitalPlatformResultBean> getPaymentTransactionsReportListByMerchantId(String var1);

    public abstract int getMaximumLengthForAddressStreetFieldOne();

    public abstract int getMaximumLengthForAddressCity();

    public abstract int getMaximumLengthForPostalCode();

    public List<DigitalPaymentPlatformPaymentMode> getOrderedPaymentModesList() {
        return this.getDigitalPaymentPlatformPaymentModesSet().stream().sorted(DigitalPaymentPlatformPaymentMode.COMPARE_BY_ORDER).collect(Collectors.toList());
    }

    public void orderPaymentModes() {
        AtomicInteger nextOrder = new AtomicInteger(1);
        this.getOrderedPaymentModesList().forEach(mode -> mode.setPaymentModeOrder(nextOrder.getAndIncrement()));
    }

    public static Stream<? extends DigitalPaymentPlatform> findAll() {
        return FenixFramework.getDomainRoot().getDigitalPaymentPlatformsSet().stream();
    }

    public static Stream<? extends DigitalPaymentPlatform> findForSibsPaymentCodeService() {
        return DigitalPaymentPlatform.findAll().filter(d -> d.isSibsPaymentCodeServiceSupported());
    }

    public static Stream<? extends DigitalPaymentPlatform> find(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getDigitalPaymentPlatformsSet().stream();
    }

    public static Stream<? extends DigitalPaymentPlatform> findForSibsPaymentCodeService(FinantialInstitution finantialInstitution) {
        return DigitalPaymentPlatform.find(finantialInstitution).filter(d -> d.isSibsPaymentCodeServiceSupported());
    }

    public static Stream<? extends DigitalPaymentPlatform> findForSibsPaymentCodeServiceByActive(FinantialInstitution finantialInstitution, boolean active) {
        PaymentMethod mbPaymentMethod = TreasurySettings.getInstance().getMbPaymentMethod();
        return DigitalPaymentPlatform.find(finantialInstitution).filter(d -> d.isSibsPaymentCodeServiceSupported()).filter(d -> active == d.isActive(mbPaymentMethod));
    }

    public static Stream<? extends DigitalPaymentPlatform> findForForwardPaymentService(FinantialInstitution finantialInstitution) {
        return DigitalPaymentPlatform.find(finantialInstitution).filter(d -> d.isForwardPaymentServiceSupported());
    }

    public static Stream<? extends DigitalPaymentPlatform> findForForwardPaymentService(FinantialInstitution finantialInstitution, boolean active) {
        PaymentMethod creditCardPaymentMethod = TreasurySettings.getInstance().getCreditCardPaymentMethod();
        return DigitalPaymentPlatform.find(finantialInstitution).filter(d -> d.isForwardPaymentServiceSupported()).filter(d -> active == d.isActive(creditCardPaymentMethod));
    }

    public static Stream<? extends DigitalPaymentPlatform> find(FinantialInstitution finantialInstitution, PaymentMethod paymentMethod, boolean active) {
        return DigitalPaymentPlatform.find(finantialInstitution).filter(d -> active == d.isActive(paymentMethod));
    }

    static {
        advice$log = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        COMPARE_BY_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName()) * 10 + o1.getExternalId().compareTo(o2.getExternalId());
    }
}

