/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.debt.balancetransfer;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.debt.balancetransfer.BalanceTransferService;
import org.fenixedu.treasury.domain.debt.balancetransfer.StandardBalanceTransferServiceForSAPAndSINGAP$callable$transferBalance;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentSettlementEntry;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlan;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanConfigurator;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanStateType;
import org.fenixedu.treasury.domain.payments.PaymentInvoiceEntriesGroup;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class StandardBalanceTransferServiceForSAPAndSINGAP
implements BalanceTransferService {
    protected DebtAccount fromDebtAccount;
    protected DebtAccount destinyDebtAccount;
    protected Map<DebitEntry, DebitEntry> conversionMap;
    protected Map<DebitEntry, SettlementEntry> settlementOfDebitEntryMap;
    private Set<PaymentPlan> openPaymentPlans;
    public static final Advice advice$transferBalance = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public StandardBalanceTransferServiceForSAPAndSINGAP(DebtAccount fromDebtAccount, DebtAccount destinyDebtAccount) {
        this.fromDebtAccount = fromDebtAccount;
        this.destinyDebtAccount = destinyDebtAccount;
        this.conversionMap = new HashMap<DebitEntry, DebitEntry>();
        this.settlementOfDebitEntryMap = new HashMap<DebitEntry, SettlementEntry>();
        this.openPaymentPlans = fromDebtAccount.getActivePaymentPlansSet();
    }

    @Override
    public void transferBalance() {
        Object object = advice$transferBalance.perform((Callable)new StandardBalanceTransferServiceForSAPAndSINGAP$callable$transferBalance(this));
    }

    static /* synthetic */ void advised$transferBalance(StandardBalanceTransferServiceForSAPAndSINGAP this_) {
        this_.openPaymentPlans.forEach(p -> {
            p.setState(PaymentPlanStateType.TRANSFERRED);
            p.setStateReason(TreasuryConstants.treasuryBundle("label.BalanceTransferService.paymentPlan.reason", this.destinyDebtAccount.getCustomer().getFiscalNumber()));
        });
        BigDecimal initialGlobalBalance = this_.fromDebtAccount.getCustomer().getGlobalBalance();
        FinantialInstitution finantialInstitution = this_.fromDebtAccount.getFinantialInstitution();
        Currency currency = finantialInstitution.getCurrency();
        DateTime now = new DateTime();
        HashSet pendingDebitNotes = Sets.newHashSet();
        for (InvoiceEntry invoiceEntry : this_.fromDebtAccount.getPendingInvoiceEntriesSet()) {
            FinantialEntity finantialEntity = invoiceEntry.getFinantialEntity();
            DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.findUniqueDefaultSeries(FinantialDocumentType.findForDebitNote(), finantialEntity);
            if (TreasuryDebtProcessMainService.isFinantialDocumentEntryAnnullmentActionBlocked((FinantialDocumentEntry)((Object)invoiceEntry))) {
                throw new TreasuryDomainException("error.DebitEntry.cannot.annul.or.credit.due.to.existing.active.debt.process", new String[0]);
            }
            if (!invoiceEntry.isDebitNoteEntry()) continue;
            DebitEntry debitEntry = (DebitEntry)((Object)invoiceEntry);
            if (debitEntry.getFinantialDocument() == null) {
                DebitNote debitNote = DebitNote.create(invoiceEntry.getFinantialEntity(), this_.fromDebtAccount, null, documentNumberSeries, now, now.toLocalDate(), null, Collections.emptyMap(), null, null);
                debitNote.addDebitNoteEntries(Lists.newArrayList((Object[])new DebitEntry[]{debitEntry}));
            }
            pendingDebitNotes.add((DebitNote)((Object)debitEntry.getFinantialDocument()));
        }
        for (DebitNote debitNote : pendingDebitNotes) {
            this_.transferDebitEntries(debitNote);
        }
        for (InvoiceEntry invoiceEntry : this_.fromDebtAccount.getPendingInvoiceEntriesSet()) {
            if (!invoiceEntry.isCreditNoteEntry()) continue;
            this_.transferCreditEntry((CreditEntry)((Object)invoiceEntry));
        }
        BigDecimal finalGlobalBalance = this_.fromDebtAccount.getCustomer().getGlobalBalance();
        if (!TreasuryConstants.isEqual(initialGlobalBalance, finalGlobalBalance)) {
            throw new TreasuryDomainException("error.BalanceTransferService.initial.and.final.global.balance", new String[]{currency.getValueFor(initialGlobalBalance), currency.getValueFor(finalGlobalBalance)});
        }
        this_.transferPaymentPlans();
        this_.transferPaymentInvoiceEntriesGroups();
    }

    private void transferPaymentInvoiceEntriesGroups() {
        this.fromDebtAccount.getPaymentInvoiceEntriesGroupsSet().stream().forEach(g -> this.transferPaymentGroupToNewDebtAccount((PaymentInvoiceEntriesGroup)((Object)g)));
    }

    private void transferPaymentGroupToNewDebtAccount(PaymentInvoiceEntriesGroup paymentGroup) {
        Set<DebitEntry> newDebitEntrySet = paymentGroup.getInvoiceEntriesSet().stream().filter(d -> this.conversionMap.containsKey(d)).map(d -> this.conversionMap.get(d)).filter(d -> TreasuryConstants.isPositive(d.getOpenAmount())).collect(Collectors.toSet());
        if (newDebitEntrySet.isEmpty()) {
            return;
        }
        PaymentInvoiceEntriesGroup group = PaymentInvoiceEntriesGroup.findUniqueByGroupKey(this.destinyDebtAccount, StringUtils.isNotEmpty((String)paymentGroup.getGroupKey()) ? paymentGroup.getGroupKey() : UUID.randomUUID().toString()).orElseGet(() -> PaymentInvoiceEntriesGroup.create(paymentGroup.getFinantialEntity(), this.destinyDebtAccount, newDebitEntrySet, paymentGroup.getGroupKey()));
        newDebitEntrySet.forEach(d -> group.addInvoiceEntries((InvoiceEntry)((Object)((Object)d))));
    }

    private void transferPaymentPlans() {
        for (PaymentPlan objectPaymentPlan : this.openPaymentPlans) {
            PaymentPlan destinyPaymentPlan = new PaymentPlan();
            destinyPaymentPlan.setFinantialEntity(objectPaymentPlan.getFinantialEntity());
            destinyPaymentPlan.setCreationDate(objectPaymentPlan.getCreationDate());
            destinyPaymentPlan.setDebtAccount(this.destinyDebtAccount);
            destinyPaymentPlan.setReason(objectPaymentPlan.getReason());
            destinyPaymentPlan.setPaymentPlanId(((PaymentPlanConfigurator)((Object)PaymentPlanConfigurator.findActives().iterator().next())).getNumberGenerators().generateNumber());
            destinyPaymentPlan.setState(PaymentPlanStateType.OPEN);
            destinyPaymentPlan.getPaymentPlanValidatorsSet().addAll(objectPaymentPlan.getPaymentPlanValidatorsSet());
            destinyPaymentPlan.setEmolument(this.conversionMap.get((Object)objectPaymentPlan.getEmolument()));
            for (Installment objectInstallment : objectPaymentPlan.getSortedOpenInstallments()) {
                Installment destinyInstallment = Installment.create(objectInstallment.getDescription().map(des -> des.replace(objectPaymentPlan.getPaymentPlanId(), destinyPaymentPlan.getPaymentPlanId())), objectInstallment.getDueDate(), destinyPaymentPlan);
                for (InstallmentEntry objectInstallmentEntry : objectInstallment.getSortedOpenInstallmentEntries()) {
                    DebitEntry destinyDebitEntry = this.conversionMap.get((Object)objectInstallmentEntry.getDebitEntry());
                    if (destinyDebitEntry.getDebitNote() != null && !destinyDebitEntry.getDebitNote().isClosed()) {
                        destinyDebitEntry.getDebitNote().closeDocument();
                    }
                    InstallmentEntry.create(destinyDebitEntry, objectInstallmentEntry.getOpenAmount(), destinyInstallment);
                    SettlementEntry settlementEntry = this.settlementOfDebitEntryMap.get((Object)objectInstallmentEntry.getDebitEntry());
                    if (settlementEntry == null) continue;
                    InstallmentSettlementEntry.create(objectInstallmentEntry, settlementEntry, objectInstallmentEntry.getOpenAmount());
                }
            }
            destinyPaymentPlan.createPaymentReferenceCode();
            objectPaymentPlan.addPaymentPlanRevisions(destinyPaymentPlan);
            objectPaymentPlan.checkRules();
            destinyPaymentPlan.checkRules();
        }
    }

    protected void transferCreditEntry(CreditEntry invoiceEntry) {
        FinantialEntity finantialEntity = invoiceEntry.getFinantialEntity();
        Series defaultSeries = Series.findUniqueDefaultSeries(finantialEntity);
        DocumentNumberSeries settlementNoteSeries = DocumentNumberSeries.find(FinantialDocumentType.findForSettlementNote(), defaultSeries);
        DateTime now = new DateTime();
        CreditEntry creditEntry = invoiceEntry;
        BigDecimal creditOpenAmount = creditEntry.getOpenAmount();
        String originNumber = creditEntry.getFinantialDocument() != null && invoiceEntry.getFinantialDocument().isClosed() ? creditEntry.getFinantialDocument().getUiDocumentNumber() : "";
        DebtAccount payorDebtAccount = creditEntry.getFinantialDocument() != null && ((Invoice)((Object)creditEntry.getFinantialDocument())).isForPayorDebtAccount() ? ((Invoice)((Object)creditEntry.getFinantialDocument())).getPayorDebtAccount() : null;
        DebitEntry regulationDebitEntry = StandardBalanceTransferServiceForSAPAndSINGAP.createBalanceTransferDebit(invoiceEntry.getFinantialEntity(), this.fromDebtAccount, now, now.toLocalDate(), originNumber, creditEntry.getProduct(), creditOpenAmount, payorDebtAccount, creditEntry.getDescription(), null);
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && (creditEntry.getFinantialDocument().isExportedInLegacyERP() || creditEntry.getFinantialDocument().getCloseDate() != null && creditEntry.getFinantialDocument().getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE))) {
            regulationDebitEntry.getFinantialDocument().setExportedInLegacyERP(true);
            regulationDebitEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
        }
        regulationDebitEntry.getFinantialDocument().closeDocument();
        CreditEntry regulationCreditEntry = StandardBalanceTransferServiceForSAPAndSINGAP.createBalanceTransferCredit(this.destinyDebtAccount, now, originNumber, creditEntry.getProduct(), creditOpenAmount, payorDebtAccount, creditEntry.getDescription(), creditEntry.getFinantialEntity());
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && (creditEntry.getFinantialDocument().isExportedInLegacyERP() || creditEntry.getFinantialDocument().getCloseDate() != null && creditEntry.getFinantialDocument().getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE))) {
            regulationCreditEntry.getFinantialDocument().setExportedInLegacyERP(true);
            regulationCreditEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
        }
        SettlementNote settlementNote = SettlementNote.create(invoiceEntry.getFinantialEntity(), this.fromDebtAccount, settlementNoteSeries, now, now, null, null);
        if (creditEntry.getFinantialDocument().isPreparing()) {
            creditEntry.getFinantialDocument().closeDocument();
        }
        SettlementEntry.create((InvoiceEntry)((Object)regulationDebitEntry), settlementNote, regulationDebitEntry.getOpenAmount(), regulationDebitEntry.getDescription(), now, false);
        SettlementEntry.create((InvoiceEntry)((Object)creditEntry), settlementNote, creditOpenAmount, creditEntry.getDescription(), now, false);
        settlementNote.markAsUsedInBalanceTransfer();
        settlementNote.closeDocument();
    }

    protected void transferDebitEntries(DebitNote objectDebitNote) {
        FinantialEntity finantialEntity = objectDebitNote.getFinantialEntity();
        DocumentNumberSeries settlementNumberSeries = DocumentNumberSeries.findUniqueDefaultSeries(FinantialDocumentType.findForSettlementNote(), finantialEntity);
        DateTime now = new DateTime();
        if (objectDebitNote.isPreparing()) {
            this.anullPreparingDebitNote(objectDebitNote);
        } else if (objectDebitNote.isClosed()) {
            DebtAccount payorDebtAccount = objectDebitNote.isForPayorDebtAccount() ? objectDebitNote.getPayorDebtAccount() : null;
            DebitNote destinyDebitNote = DebitNote.create(objectDebitNote.getFinantialEntity(), this.destinyDebtAccount, payorDebtAccount, objectDebitNote.getDocumentNumberSeries(), now, now.toLocalDate(), objectDebitNote.getUiDocumentNumber(), Collections.emptyMap(), null, null);
            SettlementNote settlementNote = SettlementNote.create(objectDebitNote.getFinantialEntity(), this.fromDebtAccount, settlementNumberSeries, now, now, null, null);
            for (FinantialDocumentEntry objectEntry : objectDebitNote.getFinantialDocumentEntriesSet()) {
                if (!TreasuryConstants.isPositive(((DebitEntry)((Object)objectEntry)).getOpenAmount())) continue;
                DebitEntry debitEntry = (DebitEntry)((Object)objectEntry);
                BigDecimal openAmount = debitEntry.getOpenAmount();
                BigDecimal availableCreditAmount = debitEntry.getAvailableAmountWithVatForCredit();
                DebitEntry destinyDebitEntry = null;
                SettlementEntry destinySettlementEntry = null;
                if (!debitEntry.getFinantialDocument().getDocumentNumberSeries().getSeries().isRegulationSeries() && TreasuryConstants.isGreaterOrEqualThan(availableCreditAmount, openAmount)) {
                    debitEntry.getCurrency();
                    BigDecimal openAmountWithoutVat = Currency.getValueWithScale(TreasuryConstants.divide(openAmount, BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)debitEntry)))));
                    CreditEntry newCreditEntry = debitEntry.createCreditEntry(now, debitEntry.getDescription(), null, null, openAmountWithoutVat, null, null, Collections.emptyMap());
                    if (newCreditEntry.getFinantialDocument().isPreparing()) {
                        newCreditEntry.getFinantialDocument().closeDocument();
                    }
                    destinySettlementEntry = SettlementEntry.create((InvoiceEntry)((Object)debitEntry), settlementNote, openAmount, debitEntry.getDescription(), now, false);
                    SettlementEntry.create((InvoiceEntry)((Object)newCreditEntry), settlementNote, openAmount, newCreditEntry.getDescription(), now, false);
                    destinyDebitEntry = this.createDestinyDebitEntry(destinyDebitNote, debitEntry);
                } else {
                    DebitEntry regulationDebitEntry;
                    CreditEntry regulationCreditEntry = StandardBalanceTransferServiceForSAPAndSINGAP.createBalanceTransferCredit(this.fromDebtAccount, now, objectDebitNote.getUiDocumentNumber(), debitEntry.getProduct(), openAmount, payorDebtAccount, null, debitEntry.getFinantialEntity());
                    if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && (objectDebitNote.isExportedInLegacyERP() || objectDebitNote.getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE))) {
                        regulationCreditEntry.getFinantialDocument().setExportedInLegacyERP(true);
                        regulationCreditEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
                    }
                    if (regulationCreditEntry.getFinantialDocument().isPreparing()) {
                        regulationCreditEntry.getFinantialDocument().closeDocument();
                    }
                    destinySettlementEntry = SettlementEntry.create((InvoiceEntry)((Object)debitEntry), settlementNote, openAmount, debitEntry.getDescription(), now, false);
                    SettlementEntry.create((InvoiceEntry)((Object)regulationCreditEntry), settlementNote, openAmount, regulationCreditEntry.getDescription(), now, false);
                    destinyDebitEntry = regulationDebitEntry = StandardBalanceTransferServiceForSAPAndSINGAP.createBalanceTransferDebit(debitEntry.getFinantialEntity(), this.destinyDebtAccount, debitEntry.getEntryDateTime(), debitEntry.getDueDate(), regulationCreditEntry.getFinantialDocument().getUiDocumentNumber(), debitEntry.getProduct(), openAmount, payorDebtAccount, debitEntry.getDescription(), debitEntry.getInterestRate());
                    if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && (objectDebitNote.isExportedInLegacyERP() || objectDebitNote.getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE))) {
                        regulationDebitEntry.getFinantialDocument().setExportedInLegacyERP(true);
                        regulationDebitEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
                    }
                    regulationDebitEntry.getFinantialDocument().closeDocument();
                }
                this.conversionMap.put(debitEntry, destinyDebitEntry);
                this.settlementOfDebitEntryMap.put(debitEntry, destinySettlementEntry);
            }
            settlementNote.markAsUsedInBalanceTransfer();
            settlementNote.closeDocument();
        }
    }

    private DebitEntry createDestinyDebitEntry(DebitNote destinyDebitNote, DebitEntry debitEntry) {
        BigDecimal openAmountWithoutVat = TreasuryConstants.divide(debitEntry.getOpenAmount(), BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)debitEntry))));
        DebitEntry newDebitEntry = DebitEntry.create(debitEntry.getFinantialEntity(), this.destinyDebtAccount, debitEntry.getTreasuryEvent(), debitEntry.getVat(), openAmountWithoutVat, debitEntry.getDueDate(), debitEntry.getPropertiesMap(), debitEntry.getProduct(), debitEntry.getDescription(), debitEntry.getQuantity(), debitEntry.getInterestRate(), debitEntry.getEntryDateTime(), debitEntry.isAcademicalActBlockingSuspension(), debitEntry.isBlockAcademicActsOnDebt(), destinyDebitNote);
        return newDebitEntry;
    }

    private void anullPreparingDebitNote(DebitNote objectDebitNote) {
        DateTime now = new DateTime();
        DebitNote newDebitNote = DebitNote.create(objectDebitNote.getFinantialEntity(), this.destinyDebtAccount, objectDebitNote.getPayorDebtAccount(), objectDebitNote.getDocumentNumberSeries(), now, now.toLocalDate(), "", Collections.emptyMap(), null, null);
        for (FinantialDocumentEntry objectEntry : objectDebitNote.getFinantialDocumentEntriesSet()) {
            DebitEntry debitEntry = (DebitEntry)((Object)objectEntry);
            BigDecimal unitAmount = debitEntry.getAmount();
            if (!TreasuryConstants.isPositive(unitAmount)) continue;
            if (debitEntry.getTreasuryEvent() != null) {
                debitEntry.annulOnEvent();
            }
            DebitEntry newDebitEntry = DebitEntry.create(debitEntry.getFinantialEntity(), this.destinyDebtAccount, debitEntry.getTreasuryEvent(), debitEntry.getVat(), unitAmount, debitEntry.getDueDate(), debitEntry.getPropertiesMap(), debitEntry.getProduct(), debitEntry.getDescription(), debitEntry.getQuantity(), debitEntry.getInterestRate(), debitEntry.getEntryDateTime(), debitEntry.isAcademicalActBlockingSuspension(), debitEntry.isBlockAcademicActsOnDebt(), newDebitNote);
            debitEntry.getTreasuryExemptionsSet().forEach(treasuryExemption -> TreasuryExemption.create(treasuryExemption.getTreasuryExemptionType(), treasuryExemption.getReason(), treasuryExemption.getNetAmountToExempt(), newDebitEntry));
            this.conversionMap.put(debitEntry, newDebitEntry);
        }
        objectDebitNote.anullDebitNoteWithCreditNote(TreasuryConstants.treasuryBundle("label.BalanceTransferService.annuled.reason", new String[0]), false);
    }

    public static LocalizedString getPresentationName() {
        return TreasuryConstants.treasuryBundleI18N("label.StandardBalanceTransferServiceForSAPAndSINGAP.presentationName", new String[0]);
    }

    @Override
    public boolean isAutoTransferInSwitchDebtAccountsEnabled() {
        return false;
    }

    @Deprecated
    private static CreditEntry createBalanceTransferCredit(DebtAccount debtAccount, DateTime documentDate, String originNumber, Product product, BigDecimal amountWithVat, DebtAccount payorDebtAccount, String entryDescription, FinantialEntity finantialEntity) {
        FinantialInstitution finantialInstitution = debtAccount.getFinantialInstitution();
        Series regulationSeries = finantialInstitution.getRegulationSeries();
        DocumentNumberSeries numberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), regulationSeries);
        Vat transferVat = Vat.findActiveUnique(product.getVatType(), finantialInstitution, documentDate).get();
        if (Strings.isNullOrEmpty((String)entryDescription)) {
            entryDescription = product.getName().getContent();
        }
        CreditNote creditNote = CreditNote.create(finantialEntity, debtAccount, numberSeries, payorDebtAccount, documentDate, originNumber);
        BigDecimal amountWithoutVat = Currency.getValueWithScale(TreasuryConstants.divide(amountWithVat, TreasuryConstants.divide(transferVat.getTaxRate(), TreasuryConstants.HUNDRED_PERCENT).add(BigDecimal.ONE)));
        CreditEntry entry = CreditEntry.create(finantialEntity, (FinantialDocument)((Object)creditNote), entryDescription, product, transferVat, amountWithoutVat, documentDate, BigDecimal.ONE);
        if (finantialInstitution.isToCloseCreditNoteWhenCreated()) {
            creditNote.closeDocument();
        }
        return entry;
    }

    @Deprecated
    private static DebitEntry createBalanceTransferDebit(FinantialEntity finantialEntity, DebtAccount debtAccount, DateTime entryDate, LocalDate dueDate, String originNumber, Product product, BigDecimal amountWithVat, DebtAccount payorDebtAccount, String entryDescription, InterestRate interestRate) {
        FinantialInstitution finantialInstitution = debtAccount.getFinantialInstitution();
        Series regulationSeries = finantialInstitution.getRegulationSeries();
        DocumentNumberSeries numberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), regulationSeries);
        Vat transferVat = Vat.findActiveUnique(product.getVatType(), finantialInstitution, entryDate).get();
        if (Strings.isNullOrEmpty((String)entryDescription)) {
            entryDescription = product.getName().getContent();
        }
        DebitNote debitNote = DebitNote.create(finantialEntity, debtAccount, payorDebtAccount, numberSeries, new DateTime(), new DateTime().toLocalDate(), originNumber, Collections.emptyMap(), null, null);
        BigDecimal amountWithoutVat = Currency.getValueWithScale(TreasuryConstants.divide(amountWithVat, TreasuryConstants.divide(transferVat.getTaxRate(), TreasuryConstants.HUNDRED_PERCENT).add(BigDecimal.ONE)));
        return DebitEntry.create(finantialEntity, debtAccount, null, transferVat, amountWithoutVat, dueDate, Maps.newHashMap(), product, entryDescription, BigDecimal.ONE, interestRate, entryDate, false, false, debitNote);
    }
}

