/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto.PaymentPlans;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanConfigurator;
import org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.PaymentPlanValidator;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.PaymentPlans.InstallmentBean;
import org.fenixedu.treasury.dto.SettlementDebitEntryBean;
import org.joda.time.LocalDate;

public class PaymentPlanBean {
    private FinantialEntity finantialEntity;
    private DebtAccount debtAccount;
    private String paymentPlanId;
    private LocalDate creationDate;
    private String reason;
    private BigDecimal emolumentAmount;
    private int nbInstallments;
    private LocalDate startDate;
    private LocalDate endDate;
    private PaymentPlanValidator paymentPlanValidator;
    private PaymentPlanConfigurator paymentPlanConfigurator;
    private List<InstallmentBean> installmentsBean;
    private String interestChangeReason;
    private Set<ISettlementInvoiceEntryBean> settlementInvoiceEntryBeans;
    private List<? extends ISettlementInvoiceEntryBean> allDebits;
    private boolean isChanged;
    private boolean withInitialValues;

    public PaymentPlanBean(FinantialEntity finantialEntity, DebtAccount debtAccount, LocalDate creationDate) {
        this.finantialEntity = finantialEntity;
        this.settlementInvoiceEntryBeans = new HashSet<ISettlementInvoiceEntryBean>();
        this.emolumentAmount = BigDecimal.ZERO;
        this.debtAccount = debtAccount;
        this.creationDate = creationDate;
        this.isChanged = false;
        this.withInitialValues = true;
        this.updateDebits();
    }

    public void updateFinantialEntity(FinantialEntity finantialEntity) {
        if (this.finantialEntity != finantialEntity) {
            this.settlementInvoiceEntryBeans = new HashSet<ISettlementInvoiceEntryBean>();
            this.setFinantialEntity(finantialEntity);
            this.updateDebits();
            this.installmentsBean = null;
            this.isChanged = true;
        }
    }

    private void updateDebits() {
        this.allDebits = this.debtAccount.getPendingInvoiceEntriesSet().stream().filter(f -> f.isDebitNoteEntry() && !((DebitEntry)((Object)((Object)f))).isInOpenPaymentPlan()).map(debitEntry -> {
            SettlementDebitEntryBean debitEntryBean = new SettlementDebitEntryBean((DebitEntry)((Object)((Object)debitEntry)));
            debitEntryBean.setSettledAmount(((DebitEntry)((Object)((Object)debitEntry))).getOpenAmountWithInterestsAtDate(this.creationDate));
            return debitEntryBean;
        }).filter(f -> this.finantialEntity == null || !f.isForDebitEntry() || f.getInvoiceEntry().getFinantialEntity() == null || f.getInvoiceEntry().getFinantialEntity() == this.finantialEntity).collect(Collectors.toList());
    }

    public void updateDebitEntriesSettleAmountInPaymentPlan() {
        for (ISettlementInvoiceEntryBean iSettlementInvoiceEntryBean : this.allDebits) {
            if (!iSettlementInvoiceEntryBean.isForDebitEntry()) continue;
            SettlementDebitEntryBean debitEntryBean = (SettlementDebitEntryBean)iSettlementInvoiceEntryBean;
            debitEntryBean.setSettledAmount(debitEntryBean.getDebitEntry().getOpenAmountWithInterestsAtDate(this.creationDate));
        }
    }

    public List<InstallmentBean> getInstallmentsBean() {
        if (this.installmentsBean == null || this.isChanged) {
            this.createInstallmentsBean(null, null);
        }
        return this.installmentsBean;
    }

    public BigDecimal getEmolumentAmount() {
        return this.emolumentAmount;
    }

    public void setEmolumentAmount(BigDecimal emolumentAmount) {
        this.emolumentAmount = emolumentAmount;
        this.isChanged = true;
    }

    public int getNbInstallments() {
        return this.nbInstallments;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public void setNbInstallments(int nbInstallments) {
        this.nbInstallments = nbInstallments;
        this.isChanged = true;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
        this.isChanged = true;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
        this.isChanged = true;
    }

    public String getPaymentPlanId() {
        return this.paymentPlanId;
    }

    public void setPaymentPlanId(String paymentPlanId) {
        this.paymentPlanId = paymentPlanId;
        this.isChanged = true;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
        this.isChanged = true;
    }

    public void setInstallmentsBean(List<InstallmentBean> installmentsBean) {
        this.installmentsBean = installmentsBean;
    }

    public boolean isChangedInstallmentPlan() {
        return this.isChanged;
    }

    public BigDecimal getTotalInstallments() {
        return this.getInstallmentsBean().stream().map(i -> i.getInstallmentAmount()).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
    }

    public FinantialEntity getFinantialEntity() {
        return this.finantialEntity;
    }

    public void setFinantialEntity(FinantialEntity finantialEntity) {
        this.finantialEntity = finantialEntity;
    }

    public DebtAccount getDebtAccount() {
        return this.debtAccount;
    }

    public void setDebtAccount(DebtAccount debtAccount) {
        this.debtAccount = debtAccount;
    }

    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public PaymentPlanValidator getPaymentPlanValidator() {
        return this.paymentPlanValidator;
    }

    public void setPaymentPlanValidator(PaymentPlanValidator paymentPlanValidator) {
        this.paymentPlanValidator = paymentPlanValidator;
        this.isChanged = true;
    }

    public boolean isWithInitialValues() {
        return this.withInitialValues;
    }

    public void setWithInitialValues(boolean withInitialValues) {
        this.withInitialValues = withInitialValues;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public PaymentPlanConfigurator getPaymentPlanConfigurator() {
        return this.paymentPlanConfigurator;
    }

    public void setPaymentPlanConfigurator(PaymentPlanConfigurator paymentPlanConfigurator) {
        this.paymentPlanConfigurator = paymentPlanConfigurator;
        this.paymentPlanId = paymentPlanConfigurator.getNumberGenerators().getNextNumberPreview();
    }

    public Set<ISettlementInvoiceEntryBean> getSettlementInvoiceEntryBeans() {
        return this.settlementInvoiceEntryBeans;
    }

    public void setSettlementInvoiceEntryBeans(Set<ISettlementInvoiceEntryBean> settlementInvoiceEntryBeans) {
        this.settlementInvoiceEntryBeans = settlementInvoiceEntryBeans;
    }

    public void addSettlementInvoiceEntryBean(ISettlementInvoiceEntryBean settlementInvoiceEntryBeans) {
        this.settlementInvoiceEntryBeans.add(settlementInvoiceEntryBeans);
    }

    public void removeSettlementInvoiceEntryBean(ISettlementInvoiceEntryBean settlementInvoiceEntryBeans) {
        this.settlementInvoiceEntryBeans.remove(settlementInvoiceEntryBeans);
    }

    public void createInstallmentsBean(List<LocalDate> fixedDates, List<BigDecimal> fixedAmounts) {
        if (fixedDates != null && !fixedDates.isEmpty()) {
            this.setStartDate(fixedDates.get(0));
            this.setEndDate(fixedDates.get(fixedDates.size() - 1));
        }
        this.installmentsBean = this.paymentPlanConfigurator.getInstallmentsBeansFor(this, fixedDates, fixedAmounts);
        this.isChanged = false;
    }

    public List<? extends ISettlementInvoiceEntryBean> getAllDebits() {
        return this.allDebits;
    }

    public void setAllDebits(List<? extends ISettlementInvoiceEntryBean> allDebits) {
        this.allDebits = allDebits;
    }

    public String getInterestChangeReason() {
        return this.interestChangeReason;
    }

    public void setInterestChangeReason(String interestChangeReason) {
        this.interestChangeReason = interestChangeReason;
    }
}

