/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Series$callable$create;
import org.fenixedu.treasury.domain.document.Series$callable$create$1;
import org.fenixedu.treasury.domain.document.Series$callable$delete;
import org.fenixedu.treasury.domain.document.Series$callable$edit;
import org.fenixedu.treasury.domain.document.Series_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Series
extends Series_Base {
    private static final Comparator<Series> COMPARATOR_BY_CODE;
    public static final Comparator<Series> COMPARATOR_BY_DEFAULT;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;
    public static final Advice advice$create$1;

    protected Series() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected Series(FinantialInstitution finantialInstitution, FinantialEntity finantialEntity, String code, LocalizedString name, boolean externSeries, boolean legacy, boolean defaultSeries, boolean selectable) {
        this();
        this.setActive(true);
        this.setFinantialInstitution(finantialInstitution);
        this.setFinantialEntity(finantialEntity);
        this.setCode(code);
        this.setName(name);
        this.setExternSeries(externSeries);
        this.setLegacy(legacy);
        this.setDefaultSeries(defaultSeries);
        this.setSelectable(selectable);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.Series.finantialInstitution.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.Series.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.Series.name.required", new String[0]);
        }
        Series.findByCode(this.getCode());
        this.getName().getLocales().stream().forEach(l -> Series.findByName(this.getName().getContent(l)));
        FinantialDocumentType.findAll().forEach(x -> {
            if (!this.getDocumentNumberSeriesSet().stream().anyMatch(series -> series.getFinantialDocumentType().equals(x))) {
                this.addDocumentNumberSeries(new DocumentNumberSeries((FinantialDocumentType)((Object)x), this));
            }
        });
        if (Boolean.TRUE.equals(this.getFinantialInstitution().getSeriesByFinantialEntity()) ? this.getFinantialEntity() != null && Series.findDefault(this.getFinantialEntity()).count() > 1L : Series.findDefault(this.getFinantialInstitution()).count() > 1L) {
            throw new TreasuryDomainException("error.Series.default.not.unique", new String[0]);
        }
    }

    public void edit(String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object = advice$edit.perform((Callable)new Series$callable$edit(this, string, localizedString, bl, bl2, bl3, bl4));
    }

    static /* synthetic */ void advised$edit(Series this_, String code, LocalizedString name, boolean externSeries, boolean legacy, boolean active, boolean selectable) {
        this_.setName(name);
        this_.setActive(active);
        if (!code.equalsIgnoreCase(this_.getCode())) {
            if (this_.isSeriesUsedForAnyDocument()) {
                throw new TreasuryDomainException("error.Series.invalid.series.type.in.used.series", new String[0]);
            }
            this_.setCode(code);
        }
        if (externSeries != this_.getExternSeries()) {
            if (this_.isSeriesUsedForAnyDocument()) {
                throw new TreasuryDomainException("error.Series.invalid.series.type.in.used.series", new String[0]);
            }
            this_.setExternSeries(externSeries);
        }
        if (legacy != this_.getLegacy()) {
            if (this_.isSeriesUsedForAnyDocument()) {
                throw new TreasuryDomainException("error.Series.invalid.series.type.in.used.series", new String[0]);
            }
            this_.setLegacy(legacy);
        }
        this_.setSelectable(selectable);
        this_.checkRules();
    }

    private boolean isSeriesUsedForAnyDocument() {
        return this.getDocumentNumberSeriesSet().stream().anyMatch(x -> !x.getFinantialDocumentsSet().isEmpty());
    }

    public boolean isDeletable() {
        return !this.getDocumentNumberSeriesSet().stream().anyMatch(x -> !x.isDeletable());
    }

    public boolean isDefaultSeries() {
        return super.getDefaultSeries();
    }

    public boolean isSelectable() {
        return super.getSelectable();
    }

    public boolean isRegulationSeries() {
        return this.getFinantialInstitution().getRegulationSeries() == this;
    }

    public boolean isActive() {
        return super.getActive();
    }

    public boolean isExternSeries() {
        return super.getExternSeries();
    }

    public boolean isLegacy() {
        return super.getLegacy();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Series$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Series this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.Series.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        for (DocumentNumberSeries ser : this_.getDocumentNumberSeriesSet()) {
            this_.removeDocumentNumberSeries(ser);
            ser.delete();
        }
        this_.setFinantialInstitution(null);
        this_.setFinantialEntity(null);
        this_.deleteDomainObject();
    }

    public static Set<Series> findAll() {
        return FenixFramework.getDomainRoot().getSeriesSet();
    }

    public static Set<Series> find(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getSeriesSet();
    }

    public static Set<Series> find(FinantialEntity finantialEntity) {
        return finantialEntity.getSeriesSet();
    }

    public static Series findByCode(String code) {
        Series result = null;
        for (Series it : Series.findAll()) {
            if (!it.getCode().equalsIgnoreCase(code)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.Series.duplicated.code", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static Series findByName(String name) {
        Series result = null;
        for (Series it : Series.findAll()) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.Series.duplicated.name", new String[0]);
            }
            result = it;
        }
        return result;
    }

    private static Stream<Series> findDefault(FinantialInstitution finantialInstitution) {
        return Series.find(finantialInstitution).stream().filter(s -> s.isDefaultSeries()).filter(s -> s.getFinantialEntity() == null);
    }

    private static Stream<Series> findDefault(FinantialEntity finantialEntity) {
        return Series.find(finantialEntity).stream().filter(s -> s.isDefaultSeries());
    }

    private static Optional<Series> findUniqueDefault(FinantialInstitution finantialInstitution) {
        return Series.findDefault(finantialInstitution).filter(s -> s.getFinantialEntity() == null).findFirst();
    }

    private static Optional<Series> findUniqueDefault(FinantialEntity finantialEntity) {
        return Series.findDefault(finantialEntity).findFirst();
    }

    public static Stream<Series> findActiveAndSelectableSeries(FinantialEntity finantialEntity) {
        if (Boolean.TRUE.equals(finantialEntity.getFinantialInstitution().getSeriesByFinantialEntity())) {
            return finantialEntity.getSeriesSet().stream().filter(s -> s.isSelectable()).filter(s -> s.isActive());
        }
        return finantialEntity.getFinantialInstitution().getSeriesSet().stream().filter(s -> s.getFinantialEntity() == null).filter(s -> s.isSelectable()).filter(s -> s.isActive());
    }

    public static Stream<Series> findActiveAndSelectableSeries(FinantialInstitution finantialInstitution) {
        return Series.find(finantialInstitution).stream().filter(s -> s.isSelectable()).filter(s -> s.isActive()).filter(s -> s.getFinantialEntity() == null);
    }

    public static Series findUniqueDefaultSeries(FinantialEntity finantialEntity) {
        FinantialInstitution finantialInstitution = finantialEntity.getFinantialInstitution();
        if (Boolean.TRUE.equals(finantialInstitution.getSeriesByFinantialEntity())) {
            return Series.findUniqueDefault(finantialEntity).orElse(null);
        }
        return Series.findUniqueDefault(finantialInstitution).orElse(null);
    }

    public static Series create(FinantialInstitution finantialInstitution, String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return (Series)((Object)advice$create.perform((Callable)new Series$callable$create(finantialInstitution, string, localizedString, bl, bl2, bl3, bl4)));
    }

    static /* synthetic */ Series advised$create(FinantialInstitution finantialInstitution, String code, LocalizedString name, boolean externSeries, boolean legacy, boolean defaultSeries, boolean selectable) {
        return new Series(finantialInstitution, null, code, name, externSeries, legacy, defaultSeries, selectable);
    }

    public static Series create(FinantialEntity finantialEntity, String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return (Series)((Object)advice$create$1.perform((Callable)new Series$callable$create$1(finantialEntity, string, localizedString, bl, bl2, bl3, bl4)));
    }

    static /* synthetic */ Series advised$create(FinantialEntity finantialEntity, String code, LocalizedString name, boolean externSeries, boolean legacy, boolean defaultSeries, boolean selectable) {
        return new Series(finantialEntity.getFinantialInstitution(), finantialEntity, code, name, externSeries, legacy, defaultSeries, selectable);
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_CODE = new Comparator<Series>(){

            @Override
            public int compare(Series o1, Series o2) {
                int c = o1.getCode().compareTo(o2.getCode());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
        COMPARATOR_BY_DEFAULT = new Comparator<Series>(){

            @Override
            public int compare(Series o1, Series o2) {
                if (o1.isDefaultSeries() && o2.isDefaultSeries()) {
                    return 1;
                }
                if (!o1.isDefaultSeries() && o2.isDefaultSeries()) {
                    return -1;
                }
                return COMPARATOR_BY_CODE.compare(o1, o2);
            }
        };
    }
}

