/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.text.StrSubstitutor;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanConfigurator$callable$delete;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanConfigurator$callable$setActive;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanConfigurator_Base;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanNumberGenerator;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxTreasuryEvent;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.dto.PaymentPenaltyEntryBean;
import org.fenixedu.treasury.dto.PaymentPlans.AddictionsCalculeTypeEnum;
import org.fenixedu.treasury.dto.PaymentPlans.InstallmentBean;
import org.fenixedu.treasury.dto.PaymentPlans.InstallmentEntryBean;
import org.fenixedu.treasury.dto.PaymentPlans.PaymentPlanBean;
import org.fenixedu.treasury.dto.SettlementInterestEntryBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaymentPlanConfigurator
extends PaymentPlanConfigurator_Base {
    private static final Comparator<ISettlementInvoiceEntryBean> COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_AFTER;
    private static final Comparator<ISettlementInvoiceEntryBean> COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_BEFORE;
    public static final Advice advice$setActive;
    public static final Advice advice$delete;

    public PaymentPlanConfigurator() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        super.setActive(Boolean.FALSE);
        this.setTreasurySettings(TreasurySettings.getInstance());
    }

    public PaymentPlanConfigurator(LocalizedString name, LocalizedString installmentDescriptionFormat, Boolean usePaymentPenalty, AddictionsCalculeTypeEnum interestDistribuition, AddictionsCalculeTypeEnum paymentPenaltyDistribuition, Product emolumentProduct, PaymentPlanNumberGenerator numberGenerator, boolean createPaymentCode) {
        this();
        this.setName(name);
        this.setInstallmentDescriptionFormat(installmentDescriptionFormat);
        this.setUsePaymentPenalty(usePaymentPenalty);
        this.setEmolumentProduct(emolumentProduct);
        this.setNumberGenerators(numberGenerator);
        this.setInterestDistribution(interestDistribuition);
        this.setPaymentPenaltyDistribution(paymentPenaltyDistribuition);
        this.setCreatePaymentCode(createPaymentCode);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getTreasurySettings() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.treasurySettings.required", new String[0]);
        }
        if (this.getInstallmentDescriptionFormat() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.InstallmentDescriptionFormat.required", new String[0]);
        }
        if (this.getEmolumentProduct() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.EmolumentProduct.required", new String[0]);
        }
        if (this.getInstallmentDescriptionFormat().anyMatch(o -> !o.contains("${paymentPlanId}"))) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.installmentDescriptionFormat.payment.plan.id.required", new String[0]);
        }
        if (this.getInstallmentDescriptionFormat().anyMatch(o -> !o.contains("${installmentNumber}"))) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.installmentDescriptionFormat.installment.number.required", new String[0]);
        }
        if (this.getNumberGenerators() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.NumberGenerators.required", new String[0]);
        }
        if (this.getInterestDistribution() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.interestDistribution.required", new String[0]);
        }
        if (Boolean.TRUE.equals(this.getUsePaymentPenalty()) && this.getPaymentPenaltyDistribution() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.paymentPenaltyDistribution.required", new String[0]);
        }
    }

    public boolean isApplyInterest() {
        return Boolean.TRUE.equals(this.getApplyDebitEntryInterest());
    }

    public void setActive(Boolean bl) {
        Object object = advice$setActive.perform((Callable)new PaymentPlanConfigurator$callable$setActive(this, bl));
    }

    static /* synthetic */ void advised$setActive(PaymentPlanConfigurator this_, Boolean active) {
        super.setActive(active);
    }

    public Boolean isActive() {
        return Boolean.TRUE.equals(this.getActive());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentPlanConfigurator$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentPlanConfigurator this_) {
        if (this_.getActive().booleanValue()) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.active.cannot.be.deleted", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setTreasurySettings(null);
        this_.setEmolumentProduct(null);
        this_.setNumberGenerators(null);
        super.deleteDomainObject();
    }

    public static Stream<PaymentPlanConfigurator> findAll() {
        return FenixFramework.getDomainRoot().getPaymentPlanConfiguratorsSet().stream();
    }

    public static Stream<PaymentPlanConfigurator> findActives() {
        return PaymentPlanConfigurator.findAll().filter(p -> Boolean.TRUE.equals(p.getActive()));
    }

    public Comparator<ISettlementInvoiceEntryBean> getComparator() {
        if (AddictionsCalculeTypeEnum.BEFORE_DEBIT_ENTRY == this.getPaymentPenaltyDistribution()) {
            return COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_BEFORE;
        }
        return COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_AFTER;
    }

    public List<InstallmentBean> getInstallmentsBeansFor(PaymentPlanBean paymentPlanBean) {
        return this.getInstallmentsBeansFor(paymentPlanBean, null, null);
    }

    public List<InstallmentBean> getInstallmentsBeansFor(PaymentPlanBean paymentPlanBean, List<LocalDate> fixedDates, List<BigDecimal> fixedAmountList) {
        this.createInterestAndTaxBeans(paymentPlanBean);
        List<InstallmentBean> installments = this.createInstallmentsList(paymentPlanBean, fixedDates);
        List<BigDecimal> installmentsMaxAmount = this.createInstallmentMaxAmountList(paymentPlanBean, fixedAmountList);
        List<ISettlementInvoiceEntryBean> invoiceEntriesToBeTreated = paymentPlanBean.getSettlementInvoiceEntryBeans().stream().sorted(this.getComparator()).collect(Collectors.toList());
        ISettlementInvoiceEntryBean currentInvoiceEntryBean = this.pullNextCurrentInvoiceEntryBean(invoiceEntriesToBeTreated);
        for (int i = 0; i < installments.size(); ++i) {
            BigDecimal installmentAmount;
            InstallmentBean currentInstallmentBean = installments.get(i);
            BigDecimal restInstallmentMaxAmount = installmentAmount = installmentsMaxAmount.get(i);
            while (currentInvoiceEntryBean != null && TreasuryConstants.isPositive(restInstallmentMaxAmount)) {
                BigDecimal installmentEntryAmount = this.getRestAmountOfBeanInPaymentPlan(currentInvoiceEntryBean, installments);
                if (!TreasuryConstants.isPositive(installmentEntryAmount)) {
                    currentInvoiceEntryBean = this.pullNextCurrentInvoiceEntryBean(invoiceEntriesToBeTreated);
                    continue;
                }
                if (TreasuryConstants.isGreaterThan(installmentEntryAmount, restInstallmentMaxAmount)) {
                    installmentEntryAmount = restInstallmentMaxAmount;
                }
                if (this.isApplyInterest() && this.getInterestDistribution().isByInstallmentEntryAmount() && this.isDebitEntry(currentInvoiceEntryBean)) {
                    List<ISettlementInvoiceEntryBean> interestEntryBeans = this.getInterestEntryBean(currentInvoiceEntryBean, invoiceEntriesToBeTreated);
                    BigDecimal restAmountOfInterestEntryBean = interestEntryBeans.stream().map(bean -> this.getRestAmountOfBeanInPaymentPlan((ISettlementInvoiceEntryBean)bean, (Collection<InstallmentBean>)installments)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal totalAmountOfInterestEntryBean = interestEntryBeans.stream().map(bean -> bean.getSettledAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (TreasuryConstants.isPositive(restAmountOfInterestEntryBean) && TreasuryConstants.isGreaterThan(restAmountOfInterestEntryBean.add(installmentEntryAmount), restInstallmentMaxAmount)) {
                        installmentEntryAmount = this.calculateDebitEntryAmountOnInstallment(restInstallmentMaxAmount, currentInvoiceEntryBean.getEntryOpenAmount(), totalAmountOfInterestEntryBean);
                        BigDecimal interestEntryAmount = restInstallmentMaxAmount.subtract(installmentEntryAmount);
                        restInstallmentMaxAmount = restInstallmentMaxAmount.subtract(interestEntryAmount);
                        this.processInterestEntryBeansToInstallmentEntryBean(installments, currentInstallmentBean, interestEntryBeans, interestEntryAmount);
                    }
                }
                this.createorUpdateInstallmentEntryBean(currentInstallmentBean, currentInvoiceEntryBean, installmentEntryAmount);
                restInstallmentMaxAmount = restInstallmentMaxAmount.subtract(installmentEntryAmount);
            }
        }
        return installments;
    }

    private void processInterestEntryBeansToInstallmentEntryBean(List<InstallmentBean> installments, InstallmentBean currentInstallmentBean, List<ISettlementInvoiceEntryBean> interestEntryBeans, BigDecimal interestEntryAmount) {
        int intrestIndex = 0;
        while (TreasuryConstants.isPositive(interestEntryAmount)) {
            ISettlementInvoiceEntryBean interestEntryBean = interestEntryBeans.get(intrestIndex);
            BigDecimal restInterestEntryBean = this.getRestAmountOfBeanInPaymentPlan(interestEntryBean, installments);
            if (TreasuryConstants.isGreaterThan(restInterestEntryBean, interestEntryAmount)) {
                restInterestEntryBean = interestEntryAmount;
            }
            this.createorUpdateInstallmentEntryBean(currentInstallmentBean, interestEntryBean, Currency.getValueWithScale(restInterestEntryBean));
            interestEntryAmount = interestEntryAmount.subtract(restInterestEntryBean);
            ++intrestIndex;
        }
    }

    private List<ISettlementInvoiceEntryBean> getInterestEntryBean(ISettlementInvoiceEntryBean currentInvoiceEntryBean, List<ISettlementInvoiceEntryBean> invoiceEntriesToBeTreated) {
        ArrayList<ISettlementInvoiceEntryBean> result = new ArrayList<ISettlementInvoiceEntryBean>();
        if (!this.isDebitEntry(currentInvoiceEntryBean)) {
            return result;
        }
        for (ISettlementInvoiceEntryBean element : invoiceEntriesToBeTreated) {
            if (currentInvoiceEntryBean == element || !currentInvoiceEntryBean.getInvoiceEntry().equals((Object)PaymentPlanConfigurator.getOriginDebitEntryFromInterestEntry(element))) continue;
            result.add(element);
        }
        return result;
    }

    private ISettlementInvoiceEntryBean pullNextCurrentInvoiceEntryBean(List<ISettlementInvoiceEntryBean> invoiceEntriesToBeTreated) {
        ISettlementInvoiceEntryBean currentInvoiceEntryBean;
        ISettlementInvoiceEntryBean iSettlementInvoiceEntryBean = currentInvoiceEntryBean = invoiceEntriesToBeTreated.isEmpty() ? null : invoiceEntriesToBeTreated.get(0);
        if (!invoiceEntriesToBeTreated.isEmpty()) {
            invoiceEntriesToBeTreated.remove(0);
        }
        return currentInvoiceEntryBean;
    }

    private BigDecimal calculateDebitEntryAmountOnInstallment(BigDecimal restInstallmentMaxAmount, BigDecimal totalDebtAmount, BigDecimal totalInterestAmount) {
        BigDecimal IAxTD = restInstallmentMaxAmount.multiply(totalDebtAmount);
        BigDecimal TDplusTI = totalDebtAmount.add(totalInterestAmount);
        BigDecimal D = TreasuryConstants.divide(IAxTD, TDplusTI);
        return Currency.getValueWithScale(D);
    }

    private BigDecimal getRestAmountOfBeanInPaymentPlan(ISettlementInvoiceEntryBean currInvoiceEntryBean, Collection<InstallmentBean> installments) {
        BigDecimal total = currInvoiceEntryBean.isForDebitEntry() ? currInvoiceEntryBean.getEntryOpenAmount() : currInvoiceEntryBean.getSettledAmount();
        Stream<InstallmentEntryBean> installmentEntryBeansWithInvoiceEntryBean = installments.stream().flatMap(inst -> inst.getInstallmentEntries().stream()).filter(entry -> entry.getInvoiceEntry() == currInvoiceEntryBean);
        BigDecimal used = installmentEntryBeansWithInvoiceEntryBean.map(entry -> entry.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        return total.subtract(used);
    }

    private List<BigDecimal> createInstallmentMaxAmountList(PaymentPlanBean paymentPlanBean, List<BigDecimal> fixedAmountList) {
        if (fixedAmountList != null && !fixedAmountList.isEmpty()) {
            return new ArrayList<BigDecimal>(fixedAmountList);
        }
        BigDecimal totalBeansAmount = paymentPlanBean.getSettlementInvoiceEntryBeans().stream().map(bean -> bean.isForDebitEntry() ? bean.getEntryOpenAmount() : bean.getSettledAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal installmentAmount = Currency.getValueWithScale(TreasuryConstants.divide(totalBeansAmount, new BigDecimal(paymentPlanBean.getNbInstallments())));
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>();
        for (int i = 0; i < paymentPlanBean.getNbInstallments() - 1; ++i) {
            result.add(installmentAmount);
            totalBeansAmount = totalBeansAmount.subtract(installmentAmount);
        }
        result.add(Currency.getValueWithScale(totalBeansAmount));
        return result;
    }

    private List<InstallmentBean> createInstallmentsList(PaymentPlanBean paymentPlanBean, List<LocalDate> dates) {
        if (dates == null || dates.isEmpty()) {
            dates = new ArrayList<LocalDate>();
            if (paymentPlanBean.getNbInstallments() == 1) {
                dates.add(paymentPlanBean.getStartDate());
            } else {
                double daysBetweenInstallments = (double)Days.daysBetween((ReadablePartial)paymentPlanBean.getStartDate(), (ReadablePartial)paymentPlanBean.getEndDate()).getDays() / ((double)paymentPlanBean.getNbInstallments() - 1.0);
                LocalDate installmentDueDate = paymentPlanBean.getStartDate();
                for (int i = 1; i <= paymentPlanBean.getNbInstallments(); ++i) {
                    if (i == paymentPlanBean.getNbInstallments()) {
                        installmentDueDate = paymentPlanBean.getEndDate();
                    }
                    dates.add(installmentDueDate);
                    installmentDueDate = paymentPlanBean.getStartDate().plusDays(Double.valueOf((double)i * daysBetweenInstallments).intValue());
                }
            }
        }
        ArrayList<InstallmentBean> result = new ArrayList<InstallmentBean>();
        for (int installmentNumber = 1; installmentNumber <= paymentPlanBean.getNbInstallments(); ++installmentNumber) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("installmentNumber", "" + installmentNumber);
            values.put("paymentPlanId", paymentPlanBean.getPaymentPlanId());
            LocalizedString installmentDescription = new LocalizedString();
            for (Locale locale : TreasuryPlataformDependentServicesFactory.implementation().availableLocales()) {
                installmentDescription = installmentDescription.with(locale, StrSubstitutor.replace((Object)this.getInstallmentDescriptionFormat().getContent(locale), values));
            }
            result.add(new InstallmentBean(dates.get(installmentNumber - 1), installmentDescription));
        }
        return result;
    }

    private void createInterestAndTaxBeans(PaymentPlanBean paymentPlanBean) {
        paymentPlanBean.setSettlementInvoiceEntryBeans(paymentPlanBean.getSettlementInvoiceEntryBeans().stream().filter(bean -> bean.isForDebitEntry() || bean.isForPendingDebitEntry()).collect(Collectors.toSet()));
        HashSet<ISettlementInvoiceEntryBean> newBeansSet = new HashSet<ISettlementInvoiceEntryBean>(paymentPlanBean.getSettlementInvoiceEntryBeans());
        for (ISettlementInvoiceEntryBean currentInvoiceEntryBean : newBeansSet) {
            PaymentPenaltyEntryBean paymentPenaltyEntryBean;
            BigDecimal interestEntryAmout;
            if (!this.isDebitEntry(currentInvoiceEntryBean)) continue;
            DebitEntry debitEntry = (DebitEntry)((Object)currentInvoiceEntryBean.getInvoiceEntry());
            if (this.isApplyInterest() && debitEntry.isApplyInterests() && TreasuryConstants.isPositive(interestEntryAmout = currentInvoiceEntryBean.getSettledAmount().subtract(currentInvoiceEntryBean.getEntryOpenAmount()))) {
                InterestRateBean interestRateBean = new InterestRateBean();
                interestRateBean.setDescription(TreasuryConstants.treasuryBundle(TreasuryConstants.DEFAULT_LANGUAGE, "label.InterestRateBean.interest.designation", debitEntry.getDescription()));
                interestRateBean.setInterestAmount(interestEntryAmout);
                SettlementInterestEntryBean interestEntryBean = new SettlementInterestEntryBean(debitEntry, interestRateBean);
                paymentPlanBean.addSettlementInvoiceEntryBean(interestEntryBean);
            }
            if (!Boolean.TRUE.equals(this.getUsePaymentPenalty()) || !this.isDebitEntry(currentInvoiceEntryBean) || this.getInterestEntryBean(currentInvoiceEntryBean, new ArrayList<ISettlementInvoiceEntryBean>(paymentPlanBean.getSettlementInvoiceEntryBeans())).isEmpty() || (paymentPenaltyEntryBean = PaymentPenaltyTaxTreasuryEvent.calculatePaymentPenaltyTax(debitEntry, paymentPlanBean.getEndDate(), paymentPlanBean.getCreationDate())) == null) continue;
            paymentPlanBean.addSettlementInvoiceEntryBean(paymentPenaltyEntryBean);
        }
    }

    private InstallmentEntryBean createorUpdateInstallmentEntryBean(InstallmentBean currentInstallmentBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean, BigDecimal installmentEntryAmount) {
        Optional<InstallmentEntryBean> installmentEntryBeanOptional = currentInstallmentBean.getInstallmentEntries().stream().filter(bean -> bean.getInvoiceEntry() == currentInvoiceEntryBean).findFirst();
        InstallmentEntryBean installmentEntryBean = null;
        if (installmentEntryBeanOptional.isEmpty()) {
            installmentEntryBean = new InstallmentEntryBean(currentInvoiceEntryBean, installmentEntryAmount);
            currentInstallmentBean.addInstallmentEntries(installmentEntryBean);
        } else {
            installmentEntryBean = installmentEntryBeanOptional.get();
            installmentEntryBean.setAmount(installmentEntryBean.getAmount().add(installmentEntryAmount));
        }
        return installmentEntryBean;
    }

    private boolean isDebitEntry(ISettlementInvoiceEntryBean currentInvoiceEntryBean) {
        return currentInvoiceEntryBean.isForDebitEntry() && ((DebitEntry)((Object)currentInvoiceEntryBean.getInvoiceEntry())).getDebitEntry() == null && !(((DebitEntry)((Object)currentInvoiceEntryBean.getInvoiceEntry())).getTreasuryEvent() instanceof PaymentPenaltyTaxTreasuryEvent);
    }

    protected static DebitEntry getOriginDebitEntryFromInterestEntry(ISettlementInvoiceEntryBean bean) {
        DebitEntry debitEntry = null;
        if (bean.isForPendingInterest() || bean.isForDebitEntry() && ((DebitEntry)((Object)bean.getInvoiceEntry())).getDebitEntry() != null) {
            debitEntry = bean.isForPendingInterest() ? ((SettlementInterestEntryBean)bean).getDebitEntry() : ((DebitEntry)((Object)bean.getInvoiceEntry())).getDebitEntry();
        }
        return debitEntry;
    }

    private static DebitEntry getOriginDebitEntryFromPenaltyTaxEntry(ISettlementInvoiceEntryBean bean) {
        DebitEntry debitEntry = null;
        if (bean.isForPaymentPenalty() || bean.isForDebitEntry() && ((DebitEntry)((Object)bean.getInvoiceEntry())).getTreasuryEvent() != null && ((DebitEntry)((Object)bean.getInvoiceEntry())).getTreasuryEvent() instanceof PaymentPenaltyTaxTreasuryEvent) {
            debitEntry = bean.isForPaymentPenalty() ? ((PaymentPenaltyEntryBean)bean).getDebitEntry() : ((PaymentPenaltyTaxTreasuryEvent)((Object)((DebitEntry)((Object)bean.getInvoiceEntry())).getTreasuryEvent())).getOriginDebitEntry();
        }
        return debitEntry;
    }

    private static int compareDebitEntryDueDate(DebitEntry debitEntry1, DebitEntry debitEntry2) {
        return new ComparatorChain((d1, d2) -> debitEntry1.getDueDate().compareTo((ReadablePartial)debitEntry2.getDueDate())).thenComparing((d1, d2) -> debitEntry1.getExternalId().compareTo(debitEntry2.getExternalId())).compare(debitEntry1, debitEntry2);
    }

    static {
        advice$setActive = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_AFTER = (s1, s2) -> {
            DebitEntry debitEntryS2;
            if (s1.isForPendingDebitEntry() || s2.isForPendingDebitEntry()) {
                return s1.isForPendingDebitEntry() ? -1 : 1;
            }
            DebitEntry interestEntryS1 = PaymentPlanConfigurator.getOriginDebitEntryFromInterestEntry(s1);
            DebitEntry penaltyTaxEntryS1 = interestEntryS1 == null ? PaymentPlanConfigurator.getOriginDebitEntryFromPenaltyTaxEntry(s1) : null;
            DebitEntry debitEntryS1 = penaltyTaxEntryS1 == null && interestEntryS1 == null ? (DebitEntry)((Object)((Object)((Object)s1.getInvoiceEntry()))) : null;
            DebitEntry interestEntryS2 = PaymentPlanConfigurator.getOriginDebitEntryFromInterestEntry(s2);
            DebitEntry penaltyTaxEntryS2 = interestEntryS2 == null ? PaymentPlanConfigurator.getOriginDebitEntryFromPenaltyTaxEntry(s2) : null;
            DebitEntry debitEntry = debitEntryS2 = penaltyTaxEntryS2 == null && interestEntryS2 == null ? (DebitEntry)((Object)((Object)((Object)s2.getInvoiceEntry()))) : null;
            if (debitEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return debitEntryS1 == interestEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return debitEntryS1 == penaltyTaxEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, penaltyTaxEntryS2);
                }
            }
            if (interestEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return interestEntryS1 == debitEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return interestEntryS1 == interestEntryS2 ? (s1.isForPendingInterest() ? 1 : -1) : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return interestEntryS1 == penaltyTaxEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, penaltyTaxEntryS2);
                }
            }
            if (penaltyTaxEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return penaltyTaxEntryS1 == debitEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return penaltyTaxEntryS1 == interestEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, penaltyTaxEntryS2);
                }
            }
            return s1.getDueDate().compareTo((ReadablePartial)s2.getDueDate());
        };
        COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_BEFORE = (s1, s2) -> {
            DebitEntry debitEntryS2;
            if (s1.isForPendingDebitEntry() || s2.isForPendingDebitEntry()) {
                return s1.isForPendingDebitEntry() ? -1 : 1;
            }
            DebitEntry interestEntryS1 = PaymentPlanConfigurator.getOriginDebitEntryFromInterestEntry(s1);
            DebitEntry penaltyTaxEntryS1 = interestEntryS1 == null ? PaymentPlanConfigurator.getOriginDebitEntryFromPenaltyTaxEntry(s1) : null;
            DebitEntry debitEntryS1 = penaltyTaxEntryS1 == null && interestEntryS1 == null ? (DebitEntry)((Object)((Object)((Object)s1.getInvoiceEntry()))) : null;
            DebitEntry interestEntryS2 = PaymentPlanConfigurator.getOriginDebitEntryFromInterestEntry(s2);
            DebitEntry penaltyTaxEntryS2 = interestEntryS2 == null ? PaymentPlanConfigurator.getOriginDebitEntryFromPenaltyTaxEntry(s2) : null;
            DebitEntry debitEntry = debitEntryS2 = penaltyTaxEntryS2 == null && interestEntryS2 == null ? (DebitEntry)((Object)((Object)((Object)s2.getInvoiceEntry()))) : null;
            if (debitEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return debitEntryS1 == interestEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return debitEntryS1 == penaltyTaxEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, penaltyTaxEntryS2);
                }
            }
            if (interestEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return interestEntryS1 == debitEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return interestEntryS1 == interestEntryS2 ? (s1.isForPendingInterest() ? 1 : -1) : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return interestEntryS1 == penaltyTaxEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, penaltyTaxEntryS2);
                }
            }
            if (penaltyTaxEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return penaltyTaxEntryS1 == debitEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return penaltyTaxEntryS1 == interestEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, penaltyTaxEntryS2);
                }
            }
            return s1.getDueDate().compareTo((ReadablePartial)s2.getDueDate());
        };
    }
}

