/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document.log;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.log.DebitEntryChangeAmountsLog_Base;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

public class DebitEntryChangeAmountsLog
extends DebitEntryChangeAmountsLog_Base {
    public DebitEntryChangeAmountsLog() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setChangeDate(new DateTime());
        this.setResponsible(TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername());
    }

    public DebitEntryChangeAmountsLog(String reason) {
        this();
        this.setReason(reason);
    }

    public static DebitEntryChangeAmountsLog log(DebitEntry debitEntry, String changeContext, String reason) {
        if (StringUtils.isEmpty((String)changeContext)) {
            throw new IllegalArgumentException("error.DebitEntryChangeAmountsLog.changeContext.required");
        }
        DebitEntryChangeAmountsLog log2 = new DebitEntryChangeAmountsLog(reason);
        log2.setDebitEntry(debitEntry);
        log2.setDebitEntryCode(debitEntry.getCode());
        log2.setOldUnitAmount(debitEntry.getAmount());
        log2.setOldQuantity(debitEntry.getQuantity());
        log2.setOldVatRate(debitEntry.getVatRate());
        log2.setOldNetAmount(debitEntry.getNetAmount());
        log2.setOldExemptedAmount(debitEntry.getNetExemptedAmount());
        log2.setOldVatAmount(debitEntry.getVatAmount());
        log2.setOldAmountWithVat(debitEntry.getAmountWithVat());
        return log2;
    }
}

