/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.bennu.signals.BennuSignalsServices;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.FinantialDocumentTypeEnum;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.ReimbursementEntry;
import org.fenixedu.treasury.domain.document.ReimbursementUtils;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$anullDocument;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$createSettlementNote;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$delete;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$edit;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$processReimbursementStateChange;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$processSettlementNoteCreation;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$updateSettlementNote;
import org.fenixedu.treasury.domain.document.SettlementNote_Base;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStatusType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentSettlementEntry;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.treasurydebtprocess.ITreasuryDebtProcess;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.SettlementCreditEntryBean;
import org.fenixedu.treasury.dto.SettlementDebitEntryBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SettlementNote
extends SettlementNote_Base {
    public static Comparator<SettlementNote> COMPARE_BY_PAYMENT_DATE;
    public static final Advice advice$edit;
    public static final Advice advice$updateSettlementNote;
    public static final Advice advice$delete;
    public static final Advice advice$processSettlementNoteCreation;
    public static final Advice advice$anullDocument;
    public static final Advice advice$processReimbursementStateChange;
    public static final Advice advice$createSettlementNote;

    protected SettlementNote() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected SettlementNote(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, DateTime paymentDate, String originDocumentNumber, String finantialTransactionReference) {
        this();
        this.init(debtAccount, documentNumberSeries, documentDate, paymentDate, originDocumentNumber, finantialTransactionReference);
    }

    protected void init(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, DateTime paymentDate, String originDocumentNumber, String finantialTransactionReference) {
        this.setFinantialTransactionReference(finantialTransactionReference);
        this.setOriginDocumentNumber(originDocumentNumber);
        if (paymentDate == null) {
            this.setPaymentDate(documentDate);
        } else {
            this.setPaymentDate(paymentDate);
        }
        super.init(debtAccount, documentNumberSeries, documentDate);
        this.checkRules();
    }

    public boolean isSettlementNote() {
        return true;
    }

    public boolean isReimbursement() {
        return this.getDocumentNumberSeries().getFinantialDocumentType() == FinantialDocumentType.findForReimbursementNote();
    }

    public BigDecimal checkDiferenceInAmount() {
        BigDecimal result = this.getTotalDebitAmount().subtract(this.getTotalCreditAmount());
        if (this.getAdvancedPaymentCreditNote() != null) {
            result = result.add(this.getAdvancedPaymentCreditNote().getTotalAmount());
        }
        if (TreasuryConstants.isZero(this.getTotalReimbursementAmount())) {
            return this.getTotalPayedAmount().subtract(result);
        }
        return this.getTotalReimbursementAmount().add(result);
    }

    public void checkRules() {
        super.checkRules();
        if (this.getPaymentDate().isAfter((ReadableInstant)this.getDocumentDate())) {
            throw new TreasuryDomainException("error.SettlementNote.invalid.payment.date.after.document.date", new String[0]);
        }
        if (!this.getDocumentNumberSeries().getFinantialDocumentType().getType().equals((Object)FinantialDocumentTypeEnum.SETTLEMENT_NOTE) && !this.getDocumentNumberSeries().getFinantialDocumentType().getType().equals((Object)FinantialDocumentTypeEnum.REIMBURSEMENT_NOTE)) {
            throw new TreasuryDomainException("error.FinantialDocument.finantialDocumentType.invalid", new String[0]);
        }
        if (this.isClosed() && this.isReimbursement() && this.getCurrentReimbursementProcessStatus() == null) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.current.status.invalid", new String[0]);
        }
        if (this.isClosed()) {
            for (Object settlementEntry : this.getSettlemetEntriesSet()) {
                if (!settlementEntry.getInvoiceEntry().isCreditNoteEntry() || settlementEntry.getInvoiceEntry().getFinantialDocument().isClosed()) continue;
                throw new TreasuryDomainException("error.SettlementNote.settlement.entry.for.credit.entry.not.closed", new String[0]);
            }
        }
        HashMap map = new HashMap();
        this.getSettlemetEntriesSet().forEach(se -> {
            map.putIfAbsent(se.getInvoiceEntry(), new LongAdder());
            ((LongAdder)map.get((Object)se.getInvoiceEntry())).increment();
        });
        for (Map.Entry entry : map.entrySet()) {
            if (((LongAdder)entry.getValue()).intValue() <= 1) continue;
            throw new TreasuryDomainException("error.SettlementNote.checkRules.invoiceEntries.not.unique", new String[0]);
        }
        if (!TreasurySettings.getInstance().getCanRegisterPaymentWithMultipleMethods() && this.getPaymentEntriesSet().size() > 1) {
            throw new TreasuryDomainException("error.SettlementNote.only.one.payment.method.is.supported", new String[0]);
        }
        boolean hasCreditEntries = this.getSettlemetEntriesSet().stream().anyMatch(se -> se.getInvoiceEntry().isCreditNoteEntry());
        boolean hasDebitEntries = this.getSettlemetEntriesSet().stream().anyMatch(se -> se.getInvoiceEntry().isDebitNoteEntry());
        if (!this.isReimbursement() && hasCreditEntries && !hasDebitEntries) {
            throw new TreasuryDomainException("error.SettlementNote.settlementNote.not.reimbursement.but.has.only.credits.settled", new String[0]);
        }
    }

    public void markAsUsedInBalanceTransfer() {
        this.setUsedInBalanceTransfer(true);
    }

    public void edit(FinantialDocumentType finantialDocumentType, DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, Currency currency, String string, DateTime dateTime, DateTime dateTime2, String string2, FinantialDocumentStateType finantialDocumentStateType) {
        Object object = advice$edit.perform((Callable)new SettlementNote$callable$edit(this, finantialDocumentType, debtAccount, documentNumberSeries, currency, string, dateTime, dateTime2, string2, finantialDocumentStateType));
    }

    static /* synthetic */ void advised$edit(SettlementNote this_, FinantialDocumentType finantialDocumentType, DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, Currency currency, String documentNumber, DateTime documentDate, DateTime paymentDate, String originDocumentNumber, FinantialDocumentStateType state) {
        this_.setFinantialDocumentType(finantialDocumentType);
        this_.setDebtAccount(debtAccount);
        this_.setDocumentNumberSeries(documentNumberSeries);
        this_.setCurrency(currency);
        this_.setDocumentNumber(documentNumber);
        this_.setDocumentDate(documentDate);
        this_.setDocumentDueDate(documentDate.toLocalDate());
        this_.setOriginDocumentNumber(originDocumentNumber);
        this_.setState(state);
        this_.setPaymentDate(paymentDate);
        this_.checkRules();
    }

    public void updateSettlementNote(String string, String string2, String string3) {
        Object object = advice$updateSettlementNote.perform((Callable)new SettlementNote$callable$updateSettlementNote(this, string, string2, string3));
    }

    static /* synthetic */ void advised$updateSettlementNote(SettlementNote this_, String originDocumentNumber, String documentObservations, String documentTermsAndConditions) {
        this_.setOriginDocumentNumber(originDocumentNumber);
        this_.setDocumentObservations(documentObservations);
        this_.setDocumentTermsAndConditions(documentTermsAndConditions);
        this_.checkRules();
    }

    public boolean isDeletable() {
        if (this.isPreparing()) {
            if (this.getAdvancedPaymentCreditNote() != null) {
                return this.getAdvancedPaymentCreditNote().isDeletable();
            }
            return true;
        }
        return false;
    }

    public boolean isAdvancePaymentSetByUser() {
        return this.getAdvancePaymentSetByUser();
    }

    public boolean isReimbursementPending() {
        if (!this.isReimbursement()) {
            return false;
        }
        if (this.getCurrentReimbursementProcessStatus() == null) {
            return false;
        }
        return this.getCurrentReimbursementProcessStatus().isInitialStatus();
    }

    public boolean isReimbursementConcluded() {
        if (!this.isReimbursement()) {
            return false;
        }
        ReimbursementProcessStatusType currentStatus = this.getCurrentReimbursementProcessStatus();
        if (currentStatus == null) {
            return false;
        }
        return currentStatus.isFinalStatus() && !currentStatus.isRejectedStatus();
    }

    public boolean isReimbursementRejected() {
        if (!this.isReimbursement()) {
            return false;
        }
        ReimbursementProcessStatusType currentStatus = this.getCurrentReimbursementProcessStatus();
        if (currentStatus == null) {
            return false;
        }
        return currentStatus.isFinalStatus() && currentStatus.isRejectedStatus();
    }

    public boolean isUsedInBalanceTransfer() {
        return this.getUsedInBalanceTransfer();
    }

    public void delete(boolean bl) {
        Object object = advice$delete.perform((Callable)new SettlementNote$callable$delete(this, bl));
    }

    static /* synthetic */ void advised$delete(SettlementNote this_, boolean deleteEntries) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.SettlementNote.cannot.delete", new String[0]);
        }
        for (PaymentEntry paymentEntry : this_.getPaymentEntriesSet()) {
            this_.removePaymentEntries(paymentEntry);
            if (deleteEntries) {
                paymentEntry.delete();
                continue;
            }
            paymentEntry.setSettlementNote(null);
        }
        for (ReimbursementEntry entry : this_.getReimbursementEntriesSet()) {
            this_.removeReimbursementEntries(entry);
            if (deleteEntries) {
                entry.delete();
                continue;
            }
            entry.setSettlementNote(null);
        }
        if (this_.getAdvancedPaymentCreditNote() != null) {
            this_.getAdvancedPaymentCreditNote().delete(true);
        }
        super.delete(deleteEntries);
    }

    public void processSettlementNoteCreation(SettlementNoteBean settlementNoteBean) {
        Object object = advice$processSettlementNoteCreation.perform((Callable)new SettlementNote$callable$processSettlementNoteCreation(this, settlementNoteBean));
    }

    static /* synthetic */ void advised$processSettlementNoteCreation(SettlementNote this_, SettlementNoteBean bean) {
        this_.processDebitEntries(bean);
        this_.processCreditEntries(bean);
        if (bean.isReimbursementNote()) {
            this_.processReimbursementEntries(bean);
        } else {
            this_.processPaymentEntries(bean);
        }
        this_.processAdvancePayments(bean);
        this_.setAdvancePaymentSetByUser(bean.isAdvancePayment());
        if (this_.isReimbursement() && this_.getSettlemetEntries().anyMatch(se -> !se.getInvoiceEntry().isCreditNoteEntry())) {
            throw new TreasuryDomainException("error.SettlementNote.reimbursement.invoice.entry.not.from.credit.note", new String[0]);
        }
    }

    private void processAdvancePayments(SettlementNoteBean bean) {
        if (bean.isReimbursementNote()) {
            return;
        }
        if (!bean.isAdvancePayment()) {
            return;
        }
        BigDecimal debitSum = bean.isReimbursementNote() ? bean.getDebtAmountWithVat().negate() : bean.getDebtAmountWithVat();
        BigDecimal paymentSum = bean.getPaymentAmount();
        BigDecimal availableAmount = paymentSum.subtract(debitSum);
        if (!TreasuryConstants.isPositive(availableAmount)) {
            return;
        }
        if (bean.getDebtAccount().getFinantialInstitution().isInvoiceRegistrationByTreasuryCertification()) {
            ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
            String comments = String.format("%s [%s]", TreasuryConstants.treasuryBundleI18N("label.SettlementNote.excessPayment", new String[0]).getContent(services.defaultLocale()), this.getPaymentDate().toString("dd/MM/yyyy"));
            this.createExcessPaymentDebitNote(bean, availableAmount, comments, this.getUiDocumentNumber());
        } else {
            String comments = String.format("%s [%s]", TreasuryConstants.treasuryBundleI18N("label.SettlementNote.advancedpayment", new String[0]).getContent(TreasuryConstants.DEFAULT_LANGUAGE), this.getPaymentDate().toString("dd/MM/yyyy"));
            this.createAdvancedPaymentCreditNote(availableAmount, comments, this.getExternalId());
        }
    }

    private void processReimbursementEntries(SettlementNoteBean bean) {
        for (SettlementNoteBean.PaymentEntryBean paymentEntryBean : bean.getPaymentEntries()) {
            ReimbursementEntry.create(this, paymentEntryBean.getPaymentMethod(), paymentEntryBean.getPaymentAmount(), paymentEntryBean.getPaymentMethodId());
        }
    }

    private void processPaymentEntries(SettlementNoteBean bean) {
        for (SettlementNoteBean.PaymentEntryBean paymentEntryBean : bean.getPaymentEntries()) {
            PaymentEntry.create(paymentEntryBean.getPaymentMethod(), this, paymentEntryBean.getPaymentAmount(), paymentEntryBean.getPaymentMethodId(), Maps.newHashMap());
        }
    }

    private void processCreditEntries(SettlementNoteBean bean) {
        boolean splitCreditEntriesWithSettledAmount = this.getDebtAccount().getFinantialInstitution().getSplitCreditEntriesWithSettledAmount();
        for (SettlementCreditEntryBean creditEntryBean : bean.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            CreditEntry creditEntry = creditEntryBean.getCreditEntry();
            BigDecimal creditAmountWithVat = creditEntryBean.getSettledAmount();
            if (bean.isReimbursementNote() && ReimbursementUtils.isCreditNoteForReimbursementMustBeClosedWithDebitNoteAndCreatedNew(creditEntry)) {
                creditEntry = ReimbursementUtils.closeWithDebitNoteAndCreateNewCreditNoteForReimbursement(creditEntry, creditAmountWithVat);
            }
            if (creditEntry.getFinantialDocument().isPreparing()) {
                if (splitCreditEntriesWithSettledAmount && TreasuryConstants.isLessThan(creditAmountWithVat, creditEntry.getOpenAmount())) {
                    creditEntry.splitCreditEntry(creditEntry.getOpenAmount().subtract(creditAmountWithVat));
                }
                creditEntry.getFinantialDocument().closeDocument();
            }
            String creditDescription = creditEntryBean.getCreditEntry().getDescription();
            SettlementEntry.create(creditEntry, creditAmountWithVat, creditDescription, this, bean.getDate());
        }
    }

    private void processDebitEntries(SettlementNoteBean bean) {
        boolean splitDebitEntriesWithSettledAmount = bean.getDebtAccount().getFinantialInstitution().getSplitDebitEntriesWithSettledAmount();
        BigDecimal paymentEntriesAmount = bean.getPaymentEntries().stream().map(p -> p.getPaymentAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal creditsAmount = bean.getCreditEntries().stream().filter(c -> c.isIncluded()).map(c -> c.getCreditAmountWithVat()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal restAmountToUse = paymentEntriesAmount.add(creditsAmount);
        DocumentNumberSeries debitNoteSeries = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), bean.getDebtAccount().getFinantialInstitution()).filter(x -> Boolean.TRUE.equals(x.getSeries().getDefaultSeries())).findFirst().orElse(null);
        ArrayList<DebitEntry> untiedDebitEntries = new ArrayList<DebitEntry>();
        for (SettlementDebitEntryBean debitEntryBean : bean.getDebitEntriesByType(SettlementDebitEntryBean.class)) {
            if (!debitEntryBean.isIncluded()) continue;
            if (!TreasuryConstants.isPositive(restAmountToUse)) {
                debitEntryBean.setSettledAmount(BigDecimal.ZERO);
                debitEntryBean.setIncluded(false);
                continue;
            }
            DebitEntry debitEntry = debitEntryBean.getDebitEntry();
            if (splitDebitEntriesWithSettledAmount && (debitEntry.getFinantialDocument() == null || debitEntry.getFinantialDocument().isPreparing()) && TreasuryConstants.isLessThan(debitEntryBean.getSettledAmount(), debitEntry.getOpenAmount())) {
                debitEntry.splitDebitEntry(debitEntry.getOpenAmount().subtract(debitEntryBean.getSettledAmount()));
            }
            if (debitEntry.getFinantialDocument() == null) {
                untiedDebitEntries.add(debitEntry);
            } else if (!debitEntry.getFinantialDocument().isClosed()) {
                debitEntry.getFinantialDocument().closeDocument();
            }
            if (TreasuryConstants.isLessThan(restAmountToUse, debitEntryBean.getSettledAmount())) {
                debitEntryBean.setSettledAmount(restAmountToUse);
            }
            restAmountToUse = restAmountToUse.subtract(debitEntryBean.getSettledAmount());
            SettlementEntry settlementEntry = SettlementEntry.create(debitEntry, debitEntryBean.getSettledAmount(), this, bean.getDate());
            InstallmentSettlementEntry.settleInstallmentEntriesOfDebitEntry(settlementEntry);
        }
        for (InstallmentPaymenPlanBean installmentPaymenPlanBean : bean.getDebitEntriesByType(InstallmentPaymenPlanBean.class)) {
            if (!installmentPaymenPlanBean.isIncluded()) continue;
            if (!TreasuryConstants.isPositive(restAmountToUse)) {
                installmentPaymenPlanBean.setSettledAmount(BigDecimal.ZERO);
                installmentPaymenPlanBean.setIncluded(false);
                continue;
            }
            if (TreasuryConstants.isLessThan(restAmountToUse, installmentPaymenPlanBean.getSettledAmount())) {
                installmentPaymenPlanBean.setSettledAmount(restAmountToUse);
            }
            restAmountToUse = restAmountToUse.subtract(installmentPaymenPlanBean.getSettledAmount());
            BigDecimal restToPay = installmentPaymenPlanBean.getSettledAmount();
            for (InstallmentEntry installmentEntry : installmentPaymenPlanBean.getInstallment().getSortedOpenInstallmentEntries()) {
                if (TreasuryConstants.isZero(restToPay)) break;
                BigDecimal debtAmount = restToPay.compareTo(installmentEntry.getOpenAmount()) > 0 ? installmentEntry.getOpenAmount() : restToPay;
                restToPay = restToPay.subtract(debtAmount);
                if (!TreasuryConstants.isPositive(debtAmount)) continue;
                if (installmentEntry.getDebitEntry().getFinantialDocument() == null) {
                    untiedDebitEntries.add(installmentEntry.getDebitEntry());
                } else if (!installmentEntry.getDebitEntry().getFinantialDocument().isClosed()) {
                    installmentEntry.getDebitEntry().getFinantialDocument().closeDocument();
                }
                SettlementEntry settlementEntry = this.getSettlementEntryByDebitEntry(installmentEntry.getDebitEntry());
                if (settlementEntry == null) {
                    settlementEntry = SettlementEntry.create(installmentEntry.getDebitEntry(), debtAmount, this, bean.getDate());
                } else {
                    settlementEntry.setAmount(settlementEntry.getAmount().add(debtAmount));
                }
                InstallmentSettlementEntry.create(installmentEntry, settlementEntry, debtAmount);
            }
            installmentPaymenPlanBean.getInstallment().getPaymentPlan().tryClosePaymentPlanByPaidOff();
        }
        if (untiedDebitEntries.size() != 0) {
            DebitNote debitNote = DebitNote.create(bean.getDebtAccount(), debitNoteSeries, bean.getDate());
            debitNote.addDebitNoteEntries(untiedDebitEntries);
            debitNote.closeDocument();
        }
    }

    public SettlementEntry getSettlementEntryByDebitEntry(DebitEntry debitEntry) {
        return this.getSettlemetEntriesSet().stream().filter(se -> se.getInvoiceEntry().equals((Object)debitEntry)).findFirst().orElse(null);
    }

    public Stream<SettlementEntry> getSettlemetEntries() {
        return this.getFinantialDocumentEntriesSet().stream().map(SettlementEntry.class::cast);
    }

    public Set<SettlementEntry> getSettlemetEntriesSet() {
        return this.getSettlemetEntries().collect(Collectors.toSet());
    }

    public Set<FinantialDocument> findRelatedDocuments(Set<FinantialDocument> documentsBaseList, Boolean includeAnulledDocuments) {
        documentsBaseList.add((FinantialDocument)((Object)this));
        for (SettlementEntry entry : this.getSettlemetEntriesSet()) {
            if (entry.getInvoiceEntry() == null || entry.getInvoiceEntry().getFinantialDocument() == null || !includeAnulledDocuments.booleanValue() && this.isAnnulled() || documentsBaseList.contains((Object)entry.getInvoiceEntry().getFinantialDocument())) continue;
            documentsBaseList.addAll(entry.getInvoiceEntry().getFinantialDocument().findRelatedDocuments(documentsBaseList, includeAnulledDocuments));
        }
        return documentsBaseList;
    }

    private void _anullDocument(String anulledReason, boolean markDocumentToExport2) {
        if (this.isPreparing()) {
            this.delete(true);
        } else if (this.isClosed()) {
            if (this.isExportedInLegacyERP()) {
                throw new TreasuryDomainException("error.SettlementNote.cannot.anull.settlement.exported.in.legacy.erp", new String[0]);
            }
            if (this.getAdvancedPaymentCreditNote() != null && this.getAdvancedPaymentCreditNote().hasValidSettlementEntries()) {
                throw new TreasuryDomainException("error.SettlementNote.cannot.anull.settlement.due.to.advanced.payment.settled", new String[0]);
            }
            if (this.getExcessPaymentDebitNote() != null && ((CreditNote)((Object)this.getExcessPaymentDebitNote().getCreditNoteSet().iterator().next())).hasValidSettlementEntries()) {
                throw new TreasuryDomainException("error.SettlementNote.cannot.anull.settlement.due.to.advanced.payment.settled", new String[0]);
            }
            if (this.isUsedInBalanceTransfer()) {
                throw new TreasuryDomainException("error.SettlementNote.cannot.anull.settlement.due.to.balance.transfer", new String[0]);
            }
            this.setState(FinantialDocumentStateType.ANNULED);
            this.setAnnulledReason(anulledReason);
            this.setAnnullmentDate(new DateTime());
            String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
            this.setAnnullmentResponsible(!Strings.isNullOrEmpty((String)loggedUsername) ? loggedUsername : "unknown");
            if (markDocumentToExport2) {
                this.markDocumentToExport();
            }
            if (this.getAdvancedPaymentCreditNote() != null) {
                this.getAdvancedPaymentCreditNote().anullDocument(anulledReason);
            }
            if (this.getExcessPaymentDebitNote() != null) {
                DateTime now = new DateTime();
                SettlementNote excessCloseSettlementNote = SettlementNote.create(this.getDebtAccount(), this.getDocumentNumberSeries(), now, now, this.getUiDocumentNumber(), null);
                DebitEntry excessDebitEntry = this.getExcessPaymentDebitNote().getDebitEntriesSet().iterator().next();
                CreditEntry excessCreditEntry = ((CreditNote)((Object)this.getExcessPaymentDebitNote().getCreditNoteSet().iterator().next())).getCreditEntriesSet().iterator().next();
                SettlementEntry.create(excessDebitEntry, excessDebitEntry.getTotalAmount(), excessCloseSettlementNote, now);
                SettlementEntry.create(excessCreditEntry, excessCreditEntry.getTotalAmount(), excessCreditEntry.getDescription(), excessCloseSettlementNote, now);
                excessCloseSettlementNote.closeDocument();
            }
            this.checkRules();
            TreasuryPlataformDependentServicesFactory.implementation().annulCertifiedDocument((FinantialDocument)((Object)this));
        } else {
            throw new TreasuryDomainException(TreasuryConstants.treasuryBundle("error.FinantialDocumentState.invalid.state.change.request", new String[0]), new String[0]);
        }
    }

    public void anullDocument(String string, boolean bl) {
        Object object = advice$anullDocument.perform((Callable)new SettlementNote$callable$anullDocument(this, string, bl));
    }

    static /* synthetic */ void advised$anullDocument(SettlementNote this_, String anulledReason, boolean markDocumentToExport2) {
        if (TreasuryDebtProcessMainService.isFinantialDocumentAnnullmentActionBlocked((FinantialDocument)((Object)this_))) {
            throw new TreasuryDomainException("error.SettlementNote.cannot.annull.due.to.existing.active.debt.process", new String[0]);
        }
        this_._anullDocument(anulledReason, markDocumentToExport2);
    }

    public void anullDocumentFromDebtProcess(String anulledReason, boolean markDocumentToExport2, ITreasuryDebtProcess debtProcess) {
        this._anullDocument(anulledReason, markDocumentToExport2);
    }

    public BigDecimal getTotalDebitAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (SettlementEntry entry : this.getSettlemetEntriesSet()) {
            if (!entry.getInvoiceEntry().isDebitNoteEntry()) continue;
            total = total.add(entry.getTotalAmount());
        }
        return total;
    }

    public void closeDocument(boolean markDocumentToExport2) {
        for (SettlementEntry settlementEntry : this.getSettlemetEntriesSet()) {
            if (!TreasuryConstants.isGreaterThan(settlementEntry.getAmount(), settlementEntry.getInvoiceEntry().getOpenAmount())) continue;
            throw new TreasuryDomainException("error.SettlementNote.invalid.settlement.entry.amount.for.invoice.entry", new String[0]);
        }
        if (!TreasuryConstants.isZero(this.checkDiferenceInAmount())) {
            throw new TreasuryDomainException("error.SettlementNote.invalid.amounts.in.settlement.note", new String[0]);
        }
        if (this.getReferencedCustomers().size() > 1) {
            throw new TreasuryDomainException("error.SettlementNote.referencedCustomers.only.one.allowed", new String[0]);
        }
        if (this.getAdvancedPaymentCreditNote() != null) {
            this.getAdvancedPaymentCreditNote().closeDocument();
        }
        if (this.isReimbursement()) {
            this.processReimbursementStateChange(ReimbursementProcessStatusType.findUniqueByInitialStatus().get(), String.valueOf(this.getDocumentDate().getYear()), new DateTime());
        }
        super.closeDocument(markDocumentToExport2);
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            boolean atLeastOneInvoiceEntryExportedInLegacyERP;
            boolean bl = atLeastOneInvoiceEntryExportedInLegacyERP = this.getSettlemetEntries().filter(s -> s.getInvoiceEntry().getFinantialDocument().isExportedInLegacyERP()).count() > 0L;
            if (atLeastOneInvoiceEntryExportedInLegacyERP) {
                if (!this.isExportedInLegacyERP()) {
                    this.setExportedInLegacyERP(true);
                    this.setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
                }
                this.getSettlemetEntries().forEach(s -> {
                    if (s.getCloseDate() == null || !s.getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1))) {
                        s.setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
                    }
                });
                if (this.getAdvancedPaymentCreditNote() != null && !this.getAdvancedPaymentCreditNote().isExportedInLegacyERP()) {
                    this.getAdvancedPaymentCreditNote().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
                    this.getAdvancedPaymentCreditNote().setExportedInLegacyERP(true);
                }
            }
        }
        this.checkRules();
        TreasuryPlataformDependentServicesFactory.implementation().certifyDocument((FinantialDocument)((Object)this));
        BennuSignalsServices.emitSignalForSettlement(this);
    }

    @Deprecated
    public void processReimbursementStateChange(ReimbursementProcessStatusType reimbursementProcessStatusType, String string, DateTime dateTime) {
        Object object = advice$processReimbursementStateChange.perform((Callable)new SettlementNote$callable$processReimbursementStateChange(this, reimbursementProcessStatusType, string, dateTime));
    }

    static /* synthetic */ void advised$processReimbursementStateChange(SettlementNote this_, ReimbursementProcessStatusType reimbursementStatus, String exerciseYear, DateTime reimbursementStatusDate) {
        if (reimbursementStatus == null) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementStatus", new String[0]);
        }
        if (!this_.isReimbursement()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.settlementNote", new String[0]);
        }
        if (!this_.isClosed() && !reimbursementStatus.isInitialStatus()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.state", new String[0]);
        }
        if (!reimbursementStatus.isInitialStatus() && this_.getCurrentReimbursementProcessStatus() == null) {
            throw new TreasuryDomainException("error.SettlementNote.currentReimbursementProcessStatus.invalid", new String[0]);
        }
        if (this_.getCurrentReimbursementProcessStatus() != null && !reimbursementStatus.isAfter(this_.getCurrentReimbursementProcessStatus())) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.next.status.invalid", new String[0]);
        }
        if (this_.getCurrentReimbursementProcessStatus() != null && this_.getCurrentReimbursementProcessStatus().isFinalStatus()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.current.status.is.final", new String[0]);
        }
        this_.setCurrentReimbursementProcessStatus(reimbursementStatus);
        if (this_.getCurrentReimbursementProcessStatus() == null) {
            throw new TreasuryDomainException("error.SettlementNote.currentReimbursementProcessStatus.invalid", new String[0]);
        }
    }

    public BigDecimal getTotalCreditAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (SettlementEntry entry : this.getSettlemetEntriesSet()) {
            if (!entry.getInvoiceEntry().isCreditNoteEntry()) continue;
            total = total.add(entry.getTotalAmount());
        }
        return total;
    }

    public BigDecimal getTotalPayedAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (PaymentEntry entry : this.getPaymentEntriesSet()) {
            total = total.add(entry.getPayedAmount());
        }
        return total;
    }

    public BigDecimal getTotalReimbursementAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (ReimbursementEntry reimbursementEntry : this.getReimbursementEntriesSet()) {
            total = total.add(reimbursementEntry.getReimbursedAmount());
        }
        return total;
    }

    public BigDecimal getTotalAmount() {
        return this.getTotalDebitAmount().subtract(this.getTotalDebitAmount());
    }

    public BigDecimal getTotalNetAmount() {
        throw new TreasuryDomainException("error.SettlementNote.totalNetAmount.not.available", new String[0]);
    }

    private void createExcessPaymentDebitNote(SettlementNoteBean bean, BigDecimal availableAmount, String comments, String originDocumentNumber) {
        FinantialInstitution finantialInstitution = this.getDebtAccount().getFinantialInstitution();
        if (this.getReferencedCustomers().size() > 1) {
            throw new TreasuryDomainException("error.SettlementNote.referencedCustomers.only.one.allowed", new String[0]);
        }
        DebtAccount payorDebtAccount = null;
        if (!this.getReferencedCustomers().isEmpty()) {
            Customer payorCustomer = this.getReferencedCustomers().iterator().next();
            if (DebtAccount.findUnique(this.getDebtAccount().getFinantialInstitution(), payorCustomer).isPresent() && DebtAccount.findUnique(this.getDebtAccount().getFinantialInstitution(), payorCustomer).get() != this.getDebtAccount()) {
                payorDebtAccount = DebtAccount.findUnique(this.getDebtAccount().getFinantialInstitution(), payorCustomer).get();
            }
        }
        BigDecimal amount = availableAmount;
        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), this.getDocumentNumberSeries().getSeries());
        DateTime now = new DateTime();
        DebitNote debitNote = DebitNote.create(this.getDebtAccount(), payorDebtAccount, documentNumberSeries, now, now.toLocalDate(), originDocumentNumber);
        Product advancePaymentProduct = TreasurySettings.getInstance().getAdvancePaymentProduct();
        Vat vat = Vat.findActiveUnique(advancePaymentProduct.getVatType(), finantialInstitution, now).get();
        DebitEntry debitEntry = DebitEntry.create(Optional.of(debitNote), this.getDebtAccount(), null, vat, amount, now.toLocalDate(), new HashMap<String, String>(), advancePaymentProduct, comments, BigDecimal.ONE, null, now);
        if (!TreasuryConstants.isEqual(debitEntry.getTotalAmount(), availableAmount)) {
            throw new RuntimeException("error.SettlementNote.createExcessPaymentDebitNote.debitEntry.totalAmount.not.equal.to.availableAmount");
        }
        debitNote.closeDocument();
        this.setExcessPaymentDebitNote(debitNote);
        SettlementEntry.create(debitEntry, availableAmount, this, bean.getDate());
    }

    public void createAdvancedPaymentCreditNote(BigDecimal availableAmount, String comments, String originDocumentNumber) {
        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), this.getDocumentNumberSeries().getSeries());
        if (this.getReferencedCustomers().size() > 1) {
            throw new TreasuryDomainException("error.SettlementNote.referencedCustomers.only.one.allowed", new String[0]);
        }
        DebtAccount payorDebtAccount = null;
        if (!this.getReferencedCustomers().isEmpty()) {
            Customer payorCustomer = this.getReferencedCustomers().iterator().next();
            if (DebtAccount.findUnique(this.getDebtAccount().getFinantialInstitution(), payorCustomer).isPresent() && DebtAccount.findUnique(this.getDebtAccount().getFinantialInstitution(), payorCustomer).get() != this.getDebtAccount()) {
                payorDebtAccount = DebtAccount.findUnique(this.getDebtAccount().getFinantialInstitution(), payorCustomer).get();
            }
        }
        AdvancedPaymentCreditNote creditNote = AdvancedPaymentCreditNote.createCreditNoteForAdvancedPayment(documentNumberSeries, this.getDebtAccount(), availableAmount, this.getDocumentDate(), comments, originDocumentNumber, payorDebtAccount);
        this.setAdvancedPaymentCreditNote(creditNote);
    }

    public boolean hasAdvancedPayment() {
        return this.getAdvancedPaymentCreditNote() != null;
    }

    protected boolean isDocumentEmpty() {
        if (this.getAdvancedPaymentCreditNote() != null) {
            return this.getAdvancedPaymentCreditNote().isDocumentEmpty() && this.getFinantialDocumentEntriesSet().isEmpty();
        }
        return this.getFinantialDocumentEntriesSet().isEmpty();
    }

    public Set<Customer> getReferencedCustomers() {
        HashSet result = Sets.newHashSet();
        for (SettlementEntry settlementEntry : this.getSettlemetEntriesSet()) {
            Invoice invoice = (Invoice)((Object)settlementEntry.getInvoiceEntry().getFinantialDocument());
            if (invoice.isForPayorDebtAccount()) {
                result.add(invoice.getPayorDebtAccount().getCustomer());
                continue;
            }
            result.add(invoice.getDebtAccount().getCustomer());
        }
        if (this.getAdvancedPaymentCreditNote() != null) {
            if (this.getAdvancedPaymentCreditNote().isForPayorDebtAccount()) {
                result.add(this.getAdvancedPaymentCreditNote().getPayorDebtAccount().getCustomer());
            } else {
                result.add(this.getAdvancedPaymentCreditNote().getDebtAccount().getCustomer());
            }
        }
        return result;
    }

    public Comparator<? extends FinantialDocumentEntry> getFinantialDocumentEntriesOrderComparator() {
        return SettlementEntry.COMPARATOR_BY_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION;
    }

    public List<? extends FinantialDocumentEntry> getFinantialDocumentEntriesOrderedByTuitionInstallmentOrderAndDescription() {
        ArrayList result = new ArrayList();
        this.getFinantialDocumentEntriesSet().stream().map(SettlementEntry.class::cast).collect(Collectors.toCollection(() -> result));
        Collections.sort(result, SettlementEntry.COMPARATOR_BY_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION);
        if (result.size() != this.getFinantialDocumentEntriesSet().size()) {
            throw new RuntimeException("error");
        }
        return result;
    }

    public void updateOverrideCertificationDateWithCloseDate(boolean overrideCertificationDateWithCloseDate, DateTime closeDate) {
        super.updateOverrideCertificationDateWithCloseDate(overrideCertificationDateWithCloseDate, closeDate);
        for (SettlementEntry settlementEntry : this.getSettlemetEntriesSet()) {
            settlementEntry.setCloseDate(closeDate);
        }
    }

    public static SettlementNote create(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, DateTime paymentDate, String originDocumentNumber, String finantialTransactionReference) {
        SettlementNote settlementNote = new SettlementNote(debtAccount, documentNumberSeries, documentDate, paymentDate, originDocumentNumber, finantialTransactionReference);
        return settlementNote;
    }

    public static SettlementNote createSettlementNote(SettlementNoteBean settlementNoteBean) {
        return (SettlementNote)((Object)advice$createSettlementNote.perform((Callable)new SettlementNote$callable$createSettlementNote(settlementNoteBean)));
    }

    static /* synthetic */ SettlementNote advised$createSettlementNote(SettlementNoteBean bean) {
        DateTime documentDate = new DateTime();
        SettlementNoteBean copy2 = SettlementNoteBean.copyForSettlementNoteCreation(bean);
        SettlementNote settlementNote = SettlementNote.create(copy2.getDebtAccount(), copy2.getDocNumSeries(), documentDate, copy2.getDate(), copy2.getOriginDocumentNumber(), (String)(!Strings.isNullOrEmpty((String)copy2.getFinantialTransactionReference()) ? copy2.getFinantialTransactionReferenceYear() + "/" + copy2.getFinantialTransactionReference() : ""));
        for (ISettlementInvoiceEntryBean virtualbean : copy2.getVirtualDebitEntries()) {
            if (!virtualbean.isIncluded() || virtualbean.getVirtualPaymentEntryHandler() == null) continue;
            virtualbean.getVirtualPaymentEntryHandler().execute(copy2, virtualbean);
        }
        settlementNote.processSettlementNoteCreation(copy2);
        settlementNote.closeDocument();
        if (settlementNote.getExcessPaymentDebitNote() != null) {
            settlementNote.getExcessPaymentDebitNote().setOriginDocumentNumber(settlementNote.getUiDocumentNumber());
            String comments = TreasuryConstants.treasuryBundleI18N("label.SettlementNote.excessPayment", new String[0]).getContent(TreasuryPlataformDependentServicesFactory.implementation().defaultLocale());
            settlementNote.getExcessPaymentDebitNote().anullDebitNoteWithCreditNote(comments, true);
            CreditNote excessCreditNote = (CreditNote)((Object)settlementNote.getExcessPaymentDebitNote().getCreditNoteSet().iterator().next());
            if (excessCreditNote.isPreparing()) {
                excessCreditNote.closeDocument();
            }
        }
        return settlementNote;
    }

    public static Stream<SettlementNote> findAll() {
        return FenixFramework.getDomainRoot().getFinantialDocumentsSet().stream().filter(x -> x instanceof SettlementNote).map(SettlementNote.class::cast);
    }

    public static Stream<SettlementNote> findByFinantialDocumentType(FinantialDocumentType finantialDocumentType) {
        return finantialDocumentType.getFinantialDocumentsSet().stream().filter(x -> x instanceof SettlementNote).map(SettlementNote.class::cast);
    }

    public static Stream<SettlementNote> findByDebtAccount(DebtAccount debtAccount) {
        return debtAccount.getFinantialDocumentsSet().stream().filter(x -> x instanceof SettlementNote).map(SettlementNote.class::cast);
    }

    public static Stream<SettlementNote> findByDocumentNumberSeries(DocumentNumberSeries documentNumberSeries) {
        return documentNumberSeries.getFinantialDocumentsSet().stream().filter(x -> x instanceof SettlementNote).map(SettlementNote.class::cast);
    }

    public static Stream<SettlementNote> findByCurrency(Currency currency) {
        return currency.getFinantialDocumentsSet().stream().filter(x -> x instanceof SettlementNote).map(SettlementNote.class::cast);
    }

    public static Stream<SettlementNote> findByDocumentNumber(String documentNumber) {
        return SettlementNote.findAll().filter(i -> documentNumber.equalsIgnoreCase(i.getDocumentNumber()));
    }

    public static Stream<SettlementNote> findByDocumentDate(DateTime documentDate) {
        return SettlementNote.findAll().filter(i -> documentDate.equals((Object)i.getDocumentDate()));
    }

    public static Stream<SettlementNote> findByDocumentDueDate(DateTime documentDueDate) {
        return SettlementNote.findAll().filter(i -> documentDueDate.equals((Object)i.getDocumentDueDate()));
    }

    public static Stream<SettlementNote> findByOriginDocumentNumber(String originDocumentNumber) {
        return SettlementNote.findAll().filter(i -> originDocumentNumber.equalsIgnoreCase(i.getOriginDocumentNumber()));
    }

    public static Stream<SettlementNote> findByState(FinantialDocumentStateType state) {
        return SettlementNote.findAll().filter(i -> state.equals((Object)i.getState()));
    }

    public static void checkMixingOfInvoiceEntriesExportedInLegacyERP(Set<? extends InvoiceEntry> invoiceEntries) {
        boolean notExportedInLegacyERP;
        boolean atLeastOneExportedInLegacyERP;
        if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            return;
        }
        boolean bl = atLeastOneExportedInLegacyERP = invoiceEntries.stream().filter(i -> i.getFinantialDocument() != null).filter(i -> i.getFinantialDocument().isExportedInLegacyERP()).count() > 0L;
        if (atLeastOneExportedInLegacyERP && (notExportedInLegacyERP = invoiceEntries.stream().anyMatch(i -> i.getFinantialDocument() == null || !i.getFinantialDocument().isExportedInLegacyERP()))) {
            throw new TreasuryDomainException("error.SettlementNote.debit.entry.mixed.exported.in.legacy.erp.not.allowed", new String[0]);
        }
    }

    public static void checkMixingOfInvoiceEntriesExportedInLegacyERP(List<ISettlementInvoiceEntryBean> invoiceEntryBeans) {
        boolean notExportedInLegacyERP;
        boolean atLeastOneExportedInLegacyERP;
        if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            return;
        }
        boolean bl = atLeastOneExportedInLegacyERP = invoiceEntryBeans.stream().filter(i -> i.getInvoiceEntry() != null).filter(i -> i.getInvoiceEntry().getFinantialDocument() != null).filter(i -> i.getInvoiceEntry().getFinantialDocument().isExportedInLegacyERP()).count() > 0L;
        if (atLeastOneExportedInLegacyERP && (notExportedInLegacyERP = invoiceEntryBeans.stream().anyMatch(i -> i.getInvoiceEntry() == null || i.getInvoiceEntry().getFinantialDocument() == null || !i.getInvoiceEntry().getFinantialDocument().isExportedInLegacyERP()))) {
            throw new TreasuryDomainException("error.SettlementNote.debit.entry.mixed.exported.in.legacy.erp.not.allowed", new String[0]);
        }
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$updateSettlementNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$processSettlementNoteCreation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$anullDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$processReimbursementStateChange = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createSettlementNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_PAYMENT_DATE = (s1, s2) -> {
            int c = s1.getPaymentDate().compareTo((ReadableInstant)s2.getPaymentDate());
            if (c != 0) {
                return c;
            }
            c = s1.getDocumentDate().compareTo((ReadableInstant)s2.getDocumentDate());
            if (c != 0) {
                return c;
            }
            return s1.getExternalId().compareTo(s2.getExternalId());
        };
    }
}

