/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.virtualpaymententries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxSettings;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxTreasuryEvent;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.PaymentPenaltyEntryBean;
import org.fenixedu.treasury.dto.SettlementDebitEntryBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.payments.virtualpaymententries.IVirtualPaymentEntryHandler;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;

public class VirtualPaymentPenaltyHandler
implements IVirtualPaymentEntryHandler {
    @Override
    public List<ISettlementInvoiceEntryBean> createISettlementInvoiceEntryBean(SettlementNoteBean settlementNoteBean) {
        if (PaymentPenaltyTaxSettings.findActive().findFirst().isEmpty()) {
            return new ArrayList<ISettlementInvoiceEntryBean>();
        }
        ArrayList<ISettlementInvoiceEntryBean> result = new ArrayList<ISettlementInvoiceEntryBean>();
        for (SettlementDebitEntryBean debitEntryBean : settlementNoteBean.getDebitEntriesByType(SettlementDebitEntryBean.class)) {
            PaymentPenaltyEntryBean calculatePaymentPenaltyTax;
            if (!debitEntryBean.isIncluded() || !TreasuryConstants.isEqual(debitEntryBean.getDebitEntry().getOpenAmount(), debitEntryBean.getSettledAmount()) || (calculatePaymentPenaltyTax = PaymentPenaltyTaxTreasuryEvent.calculatePaymentPenaltyTax(debitEntryBean.getDebitEntry(), settlementNoteBean.getDate().toLocalDate())) == null) continue;
            calculatePaymentPenaltyTax.setIncluded(!debitEntryBean.getDebitEntry().isExportedInERPAndInRestrictedPaymentMixingLegacyInvoices());
            calculatePaymentPenaltyTax.setVirtualPaymentEntryHandler(this);
            calculatePaymentPenaltyTax.setCalculationDescription(this.getCalculationDescription(settlementNoteBean, calculatePaymentPenaltyTax));
            result.add(calculatePaymentPenaltyTax);
        }
        return result;
    }

    private Map<String, List<String>> getCalculationDescription(SettlementNoteBean settlementNoteBean, PaymentPenaltyEntryBean calculatePaymentPenaltyTax) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        String title = TreasuryConstants.treasuryBundle("label.VirtualPaymentPenaltyHandler.Payment_Penalty", new String[0]);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(calculatePaymentPenaltyTax.getDebitEntry().getDescription());
        map.put(title, lines);
        return map;
    }

    @Override
    public void execute(SettlementNoteBean settlementNoteBean, ISettlementInvoiceEntryBean invoiceEntryBean) {
        if (!(invoiceEntryBean instanceof PaymentPenaltyEntryBean)) {
            return;
        }
        PaymentPenaltyEntryBean paymentPenaltyEntryBean = (PaymentPenaltyEntryBean)invoiceEntryBean;
        DebtAccount debtAccount = settlementNoteBean.getDebtAccount();
        FinantialInstitution finantialInstitution = debtAccount.getFinantialInstitution();
        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), finantialInstitution).get();
        LocalDate whenDebtCreationDate = settlementNoteBean.getDate().toLocalDate();
        DebitNote debitNote = DebitNote.create(settlementNoteBean.getFinantialEntity(), debtAccount, null, documentNumberSeries, whenDebtCreationDate.toDateTimeAtStartOfDay(), whenDebtCreationDate, null, Collections.emptyMap(), null, null);
        if (settlementNoteBean.getReferencedCustomers().size() == 1 && settlementNoteBean.getReferencedCustomers().iterator().next() != debtAccount.getCustomer()) {
            Customer payorCustomer = settlementNoteBean.getReferencedCustomers().iterator().next();
            DebtAccount payorDebtAccount = payorCustomer.getDebtAccountFor(debtAccount.getFinantialInstitution());
            debitNote.setPayorDebtAccount(payorDebtAccount);
        }
        DebitEntry paymentPenaltyEntry = PaymentPenaltyTaxTreasuryEvent.checkAndCreatePaymentPenaltyTax(paymentPenaltyEntryBean.getDebitEntry(), whenDebtCreationDate, debitNote, false);
        SettlementDebitEntryBean settlementDebitEntryBean = new SettlementDebitEntryBean(paymentPenaltyEntry);
        settlementDebitEntryBean.setIncluded(true);
        settlementNoteBean.getDebitEntries().add(settlementDebitEntryBean);
        paymentPenaltyEntryBean.setIncluded(false);
    }
}

