/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibspay.model;

import java.math.BigDecimal;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.treasury.services.payments.sibspay.SibsPayAPIService;
import org.fenixedu.treasury.services.payments.sibspay.model.SibsPayWebhookNotification;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class SibsPayWebhookNotificationWrapper
implements DigitalPlatformResultBean {
    private SibsPayWebhookNotification webhookNotification;

    public SibsPayWebhookNotificationWrapper(SibsPayWebhookNotification webhookNotification) {
        this.webhookNotification = webhookNotification;
    }

    public BigDecimal getAmount() {
        return this.webhookNotification.getAmount().getValue();
    }

    public String getMerchantTransactionId() {
        if (this.webhookNotification.getMerchant() != null) {
            return this.webhookNotification.getMerchant().getTransactionId();
        }
        return null;
    }

    public String getPaymentBrand() {
        return this.webhookNotification.getPaymentMethod();
    }

    public DateTime getPaymentDate() {
        if (this.webhookNotification.getTransactionDateTime() == null) {
            return this.webhookNotification.getTransactionDateTime();
        }
        DateTime transactionDateTimeWithSibsPayTimezone = this.webhookNotification.getTransactionDateTime();
        DateTimeZone serverTimezone = DateTimeZone.getDefault();
        int serverOffsetMillis = serverTimezone.getOffset((ReadableInstant)transactionDateTimeWithSibsPayTimezone);
        DateTime dateTimeServerTimezone = transactionDateTimeWithSibsPayTimezone.withZone(DateTimeZone.forOffsetMillis((int)serverOffsetMillis));
        return dateTimeServerTimezone;
    }

    public String getPaymentResultCode() {
        return this.webhookNotification.getPaymentStatus();
    }

    public String getPaymentResultDescription() {
        return null;
    }

    public String getPaymentType() {
        return this.webhookNotification.getPaymentMethod();
    }

    public String getTimestamp() {
        return null;
    }

    public String getTransactionId() {
        return this.webhookNotification.getTransactionID();
    }

    public String getOperationStatusCode() {
        return this.webhookNotification.getReturnStatus().getStatusCode();
    }

    public String getOperationStatusMessage() {
        return this.webhookNotification.getReturnStatus().getStatusMsg();
    }

    public String getOperationStatusDescription() {
        return this.webhookNotification.getReturnStatus().getStatusDescription();
    }

    public String getNotificationID() {
        return this.webhookNotification.getNotificationID();
    }

    public boolean isOperationSuccess() {
        return SibsPayAPIService.isOperationSuccess(this.webhookNotification.getReturnStatus().getStatusCode());
    }

    public boolean isPaid() {
        return SibsPayAPIService.isPaid(this.getPaymentResultCode());
    }

    public boolean isPending() {
        return SibsPayAPIService.isPending(this.getPaymentResultCode());
    }

    public boolean isExpired() {
        return SibsPayAPIService.isExpired(this.getPaymentResultCode());
    }

    public boolean isDeclined() {
        return SibsPayAPIService.isDeclined(this.getPaymentResultCode());
    }
}

