/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.sap;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.ERPCustomerFieldsBean;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.ReimbursementEntry;
import org.fenixedu.treasury.domain.document.ReimbursementUtils;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStatusType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.domain.integration.ERPImportOperation;
import org.fenixedu.treasury.domain.integration.IntegrationOperationLogBean;
import org.fenixedu.treasury.domain.integration.OperationFile;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.generated.sources.saft.sap.AddressStructure;
import org.fenixedu.treasury.generated.sources.saft.sap.AddressStructurePT;
import org.fenixedu.treasury.generated.sources.saft.sap.AuditFile;
import org.fenixedu.treasury.generated.sources.saft.sap.Header;
import org.fenixedu.treasury.generated.sources.saft.sap.MovementTax;
import org.fenixedu.treasury.generated.sources.saft.sap.OrderReferences;
import org.fenixedu.treasury.generated.sources.saft.sap.PaymentMethod;
import org.fenixedu.treasury.generated.sources.saft.sap.ReimbursementStatusType;
import org.fenixedu.treasury.generated.sources.saft.sap.SAFTPTMovementTaxType;
import org.fenixedu.treasury.generated.sources.saft.sap.SAFTPTPaymentType;
import org.fenixedu.treasury.generated.sources.saft.sap.SAFTPTSettlementType;
import org.fenixedu.treasury.generated.sources.saft.sap.SAFTPTSourceBilling;
import org.fenixedu.treasury.generated.sources.saft.sap.SAFTPTSourcePayment;
import org.fenixedu.treasury.generated.sources.saft.sap.SourceDocuments;
import org.fenixedu.treasury.generated.sources.saft.sap.Tax;
import org.fenixedu.treasury.generated.sources.saft.sap.TaxTable;
import org.fenixedu.treasury.generated.sources.saft.sap.TaxTableEntry;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.ReimbursementStateBean;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import org.fenixedu.treasury.services.integration.erp.SaftConfig;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentStatusWS;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationInput;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationOutput;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter$callable$checkReimbursementState;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter$callable$createSaftExportOperation;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter$callable$exportCustomersToIntegration;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter$callable$exportFinantialDocumentToIntegration;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter$callable$exportProductsToIntegration;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter$callable$processReimbursementStateChange;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter$callable$writeContentToExportOperation;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporterUtils;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SAPExporter
implements IERPExporter {
    public static final DateTime ERP_INTEGRATION_START_DATE;
    private static final int MAX_REASON = 50;
    private static final String MORADA_DESCONHECIDO = "Desconhecido";
    private static final int MAX_STREET_NAME = 90;
    private static final int MAX_BUSINESS_ID = 30;
    private static final int MAX_SOURCE_ID = 30;
    public static final String SAFT_PT_ENCODING = "UTF-8";
    public static final String ERP_HEADER_VERSION_1_00_00 = "1.0.3";
    private static Logger logger;
    private static final String SAP_CUSTOMER_ID_IN_LOG_PAT = "(?si).+clientes: \\(SAP n.? \\d+\\): \\[S\\].+";
    public static final Advice advice$createSaftExportOperation;
    public static final Advice advice$writeContentToExportOperation;
    public static final Advice advice$exportFinantialDocumentToIntegration;
    public static final Advice advice$exportCustomersToIntegration;
    public static final Advice advice$exportProductsToIntegration;
    public static final Advice advice$checkReimbursementState;
    public static final Advice advice$processReimbursementStateChange;

    protected String generateERPFile(FinantialInstitution institution, DateTime fromDate, DateTime toDate, List<? extends FinantialDocument> allDocuments, boolean generateAllCustomers, Boolean generateAllProducts, UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize) {
        int i;
        SAPExporter.checkForUnsetDocumentSeriesNumberInDocumentsToExport(allDocuments);
        AuditFile auditFile = new AuditFile();
        Header header = this.createSAFTHeader(fromDate, toDate, institution, ERP_HEADER_VERSION_1_00_00);
        auditFile.setHeader(header);
        AuditFile.MasterFiles masterFiles = new AuditFile.MasterFiles();
        auditFile.setMasterFiles(masterFiles);
        List<org.fenixedu.treasury.generated.sources.saft.sap.Product> productList = masterFiles.getProduct();
        HashMap<String, org.fenixedu.treasury.generated.sources.saft.sap.Product> productMap = new HashMap<String, org.fenixedu.treasury.generated.sources.saft.sap.Product>();
        HashSet<String> productCodes = new HashSet<String>();
        List<org.fenixedu.treasury.generated.sources.saft.sap.Customer> customerList = masterFiles.getCustomer();
        HashMap<String, ERPCustomerFieldsBean> customerMap = new HashMap<String, ERPCustomerFieldsBean>();
        if (generateAllCustomers) {
            logger.info("Reading all Customers in Institution " + institution.getCode());
            HashSet<Customer> allCustomers = new HashSet<Customer>();
            for (Object debt : institution.getDebtAccountsSet()) {
                allCustomers.add(debt.getCustomer());
            }
            i = 0;
            for (Customer customer : allCustomers) {
                ERPCustomerFieldsBean customerBean = ERPCustomerFieldsBean.fillFromCustomer(customer);
                org.fenixedu.treasury.generated.sources.saft.sap.Customer saftCustomer = SAPExporter.convertCustomerToSAFTCustomer(customerBean);
                customerMap.put(saftCustomer.getCustomerID(), customerBean);
                if (++i % 100 != 0) continue;
                logger.info("Processing " + i + "/" + allCustomers.size() + " Customers in Institution " + institution.getCode());
            }
        }
        if (generateAllProducts.booleanValue()) {
            logger.info("Reading all Customers in Institution " + institution.getCode());
            Set allProducts = institution.getAvailableProductsSet();
            i = 0;
            for (Product product : allProducts) {
                if (!productCodes.contains(product.getCode())) {
                    org.fenixedu.treasury.generated.sources.saft.sap.Product saftProduct = SAPExporter.convertProductToSAFTProduct(product);
                    productCodes.add(product.getCode());
                    productMap.put(saftProduct.getProductCode(), saftProduct);
                }
                if (++i % 100 != 0) continue;
                logger.info("Processing " + i + "/" + allProducts.size() + " Products in Institution " + institution.getCode());
            }
        }
        TaxTable taxTable = new TaxTable();
        masterFiles.setTaxTable(taxTable);
        for (Vat vat : institution.getVatsSet()) {
            if (!vat.isActiveNow()) continue;
            taxTable.getTaxTableEntry().add(SAPExporter.convertVATtoTaxTableEntry(vat, institution));
        }
        SourceDocuments sourceDocuments = new SourceDocuments();
        auditFile.setSourceDocuments(sourceDocuments);
        SourceDocuments.SalesInvoices invoices = new SourceDocuments.SalesInvoices();
        SourceDocuments.WorkingDocuments workingDocuments = new SourceDocuments.WorkingDocuments();
        SourceDocuments.Payments paymentsDocuments = new SourceDocuments.Payments();
        BigInteger numberOfPaymentsDocuments = BigInteger.ZERO;
        BigDecimal totalDebitOfPaymentsDocuments = BigDecimal.ZERO;
        BigDecimal totalCreditOfPaymentsDocuments = BigDecimal.ZERO;
        BigInteger numberOfWorkingDocuments = BigInteger.ZERO;
        BigDecimal totalDebitOfWorkingDocuments = BigDecimal.ZERO;
        BigDecimal totalCreditOfWorkingDocuments = BigDecimal.ZERO;
        invoices.setNumberOfEntries(BigInteger.ZERO);
        invoices.setTotalCredit(BigDecimal.ZERO);
        invoices.setTotalDebit(BigDecimal.ZERO);
        if (!generateAllCustomers && !generateAllProducts.booleanValue()) {
            for (FinantialDocument finantialDocument : allDocuments) {
                if ((finantialDocument.isCreditNote() || finantialDocument.isDebitNote()) && (finantialDocument.isClosed() || finantialDocument.isAnnulled())) {
                    SourceDocuments.WorkingDocuments.WorkDocument workDocument = this.convertToSAFTWorkDocument((Invoice)((Object)finantialDocument), customerMap, productMap);
                    workingDocuments.getWorkDocument().add(workDocument);
                    numberOfWorkingDocuments = numberOfWorkingDocuments.add(BigInteger.ONE);
                    if (finantialDocument.isAnnulled()) continue;
                    if (finantialDocument.isDebitNote()) {
                        totalDebitOfWorkingDocuments = totalDebitOfWorkingDocuments.add(workDocument.getDocumentTotals().getNetTotal());
                        continue;
                    }
                    if (!finantialDocument.isCreditNote()) continue;
                    totalCreditOfWorkingDocuments = totalCreditOfWorkingDocuments.add(workDocument.getDocumentTotals().getNetTotal());
                    continue;
                }
                if (finantialDocument.isSettlementNote()) continue;
                logger.info("Ignoring document " + finantialDocument.getUiDocumentNumber() + " because is not closed yet.");
            }
        }
        workingDocuments.setNumberOfEntries(numberOfWorkingDocuments);
        workingDocuments.setTotalCredit(totalCreditOfWorkingDocuments.setScale(2, RoundingMode.HALF_EVEN));
        workingDocuments.setTotalDebit(totalDebitOfWorkingDocuments.setScale(2, RoundingMode.HALF_EVEN));
        sourceDocuments.setWorkingDocuments(workingDocuments);
        paymentsDocuments.setNumberOfEntries(BigInteger.ZERO);
        paymentsDocuments.setTotalCredit(BigDecimal.ZERO);
        paymentsDocuments.setTotalDebit(BigDecimal.ZERO);
        if (!generateAllCustomers && !generateAllProducts.booleanValue()) {
            for (FinantialDocument finantialDocument : allDocuments) {
                SAPExporter.checkForUnsetDocumentSeriesNumberInDocumentsToExport(Lists.newArrayList((Object[])new FinantialDocument[]{finantialDocument}));
                if (finantialDocument.isSettlementNote() && (finantialDocument.isClosed() || finantialDocument.isAnnulled())) {
                    SourceDocuments.Payments.Payment paymentDocument = this.convertToSAFTPaymentDocument((SettlementNote)((Object)finantialDocument), customerMap, productMap);
                    paymentsDocuments.getPayment().add(paymentDocument);
                    numberOfPaymentsDocuments = numberOfPaymentsDocuments.add(BigInteger.ONE);
                    if (finantialDocument.isAnnulled()) continue;
                    totalCreditOfPaymentsDocuments = totalCreditOfPaymentsDocuments.add(((SettlementNote)((Object)finantialDocument)).getTotalCreditAmount());
                    totalDebitOfPaymentsDocuments = totalDebitOfPaymentsDocuments.add(((SettlementNote)((Object)finantialDocument)).getTotalDebitAmount());
                    continue;
                }
                if (!finantialDocument.isSettlementNote()) continue;
                logger.info("Ignoring document " + finantialDocument.getUiDocumentNumber() + " because is not closed yet.");
            }
        }
        paymentsDocuments.setNumberOfEntries(numberOfPaymentsDocuments);
        paymentsDocuments.setTotalCredit(totalCreditOfPaymentsDocuments.setScale(2, RoundingMode.HALF_EVEN));
        paymentsDocuments.setTotalDebit(totalDebitOfPaymentsDocuments.setScale(2, RoundingMode.HALF_EVEN));
        sourceDocuments.setPayments(paymentsDocuments);
        for (ERPCustomerFieldsBean eRPCustomerFieldsBean : customerMap.values()) {
            org.fenixedu.treasury.generated.sources.saft.sap.Customer customer = SAPExporter.convertCustomerToSAFTCustomer(eRPCustomerFieldsBean);
            customerList.add(customer);
        }
        for (org.fenixedu.treasury.generated.sources.saft.sap.Product product : productMap.values()) {
            productList.add(product);
        }
        if (preProcessFunctionBeforeSerialize != null) {
            auditFile = (AuditFile)preProcessFunctionBeforeSerialize.apply(auditFile);
        }
        String xml = SAPExporter.exportAuditFileToXML(auditFile);
        logger.debug("SAFT File export concluded with success.");
        return xml;
    }

    private SourceDocuments.Payments.Payment convertToSAFTPaymentDocument(SettlementNote document, Map<String, ERPCustomerFieldsBean> baseCustomers, Map<String, org.fenixedu.treasury.generated.sources.saft.sap.Product> productMap) {
        ERPCustomerFieldsBean customerBean = ERPCustomerFieldsBean.fillFromCustomer(document.getDebtAccount().getCustomer());
        SourceDocuments.Payments.Payment payment = new SourceDocuments.Payments.Payment();
        if (baseCustomers.containsKey(customerBean.getCustomerId())) {
            ERPCustomerFieldsBean customer = baseCustomers.get(customerBean.getCustomerId());
            if (!customer.getCustomerFiscalNumber().equals(customerBean.getCustomerFiscalNumber())) {
                throw new TreasuryDomainException("error.SAPExporter.customer.registered.with.different.fiscalNumber", new String[0]);
            }
        } else {
            baseCustomers.put(customerBean.getCustomerId(), customerBean);
        }
        if (!baseCustomers.containsKey(document.getDebtAccount().getCustomer().getCode())) {
            throw new TreasuryDomainException("error.SAPExporter.convertToSAFTPaymentDocument.customer.not.processed", new String[0]);
        }
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            DateTime documentDate = document.getDocumentDate();
            DateTime paymentDate = document.getPaymentDate();
            payment.setSystemEntryDate(SAPExporter.convertToXMLDateTime(dataTypeFactory, documentDate));
            payment.setTransactionDate(SAPExporter.convertToXMLDate(dataTypeFactory, paymentDate));
            payment.setPaymentType(SAFTPTPaymentType.RG);
            payment.setPaymentRefNo(document.getUiDocumentNumber());
            payment.setFinantialTransactionReference(!Strings.isNullOrEmpty((String)document.getFinantialTransactionReference()) ? document.getFinantialTransactionReference() : "");
            String creator = TreasuryPlataformDependentServicesFactory.implementation().versioningCreatorUsername(document);
            String sourceId = !Strings.isNullOrEmpty((String)creator) ? (String)Splitter.fixedLength((int)30).splitToList((CharSequence)creator).get(0) : " ";
            payment.setSourceID(sourceId);
            payment.setCustomerID(document.getDebtAccount().getCustomer().getCode());
            if (document.getReferencedCustomers().size() > 1) {
                throw new TreasuryDomainException("error.SettlementNote.referencedCustomers.only.one.allowed", new String[0]);
            }
            SourceDocuments.Payments.Payment.DocumentStatus status = new SourceDocuments.Payments.Payment.DocumentStatus();
            if (document.isAnnulled()) {
                status.setPaymentStatus("A");
            } else {
                status.setPaymentStatus("N");
            }
            DateTime versioningUpdateDate = TreasuryPlataformDependentServicesFactory.implementation().versioningUpdateDate(document);
            if (versioningUpdateDate != null) {
                status.setPaymentStatusDate(SAPExporter.convertToXMLDateTime(dataTypeFactory, versioningUpdateDate));
                Iterator versioningUpdatorUsername = TreasuryPlataformDependentServicesFactory.implementation().versioningUpdatorUsername(document);
                String sourceId2 = versioningUpdatorUsername != null ? (String)Splitter.fixedLength((int)30).splitToList((CharSequence)((Object)versioningUpdatorUsername)).get(0) : " ";
                status.setSourceID(sourceId2);
            } else {
                status.setPaymentStatusDate(payment.getSystemEntryDate());
                status.setSourceID(" ");
            }
            if (!Strings.isNullOrEmpty((String)document.getDocumentObservations())) {
                status.setReason((String)Splitter.fixedLength((int)50).splitToList((CharSequence)document.getDocumentObservations()).get(0));
            }
            if (Boolean.TRUE.equals(document.getDocumentNumberSeries().getSeries().getExternSeries()) || Boolean.TRUE.equals(document.getDocumentNumberSeries().getSeries().getLegacy())) {
                status.setSourcePayment(SAFTPTSourcePayment.I);
            } else {
                status.setSourcePayment(SAFTPTSourcePayment.P);
            }
            payment.setDocumentStatus(status);
            if (TreasuryConstants.isPositive(document.getTotalPayedAmount())) {
                for (PaymentEntry paymentEntry : document.getPaymentEntriesSet()) {
                    method = new PaymentMethod();
                    method.setPaymentAmount(paymentEntry.getPayedAmount().setScale(2, RoundingMode.HALF_EVEN));
                    method.setPaymentDate(SAPExporter.convertToXMLDate(dataTypeFactory, this.calculatePaymentDate(document)));
                    method.setPaymentMechanism(this.convertToSAFTPaymentMechanism(paymentEntry.getPaymentMethod()));
                    method.setPaymentMethodReference(!Strings.isNullOrEmpty((String)paymentEntry.getPaymentMethodId()) ? paymentEntry.getPaymentMethodId() : "");
                    payment.getPaymentMethod().add(method);
                }
                payment.setSettlementType(SAFTPTSettlementType.NL);
            } else if (TreasuryConstants.isPositive(document.getTotalReimbursementAmount())) {
                for (ReimbursementEntry reimbursmentEntry : document.getReimbursementEntriesSet()) {
                    method = new PaymentMethod();
                    method.setPaymentAmount(reimbursmentEntry.getReimbursedAmount().setScale(2, RoundingMode.HALF_EVEN));
                    method.setPaymentDate(SAPExporter.convertToXMLDate(dataTypeFactory, this.calculatePaymentDate(document)));
                    method.setPaymentMechanism(this.convertToSAFTPaymentMechanism(reimbursmentEntry.getPaymentMethod()));
                    method.setPaymentMethodReference(!Strings.isNullOrEmpty((String)reimbursmentEntry.getReimbursementMethodId()) ? reimbursmentEntry.getReimbursementMethodId() : "");
                    payment.getPaymentMethod().add(method);
                    payment.setSettlementType(SAFTPTSettlementType.NR);
                }
                SourceDocuments.Payments.Payment.ReimbursementProcess reimbursementProcess = new SourceDocuments.Payments.Payment.ReimbursementProcess();
                reimbursementProcess.setStatusDate(SAPExporter.convertToXMLDate(dataTypeFactory, document.getDocumentDate()));
                reimbursementProcess.setStatus(ReimbursementStatusType.PENDING);
                payment.setReimbursementProcess(reimbursementProcess);
            } else {
                PaymentMethod voidMethod = new PaymentMethod();
                voidMethod.setPaymentAmount(BigDecimal.ZERO);
                voidMethod.setPaymentDate(SAPExporter.convertToXMLDate(dataTypeFactory, this.calculatePaymentDate(document)));
                voidMethod.setPaymentMechanism("OU");
                voidMethod.setPaymentMethodReference("");
                payment.getPaymentMethod().add(voidMethod);
                payment.setSettlementType(SAFTPTSettlementType.NN);
            }
            SourceDocuments.Payments.Payment.DocumentTotals docTotals = new SourceDocuments.Payments.Payment.DocumentTotals();
            BigInteger i = BigInteger.ONE;
            List settlementEntriesList = document.getSettlemetEntriesSet().stream().sorted(SettlementEntry.COMPARATOR_BY_ENTRY_ORDER).collect(Collectors.toList());
            if (settlementEntriesList.size() != document.getSettlemetEntriesSet().size()) {
                throw new RuntimeException("error");
            }
            for (SettlementEntry settlementEntry : settlementEntriesList) {
                SourceDocuments.Payments.Payment.Line line = new SourceDocuments.Payments.Payment.Line();
                line.setLineNumber(i);
                SourceDocuments.Payments.Payment.Line.SourceDocumentID sourceDocument = new SourceDocuments.Payments.Payment.Line.SourceDocumentID();
                sourceDocument.setLineNumber(BigInteger.valueOf(settlementEntry.getInvoiceEntry().getEntryOrder().intValue()));
                sourceDocument.setOriginatingON(settlementEntry.getInvoiceEntry().getFinantialDocument().getUiDocumentNumber());
                sourceDocument.setInvoiceDate(SAPExporter.convertToXMLDate(dataTypeFactory, settlementEntry.getInvoiceEntry().getFinantialDocument().getDocumentDate()));
                sourceDocument.setDescription(StringUtils.abbreviate((String)settlementEntry.getDescription(), (int)200));
                line.getSourceDocumentID().add(sourceDocument);
                line.setSettlementAmount(BigDecimal.ZERO);
                if (settlementEntry.getInvoiceEntry().isDebitNoteEntry()) {
                    line.setDebitAmount(settlementEntry.getTotalAmount());
                } else if (settlementEntry.getInvoiceEntry().isCreditNoteEntry()) {
                    line.setCreditAmount(settlementEntry.getTotalAmount());
                }
                payment.getLine().add(line);
                i = i.add(BigInteger.ONE);
            }
            if (document.getAdvancedPaymentCreditNote() != null) {
                payment.setAdvancedPaymentCredit(new SourceDocuments.Payments.Payment.AdvancedPaymentCredit());
                payment.getAdvancedPaymentCredit().setCreditAmount(document.getAdvancedPaymentCreditNote().getTotalAmount().setScale(2, RoundingMode.HALF_EVEN));
                payment.getAdvancedPaymentCredit().setOriginatingON(document.getAdvancedPaymentCreditNote().getUiDocumentNumber());
                payment.getAdvancedPaymentCredit().setDescription(document.getAdvancedPaymentCreditNote().getDocumentObservations());
            }
            docTotals.setGrossTotal(document.getTotalAmount().setScale(2, RoundingMode.HALF_EVEN));
            docTotals.setNetTotal(document.getTotalAmount().setScale(2, RoundingMode.HALF_EVEN));
            docTotals.setTaxPayable(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_EVEN));
            payment.setDocumentTotals(docTotals);
            payment.setPeriod(document.getDocumentDate().getMonthOfYear());
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return payment;
    }

    private DateTime calculatePaymentDate(SettlementNote document) {
        DateTime result = document.getPaymentDate();
        for (SettlementEntry settlementEntry : document.getSettlemetEntriesSet()) {
            LocalDate certificationDate = settlementEntry.getInvoiceEntry().getFinantialDocument().getErpCertificationDate();
            if (certificationDate == null || !certificationDate.toDateTimeAtStartOfDay().isAfter((ReadableInstant)result)) continue;
            result = certificationDate.toDateTimeAtStartOfDay();
        }
        return result;
    }

    private SourceDocuments.WorkingDocuments.WorkDocument convertToSAFTWorkDocument(Invoice document, Map<String, ERPCustomerFieldsBean> baseCustomers, Map<String, org.fenixedu.treasury.generated.sources.saft.sap.Product> baseProducts) {
        ERPCustomerFieldsBean customerBean = null;
        if (document.isDebitNote()) {
            customerBean = ERPCustomerFieldsBean.fillFromDebitNote((DebitNote)((Object)document));
        } else if (document.isCreditNote()) {
            customerBean = ERPCustomerFieldsBean.fillFromCreditNote((CreditNote)((Object)document));
        } else {
            throw new RuntimeException("unknown document type");
        }
        SourceDocuments.WorkingDocuments.WorkDocument workDocument = new SourceDocuments.WorkingDocuments.WorkDocument();
        if (baseCustomers.containsKey(customerBean.getCustomerId())) {
            ERPCustomerFieldsBean customer = baseCustomers.get(customerBean.getCustomerId());
            if (!customer.getCustomerFiscalNumber().equals(customerBean.getCustomerFiscalNumber())) {
                throw new TreasuryDomainException("error.SAPExporter.customer.registered.with.different.fiscalNumber", new String[0]);
            }
        } else {
            baseCustomers.put(customerBean.getCustomerId(), customerBean);
        }
        if (document instanceof AdvancedPaymentCreditNote && ((AdvancedPaymentCreditNote)((Object)document)).getAdvancedPaymentSettlementNote() != null) {
            SourceDocuments.WorkingDocuments.WorkDocument.AdvancedPayment advancedPayment = new SourceDocuments.WorkingDocuments.WorkDocument.AdvancedPayment();
            advancedPayment.setDescription("");
            advancedPayment.setOriginatingON(((AdvancedPaymentCreditNote)((Object)document)).getAdvancedPaymentSettlementNote().getUiDocumentNumber());
            workDocument.setAdvancedPayment(advancedPayment);
        }
        if (document.getPayorDebtAccount() == document.getDebtAccount()) {
            throw new TreasuryDomainException("error.SAPExporter.payor.same.as.debt.account", new String[0]);
        }
        if (document.getPayorDebtAccount() != null) {
            if (!document.getPayorDebtAccount().getCustomer().isAdhocCustomer()) {
                throw new TreasuryDomainException("error.SAPExporter.payor.debt.account.not.adhoc.customer", new String[0]);
            }
            ERPCustomerFieldsBean payorCustomerBean = null;
            if (document.isDebitNote()) {
                payorCustomerBean = ERPCustomerFieldsBean.fillPayorFromDebitNote((DebitNote)((Object)document));
            } else if (document.isCreditNote()) {
                payorCustomerBean = ERPCustomerFieldsBean.fillPayorFromCreditNote((CreditNote)((Object)document));
            } else {
                throw new RuntimeException("unknown document type");
            }
            if (baseCustomers.containsKey(payorCustomerBean.getCustomerId())) {
                ERPCustomerFieldsBean payorCustomer = baseCustomers.get(payorCustomerBean.getCustomerId());
                if (!payorCustomer.getCustomerFiscalNumber().equals(payorCustomerBean.getCustomerFiscalNumber())) {
                    throw new TreasuryDomainException("error.SAPExporter.customer.registered.with.different.fiscalNumber", new String[0]);
                }
            } else {
                baseCustomers.put(payorCustomerBean.getCustomerId(), payorCustomerBean);
            }
        }
        try {
            CreditNote creditNote;
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            DateTime documentDate = document.getDocumentDate();
            workDocument.setDueDate(SAPExporter.convertToXMLDate(dataTypeFactory, document.getDocumentDueDate().toDateTimeAtStartOfDay()));
            workDocument.setHash(Strings.repeat((String)"0", (int)172));
            workDocument.setSystemEntryDate(SAPExporter.convertToXMLDateTime(dataTypeFactory, documentDate));
            workDocument.setWorkDate(SAPExporter.convertToXMLDate(dataTypeFactory, documentDate));
            workDocument.setDocumentNumber(document.getUiDocumentNumber());
            workDocument.setCustomerID(document.getDebtAccount().getCustomer().getCode());
            if (document.isCreditNote() && !((CreditNote)((Object)document)).isAdvancePayment() && !((CreditNote)((Object)document)).isExportedInLegacyERP() && ((creditNote = (CreditNote)((Object)document)).getDebitNote() == null || creditNote.getDebitNote().isExportedInLegacyERP())) {
                workDocument.setForceCertification(true);
            }
            workDocument.setCertificationDate(SAPExporter.convertToXMLDate(dataTypeFactory, document.getCloseDate()));
            if (document.getPayorDebtAccount() != null && document.getPayorDebtAccount() != document.getDebtAccount()) {
                workDocument.setPayorCustomerID(document.getPayorDebtAccount().getCustomer().getCode());
            }
            SourceDocuments.WorkingDocuments.WorkDocument.DocumentStatus status = new SourceDocuments.WorkingDocuments.WorkDocument.DocumentStatus();
            if (document.isAnnulled()) {
                status.setWorkStatus("A");
            } else {
                status.setWorkStatus("N");
            }
            DateTime versioningUpdateDate = TreasuryPlataformDependentServicesFactory.implementation().versioningUpdateDate(document);
            if (versioningUpdateDate != null) {
                status.setWorkStatusDate(SAPExporter.convertToXMLDateTime(dataTypeFactory, versioningUpdateDate));
                String versioningUpdatorUsername = TreasuryPlataformDependentServicesFactory.implementation().versioningUpdatorUsername(document);
                String sourceId = versioningUpdatorUsername != null ? (String)Splitter.fixedLength((int)30).splitToList((CharSequence)versioningUpdatorUsername).get(0) : " ";
                status.setSourceID(sourceId);
            } else {
                status.setWorkStatusDate(workDocument.getSystemEntryDate());
                status.setSourceID(" ");
            }
            if (Boolean.TRUE.equals(document.getDocumentNumberSeries().getSeries().getExternSeries()) || Boolean.TRUE.equals(document.getDocumentNumberSeries().getSeries().getLegacy())) {
                status.setSourceBilling(SAFTPTSourceBilling.I);
            } else {
                status.setSourceBilling(SAFTPTSourceBilling.P);
            }
            workDocument.setDocumentStatus(status);
            SourceDocuments.WorkingDocuments.WorkDocument.DocumentTotals docTotals = new SourceDocuments.WorkingDocuments.WorkDocument.DocumentTotals();
            docTotals.setGrossTotal(document.getTotalAmount().setScale(2, RoundingMode.HALF_EVEN));
            docTotals.setNetTotal(document.getTotalNetAmount().setScale(2, RoundingMode.HALF_EVEN));
            docTotals.setTaxPayable(document.getTotalAmount().subtract(document.getTotalNetAmount()).setScale(2, RoundingMode.HALF_EVEN));
            if (document.isExportedInLegacyERP()) {
                BigDecimal totalAmount = SAPExporterUtils.amountAtDate(document, ERP_INTEGRATION_START_DATE);
                BigDecimal netAmount = SAPExporterUtils.netAmountAtDate(document, ERP_INTEGRATION_START_DATE);
                docTotals.setGrossTotal(totalAmount.setScale(2, RoundingMode.HALF_EVEN));
                docTotals.setNetTotal(netAmount.setScale(2, RoundingMode.HALF_EVEN));
                docTotals.setTaxPayable(totalAmount.subtract(netAmount).setScale(2, RoundingMode.HALF_EVEN));
            }
            workDocument.setDocumentTotals(docTotals);
            workDocument.setWorkType("DC");
            workDocument.setPeriod(document.getDocumentDate().getMonthOfYear());
            String creator = TreasuryPlataformDependentServicesFactory.implementation().versioningCreatorUsername(document);
            String sourceId = !Strings.isNullOrEmpty((String)creator) ? (String)Splitter.fixedLength((int)30).splitToList((CharSequence)creator).get(0) : "";
            workDocument.setSourceID(sourceId);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        List<SourceDocuments.WorkingDocuments.WorkDocument.Line> productLines = workDocument.getLine();
        BigInteger i = BigInteger.ONE;
        for (FinantialDocumentEntry docLine : document.getFinantialDocumentEntriesSet()) {
            InvoiceEntry orderNoteLine = (InvoiceEntry)((Object)docLine);
            SourceDocuments.WorkingDocuments.WorkDocument.Line line = this.convertToSAFTWorkDocumentLine(orderNoteLine, baseProducts);
            line.setLineNumber(BigInteger.valueOf(orderNoteLine.getEntryOrder().intValue()));
            i = i.add(BigInteger.ONE);
            productLines.add(line);
        }
        return workDocument;
    }

    protected SourceDocuments.WorkingDocuments.WorkDocument.Line convertToSAFTWorkDocumentLine(InvoiceEntry entry, Map<String, org.fenixedu.treasury.generated.sources.saft.sap.Product> baseProducts) {
        FinantialInstitution institution = entry.getDebtAccount().getFinantialInstitution();
        org.fenixedu.treasury.generated.sources.saft.sap.Product currentProduct = null;
        Product product = entry.getProduct();
        if (product.getCode() != null && baseProducts.containsKey(product.getCode())) {
            currentProduct = baseProducts.get(product.getCode());
        } else {
            currentProduct = SAPExporter.convertProductToSAFTProduct(product);
            baseProducts.put(currentProduct.getProductCode(), currentProduct);
        }
        XMLGregorianCalendar documentDateCalendar = null;
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            DateTime documentDate = entry.getFinantialDocument().getDocumentDate();
            documentDateCalendar = SAPExporter.convertToXMLDate(dataTypeFactory, documentDate);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        SourceDocuments.WorkingDocuments.WorkDocument.Line line = new SourceDocuments.WorkingDocuments.WorkDocument.Line();
        if (entry.isCreditNoteEntry()) {
            line.setCreditAmount(entry.getNetAmount().setScale(2, RoundingMode.HALF_EVEN));
        } else if (entry.isDebitNoteEntry()) {
            line.setDebitAmount(entry.getNetAmount().setScale(2, RoundingMode.HALF_EVEN));
        }
        if (entry.getFinantialDocument().isExportedInLegacyERP()) {
            if (entry.isCreditNoteEntry()) {
                line.setCreditAmount(SAPExporterUtils.openAmountAtDate(entry, ERP_INTEGRATION_START_DATE).setScale(2, RoundingMode.HALF_EVEN));
            } else if (entry.isDebitNoteEntry()) {
                line.setDebitAmount(SAPExporterUtils.openAmountAtDate(entry, ERP_INTEGRATION_START_DATE).setScale(2, RoundingMode.HALF_EVEN));
            }
        }
        line.setDescription(StringUtils.abbreviate((String)entry.getDescription(), (int)200));
        List<OrderReferences> orderReferences = line.getOrderReferences();
        if (entry.isCreditNoteEntry()) {
            CreditEntry creditEntry = (CreditEntry)((Object)entry);
            if (creditEntry.getDebitEntry() != null) {
                SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata metadata = new SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata();
                metadata.setDescription(creditEntry.getDebitEntry().getERPIntegrationMetadata());
                line.setMetadata(metadata);
                OrderReferences reference = new OrderReferences();
                if (!creditEntry.getFinantialDocument().isExportedInLegacyERP()) {
                    reference.setOriginatingON(creditEntry.getDebitEntry().getFinantialDocument().getUiDocumentNumber());
                } else {
                    reference.setOriginatingON("");
                }
                reference.setOrderDate(documentDateCalendar);
                if (((DebitNote)((Object)creditEntry.getDebitEntry().getFinantialDocument())).isExportedInLegacyERP()) {
                    DebitNote debitNote = (DebitNote)((Object)creditEntry.getDebitEntry().getFinantialDocument());
                    if (!Strings.isNullOrEmpty((String)debitNote.getLegacyERPCertificateDocumentReference())) {
                        if (!creditEntry.getFinantialDocument().isExportedInLegacyERP()) {
                            reference.setOriginatingON(debitNote.getLegacyERPCertificateDocumentReference());
                        }
                    } else {
                        if (!creditEntry.getFinantialDocument().isExportedInLegacyERP() && !institution.getErpIntegrationConfiguration().isCreditsOfLegacyDebitWithoutLegacyInvoiceExportEnabled()) {
                            throw new TreasuryDomainException("error.ERPExporter.credit.note.of.legacy.debit.note.without.legacyERPCertificateDocumentReference", new String[]{debitNote.getUiDocumentNumber(), creditEntry.getFinantialDocument().getUiDocumentNumber()});
                        }
                        reference.setOriginatingON("");
                    }
                }
                reference.setLineNumber(BigInteger.ONE);
                orderReferences.add(reference);
            }
        } else if (entry.isDebitNoteEntry()) {
            DebitEntry debitEntry = (DebitEntry)((Object)entry);
            SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata metadata = new SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata();
            metadata.setDescription(debitEntry.getERPIntegrationMetadata());
            line.setMetadata(metadata);
        }
        line.setProductCode(currentProduct.getProductCode());
        line.setProductDescription(currentProduct.getProductDescription());
        line.setQuantity(entry.getQuantity());
        line.setSettlementAmount(BigDecimal.ZERO);
        line.setTax(this.getSAFTWorkingDocumentsTax(product, entry));
        line.setTaxPointDate(documentDateCalendar);
        if (TreasuryConstants.isEqual(line.getTax().getTaxPercentage(), BigDecimal.ZERO) || line.getTax().getTaxAmount() != null && TreasuryConstants.isEqual(line.getTax().getTaxAmount(), BigDecimal.ZERO)) {
            if (product.getVatExemptionReason() != null) {
                line.setTaxExemptionReason(product.getVatExemptionReason().getCode() + "-" + product.getVatExemptionReason().getName().getContent());
            } else {
                line.setTaxExemptionReason(TreasuryConstants.treasuryBundle("warning.ERPExporter.vat.exemption.unknown", new String[0]));
            }
        }
        line.setUnitOfMeasure(product.getUnitOfMeasure().getContent());
        line.setUnitPrice(TreasuryConstants.divide(entry.getNetAmount(), entry.getQuantity()).setScale(4, RoundingMode.HALF_UP));
        if (entry.getFinantialDocument().isExportedInLegacyERP()) {
            line.setUnitPrice(SAPExporterUtils.openAmountAtDate(entry, ERP_INTEGRATION_START_DATE).setScale(2, RoundingMode.HALF_EVEN));
        }
        return line;
    }

    protected Tax getSAFTWorkingDocumentsTax(Product product, InvoiceEntry entry) {
        Vat vat = entry.getVat();
        Tax tax = new Tax();
        tax.setTaxCode(vat.getVatType().getCode());
        tax.setTaxCountryRegion("PT");
        tax.setTaxPercentage(vat.getTaxRate());
        tax.setTaxType("IVA");
        return tax;
    }

    public static TaxTableEntry convertVATtoTaxTableEntry(Vat vat, FinantialInstitution finantialInstitution) {
        TaxTableEntry entry = new TaxTableEntry();
        entry.setTaxType("IVA");
        entry.setTaxCode(vat.getVatType().getName().getContent());
        if (finantialInstitution.getFiscalNumber() != null) {
            entry.setTaxCountryRegion(finantialInstitution.getFiscalCountryRegion().getFiscalCode());
            entry.setDescription(finantialInstitution.getFiscalCountryRegion().getName().getContent() + "-" + vat.getVatType().getName().getContent());
        } else {
            entry.setTaxCountryRegion("PT");
            entry.setDescription("");
        }
        entry.setTaxCode(vat.getVatType().getCode());
        entry.setTaxPercentage(vat.getTaxRate());
        if (Strings.isNullOrEmpty((String)entry.getDescription())) {
            entry.setDescription(entry.getTaxCode() + "_" + entry.getTaxCountryRegion());
        }
        return entry;
    }

    private Header createSAFTHeader(DateTime startDate, DateTime endDate, FinantialInstitution finantialInstitution, String auditVersion) {
        Header header = new Header();
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            header.setAuditFileVersion(auditVersion);
            header.setIdProcesso(finantialInstitution.getErpIntegrationConfiguration().getErpIdProcess());
            header.setBusinessName(finantialInstitution.getCompanyName());
            header.setCompanyName(finantialInstitution.getName());
            AddressStructurePT companyAddress = null;
            companyAddress = SAPExporter.convertFinantialInstitutionAddressToAddressPT(finantialInstitution.getAddress(), finantialInstitution.getZipCode(), finantialInstitution.getMunicipality() != null ? finantialInstitution.getMunicipality().getLocalizedName(new Locale("pt")) : "---", finantialInstitution.getAddress());
            header.setCompanyAddress(companyAddress);
            header.setCompanyID(finantialInstitution.getFiscalNumber());
            header.setCurrencyCode(finantialInstitution.getCurrency().getCode());
            DateTime now = new DateTime();
            header.setDateCreated(SAPExporter.convertToXMLDate(dataTypeFactory, now));
            header.setEndDate(SAPExporter.convertToXMLDate(dataTypeFactory, endDate));
            header.setFiscalYear(endDate.getYear());
            header.setProductCompanyTaxID(SaftConfig.PRODUCT_COMPANY_TAX_ID());
            header.setProductID(SaftConfig.PRODUCT_ID());
            header.setProductVersion(SaftConfig.PRODUCT_VERSION());
            header.setSoftwareCertificateNumber(BigInteger.valueOf(0L));
            header.setStartDate(dataTypeFactory.newXMLGregorianCalendarDate(startDate.getYear(), startDate.getMonthOfYear(), startDate.getDayOfMonth(), Integer.MIN_VALUE));
            header.setTaxAccountingBasis("P");
            header.setTaxEntity("Global");
            try {
                header.setTaxRegistrationNumber(Integer.parseInt(finantialInstitution.getFiscalNumber()));
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid Fiscal Number.");
            }
            return header;
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AddressStructurePT convertFinantialInstitutionAddressToAddressPT(String addressDetail, String zipCode, String zipCodeRegion, String street) {
        AddressStructurePT companyAddress = new AddressStructurePT();
        companyAddress.setCountry("PT");
        companyAddress.setAddressDetail(!Strings.isNullOrEmpty((String)addressDetail) ? addressDetail : MORADA_DESCONHECIDO);
        companyAddress.setCity(!Strings.isNullOrEmpty((String)zipCodeRegion) ? zipCodeRegion : MORADA_DESCONHECIDO);
        companyAddress.setPostalCode(!Strings.isNullOrEmpty((String)zipCode) ? zipCode : MORADA_DESCONHECIDO);
        companyAddress.setRegion(!Strings.isNullOrEmpty((String)zipCodeRegion) ? zipCodeRegion : MORADA_DESCONHECIDO);
        companyAddress.setStreetName((String)Splitter.fixedLength((int)90).splitToList((CharSequence)street).get(0));
        return companyAddress;
    }

    public static String exportAuditFileToXML(AuditFile auditFile) {
        try {
            String cleanXMLAnotations = "xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"";
            String cleanXMLAnotations2 = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
            String cleanXMLAnotations3 = "xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xs:string\"";
            String cleanDateTimeMiliseconds = ".000<";
            String cleanStandaloneAnnotation = "standalone=\"yes\"";
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AuditFile.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)SAFT_PT_ENCODING);
            marshaller.marshal((Object)auditFile, (OutputStream)writer);
            Object xml = new String(writer.toByteArray(), SAFT_PT_ENCODING);
            xml = ((String)xml).replace("xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"", "");
            xml = ((String)xml).replace("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", "");
            xml = ((String)xml).replace("xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"xs:string\"", "");
            xml = ((String)xml).replace(".000<", "<");
            xml = ((String)xml).replace("standalone=\"yes\"", "");
            try {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                md.update(("SALTING WITH QUB:" + (String)xml).getBytes(SAFT_PT_ENCODING));
                byte[] output = md.digest();
                String digestAscii = SAPExporter.bytesToHex(output);
                xml = (String)xml + "<!-- QUB-IT (remove this line,add the qubSALT, save with UTF-8 encode): " + digestAscii + " -->\n";
            }
            catch (Exception exception) {
                // empty catch block
            }
            return xml;
        }
        catch (JAXBException e) {
            return "";
        }
        catch (UnsupportedEncodingException jex) {
            return "";
        }
    }

    public static String bytesToHex(byte[] b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer buf = new StringBuffer();
        for (byte element : b) {
            buf.append(hexDigit[element >> 4 & 0xF]);
            buf.append(hexDigit[element & 0xF]);
        }
        return buf.toString();
    }

    public static org.fenixedu.treasury.generated.sources.saft.sap.Customer convertCustomerToSAFTCustomer(ERPCustomerFieldsBean customer) {
        org.fenixedu.treasury.generated.sources.saft.sap.Customer c = new org.fenixedu.treasury.generated.sources.saft.sap.Customer();
        c.setDisable("");
        c.setAccountID(customer.getCustomerAccountId());
        c.setBillingAddress(SAPExporter.convertAddressToSAFTAddress(customer));
        c.setCompanyName(customer.getCustomerName());
        c.setContact(customer.getCustomerContact());
        c.setCustomerID(customer.getCustomerId());
        c.setCustomerBusinessID(customer.getCustomerBusinessId());
        if (StringUtils.isNotEmpty((String)c.getCustomerBusinessID())) {
            c.setCustomerBusinessID((String)Splitter.fixedLength((int)30).splitToList((CharSequence)customer.getCustomerBusinessId()).get(0));
        }
        c.setCustomerTaxID(customer.getCustomerFiscalNumber());
        c.setSelfBillingIndicator(0);
        c.setFiscalCountry(SAPExporter.translateCountryCodeForExceptions(customer.getCustomerAddressCountryCode()));
        c.setNationality(SAPExporter.translateCountryCodeForExceptions(customer.getCustomerNationality()));
        return c;
    }

    private static String translateCountryCodeForExceptions(String countryCode) {
        if (Strings.isNullOrEmpty((String)countryCode)) {
            return countryCode;
        }
        return countryCode.toUpperCase();
    }

    public static AddressStructure convertAddressToSAFTAddress(ERPCustomerFieldsBean customer) {
        AddressStructure address = new AddressStructure();
        address.setCountry(!Strings.isNullOrEmpty((String)customer.getCustomerAddressCountryCode()) ? SAPExporter.translateCountryCodeForExceptions(customer.getCustomerAddressCountryCode()) : MORADA_DESCONHECIDO);
        address.setAddressDetail(!Strings.isNullOrEmpty((String)customer.getCustomerAddressDetail()) ? customer.getCustomerAddressDetail() : MORADA_DESCONHECIDO);
        address.setCity(!Strings.isNullOrEmpty((String)customer.getCustomerCity()) ? customer.getCustomerCity() : MORADA_DESCONHECIDO);
        address.setPostalCode(!Strings.isNullOrEmpty((String)customer.getCustomerZipCode()) ? customer.getCustomerZipCode() : "");
        address.setRegion(!Strings.isNullOrEmpty((String)customer.getCustomerRegion()) ? customer.getCustomerRegion() : MORADA_DESCONHECIDO);
        address.setStreetName(customer.getCustomerStreetName());
        return address;
    }

    public static org.fenixedu.treasury.generated.sources.saft.sap.Product convertProductToSAFTProduct(Product product) {
        org.fenixedu.treasury.generated.sources.saft.sap.Product p = new org.fenixedu.treasury.generated.sources.saft.sap.Product();
        p.setProductCode(product.getCode());
        p.setProductDescription(StringUtils.abbreviate((String)product.getName().getContent(), (int)200));
        if (product.getProductGroup() != null) {
            p.setProductGroup(product.getProductGroup().getName().getContent());
        }
        p.setProductNumberCode(p.getProductCode());
        p.setProductType("S");
        return p;
    }

    private MovementTax getSAFTMovementTax(Product product, Vat vat) {
        MovementTax tax = new MovementTax();
        tax.setTaxCode(vat.getVatType().getCode());
        tax.setTaxCountryRegion("PT");
        tax.setTaxPercentage(vat.getTaxRate());
        tax.setTaxType(SAFTPTMovementTaxType.IVA);
        return tax;
    }

    private Tax getSAFTInvoiceTax(Product product, Vat vat) {
        Tax tax = new Tax();
        tax.setTaxCode(vat.getVatType().getCode());
        tax.setTaxCountryRegion("PT");
        tax.setTaxPercentage(vat.getTaxRate());
        tax.setTaxType("IVA");
        return tax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ERPExportOperation exportFullToIntegration(FinantialInstitution institution, DateTime fromDate, DateTime toDate, String username, Boolean includeMovements) {
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        ERPExportOperation operation = this.createSaftExportOperation(null, institution, new DateTime());
        try {
            SAPExporter saftExporter = new SAPExporter();
            List<FinantialDocument> documents = new ArrayList<FinantialDocument>(institution.getExportableDocuments(fromDate, toDate));
            documents = this.processCreditNoteSettlementsInclusion(documents);
            logger.info("Collecting " + documents.size() + " documents to export to institution " + institution.getCode());
            UnaryOperator<AuditFile> auditFilePreProcess = this.getAuditFilePreProcessOperator(institution);
            if (documents.isEmpty()) {
                throw new TreasuryDomainException("error.ERPExporter.no.document.to.export", new String[0]);
            }
            String xml = saftExporter.generateERPFile(institution, fromDate, toDate, documents, true, true, auditFilePreProcess);
            this.writeContentToExportOperation(xml, operation);
            boolean success = this.sendDocumentsInformationToIntegration(institution, xml.getBytes(SAFT_PT_ENCODING), logBean);
            operation.getFinantialDocumentsSet().addAll(documents);
            operation.setSuccess(success);
        }
        catch (Throwable t) {
            this.writeError(operation, logBean, t);
        }
        finally {
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
        return operation;
    }

    @Override
    public void requestPendingDocumentStatus(FinantialInstitution institution) {
        ERPConfiguration erpIntegrationConfiguration = institution.getErpIntegrationConfiguration();
        if (erpIntegrationConfiguration == null) {
            throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
        }
        if (!erpIntegrationConfiguration.getActive()) {
            return;
        }
        IERPExternalService service = erpIntegrationConfiguration.getERPExternalServiceImplementation();
        List<String> documentNumbers = institution.getFinantialDocumentsPendingForExportationSet().stream().map(doc -> doc.getUiDocumentNumber()).collect(Collectors.toList());
        List<DocumentStatusWS> integrationStatusFor = service.getIntegrationStatusFor(institution.getFiscalNumber(), documentNumbers);
        for (DocumentStatusWS documentStatus : integrationStatusFor) {
            if (!documentStatus.isIntegratedWithSuccess()) continue;
            String message = TreasuryConstants.treasuryBundle("info.ERPExporter.sucess.integrating.document", documentStatus.getDocumentNumber());
            FinantialDocument document = institution.getFinantialDocumentsPendingForExportationSet().stream().filter(x -> x.getUiDocumentNumber().equals(documentStatus.getDocumentNumber())).findFirst().orElse(null);
            if (document == null) continue;
            document.clearDocumentToExport(message);
        }
    }

    private boolean sendDocumentsInformationToIntegration(FinantialInstitution institution, byte[] contents, IntegrationOperationLogBean logBean) throws MalformedURLException {
        DocumentsInformationOutput sendInfoOnlineResult;
        boolean success = true;
        ERPConfiguration erpIntegrationConfiguration = institution.getErpIntegrationConfiguration();
        if (erpIntegrationConfiguration == null) {
            throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
        }
        if (!erpIntegrationConfiguration.getActive()) {
            logBean.appendErrorLog(TreasuryConstants.treasuryBundle("info.ERPExporter.configuration.inactive", new String[0]));
            return false;
        }
        IERPExternalService service = TreasuryPlataformDependentServicesFactory.implementation().getERPExternalServiceImplementation(erpIntegrationConfiguration);
        logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("info.ERPExporter.sending.inforation", new String[0]));
        DocumentsInformationInput input = new DocumentsInformationInput();
        if ((long)contents.length <= erpIntegrationConfiguration.getMaxSizeBytesToExportOnline()) {
            input.setData(contents);
            sendInfoOnlineResult = service.sendInfoOnline(institution, input);
            TreasuryPlataformDependentServicesFactory.implementation().getERPExternalServiceImplementation(erpIntegrationConfiguration);
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("info.ERPExporter.sucess.sending.inforation.online", sendInfoOnlineResult.getRequestId()));
            logBean.setErpOperationId(sendInfoOnlineResult.getRequestId());
            for (DocumentStatusWS status : sendInfoOnlineResult.getDocumentStatus()) {
                FinantialDocument document = FinantialDocument.findByUiDocumentNumber(institution, status.getDocumentNumber());
                boolean integratedWithSuccess = status.isIntegratedWithSuccess();
                if (integratedWithSuccess) {
                    if (document != null) {
                        String message = TreasuryConstants.treasuryBundle("info.ERPExporter.sucess.integrating.document", document.getUiDocumentNumber());
                        logBean.appendIntegrationLog(message);
                        document.clearDocumentToExportAndSaveERPCertificationData(message, new LocalDate(), status.getSapDocumentNumber());
                        continue;
                    }
                    success = false;
                    logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
                    logBean.appendErrorLog(TreasuryConstants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
                    continue;
                }
                success = false;
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
                logBean.appendErrorLog(TreasuryConstants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
            }
            for (String m : sendInfoOnlineResult.getOtherMessages()) {
                logBean.appendIntegrationLog(m);
            }
            for (String m : sendInfoOnlineResult.getOtherErrorMessages()) {
                logBean.appendErrorLog(m);
            }
        } else {
            throw new TreasuryDomainException("error.ERPExporter.sendDocumentsInformationToIntegration.maxSizeBytesToExportOnline.exceeded", new String[0]);
        }
        logBean.defineSoapInboundMessage(sendInfoOnlineResult.getSoapInboundMessage());
        logBean.defineSoapOutboundMessage(sendInfoOnlineResult.getSoapOutboundMessage());
        return success;
    }

    private void writeError(ERPExportOperation operation, IntegrationOperationLogBean logBean, Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        t.printStackTrace(writer);
        logBean.appendErrorLog(out.toString());
        operation.setProcessed(true);
    }

    private ERPExportOperation createSaftExportOperation(byte[] byArray, FinantialInstitution finantialInstitution, DateTime dateTime) {
        return (ERPExportOperation)((Object)advice$createSaftExportOperation.perform((Callable)new SAPExporter$callable$createSaftExportOperation(this, byArray, finantialInstitution, dateTime)));
    }

    static /* synthetic */ ERPExportOperation advised$createSaftExportOperation(SAPExporter this_, byte[] data, FinantialInstitution institution, DateTime when) {
        String filename = institution.getFiscalNumber() + "_" + when.toString() + ".xml";
        ERPExportOperation operation = ERPExportOperation.create(data, filename, institution, null, when, false, false, false);
        return operation;
    }

    private OperationFile writeContentToExportOperation(String string, ERPExportOperation eRPExportOperation) {
        return (OperationFile)advice$writeContentToExportOperation.perform((Callable)new SAPExporter$callable$writeContentToExportOperation(this, string, eRPExportOperation));
    }

    static /* synthetic */ OperationFile advised$writeContentToExportOperation(SAPExporter this_, String content, ERPExportOperation operation) {
        byte[] bytes = null;
        try {
            bytes = content.getBytes(SAFT_PT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String fileName = operation.getFinantialInstitution().getFiscalNumber() + "_" + operation.getExecutionDate().toString("ddMMyyyy_hhmm") + ".xml";
        OperationFile binaryStream = new OperationFile(fileName, bytes);
        if (operation.getFile() != null) {
            operation.getFile().delete();
        }
        operation.setFile(binaryStream);
        return binaryStream;
    }

    @Override
    public String exportFinantialDocumentToXML(FinantialInstitution finantialInstitution, List<FinantialDocument> documents) {
        UnaryOperator<AuditFile> auditFilePreProcess = this.getAuditFilePreProcessOperator(finantialInstitution);
        return this.exportFinantialDocumentToXML(finantialInstitution, documents, auditFilePreProcess);
    }

    protected String exportFinantialDocumentToXML(FinantialInstitution finantialInstitution, List<FinantialDocument> documents, UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize) {
        if (documents.isEmpty()) {
            throw new TreasuryDomainException("error.ERPExporter.no.document.to.export", new String[0]);
        }
        SAPExporter.checkForUnsetDocumentSeriesNumberInDocumentsToExport(documents);
        documents = this.processCreditNoteSettlementsInclusion(documents);
        DateTime beginDate = ((FinantialDocument)((Object)documents.stream().min((x, y) -> x.getDocumentDate().compareTo((ReadableInstant)y.getDocumentDate())).get())).getDocumentDate();
        DateTime endDate = ((FinantialDocument)((Object)documents.stream().max((x, y) -> x.getDocumentDate().compareTo((ReadableInstant)y.getDocumentDate())).get())).getDocumentDate();
        return this.generateERPFile(finantialInstitution, beginDate, endDate, documents, false, false, preProcessFunctionBeforeSerialize);
    }

    @Override
    public List<FinantialDocument> processCreditNoteSettlementsInclusion(List<FinantialDocument> documents) {
        List<Object> result = Lists.newArrayList(documents);
        for (FinantialDocument finantialDocument : documents) {
            if (!finantialDocument.isSettlementNote()) continue;
            SettlementNote settlementNote = (SettlementNote)((Object)finantialDocument);
            if (settlementNote.getAdvancedPaymentCreditNote() != null && !result.contains((Object)settlementNote.getAdvancedPaymentCreditNote())) {
                result.add((Object)settlementNote.getAdvancedPaymentCreditNote());
            }
            if (settlementNote.isAnnulled() && !settlementNote.isReimbursement()) continue;
            for (SettlementEntry settlementEntry : settlementNote.getSettlemetEntriesSet()) {
                CreditNote creditNote;
                if (!settlementEntry.getInvoiceEntry().isCreditNoteEntry() || (creditNote = (CreditNote)((Object)settlementEntry.getInvoiceEntry().getFinantialDocument())).isAdvancePayment() || result.contains((Object)creditNote)) continue;
                result.add((Object)creditNote);
            }
        }
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            result = result.stream().filter(d -> !d.isExportedInLegacyERP()).filter(d -> !d.getCloseDate().isBefore((ReadableInstant)ERP_INTEGRATION_START_DATE)).collect(Collectors.toList());
        }
        return result;
    }

    protected static void checkForUnsetDocumentSeriesNumberInDocumentsToExport(List<? extends FinantialDocument> documents) {
        for (FinantialDocument finantialDocument : documents) {
            if (finantialDocument.isDocumentSeriesNumberSet()) continue;
            throw new TreasuryDomainException("error.ERPExporter.document.without.number.series", new String[0]);
        }
    }

    @Override
    public String exportsProductsToXML(FinantialInstitution finantialInstitution) {
        UnaryOperator<AuditFile> auditFilePreProcess = this.getAuditFilePreProcessOperator(finantialInstitution);
        return this.exportsProductsToXML(finantialInstitution, auditFilePreProcess);
    }

    protected String exportsProductsToXML(FinantialInstitution finantialInstitution, UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize) {
        SAPExporter saftExporter = new SAPExporter();
        return saftExporter.generateERPFile(finantialInstitution, new DateTime(), new DateTime(), new ArrayList(), false, true, preProcessFunctionBeforeSerialize);
    }

    @Override
    public String exportsCustomersToXML(FinantialInstitution finantialInstitution) {
        UnaryOperator<AuditFile> auditFilePreProcess = this.getAuditFilePreProcessOperator(finantialInstitution);
        return this.exportCustomersToXML(finantialInstitution, auditFilePreProcess);
    }

    protected String exportCustomersToXML(FinantialInstitution finantialInstitution, UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize) {
        SAPExporter saftExporter = new SAPExporter();
        return saftExporter.generateERPFile(finantialInstitution, new DateTime(), new DateTime(), new ArrayList(), true, false, preProcessFunctionBeforeSerialize);
    }

    @Override
    public ERPExportOperation exportFinantialDocumentToIntegration(FinantialInstitution finantialInstitution, List<FinantialDocument> list) {
        return (ERPExportOperation)((Object)advice$exportFinantialDocumentToIntegration.perform((Callable)new SAPExporter$callable$exportFinantialDocumentToIntegration(this, finantialInstitution, list)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ERPExportOperation advised$exportFinantialDocumentToIntegration(SAPExporter this_, FinantialInstitution institution, List documents) {
        SAPExporter.checkForUnsetDocumentSeriesNumberInDocumentsToExport((List<? extends FinantialDocument>)documents);
        if (!institution.getErpIntegrationConfiguration().isIntegratedDocumentsExportationEnabled()) {
            documents = documents.stream().filter(x -> x.isDocumentToExport()).collect(Collectors.toList());
        }
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        ERPExportOperation operation = this_.createSaftExportOperation(null, institution, new DateTime());
        documents.forEach(document -> operation.addFinantialDocuments((FinantialDocument)((Object)document)));
        try {
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.starting.finantialdocuments.integration", new String[0]));
            UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize = this_.getAuditFilePreProcessOperator(institution);
            String xml = this_.exportFinantialDocumentToXML(institution, documents, preProcessFunctionBeforeSerialize);
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.erp.xml.content.generated", new String[0]));
            this_.writeContentToExportOperation(xml, operation);
            boolean success = this_.sendDocumentsInformationToIntegration(institution, xml.getBytes(SAFT_PT_ENCODING), logBean);
            operation.getFinantialDocumentsSet().addAll(documents);
            operation.setSuccess(success);
        }
        catch (Exception ex) {
            this_.writeError(operation, logBean, ex);
        }
        finally {
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.finished.finantialdocuments.integration", new String[0]));
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
        return operation;
    }

    @Override
    public ERPExportOperation exportCustomersToIntegration(FinantialInstitution finantialInstitution) {
        return (ERPExportOperation)((Object)advice$exportCustomersToIntegration.perform((Callable)new SAPExporter$callable$exportCustomersToIntegration(this, finantialInstitution)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ERPExportOperation advised$exportCustomersToIntegration(SAPExporter this_, FinantialInstitution institution) {
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        ERPExportOperation operation = this_.createSaftExportOperation(null, institution, new DateTime());
        try {
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.starting.customers.integration", new String[0]));
            UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize = this_.getAuditFilePreProcessOperator(institution);
            String xml = this_.exportCustomersToXML(institution, preProcessFunctionBeforeSerialize);
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.erp.xml.content.generated", new String[0]));
            this_.writeContentToExportOperation(xml, operation);
            boolean success = this_.sendDocumentsInformationToIntegration(institution, xml.getBytes(SAFT_PT_ENCODING), logBean);
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.finished.customers.integration", new String[0]));
            operation.setSuccess(success);
        }
        catch (Exception ex) {
            this_.writeError(operation, logBean, ex);
        }
        finally {
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
        return operation;
    }

    @Override
    public ERPExportOperation exportProductsToIntegration(FinantialInstitution finantialInstitution) {
        return (ERPExportOperation)((Object)advice$exportProductsToIntegration.perform((Callable)new SAPExporter$callable$exportProductsToIntegration(this, finantialInstitution)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ERPExportOperation advised$exportProductsToIntegration(SAPExporter this_, FinantialInstitution institution) {
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        ERPExportOperation operation = this_.createSaftExportOperation(null, institution, new DateTime());
        try {
            UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize = this_.getAuditFilePreProcessOperator(institution);
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.starting.products.integration", new String[0]));
            String xml = this_.exportsProductsToXML(institution, preProcessFunctionBeforeSerialize);
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.erp.xml.content.generated", new String[0]));
            this_.writeContentToExportOperation(xml, operation);
            boolean success = this_.sendDocumentsInformationToIntegration(institution, xml.getBytes(SAFT_PT_ENCODING), logBean);
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.finished.products.integration", new String[0]));
            operation.setSuccess(success);
        }
        catch (Exception ex) {
            this_.writeError(operation, logBean, ex);
        }
        finally {
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
        return operation;
    }

    @Override
    public void testExportToIntegration(FinantialInstitution institution) {
        ERPConfiguration erpIntegrationConfiguration = institution.getErpIntegrationConfiguration();
        if (erpIntegrationConfiguration == null) {
            throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
        }
    }

    @Override
    public void checkIntegrationDocumentStatus(FinantialDocument document) {
        ERPConfiguration erpIntegrationConfiguration = document.getDebtAccount().getFinantialInstitution().getErpIntegrationConfiguration();
        if (erpIntegrationConfiguration == null) {
            throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
        }
        if (!erpIntegrationConfiguration.getActive()) {
            return;
        }
        IERPExternalService service = erpIntegrationConfiguration.getERPExternalServiceImplementation();
        ArrayList<String> documentsList = new ArrayList<String>();
        documentsList.add(document.getUiDocumentNumber());
        List<DocumentStatusWS> integrationStatusFor = service.getIntegrationStatusFor(document.getDebtAccount().getFinantialInstitution().getFiscalNumber(), documentsList);
        for (DocumentStatusWS documentStatus : integrationStatusFor) {
            if (!documentStatus.getDocumentNumber().equals(document.getUiDocumentNumber()) || !documentStatus.isIntegratedWithSuccess()) continue;
            String message = TreasuryConstants.treasuryBundle("info.ERPExporter.sucess.integrating.document", document.getUiDocumentNumber());
            document.clearDocumentToExport(message);
        }
    }

    private UnaryOperator<AuditFile> getAuditFilePreProcessOperator(FinantialInstitution finantialInstitution) {
        return x -> x;
    }

    public static XMLGregorianCalendar convertToXMLDateTime(DatatypeFactory dataTypeFactory, DateTime documentDate) {
        return dataTypeFactory.newXMLGregorianCalendar(documentDate.getYear(), documentDate.getMonthOfYear(), documentDate.getDayOfMonth(), documentDate.getHourOfDay(), documentDate.getMinuteOfHour(), documentDate.getSecondOfMinute(), 0, Integer.MIN_VALUE);
    }

    public static XMLGregorianCalendar convertToXMLDate(DatatypeFactory dataTypeFactory, DateTime date) {
        return dataTypeFactory.newXMLGregorianCalendarDate(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), Integer.MIN_VALUE);
    }

    private String convertToSAFTPaymentMechanism(org.fenixedu.treasury.domain.PaymentMethod paymentMethod) {
        return paymentMethod.getCode();
    }

    @Override
    public byte[] downloadCertifiedDocumentPrint(FinantialDocument finantialDocument) {
        FinantialInstitution finantialInstitution = finantialDocument.getDebtAccount().getFinantialInstitution();
        ERPConfiguration erpIntegrationConfiguration = finantialDocument.getDebtAccount().getFinantialInstitution().getErpIntegrationConfiguration();
        if (erpIntegrationConfiguration == null) {
            throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
        }
        if (!erpIntegrationConfiguration.getActive()) {
            throw new TreasuryDomainException("error.IERPExporter.downloadCertifiedDocumentPrint.integration.not.active", new String[0]);
        }
        IERPExternalService service = erpIntegrationConfiguration.getERPExternalServiceImplementation();
        return service.downloadCertifiedDocumentPrint(finantialInstitution.getFiscalNumber(), finantialDocument.getUiDocumentNumber(), erpIntegrationConfiguration.getErpIdProcess());
    }

    @Override
    public ReimbursementStateBean checkReimbursementState(SettlementNote settlementNote) {
        return (ReimbursementStateBean)advice$checkReimbursementState.perform((Callable)new SAPExporter$callable$checkReimbursementState(this, settlementNote));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ReimbursementStateBean advised$checkReimbursementState(SAPExporter this_, SettlementNote reimbursementNote) {
        FinantialInstitution institution = reimbursementNote.getDebtAccount().getFinantialInstitution();
        ERPConfiguration erpIntegrationConfiguration = institution.getErpIntegrationConfiguration();
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        DateTime when = new DateTime();
        String filename = institution.getFiscalNumber() + "_" + when.toString() + ".xml";
        ERPImportOperation operation = ERPImportOperation.create(filename, new byte[0], institution, null, when, false, false, false);
        try {
            if (erpIntegrationConfiguration == null) {
                throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
            }
            if (!erpIntegrationConfiguration.getActive()) {
                throw new TreasuryDomainException("error.ERPExporter.integration.not.active", new String[0]);
            }
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.checkReimbursementState.init", reimbursementNote.getUiDocumentNumber(), reimbursementNote.getCurrentReimbursementProcessStatus().getDescription()));
            IERPExternalService service = erpIntegrationConfiguration.getERPExternalServiceImplementation();
            ReimbursementStateBean reimbursementState = service.checkReimbursementState(reimbursementNote, logBean);
            operation.setSuccess(reimbursementState.isSuccess());
            ReimbursementStateBean reimbursementStateBean = reimbursementState;
            return reimbursementStateBean;
        }
        catch (Throwable t) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            t.printStackTrace(writer);
            logBean.appendErrorLog(out.toString());
            operation.setProcessed(true);
            ReimbursementStateBean reimbursementStateBean = null;
            return reimbursementStateBean;
        }
        finally {
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
    }

    @Override
    public String saftEncoding() {
        return SAFT_PT_ENCODING;
    }

    @Override
    public boolean isCustomerWithFinantialDocumentsIntegratedInPreviousERP(Customer customer) {
        for (DebtAccount debtAccount : customer.getDebtAccountsSet()) {
            if (debtAccount.getFinantialInstitution().getErpIntegrationConfiguration() != null && debtAccount.getFinantialInstitution().getErpIntegrationConfiguration().isAllowFiscalFixWithLegacyDocsExportedLegacyERP()) continue;
            for (FinantialDocument finantialDocument : debtAccount.getFinantialDocumentsSet()) {
                if (!finantialDocument.isExportedInLegacyERP()) continue;
                return true;
            }
            for (Invoice invoice : debtAccount.getInvoiceSet()) {
                if (!invoice.isExportedInLegacyERP()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCustomerWithFinantialDocumentsIntegratedInERP(Customer customer) {
        for (DebtAccount debtAccount : customer.getDebtAccountsSet()) {
            for (FinantialDocument finantialDocument : debtAccount.getFinantialDocumentsSet()) {
                for (ERPExportOperation erpExportOperation : finantialDocument.getErpExportOperationsSet()) {
                    if (!erpExportOperation.getSuccess() || erpExportOperation.getExecutionDate().isBefore((ReadableInstant)ERP_INTEGRATION_START_DATE)) continue;
                    return true;
                }
                if (Strings.isNullOrEmpty((String)finantialDocument.getErpCertificateDocumentReference())) continue;
                return true;
            }
            for (Invoice invoice : debtAccount.getInvoiceSet()) {
                for (ERPExportOperation erpExportOperation : invoice.getErpExportOperationsSet()) {
                    if (!erpExportOperation.getSuccess() || erpExportOperation.getExecutionDate().isBefore((ReadableInstant)ERP_INTEGRATION_START_DATE)) continue;
                    return true;
                }
                if (Strings.isNullOrEmpty((String)invoice.getErpCertificateDocumentReference())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<FinantialDocument> filterDocumentsToExport(Stream<? extends FinantialDocument> finantialDocumentsStream) {
        List tempList = finantialDocumentsStream.filter(d -> d.isDocumentToExport()).filter(d -> !d.isCreditNote()).filter(d -> d.isAnnulled() || d.isClosed()).filter(d -> d.isDocumentSeriesNumberSet()).filter(x -> x.getCloseDate() != null).filter(x -> x.isDebitNote() || x.isSettlementNote() && !x.getCloseDate().isBefore((ReadableInstant)ERP_INTEGRATION_START_DATE)).collect(Collectors.toList());
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            tempList = tempList.stream().filter(d -> !d.isExportedInLegacyERP()).filter(d -> !d.getCloseDate().isBefore((ReadableInstant)ERP_INTEGRATION_START_DATE)).collect(Collectors.toList());
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(tempList.stream().filter(d -> d.isDebitNote()).collect(Collectors.toList()));
        result.addAll(tempList.stream().filter(d -> d.isSettlementNote()).collect(Collectors.toList()));
        if (tempList.size() != result.size()) {
            throw new RuntimeException("error");
        }
        return result;
    }

    @Override
    public void processReimbursementStateChange(SettlementNote settlementNote, ReimbursementProcessStatusType reimbursementProcessStatusType, String string, DateTime dateTime) {
        Object object = advice$processReimbursementStateChange.perform((Callable)new SAPExporter$callable$processReimbursementStateChange(this, settlementNote, reimbursementProcessStatusType, string, dateTime));
    }

    static /* synthetic */ void advised$processReimbursementStateChange(SAPExporter this_, SettlementNote reimbursementNote, ReimbursementProcessStatusType reimbursementStatus, String exerciseYear, DateTime reimbursementStatusDate) {
        if (reimbursementStatus == null) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementStatus", new String[0]);
        }
        if (!reimbursementNote.isReimbursement()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.settlementNote", new String[0]);
        }
        if (!reimbursementNote.isClosed() && !reimbursementStatus.isInitialStatus()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.state", new String[0]);
        }
        if (!reimbursementStatus.isInitialStatus() && reimbursementNote.getCurrentReimbursementProcessStatus() == null) {
            throw new TreasuryDomainException("error.SettlementNote.currentReimbursementProcessStatus.invalid", new String[0]);
        }
        if (reimbursementNote.getCurrentReimbursementProcessStatus() != null && !reimbursementStatus.isAfter(reimbursementNote.getCurrentReimbursementProcessStatus())) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.next.status.invalid", new String[0]);
        }
        if (reimbursementNote.getCurrentReimbursementProcessStatus() != null && reimbursementNote.getCurrentReimbursementProcessStatus().isFinalStatus()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.current.status.is.final", new String[0]);
        }
        reimbursementNote.setCurrentReimbursementProcessStatus(reimbursementStatus);
        if (reimbursementNote.getCurrentReimbursementProcessStatus() == null) {
            throw new TreasuryDomainException("error.SettlementNote.currentReimbursementProcessStatus.invalid", new String[0]);
        }
        if (reimbursementNote.getCurrentReimbursementProcessStatus().isRejectedStatus() && reimbursementNote.isClosed()) {
            CreditNote creditNote = (CreditNote)((Object)reimbursementNote.getSettlemetEntries().findFirst().get().getInvoiceEntry().getFinantialDocument());
            if (!creditNote.isAdvancePayment()) {
                SAPExporter.anullReimbursementCreditNoteAndCopy(creditNote, TreasuryConstants.treasuryBundle("error.SettlementNote.reimbursement.rejected.reason", new String[0]));
            }
            reimbursementNote.anullDocument(TreasuryConstants.treasuryBundle("label.ReimbursementProcessStatusType.annuled.reimbursement.by.annuled.process", new String[0]), false);
        }
    }

    @Override
    public String exportCustomerToXML(DebtAccount debtAccount) {
        UnaryOperator<AuditFile> auditFilePreProcess = this.getAuditFilePreProcessOperator(debtAccount.getFinantialInstitution());
        return this.exportCustomerToXML(debtAccount, auditFilePreProcess);
    }

    protected String exportCustomerToXML(DebtAccount debtAccount, UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize) {
        DateTime fromDate = new DateTime();
        DateTime toDate = new DateTime();
        FinantialInstitution institution = debtAccount.getFinantialInstitution();
        AuditFile auditFile = new AuditFile();
        Header header = this.createSAFTHeader(fromDate, toDate, institution, ERP_HEADER_VERSION_1_00_00);
        auditFile.setHeader(header);
        AuditFile.MasterFiles masterFiles = new AuditFile.MasterFiles();
        auditFile.setMasterFiles(masterFiles);
        List<org.fenixedu.treasury.generated.sources.saft.sap.Product> productList = masterFiles.getProduct();
        HashMap productMap = new HashMap();
        HashSet productCodes = new HashSet();
        List<org.fenixedu.treasury.generated.sources.saft.sap.Customer> customerList = masterFiles.getCustomer();
        HashMap<String, ERPCustomerFieldsBean> customerMap = new HashMap<String, ERPCustomerFieldsBean>();
        ERPCustomerFieldsBean customerBean = ERPCustomerFieldsBean.fillFromCustomer(debtAccount.getCustomer());
        org.fenixedu.treasury.generated.sources.saft.sap.Customer saftCustomer = SAPExporter.convertCustomerToSAFTCustomer(customerBean);
        customerMap.put(saftCustomer.getCustomerID(), customerBean);
        customerList.add(saftCustomer);
        TaxTable taxTable = new TaxTable();
        masterFiles.setTaxTable(taxTable);
        for (Vat vat : institution.getVatsSet()) {
            if (!vat.isActiveNow()) continue;
            taxTable.getTaxTableEntry().add(SAPExporter.convertVATtoTaxTableEntry(vat, institution));
        }
        SourceDocuments sourceDocuments = new SourceDocuments();
        auditFile.setSourceDocuments(sourceDocuments);
        SourceDocuments.SalesInvoices invoices = new SourceDocuments.SalesInvoices();
        SourceDocuments.WorkingDocuments workingDocuments = new SourceDocuments.WorkingDocuments();
        SourceDocuments.Payments paymentsDocuments = new SourceDocuments.Payments();
        BigInteger numberOfPaymentsDocuments = BigInteger.ZERO;
        BigDecimal totalDebitOfPaymentsDocuments = BigDecimal.ZERO;
        BigDecimal totalCreditOfPaymentsDocuments = BigDecimal.ZERO;
        BigInteger numberOfWorkingDocuments = BigInteger.ZERO;
        BigDecimal totalDebitOfWorkingDocuments = BigDecimal.ZERO;
        BigDecimal totalCreditOfWorkingDocuments = BigDecimal.ZERO;
        invoices.setNumberOfEntries(BigInteger.ZERO);
        invoices.setTotalCredit(BigDecimal.ZERO);
        invoices.setTotalDebit(BigDecimal.ZERO);
        workingDocuments.setNumberOfEntries(numberOfWorkingDocuments);
        workingDocuments.setTotalCredit(totalCreditOfWorkingDocuments.setScale(2, RoundingMode.HALF_EVEN));
        workingDocuments.setTotalDebit(totalDebitOfWorkingDocuments.setScale(2, RoundingMode.HALF_EVEN));
        sourceDocuments.setWorkingDocuments(workingDocuments);
        paymentsDocuments.setNumberOfEntries(BigInteger.ZERO);
        paymentsDocuments.setTotalCredit(BigDecimal.ZERO);
        paymentsDocuments.setTotalDebit(BigDecimal.ZERO);
        paymentsDocuments.setNumberOfEntries(numberOfPaymentsDocuments);
        paymentsDocuments.setTotalCredit(totalCreditOfPaymentsDocuments.setScale(2, RoundingMode.HALF_EVEN));
        paymentsDocuments.setTotalDebit(totalDebitOfPaymentsDocuments.setScale(2, RoundingMode.HALF_EVEN));
        sourceDocuments.setPayments(paymentsDocuments);
        if (preProcessFunctionBeforeSerialize != null) {
            auditFile = (AuditFile)preProcessFunctionBeforeSerialize.apply(auditFile);
        }
        String xml = SAPExporter.exportAuditFileToXML(auditFile);
        logger.debug("SAFT File export concluded with success.");
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ERPExportOperation exportCustomerToIntegration(DebtAccount debtAccount) {
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        ERPExportOperation operation = this.createSaftExportOperation(null, debtAccount.getFinantialInstitution(), new DateTime());
        try {
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.starting.customers.integration", new String[0]));
            UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize = this.getAuditFilePreProcessOperator(debtAccount.getFinantialInstitution());
            String xml = this.exportCustomerToXML(debtAccount, preProcessFunctionBeforeSerialize);
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.erp.xml.content.generated", new String[0]));
            this.writeContentToExportOperation(xml, operation);
            boolean success = this.sendDocumentsInformationToIntegration(debtAccount.getFinantialInstitution(), xml.getBytes(SAFT_PT_ENCODING), logBean);
            logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("label.ERPExporter.finished.customers.integration", new String[0]));
            operation.setSuccess(success);
        }
        catch (Exception ex) {
            this.writeError(operation, logBean, ex);
        }
        finally {
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
        return operation;
    }

    private static CreditNote anullReimbursementCreditNoteAndCopy(CreditNote creditNoteToAnnul, String annuledReason) {
        if (!creditNoteToAnnul.isClosed()) {
            throw new TreasuryDomainException("error.CreditNote.anullReimbursementCreditNoteAndCopy.copy.only.on.closed.credit.note", new String[0]);
        }
        if (!creditNoteToAnnul.isRelatedToReimbursement()) {
            throw new TreasuryDomainException("error.CreditNote.creditNote.not.from.reimbursement", new String[0]);
        }
        if (creditNoteToAnnul.isAdvancePayment()) {
            throw new TreasuryDomainException("error.CreditNote.annulment.over.advance.payment.not.possible", new String[0]);
        }
        if (ReimbursementUtils.isCreditNoteSettledWithPayment(creditNoteToAnnul)) {
            throw new TreasuryDomainException("error.CreditNote.annulment.over.credit.with.payments.not.possible", new String[0]);
        }
        creditNoteToAnnul.setState(FinantialDocumentStateType.ANNULED);
        creditNoteToAnnul.setAnnulledReason(annuledReason);
        creditNoteToAnnul.setAnnullmentDate(new DateTime());
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        creditNoteToAnnul.setAnnullmentResponsible(!Strings.isNullOrEmpty((String)loggedUsername) ? loggedUsername : "unknown");
        CreditNote result = SAPExporter.createCreditNote(creditNoteToAnnul);
        for (CreditEntry creditEntry : creditNoteToAnnul.getCreditEntriesSet()) {
            if (creditEntry.isFromExemption()) {
                CreditEntry.createFromExemption(creditEntry.getTreasuryExemption(), (FinantialDocument)((Object)result), creditEntry.getDescription(), creditEntry.getAmount(), new DateTime(), creditEntry.getQuantity());
                continue;
            }
            if (creditEntry.getDebitEntry() != null) {
                CreditEntry.create((FinantialDocument)((Object)result), creditEntry.getDescription(), creditEntry.getProduct(), creditEntry.getVat(), creditEntry.getAmount(), new DateTime(), creditEntry.getDebitEntry(), creditEntry.getQuantity(), creditEntry.getCreditedExemptionsMap());
                continue;
            }
            CreditEntry.create(creditEntry.getFinantialEntity(), (FinantialDocument)((Object)result), creditEntry.getDescription(), creditEntry.getProduct(), creditEntry.getVat(), creditEntry.getAmount(), new DateTime(), creditEntry.getQuantity());
        }
        return result;
    }

    private static CreditNote createCreditNote(CreditNote creditNoteToAnnul) {
        if (creditNoteToAnnul.getDebitNote() != null) {
            return CreditNote.create(creditNoteToAnnul.getDebitNote(), creditNoteToAnnul.getDocumentNumberSeries(), new DateTime(), creditNoteToAnnul.getOriginDocumentNumber());
        }
        return CreditNote.create(creditNoteToAnnul.getFinantialEntity(), creditNoteToAnnul.getDebtAccount(), creditNoteToAnnul.getDocumentNumberSeries(), creditNoteToAnnul.getPayorDebtAccount(), new DateTime(), creditNoteToAnnul.getOriginDocumentNumber());
    }

    static {
        advice$createSaftExportOperation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$writeContentToExportOperation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$exportFinantialDocumentToIntegration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$exportCustomersToIntegration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$exportProductsToIntegration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$checkReimbursementState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$processReimbursementStateChange = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        ERP_INTEGRATION_START_DATE = new LocalDate(2017, 1, 1).toDateTimeAtStartOfDay();
        logger = LoggerFactory.getLogger(SAPExporter.class);
    }
}

