/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class SOAPLoggingHandler
implements SOAPHandler<SOAPMessageContext> {
    private String outboundMessage;
    private String inboundMessage;

    public void close(MessageContext messageContext) {
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return false;
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        boolean direction = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (direction) {
            this.outboundMessage = this.dumpMsg(messageContext);
        } else {
            this.inboundMessage = this.dumpMsg(messageContext);
        }
        return true;
    }

    public String dumpMsg(SOAPMessageContext context) {
        try {
            SOAPMessage soapmsg = context.getMessage();
            return this.getMsgAsString(soapmsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getMsgAsString(SOAPMessage message) {
        String msg = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.writeTo((OutputStream)baos);
            msg = baos.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    public Set getHeaders() {
        return null;
    }

    public String getOutboundMessage() {
        return this.outboundMessage;
    }

    public String getInboundMessage() {
        return this.inboundMessage;
    }

    public static SOAPLoggingHandler createLoggingHandler(BindingProvider client) {
        SOAPLoggingHandler loggingHandler = new SOAPLoggingHandler();
        ArrayList<SOAPLoggingHandler> handlerChain = client.getBinding().getHandlerChain();
        if (handlerChain == null) {
            handlerChain = new ArrayList<SOAPLoggingHandler>();
        }
        handlerChain.add(loggingHandler);
        client.getBinding().setHandlerChain(handlerChain);
        return loggingHandler;
    }
}

