/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration;

import java.io.InputStream;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineWebServiceResponse;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import org.fenixedu.treasury.services.integration.erp.ISaftExporterConfiguration;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import pt.ist.fenixframework.DomainObject;

public interface ITreasuryPlatformDependentServices {
    public void scheduleDocumentForExportation(FinantialDocument var1);

    public IERPExternalService getERPExternalServiceImplementation(ERPConfiguration var1);

    public byte[] getFileContent(IGenericFile var1);

    public long getFileSize(IGenericFile var1);

    public String getFilename(IGenericFile var1);

    public InputStream getFileStream(IGenericFile var1);

    public DateTime getFileCreationDate(IGenericFile var1);

    public String getFileContentType(IGenericFile var1);

    public void createFile(IGenericFile var1, String var2, String var3, byte[] var4);

    public void deleteFile(IGenericFile var1);

    public byte[] getFileContent(String var1);

    public long getFileSize(String var1);

    public String getFilename(String var1);

    public InputStream getFileStream(String var1);

    public DateTime getFileCreationDate(String var1);

    public String getFileContentType(String var1);

    public String createFile(String var1, String var2, byte[] var3);

    public void deleteFile(String var1);

    public String getLoggedUsername();

    public String getCustomerEmail(Customer var1);

    public void setCurrentApplicationUser(String var1);

    public void removeCurrentApplicationUser();

    public Locale defaultLocale();

    public Locale currentLocale();

    public Set<Locale> availableLocales();

    public String bundle(String var1, String var2, String ... var3);

    public String bundle(Locale var1, String var2, String var3, String ... var4);

    public LocalizedString bundleI18N(String var1, String var2, String ... var3);

    public <T> String versioningCreatorUsername(T var1);

    public <T> DateTime versioningCreationDate(T var1);

    public <T> String versioningUpdatorUsername(T var1);

    public <T> DateTime versioningUpdateDate(T var1);

    public PaylineWebServiceResponse paylineGetWebPaymentDetails(ForwardPaymentRequest var1);

    public PaylineWebServiceResponse paylineDoWebPayment(ForwardPaymentRequest var1, String var2, String var3);

    public void paylineConfigureWebservice(PaylineConfiguration var1);

    public String calculateURLChecksum(String var1, HttpSession var2);

    public void signalsRegisterHandlerForKey(String var1, Object var2);

    public void signalsUnregisterHandlerForKey(String var1, Object var2);

    public void signalsEmitForObject(String var1, DomainObject var2);

    public String getForwardPaymentURL(String var1, Class var2, boolean var3, String var4, boolean var5);

    public InputStream exportDocuments(String var1, FinantialInstitution var2, FinantialEntity var3, LocalDate var4, LocalDate var5, String var6);

    public String exportDocumentFileExtension();

    public InputStream exportPaymentReceipt(String var1, SettlementNote var2);

    public ISaftExporterConfiguration getSaftExporterConfiguration(ERPConfiguration var1);

    public Set<Partial> getHolidays();

    public void certifyDocument(FinantialDocument var1);

    public void updateCertifiedDocument(FinantialDocument var1);

    public void annulCertifiedDocument(FinantialDocument var1);

    public boolean hasCertifiedDocument(FinantialDocument var1);

    public String getCertifiedDocumentNumber(FinantialDocument var1);

    public LocalDate getCertifiedDocumentDate(FinantialDocument var1);

    public boolean isProductCertified(Product var1);

    public boolean isQualityOrDevelopmentMode();
}

