/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.sibspaymentsgateway.integration;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.onlinepaymentsgateway.api.CheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.api.CustomerDataInputBean;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.onlinepaymentsgateway.api.MbCheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.api.MbPrepareCheckoutInputBean;
import org.fenixedu.onlinepaymentsgateway.api.MbWayCheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.api.MbWayPrepareCheckoutInputBean;
import org.fenixedu.onlinepaymentsgateway.api.OnlinePaymentServiceFactory;
import org.fenixedu.onlinepaymentsgateway.api.PaymentStateBean;
import org.fenixedu.onlinepaymentsgateway.api.PrepareCheckoutInputBean;
import org.fenixedu.onlinepaymentsgateway.api.SIBSInitializeServiceBean;
import org.fenixedu.onlinepaymentsgateway.api.SIBSOnlinePaymentsGatewayService;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.SibsEnvironmentMode;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.SibsResultCodeType;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentController;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentCodeTransaction;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.SibsReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxTreasuryEvent;
import org.fenixedu.treasury.domain.payments.IMbwayPaymentPlatformService;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsBillingAddressBean;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGatewayEnviromentMode;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest;
import org.fenixedu.treasury.domain.sibspaymentsgateway.SibsPaymentsGatewayLog;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$createForwardPaymentRequest;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$createLog;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$createLogForSibsPaymentRequest;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$createMbwayRequest;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$createMbwayRequest$1;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$generateMBPaymentReference;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$getPaymentStatusBySibsCheckoutId;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$getPaymentStatusBySibsTransactionId;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$getPaymentTransactionsReportListByMerchantId;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$prepareCheckout;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$prepareCheckout$1;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$processMbwayTransaction;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$processPaymentReferenceCodeTransaction;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway$callable$saveExceptionLog;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway_Base;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.PaymentPenaltyEntryBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsPaymentsGateway
extends SibsPaymentsGateway_Base
implements ISibsPaymentCodePoolService,
IForwardPaymentPlatformService,
IMbwayPaymentPlatformService {
    private static final String ERROR_UNEXPECTED_NUMBER_TRANSACTIONS_BY_MERCHANT_TRANSACTION_ID = "error.SibsOnlinePaymentsGatewayForwardImplementation.paymentStatus.unexpected.number.transactions.by.merchantTransactionId";
    public static final String CONTROLLER_URL = "/treasury/document/forwardpayments/sibsonlinepaymentsgateway";
    private static final String RETURN_FORWARD_PAYMENT_URI = "/returnforwardpayment";
    public static final String RETURN_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/sibsonlinepaymentsgateway/returnforwardpayment";
    public static final Advice advice$prepareCheckout = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$prepareCheckout$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$getPaymentStatusBySibsCheckoutId = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$getPaymentTransactionsReportListByMerchantId = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$getPaymentStatusBySibsTransactionId = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$generateMBPaymentReference = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$saveExceptionLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createLogForSibsPaymentRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createMbwayRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$createMbwayRequest$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$processPaymentReferenceCodeTransaction = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$processMbwayTransaction = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$createLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createForwardPaymentRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

    public SibsPaymentsGateway() {
    }

    public SibsPaymentsGateway(FinantialInstitution finantialInstitution, FinantialEntity finantialEntity, String name, boolean active, String entityReferenceCode, String sibsEntityId, String sibsEndpointUrl, String bearerToken, String aesKey) {
        this();
        this.init(finantialInstitution, finantialEntity, name, active);
        this.setEntityReferenceCode(entityReferenceCode);
        this.setSibsEntityId(sibsEntityId);
        this.setSibsEndpointUrl(sibsEndpointUrl);
        this.setBearerToken(bearerToken);
        this.setAesKey(aesKey);
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getCreditCardPaymentMethod());
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getMbPaymentMethod());
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getMbWayPaymentMethod());
        this.checkRules();
    }

    public boolean isSendBillingDataInOnlinePayment() {
        return super.getSendBillingDataInOnlinePayment();
    }

    public String generateNewMerchantTransactionId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public MbWayCheckoutResultBean generateMbwayReference(BigDecimal payableAmount, String merchantTransactionId, String phoneNumber) throws OnlinePaymentsGatewayCommunicationException {
        SIBSOnlinePaymentsGatewayService gatewayService = this.gatewayService();
        MbWayPrepareCheckoutInputBean inputBean = new MbWayPrepareCheckoutInputBean(payableAmount, merchantTransactionId, phoneNumber);
        inputBean.setAmount(payableAmount);
        inputBean.setMerchantTransactionId(merchantTransactionId);
        inputBean.setPhoneNumber(phoneNumber);
        MbWayCheckoutResultBean mbwayCheckoutResult = gatewayService.generateMbWayPayment(inputBean, null);
        return mbwayCheckoutResult;
    }

    @Override
    public IForwardPaymentController getForwardPaymentController(ForwardPaymentRequest request) {
        return IForwardPaymentController.getForwardPaymentController((PaymentRequest)((Object)request));
    }

    @Override
    public String getLogosJspPage() {
        return "/WEB-INF/treasury/document/forwardpayments/forwardpayment/implementations/netcaixa/logos.jsp";
    }

    @Override
    public String getWarningBeforeRedirectionJspPage() {
        return null;
    }

    public PaymentRequestLog log(PaymentRequest paymentRequest, String operationCode, String statusCode, String statusMessage, String requestBody, String responseBody) {
        SibsPaymentsGatewayLog log2 = SibsPaymentsGatewayLog.createPaymentRequestLog(paymentRequest, paymentRequest.getCurrentState().getCode(), paymentRequest.getCurrentState().getLocalizedName());
        log2.setOperationCode(operationCode);
        log2.setStatusCode(statusCode);
        log2.setStatusMessage(statusMessage);
        if (!Strings.isNullOrEmpty((String)requestBody)) {
            log2.saveRequest(requestBody);
        }
        if (!Strings.isNullOrEmpty((String)responseBody)) {
            log2.saveResponse(responseBody);
        }
        return log2;
    }

    public String getReturnURL(ForwardPaymentRequest forwardPayment) {
        return String.format("%s%s/%s", TreasurySettings.getInstance().getForwardPaymentReturnDefaultURL(), RETURN_FORWARD_PAYMENT_URL, forwardPayment.getExternalId());
    }

    @Override
    public String getPaymentURL(ForwardPaymentRequest request) {
        return this.getSibsEndpointUrl() + "/paymentWidgets.js?checkoutId=" + request.getCheckoutId();
    }

    public ForwardPaymentStatusBean prepareCheckout(ForwardPaymentRequest forwardPaymentRequest, SibsBillingAddressBean sibsBillingAddressBean) {
        return (ForwardPaymentStatusBean)advice$prepareCheckout.perform((Callable)new SibsPaymentsGateway$callable$prepareCheckout(this, forwardPaymentRequest, sibsBillingAddressBean));
    }

    static /* synthetic */ ForwardPaymentStatusBean advised$prepareCheckout(SibsPaymentsGateway this_, ForwardPaymentRequest forwardPayment, SibsBillingAddressBean addressBean) {
        String merchantTransactionId = this_.generateNewMerchantTransactionId();
        FenixFramework.atomic(() -> {
            if (!StringUtils.isEmpty((String)forwardPayment.getMerchantTransactionId())) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.sibsMerchantTransactionId.already.filled", new String[0]);
            }
            forwardPayment.setMerchantTransactionId(merchantTransactionId);
        });
        try {
            DateTime requestSendDate = new DateTime();
            CheckoutResultBean checkoutBean = this_.prepareCheckout(forwardPayment.getDebtAccount(), merchantTransactionId, forwardPayment.getPayableAmount(), this_.getReturnURL(forwardPayment), addressBean);
            DateTime requestReceiveDate = new DateTime();
            ForwardPaymentStateType stateType = this_.translateForwardPaymentStateType(checkoutBean.getOperationResultType(), false);
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(checkoutBean.isOperationSuccess(), stateType, checkoutBean.getPaymentGatewayResultCode(), checkoutBean.getPaymentGatewayResultDescription(), checkoutBean.getRequestLog(), checkoutBean.getResponseLog());
            FenixFramework.atomic(() -> forwardPayment.setCheckoutId(checkoutBean.getCheckoutId()));
            FenixFramework.atomic(() -> {
                if (!result.isOperationSuccess() || result.getStateType() == ForwardPaymentStateType.REJECTED) {
                    SibsPaymentsGatewayLog log2 = (SibsPaymentsGatewayLog)((Object)((Object)((Object)forwardPayment.reject("prepareCheckout", checkoutBean.getPaymentGatewayResultCode(), checkoutBean.getPaymentGatewayResultDescription(), checkoutBean.getRequestLog(), checkoutBean.getResponseLog()))));
                    log2.setRequestSendDate(requestSendDate);
                    log2.setRequestReceiveDate(requestReceiveDate);
                } else {
                    SibsPaymentsGatewayLog log3 = (SibsPaymentsGatewayLog)((Object)((Object)((Object)forwardPayment.advanceToRequestState("prepareCheckout", checkoutBean.getPaymentGatewayResultCode(), checkoutBean.getPaymentGatewayResultDescription(), checkoutBean.getRequestLog(), checkoutBean.getResponseLog()))));
                    log3.setOperationSuccess(result.isOperationSuccess());
                    log3.setRequestSendDate(requestSendDate);
                    log3.setRequestReceiveDate(requestReceiveDate);
                }
            });
            result.defineSibsOnlinePaymentBrands(checkoutBean.getPaymentBrands());
            return result;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)e).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)e).getResponseLog();
                }
                this.logException((PaymentRequest)((Object)((Object)((Object)forwardPayment))), e, "prepareCheckout", "error", "message", requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private CheckoutResultBean prepareCheckout(DebtAccount debtAccount, String string, BigDecimal bigDecimal, String string2, SibsBillingAddressBean sibsBillingAddressBean) throws OnlinePaymentsGatewayCommunicationException {
        return (CheckoutResultBean)advice$prepareCheckout$1.perform((Callable)new SibsPaymentsGateway$callable$prepareCheckout$1(this, debtAccount, string, bigDecimal, string2, sibsBillingAddressBean));
    }

    static /* synthetic */ CheckoutResultBean advised$prepareCheckout(SibsPaymentsGateway this_, DebtAccount debtAccount, String merchantTransactionId, BigDecimal payableAmount, String returnUrl, SibsBillingAddressBean billingAddressBean) throws OnlinePaymentsGatewayCommunicationException {
        SIBSOnlinePaymentsGatewayService gatewayService = this_.gatewayService();
        PrepareCheckoutInputBean bean = new PrepareCheckoutInputBean(payableAmount, merchantTransactionId, returnUrl, new DateTime(), new DateTime().plusDays(7));
        if (this_.isSendBillingDataInOnlinePayment()) {
            String customerEmail = debtAccount.getCustomer().getEmail();
            bean.fillBillingData(null, billingAddressBean.getAddressCountryCode(), billingAddressBean.getCity(), billingAddressBean.getAddress(), billingAddressBean.getZipCode(), customerEmail);
        }
        bean.setUseCreditCard(Boolean.valueOf(true));
        CheckoutResultBean resultBean = gatewayService.prepareOnlinePaymentCheckout(bean);
        return resultBean;
    }

    public ForwardPaymentStatusBean paymentStatusByCheckoutId(ForwardPaymentRequest forwardPayment) {
        try {
            PaymentStateBean paymentStateBean = this.getPaymentStatusBySibsCheckoutId(forwardPayment.getCheckoutId());
            String requestLog = paymentStateBean.getRequestLog();
            String responseLog = paymentStateBean.getResponseLog();
            ForwardPaymentStateType type = this.translateForwardPaymentStateType(paymentStateBean.getOperationResultType(), paymentStateBean.isPaid());
            ForwardPaymentStatusBean statusBean = new ForwardPaymentStatusBean(paymentStateBean.isOperationSuccess(), type, paymentStateBean.getPaymentGatewayResultCode(), paymentStateBean.getPaymentGatewayResultDescription(), requestLog, responseLog);
            statusBean.editTransactionDetails(paymentStateBean.getTransactionId(), paymentStateBean.getPaymentDate(), paymentStateBean.getAmount());
            return statusBean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                this.logException((PaymentRequest)((Object)((Object)((Object)forwardPayment))), e, "paymentStatusByCheckoutId", "error", "error", requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    @Override
    public ForwardPaymentStatusBean paymentStatus(ForwardPaymentRequest forwardPayment) {
        try {
            PaymentStateBean paymentStateBean = null;
            if (!StringUtils.isEmpty((String)forwardPayment.getTransactionId())) {
                paymentStateBean = this.getPaymentStatusBySibsTransactionId(forwardPayment.getTransactionId());
            } else {
                List<? extends DigitalPlatformResultBean> paymentStateBeanList = this.getPaymentTransactionsReportListByMerchantId(forwardPayment.getMerchantTransactionId());
                if (paymentStateBeanList.size() != 1) {
                    throw new TreasuryDomainException(ERROR_UNEXPECTED_NUMBER_TRANSACTIONS_BY_MERCHANT_TRANSACTION_ID, new String[0]);
                }
                paymentStateBean = (PaymentStateBean)paymentStateBeanList.get(0);
            }
            String requestLog = paymentStateBean.getRequestLog();
            String responseLog = paymentStateBean.getResponseLog();
            ForwardPaymentStateType type = this.translateForwardPaymentStateType(paymentStateBean.getOperationResultType(), paymentStateBean.isPaid());
            ForwardPaymentStatusBean bean = new ForwardPaymentStatusBean(paymentStateBean.isOperationSuccess(), type, paymentStateBean.getPaymentGatewayResultCode(), paymentStateBean.getPaymentGatewayResultDescription(), requestLog, responseLog);
            bean.editTransactionDetails(paymentStateBean.getTransactionId(), paymentStateBean.getPaymentDate(), paymentStateBean.getAmount());
            return bean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                if (!ERROR_UNEXPECTED_NUMBER_TRANSACTIONS_BY_MERCHANT_TRANSACTION_ID.equals(e.getMessage())) {
                    this.logException((PaymentRequest)((Object)((Object)((Object)forwardPayment))), e, "paymentStatus", "error", "error", requestBody, responseBody);
                }
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    private ForwardPaymentStateType translateForwardPaymentStateType(SibsResultCodeType operationResultType, boolean paid) {
        if (operationResultType == null) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.unknown.payment.state", new String[0]);
        }
        if (paid) {
            if (operationResultType != SibsResultCodeType.SUCCESSFUL_TRANSACTION && operationResultType != SibsResultCodeType.SUCESSFUL_PROCESSED_TRANSACTION_FOR_REVIEW) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayForwardImplementation.payment.appears.paid.but.inconsistent.with.result.code", new String[0]);
            }
            return ForwardPaymentStateType.PAYED;
        }
        if (operationResultType == SibsResultCodeType.PENDING_TRANSACTION) {
            return ForwardPaymentStateType.REQUESTED;
        }
        return ForwardPaymentStateType.REJECTED;
    }

    @Override
    public PostProcessPaymentStatusBean postProcessPayment(ForwardPaymentRequest forwardPayment, String justification, Optional<String> specificTransactionId) {
        if (specificTransactionId.isEmpty()) {
            ForwardPaymentStatusBean statusBean = new ForwardPaymentStatusBean(false, forwardPayment.getState(), "N/A", "N/A", null, null);
            return new PostProcessPaymentStatusBean(statusBean, forwardPayment.getState(), false);
        }
        if (!forwardPayment.getState().isInStateToPostProcessPayment()) {
            throw new TreasuryDomainException("error.ManageForwardPayments.forwardPayment.not.created.nor.requested", String.valueOf(forwardPayment.getOrderNumber()));
        }
        try {
            DateTime requestSendDate = new DateTime();
            PaymentStateBean paymentStateBean = this.getPaymentStatusBySibsTransactionId(specificTransactionId.get());
            DateTime requestReceiveDate = new DateTime();
            String requestLog = paymentStateBean.getRequestLog();
            String responseLog = paymentStateBean.getResponseLog();
            ForwardPaymentStateType type = this.translateForwardPaymentStateType(paymentStateBean.getOperationResultType(), paymentStateBean.isPaid());
            ForwardPaymentStatusBean bean = new ForwardPaymentStatusBean(paymentStateBean.isOperationSuccess(), type, paymentStateBean.getPaymentGatewayResultCode(), paymentStateBean.getPaymentGatewayResultDescription(), requestLog, responseLog);
            bean.editTransactionDetails(paymentStateBean.getTransactionId(), paymentStateBean.getPaymentDate(), paymentStateBean.getAmount());
            if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains(bean.getStateType())) {
                return new PostProcessPaymentStatusBean(bean, forwardPayment.getState(), false);
            }
            FenixFramework.atomic(() -> forwardPayment.setTransactionId(bean.getTransactionId()));
            PostProcessPaymentStatusBean returnBean = new PostProcessPaymentStatusBean(bean, forwardPayment.getState(), bean.isInPayedState());
            if (bean.isInPayedState()) {
                FenixFramework.atomic(() -> {
                    SibsPaymentsGatewayLog log2 = (SibsPaymentsGatewayLog)((Object)((Object)((Object)forwardPayment.advanceToPaidState(bean.getStatusCode(), bean.getStatusMessage(), bean.getPayedAmount(), bean.getTransactionDate(), bean.getTransactionId(), null, bean.getRequestBody(), bean.getResponseBody(), ""))));
                    log2.setRequestSendDate(requestSendDate);
                    log2.setRequestReceiveDate(requestReceiveDate);
                    log2.setSibsGatewayTransactionId(bean.getTransactionId());
                });
            } else if (bean.isInRejectedState()) {
                FenixFramework.atomic(() -> {
                    SibsPaymentsGatewayLog log2 = (SibsPaymentsGatewayLog)((Object)((Object)((Object)forwardPayment.reject("postProcessPayment", bean.getStatusCode(), bean.getStatusMessage(), bean.getRequestBody(), bean.getResponseBody()))));
                    log2.setRequestSendDate(requestSendDate);
                    log2.setRequestReceiveDate(requestReceiveDate);
                    log2.setSibsGatewayTransactionId(bean.getTransactionId());
                });
            }
            return returnBean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                this.logException((PaymentRequest)((Object)((Object)((Object)forwardPayment))), e, "postProcessPayment", "error", "error", requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments) {
        BigDecimal payableAmountDebitEntries = debitEntries.stream().map(InvoiceEntry::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmountInstallments = installments.stream().map(Installment::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmount = payableAmountDebitEntries.add(payableAmountInstallments);
        LocalDate now = new LocalDate();
        Set map = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        map.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = map.stream().max(LocalDate::compareTo).orElse(now);
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        return this.createSibsPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequest(SettlementNoteBean settlementNoteBean) {
        DebtAccount debtAccount = settlementNoteBean.getDebtAccount();
        Set<DebitEntry> debitEntries = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.getInvoiceEntry() != null).map(s -> s.getInvoiceEntry()).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.isForInstallment()).map(InstallmentPaymenPlanBean.class::cast).map(s -> s.getInstallment()).collect(Collectors.toSet());
        BigDecimal payableAmount = settlementNoteBean.getTotalAmountToPay();
        LocalDate now = new LocalDate();
        Set map = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        map.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = map.stream().max(LocalDate::compareTo).orElse(now);
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        return this.createSibsPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    @Override
    @Deprecated
    public SibsPaymentRequest createSibsPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, BigDecimal payableAmount) {
        LocalDate now = new LocalDate();
        Set dueDatesSet = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        dueDatesSet.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = dueDatesSet.stream().max(LocalDate::compareTo).orElse(now);
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        return this.createSibsPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    @Override
    public SibsPaymentRequest createSibsPaymentRequestWithInterests(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, LocalDate interestsCalculationDate) {
        BigDecimal payableAmountDebitEntries = debitEntries.stream().map(d -> d.getOpenAmountWithInterestsAtDate(interestsCalculationDate)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmountInstallments = installments.stream().map(Installment::getOpenAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmount = payableAmountDebitEntries.add(payableAmountInstallments);
        LocalDate now = new LocalDate();
        Set map = debitEntries.stream().map(d -> d.getDueDate()).collect(Collectors.toSet());
        map.addAll(installments.stream().map(i -> i.getDueDate()).collect(Collectors.toSet()));
        LocalDate validTo = map.stream().max(LocalDate::compareTo).orElse(now);
        if (validTo.isBefore((ReadablePartial)now)) {
            validTo = now;
        }
        return this.createSibsPaymentRequest(debtAccount, debitEntries, installments, validTo, payableAmount);
    }

    private SibsPaymentRequest createSibsPaymentRequest(DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, LocalDate validTo, BigDecimal payableAmount) {
        if (!this.isActive()) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.paymentCodePool.not.active", new String[0]);
        }
        if (PaymentRequest.getReferencedCustomers(debitEntries, installments).size() > 1) {
            throw new TreasuryDomainException("error.PaymentRequest.referencedCustomers.only.one.allowed", new String[0]);
        }
        String merchantTransactionId = this.generateNewMerchantTransactionId();
        SibsPaymentsGatewayLog log2 = SibsPaymentsGateway.createLogForSibsPaymentRequest(merchantTransactionId);
        try {
            DateTime sibsValidFrom = new DateTime();
            DateTime sibsValidTo = sibsValidFrom.plusMonths(this.getNumberOfMonthsToExpirePaymentReferenceCode());
            MbCheckoutResultBean checkoutResultBean = this.generateMBPaymentReference(payableAmount, sibsValidFrom, sibsValidTo, merchantTransactionId);
            String sibsReferenceId = checkoutResultBean.getTransactionId();
            FenixFramework.atomic(() -> {
                log2.logRequestReceiveDateAndData(checkoutResultBean.getTransactionId(), checkoutResultBean.isOperationSuccess(), false, checkoutResultBean.getPaymentGatewayResultCode(), checkoutResultBean.getOperationResultDescription());
                log2.saveRequest(checkoutResultBean.getRequestLog());
                log2.saveResponse(checkoutResultBean.getResponseLog());
                log2.savePaymentTypeAndBrand(checkoutResultBean.getPaymentType() != null ? checkoutResultBean.getPaymentType().name() : null, checkoutResultBean.getPaymentBrand() != null ? checkoutResultBean.getPaymentBrand().name() : null);
            });
            if (!checkoutResultBean.isOperationSuccess()) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.request.not.successful", new String[0]);
            }
            String referenceCode = checkoutResultBean.getPaymentReference();
            if (StringUtils.isEmpty((String)referenceCode)) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.reference.not.empty", new String[0]);
            }
            if (SibsReferenceCode.findByReferenceCode(this.getEntityReferenceCode(), referenceCode).count() >= 1L) {
                throw new TreasuryDomainException("error.PaymentReferenceCode.referenceCode.duplicated", new String[0]);
            }
            if (PaymentRequest.findBySibsGatewayMerchantTransactionId(merchantTransactionId).count() >= 1L) {
                throw new TreasuryDomainException("error.PaymentReferenceCode.sibsMerchantTransaction.found.duplicated", new String[0]);
            }
            if (PaymentRequest.findBySibsGatewayTransactionId(sibsReferenceId).count() >= 1L) {
                throw new TreasuryDomainException("error.PaymentReferenceCode.sibsReferenceId.found.duplicated", new String[0]);
            }
            SibsPaymentRequest sibsPaymentRequest = (SibsPaymentRequest)((Object)FenixFramework.atomic(() -> {
                SibsPaymentRequest request = SibsPaymentRequest.create((DigitalPaymentPlatform)((Object)((Object)this)), debtAccount, debitEntries, installments, payableAmount, this.getEntityReferenceCode(), referenceCode, merchantTransactionId, sibsReferenceId);
                request.setExpiresDate(sibsValidTo);
                log2.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)request))));
                return request;
            }));
            return sibsPaymentRequest;
        }
        catch (Exception e) {
            boolean isOnlinePaymentsGatewayException = e instanceof OnlinePaymentsGatewayCommunicationException;
            this.saveExceptionLog(log2, e, isOnlinePaymentsGatewayException);
            if (e instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)e;
            }
            String message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.unknown";
            if (isOnlinePaymentsGatewayException) {
                message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.gateway.communication";
            }
            throw new TreasuryDomainException((Throwable)e, message, new String[0]);
        }
    }

    public PaymentStateBean handleWebhookNotificationRequest(String initializationVector, String authTag, String encryptedPayload) throws Exception {
        return this.gatewayService().handleNotificationRequest(initializationVector, authTag, encryptedPayload);
    }

    public PaymentStateBean getPaymentStatusBySibsCheckoutId(String string) throws OnlinePaymentsGatewayCommunicationException {
        return (PaymentStateBean)advice$getPaymentStatusBySibsCheckoutId.perform((Callable)new SibsPaymentsGateway$callable$getPaymentStatusBySibsCheckoutId(this, string));
    }

    static /* synthetic */ PaymentStateBean advised$getPaymentStatusBySibsCheckoutId(SibsPaymentsGateway this_, String checkoutId) throws OnlinePaymentsGatewayCommunicationException {
        try {
            return this_.gatewayService().getPaymentStatusByCheckoutId(checkoutId);
        }
        catch (OnlinePaymentsGatewayCommunicationException e) {
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    public List<? extends DigitalPlatformResultBean> getPaymentTransactionsReportListByMerchantId(String string) {
        return (List)advice$getPaymentTransactionsReportListByMerchantId.perform((Callable)new SibsPaymentsGateway$callable$getPaymentTransactionsReportListByMerchantId(this, string));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$getPaymentTransactionsReportListByMerchantId(SibsPaymentsGateway this_, String merchantTransactionId) {
        try {
            return this_.gatewayService().getPaymentTransactionsReportListByMerchantId(merchantTransactionId);
        }
        catch (OnlinePaymentsGatewayCommunicationException e) {
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    public PaymentStateBean getPaymentStatusBySibsTransactionId(String string) throws OnlinePaymentsGatewayCommunicationException {
        return (PaymentStateBean)advice$getPaymentStatusBySibsTransactionId.perform((Callable)new SibsPaymentsGateway$callable$getPaymentStatusBySibsTransactionId(this, string));
    }

    static /* synthetic */ PaymentStateBean advised$getPaymentStatusBySibsTransactionId(SibsPaymentsGateway this_, String transactionId) throws OnlinePaymentsGatewayCommunicationException {
        return this_.gatewayService().getPaymentTransactionReportByTransactionId(transactionId);
    }

    public void edit(String name, String sibsEndpointUrl, String sibsEntityId, String entityReferenceCode, String bearerToken, String aesKey, int numberOfMonthsToExpirePaymentReferenceCode, boolean sendBillingDataInOnlinePayment) {
        this.setName(name);
        this.setSibsEndpointUrl(sibsEndpointUrl);
        this.setSibsEntityId(sibsEntityId);
        this.setEntityReferenceCode(entityReferenceCode);
        this.setBearerToken(bearerToken);
        this.setAesKey(aesKey);
        this.setNumberOfMonthsToExpirePaymentReferenceCode(numberOfMonthsToExpirePaymentReferenceCode);
        this.setSendBillingDataInOnlinePayment(sendBillingDataInOnlinePayment);
        this.checkRules();
    }

    public void changeEnvironmentMode(SibsOnlinePaymentsGatewayEnviromentMode environmentMode) {
        this.setEnviromentMode(environmentMode);
        this.checkRules();
    }

    public void delete() {
        super.delete();
        super.deleteDomainObject();
    }

    private MbCheckoutResultBean generateMBPaymentReference(BigDecimal bigDecimal, DateTime dateTime, DateTime dateTime2, String string) throws OnlinePaymentsGatewayCommunicationException {
        return (MbCheckoutResultBean)advice$generateMBPaymentReference.perform((Callable)new SibsPaymentsGateway$callable$generateMBPaymentReference(this, bigDecimal, dateTime, dateTime2, string));
    }

    static /* synthetic */ MbCheckoutResultBean advised$generateMBPaymentReference(SibsPaymentsGateway this_, BigDecimal payableAmount, DateTime validFrom, DateTime validTo, String merchantTransactionId) throws OnlinePaymentsGatewayCommunicationException {
        SIBSOnlinePaymentsGatewayService gatewayService = this_.gatewayService();
        MbPrepareCheckoutInputBean inputBean = new MbPrepareCheckoutInputBean(payableAmount, merchantTransactionId, validFrom, validTo);
        CustomerDataInputBean customerInputBean = null;
        MbCheckoutResultBean requestResult = gatewayService.generateMBPaymentReference(inputBean, customerInputBean);
        return requestResult;
    }

    private void saveExceptionLog(SibsPaymentsGatewayLog sibsPaymentsGatewayLog, Exception exception, boolean bl) {
        Object object = advice$saveExceptionLog.perform((Callable)new SibsPaymentsGateway$callable$saveExceptionLog(this, sibsPaymentsGatewayLog, exception, bl));
    }

    static /* synthetic */ void advised$saveExceptionLog(SibsPaymentsGateway this_, SibsPaymentsGatewayLog log2, Exception e, boolean isOnlinePaymentsGatewayException) {
        log2.logRequestReceiveDateAndData(null, false, false, null, null);
        log2.logException(e);
        if (isOnlinePaymentsGatewayException) {
            log2.saveRequest(((OnlinePaymentsGatewayCommunicationException)((Object)e)).getRequestLog());
            log2.saveResponse(((OnlinePaymentsGatewayCommunicationException)((Object)e)).getResponseLog());
        }
    }

    private SIBSOnlinePaymentsGatewayService gatewayService() {
        SIBSInitializeServiceBean initializeServiceBean = new SIBSInitializeServiceBean(this.getSibsEntityId(), this.getBearerToken(), this.getSibsEndpointUrl(), this.getEntityReferenceCode(), this.getFinantialInstitution().getCurrency().getIsoCode(), this.translateEnviromentMode());
        initializeServiceBean.setAesKey(this.getAesKey());
        SIBSOnlinePaymentsGatewayService gatewayService = OnlinePaymentServiceFactory.createSIBSOnlinePaymentGatewayService((SIBSInitializeServiceBean)initializeServiceBean);
        return gatewayService;
    }

    private SibsEnvironmentMode translateEnviromentMode() {
        if (this.getEnviromentMode() == SibsOnlinePaymentsGatewayEnviromentMode.PRODUCTION) {
            return SibsEnvironmentMode.PRODUCTION;
        }
        if (this.getEnviromentMode() == SibsOnlinePaymentsGatewayEnviromentMode.TEST_MODE_EXTERNAL) {
            return SibsEnvironmentMode.TEST_MODE_EXTERNAL;
        }
        if (this.getEnviromentMode() == SibsOnlinePaymentsGatewayEnviromentMode.TEST_MODE_INTERNAL) {
            return SibsEnvironmentMode.TEST_MODE_INTERNAL;
        }
        throw new RuntimeException("SibsOnlinePaymentsGateway.translateEnviromentMode() unkown environment mode");
    }

    public static Stream<SibsPaymentsGateway> findAll() {
        return DigitalPaymentPlatform.findAll().filter(p -> p instanceof SibsPaymentsGateway).map(SibsPaymentsGateway.class::cast);
    }

    public static Stream<SibsPaymentsGateway> find(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getDigitalPaymentPlatformsSet().stream().filter(p -> p instanceof SibsPaymentsGateway).map(SibsPaymentsGateway.class::cast);
    }

    public static Optional<SibsPaymentsGateway> findUniqueActive(FinantialInstitution finantialInstitution) {
        return SibsPaymentsGateway.find(finantialInstitution).filter(p -> p.isActive()).findAny();
    }

    public static SibsPaymentsGateway create(FinantialInstitution finantialInstitution, FinantialEntity finantialEntity, String name, boolean active, String entityReferenceCode, String sibsEntityId, String sibsEndpointUrl, String bearerToken, String aesKey) {
        return new SibsPaymentsGateway(finantialInstitution, finantialEntity, name, active, entityReferenceCode, sibsEntityId, sibsEndpointUrl, bearerToken, aesKey);
    }

    private static SibsPaymentsGatewayLog createLogForSibsPaymentRequest(String string) {
        return (SibsPaymentsGatewayLog)((Object)advice$createLogForSibsPaymentRequest.perform((Callable)new SibsPaymentsGateway$callable$createLogForSibsPaymentRequest(string)));
    }

    static /* synthetic */ SibsPaymentsGatewayLog advised$createLogForSibsPaymentRequest(String sibsGatewayMerchantTransactionId) {
        SibsPaymentsGatewayLog log2 = SibsPaymentsGatewayLog.createForSibsPaymentRequest(sibsGatewayMerchantTransactionId);
        log2.logRequestSendDate();
        return log2;
    }

    public static boolean isMbwayServiceActive(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getDigitalPaymentPlatformsSet().stream().flatMap(p -> p.getDigitalPaymentPlatformPaymentModesSet().stream()).filter(p -> p.getPaymentMethod() == TreasurySettings.getInstance().getMbWayPaymentMethod()).anyMatch(p -> p.isActive());
    }

    public static String getPresentationName() {
        return TreasuryConstants.treasuryBundle("label.SibsPaymentsGateway.presentationName", new String[0]);
    }

    @Override
    public MbwayRequest createMbwayRequest(DebtAccount debtAccount, Set<DebitEntry> set, Set<Installment> set2, String string, String string2) {
        return (MbwayRequest)((Object)advice$createMbwayRequest.perform((Callable)new SibsPaymentsGateway$callable$createMbwayRequest(this, debtAccount, set, set2, string, string2)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ MbwayRequest advised$createMbwayRequest(SibsPaymentsGateway this_, DebtAccount debtAccount, Set debitEntries, Set installments, String countryPrefix, String localPhoneNumber) {
        Function<DebitEntry, BigDecimal> getExtraAmount = debitEntry -> {
            PaymentPenaltyEntryBean penaltyTax = PaymentPenaltyTaxTreasuryEvent.calculatePaymentPenaltyTax(debitEntry, LocalDate.now());
            BigDecimal penaltyTaxAmount = penaltyTax != null ? penaltyTax.getSettledAmount() : BigDecimal.ZERO;
            return debitEntry.getOpenAmountWithInterests().add(penaltyTaxAmount);
        };
        if (PaymentRequest.getReferencedCustomers(debitEntries, installments).size() > 1) {
            throw new TreasuryDomainException("error.PaymentRequest.referencedCustomers.only.one.allowed", new String[0]);
        }
        if (StringUtils.isEmpty((String)countryPrefix)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.countryPrefix.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)localPhoneNumber)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.required", new String[0]);
        }
        if (!countryPrefix.matches("\\d+")) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.countryPrefix.number.format.required", new String[0]);
        }
        if (!localPhoneNumber.matches("\\d+")) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.format.required", new String[0]);
        }
        String phoneNumber = String.format("%s#%s", countryPrefix, localPhoneNumber);
        BigDecimal payableAmountDebitEntries = debitEntries.stream().map(e -> (BigDecimal)getExtraAmount.apply((DebitEntry)((Object)e))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmountInstallments = installments.stream().map(i -> i.getOpenAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payableAmount = payableAmountDebitEntries.add(payableAmountInstallments);
        String merchantTransactionId = this_.generateNewMerchantTransactionId();
        SibsPaymentsGatewayLog log2 = SibsPaymentsGateway.createLog(merchantTransactionId);
        try {
            MbwayRequest mbwayPaymentRequest = MbwayRequest.create(this_, debtAccount, debitEntries, installments, phoneNumber, payableAmount, merchantTransactionId);
            FenixFramework.atomic(() -> log2.logRequestSendDate());
            MbWayCheckoutResultBean checkoutResultBean = this_.generateMbwayReference(payableAmount, merchantTransactionId, phoneNumber);
            FenixFramework.atomic(() -> {
                log2.logRequestReceiveDateAndData(checkoutResultBean.getTransactionId(), checkoutResultBean.isOperationSuccess(), false, checkoutResultBean.getPaymentGatewayResultCode(), checkoutResultBean.getOperationResultDescription());
                log2.saveRequest(checkoutResultBean.getRequestLog());
                log2.saveResponse(checkoutResultBean.getResponseLog());
            });
            if (!checkoutResultBean.isOperationSuccess()) {
                throw new TreasuryDomainException("error.MbwayPaymentRequest.request.in.gateway.failed", new String[0]);
            }
            FenixFramework.atomic(() -> {
                mbwayPaymentRequest.setTransactionId(checkoutResultBean.getTransactionId());
                log2.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)mbwayPaymentRequest))));
                log2.setStateCode(mbwayPaymentRequest.getState().name());
                log2.setStateDescription(mbwayPaymentRequest.getState().getDescriptionI18N());
            });
            return mbwayPaymentRequest;
        }
        catch (Exception e2) {
            boolean isOnlinePaymentsGatewayException = e2 instanceof OnlinePaymentsGatewayCommunicationException;
            FenixFramework.atomic(() -> {
                log2.logRequestReceiveDateAndData(null, false, false, null, null);
                log2.logException(e2);
                if (isOnlinePaymentsGatewayException) {
                    OnlinePaymentsGatewayCommunicationException onlineException = (OnlinePaymentsGatewayCommunicationException)((Object)((Object)e2));
                    log2.saveRequest(onlineException.getRequestLog());
                    log2.saveResponse(onlineException.getResponseLog());
                }
            });
            if (e2 instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)e2;
            }
            String message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor." + (isOnlinePaymentsGatewayException ? "gateway.communication" : "unknown");
            throw new TreasuryDomainException((Throwable)e2, message, new String[0]);
        }
    }

    @Override
    public MbwayRequest createMbwayRequest(SettlementNoteBean settlementNoteBean, String string, String string2) {
        return (MbwayRequest)((Object)advice$createMbwayRequest$1.perform((Callable)new SibsPaymentsGateway$callable$createMbwayRequest$1(this, settlementNoteBean, string, string2)));
    }

    static /* synthetic */ MbwayRequest advised$createMbwayRequest(SibsPaymentsGateway this_, SettlementNoteBean settlementNoteBean, String countryPrefix, String localPhoneNumber) {
        DebtAccount debtAccount = settlementNoteBean.getDebtAccount();
        Set<DebitEntry> debitEntries = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.getInvoiceEntry() != null).map(s -> s.getInvoiceEntry()).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = settlementNoteBean.getIncludedInvoiceEntryBeans().stream().filter(s -> s.isForInstallment()).map(InstallmentPaymenPlanBean.class::cast).map(s -> s.getInstallment()).collect(Collectors.toSet());
        BigDecimal payableAmount = settlementNoteBean.getTotalAmountToPay();
        if (PaymentRequest.getReferencedCustomers(debitEntries, installments).size() > 1) {
            throw new TreasuryDomainException("error.PaymentRequest.referencedCustomers.only.one.allowed", new String[0]);
        }
        if (StringUtils.isEmpty((String)countryPrefix)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.countryPrefix.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)localPhoneNumber)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.required", new String[0]);
        }
        if (!countryPrefix.matches("\\d+")) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.countryPrefix.number.format.required", new String[0]);
        }
        if (!localPhoneNumber.matches("\\d+")) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.format.required", new String[0]);
        }
        String phoneNumber = String.format("%s#%s", countryPrefix, localPhoneNumber);
        String merchantTransactionId = this_.generateNewMerchantTransactionId();
        SibsPaymentsGatewayLog log2 = SibsPaymentsGateway.createLog(merchantTransactionId);
        try {
            MbwayRequest mbwayPaymentRequest = MbwayRequest.create(this_, debtAccount, debitEntries, installments, phoneNumber, payableAmount, merchantTransactionId);
            FenixFramework.atomic(() -> log2.logRequestSendDate());
            MbWayCheckoutResultBean checkoutResultBean = this_.generateMbwayReference(payableAmount, merchantTransactionId, phoneNumber);
            FenixFramework.atomic(() -> {
                log2.logRequestReceiveDateAndData(checkoutResultBean.getTransactionId(), checkoutResultBean.isOperationSuccess(), false, checkoutResultBean.getPaymentGatewayResultCode(), checkoutResultBean.getOperationResultDescription());
                log2.saveRequest(checkoutResultBean.getRequestLog());
                log2.saveResponse(checkoutResultBean.getResponseLog());
            });
            if (!checkoutResultBean.isOperationSuccess()) {
                throw new TreasuryDomainException("error.MbwayPaymentRequest.request.in.gateway.failed", new String[0]);
            }
            FenixFramework.atomic(() -> {
                mbwayPaymentRequest.setTransactionId(checkoutResultBean.getTransactionId());
                log2.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)mbwayPaymentRequest))));
                log2.setStateCode(mbwayPaymentRequest.getState().name());
                log2.setStateDescription(mbwayPaymentRequest.getState().getDescriptionI18N());
            });
            return mbwayPaymentRequest;
        }
        catch (Exception e) {
            boolean isOnlinePaymentsGatewayException = e instanceof OnlinePaymentsGatewayCommunicationException;
            FenixFramework.atomic(() -> {
                log2.logRequestReceiveDateAndData(null, false, false, null, null);
                log2.logException(e);
                if (isOnlinePaymentsGatewayException) {
                    OnlinePaymentsGatewayCommunicationException onlineException = (OnlinePaymentsGatewayCommunicationException)((Object)((Object)e));
                    log2.saveRequest(onlineException.getRequestLog());
                    log2.saveResponse(onlineException.getResponseLog());
                }
            });
            if (e instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)e;
            }
            String message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor." + (isOnlinePaymentsGatewayException ? "gateway.communication" : "unknown");
            throw new TreasuryDomainException((Throwable)e, message, new String[0]);
        }
    }

    public PaymentTransaction processPaymentReferenceCodeTransaction(SibsPaymentsGatewayLog sibsPaymentsGatewayLog, PaymentStateBean paymentStateBean) {
        return (PaymentTransaction)((Object)advice$processPaymentReferenceCodeTransaction.perform((Callable)new SibsPaymentsGateway$callable$processPaymentReferenceCodeTransaction(this, sibsPaymentsGatewayLog, paymentStateBean)));
    }

    static /* synthetic */ PaymentTransaction advised$processPaymentReferenceCodeTransaction(SibsPaymentsGateway this_, SibsPaymentsGatewayLog log2, PaymentStateBean bean) {
        SibsPaymentRequest paymentRequest = (SibsPaymentRequest)((Object)log2.getPaymentRequest());
        if (!bean.getMerchantTransactionId().equals(paymentRequest.getMerchantTransactionId())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.merchantTransactionId.not.equal", new String[0]);
        }
        FenixFramework.atomic(() -> log2.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)paymentRequest)))));
        BigDecimal paidAmount = bean.getAmount();
        DateTime paymentDate = bean.getPaymentDate();
        FenixFramework.atomic(() -> log2.savePaymentInfo(paidAmount, paymentDate));
        if (paidAmount == null || !TreasuryConstants.isPositive(paidAmount)) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.invalid.amount", new String[0]);
        }
        if (paymentDate == null) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.processPaymentReferenceCodeTransaction.invalid.payment.date", new String[0]);
        }
        String entityReferenceCode = this_.getEntityReferenceCode();
        if (SibsPaymentCodeTransaction.isReferenceProcessingDuplicate(entityReferenceCode, paymentRequest.getReferenceCode(), paymentDate)) {
            FenixFramework.atomic(() -> log2.markAsDuplicatedTransaction());
            return null;
        }
        if (PaymentTransaction.isTransactionDuplicate(bean.getTransactionId())) {
            FenixFramework.atomic(() -> log2.markAsDuplicatedTransaction());
            return null;
        }
        return paymentRequest.processPayment(paidAmount, paymentDate, bean.getTransactionId(), null, bean.getMerchantTransactionId(), new DateTime(), null, true);
    }

    public PaymentTransaction processMbwayTransaction(SibsPaymentsGatewayLog sibsPaymentsGatewayLog, PaymentStateBean paymentStateBean) {
        return (PaymentTransaction)((Object)advice$processMbwayTransaction.perform((Callable)new SibsPaymentsGateway$callable$processMbwayTransaction(this, sibsPaymentsGatewayLog, paymentStateBean)));
    }

    static /* synthetic */ PaymentTransaction advised$processMbwayTransaction(SibsPaymentsGateway this_, SibsPaymentsGatewayLog log2, PaymentStateBean bean) {
        MbwayRequest request = (MbwayRequest)((Object)log2.getPaymentRequest());
        if (!bean.getMerchantTransactionId().equals(request.getMerchantTransactionId())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.merchantTransactionId.not.equal", new String[0]);
        }
        BigDecimal paidAmount = bean.getAmount();
        DateTime paymentDate = bean.getPaymentDate();
        FenixFramework.atomic(() -> log2.savePaymentInfo(paidAmount, paymentDate));
        if (paidAmount == null || !TreasuryConstants.isPositive(paidAmount)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.invalid.amount", new String[0]);
        }
        if (paymentDate == null) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.invalid.payment.date", new String[0]);
        }
        if (PaymentTransaction.isTransactionDuplicate(bean.getTransactionId())) {
            FenixFramework.atomic(() -> log2.markAsDuplicatedTransaction());
            return null;
        }
        try {
            return (PaymentTransaction)((Object)FenixFramework.atomic(() -> {
                Set<SettlementNote> settlementNotes = request.processPayment(paidAmount, paymentDate, bean.getTransactionId(), bean.getMerchantTransactionId());
                PaymentTransaction transaction = PaymentTransaction.create((PaymentRequest)((Object)((Object)((Object)request))), bean.getTransactionId(), paymentDate, paidAmount, settlementNotes);
                return transaction;
            }));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PaymentTransaction processMbwayTransaction(PaymentRequestLog log2, DigitalPlatformResultBean bean) {
        return this.processMbwayTransaction((SibsPaymentsGatewayLog)((Object)log2), (PaymentStateBean)bean);
    }

    private static SibsPaymentsGatewayLog createLog(String string) {
        return (SibsPaymentsGatewayLog)((Object)advice$createLog.perform((Callable)new SibsPaymentsGateway$callable$createLog(string)));
    }

    static /* synthetic */ SibsPaymentsGatewayLog advised$createLog(String sibsGatewayMerchantTransactionId) {
        return SibsPaymentsGatewayLog.createForMbwayPaymentRequest(sibsGatewayMerchantTransactionId);
    }

    @Override
    public ForwardPaymentRequest createForwardPaymentRequest(SettlementNoteBean settlementNoteBean, Function<ForwardPaymentRequest, String> function, Function<ForwardPaymentRequest, String> function2) {
        return (ForwardPaymentRequest)((Object)advice$createForwardPaymentRequest.perform((Callable)new SibsPaymentsGateway$callable$createForwardPaymentRequest(this, settlementNoteBean, function, function2)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ ForwardPaymentRequest advised$createForwardPaymentRequest(SibsPaymentsGateway this_, SettlementNoteBean bean, Function successUrlFunction, Function insuccessUrlFunction) {
        Set debitEntries = bean.getIncludedInvoiceEntryBeans().stream().map(ISettlementInvoiceEntryBean::getInvoiceEntry).filter(i -> i != null).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set installments = bean.getIncludedInvoiceEntryBeans().stream().filter(i -> i instanceof InstallmentPaymenPlanBean && i.isIncluded()).map(InstallmentPaymenPlanBean.class::cast).map(ib -> ib.getInstallment()).collect(Collectors.toSet());
        ForwardPaymentRequest paymentRequest = null;
        try {
            paymentRequest = (ForwardPaymentRequest)((Object)FenixFramework.atomic(() -> ForwardPaymentRequest.create(bean.getDigitalPaymentPlatform(), bean.getDebtAccount(), debitEntries, installments, bean.getTotalAmountToPay(), successUrlFunction, insuccessUrlFunction)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this_.prepareCheckout(paymentRequest, bean.getAddressBean());
        return paymentRequest;
    }

    @Override
    public PaymentTransaction processPaymentReferenceCodeTransaction(PaymentRequestLog log2, DigitalPlatformResultBean bean) {
        return this.processPaymentReferenceCodeTransaction((SibsPaymentsGatewayLog)((Object)log2), (PaymentStateBean)bean);
    }

    @Override
    public PaymentRequestLog createLogForWebhookNotification() {
        return SibsPaymentsGatewayLog.createLogForWebhookNotification();
    }

    @Override
    public void fillLogForWebhookNotification(PaymentRequestLog paymentRequestLog, DigitalPlatformResultBean digitalPlatformResultBean) {
        SibsPaymentsGatewayLog log2 = (SibsPaymentsGatewayLog)((Object)paymentRequestLog);
        PaymentStateBean bean = (PaymentStateBean)digitalPlatformResultBean;
        log2.logRequestReceiveDateAndData(bean.getTransactionId(), bean.isOperationSuccess(), bean.isPaid(), bean.getPaymentGatewayResultCode(), bean.getPaymentGatewayResultDescription());
        log2.saveRequest(bean.getRequestLog());
        log2.saveMerchantTransactionId(bean.getMerchantTransactionId());
        log2.saveTransactionId(bean.getTransactionId());
        log2.saveReferenceId(bean.getReferencedId());
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPayment(ForwardPaymentRequest forwardPayment) {
        try {
            PaymentStateBean paymentStatusBySibsCheckoutId = this.getPaymentStatusBySibsCheckoutId(forwardPayment.getCheckoutId());
            return this.postProcessPayment(forwardPayment, "", Optional.of(paymentStatusBySibsCheckoutId.getTransactionId()));
        }
        catch (OnlinePaymentsGatewayCommunicationException e) {
            return null;
        }
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPaymentFromWebhook(PaymentRequestLog paymentRequestLog, DigitalPlatformResultBean digitalPlatformResultBean) {
        ForwardPaymentRequest forwardPayment = (ForwardPaymentRequest)((Object)paymentRequestLog.getPaymentRequest());
        SibsPaymentsGatewayLog log2 = (SibsPaymentsGatewayLog)((Object)paymentRequestLog);
        PaymentStateBean bean = (PaymentStateBean)digitalPlatformResultBean;
        try {
            ForwardPaymentStateType stateType = this.translateForwardPaymentStateType(bean.getOperationResultType(), bean.isPaid());
            ForwardPaymentStatusBean result = new ForwardPaymentStatusBean(true, stateType, bean.getPaymentGatewayResultCode(), bean.getPaymentGatewayResultDescription(), "", "");
            result.editTransactionDetails(bean.getTransactionId(), bean.getPaymentDate(), bean.getAmount());
            if (forwardPayment.getState().isPayed() || forwardPayment.getState().isRejected()) {
                FenixFramework.atomic(() -> {
                    log2.setTransactionWithPayment(forwardPayment.getState().isPayed());
                    log2.setOperationCode("processDuplicated");
                    log2.setOperationSuccess(true);
                });
                return new PostProcessPaymentStatusBean(result, forwardPayment.getState(), false);
            }
            if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains(result.getStateType())) {
                return new PostProcessPaymentStatusBean(result, forwardPayment.getState(), false);
            }
            PostProcessPaymentStatusBean returnBean = new PostProcessPaymentStatusBean(result, forwardPayment.getState(), result.isInPayedState());
            returnBean.getForwardPaymentStatusBean().defineSibsOnlinePaymentBrands(bean.getPaymentBrand());
            FenixFramework.atomic(() -> {
                if (StringUtils.isEmpty((String)forwardPayment.getTransactionId())) {
                    forwardPayment.setTransactionId(bean.getTransactionId());
                }
            });
            if (forwardPayment.getState().isPayed() || forwardPayment.getState().isRejected()) {
                FenixFramework.atomic(() -> {
                    log2.setTransactionWithPayment(forwardPayment.getState().isPayed());
                    log2.setOperationCode("processDuplicated");
                    log2.setOperationSuccess(true);
                });
                return new PostProcessPaymentStatusBean(result, forwardPayment.getState(), false);
            }
            if (bean.isPaid()) {
                FenixFramework.atomic(() -> {
                    forwardPayment.advanceToPaidState(result.getStatusCode(), result.getPayedAmount(), result.getTransactionDate(), result.getTransactionId(), null);
                    log2.setSibsGatewayTransactionId(bean.getTransactionId());
                });
            } else if (!bean.isOperationSuccess()) {
                FenixFramework.atomic(() -> {
                    forwardPayment.reject();
                    log2.setSibsGatewayTransactionId(bean.getTransactionId());
                });
            }
            return returnBean;
        }
        catch (Exception e) {
            FenixFramework.atomic(() -> {
                String requestBody = null;
                String responseBody = null;
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    requestBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getRequestLog();
                    responseBody = ((OnlinePaymentsGatewayCommunicationException)((Object)((Object)e))).getResponseLog();
                }
                this.logException((PaymentRequest)((Object)((Object)((Object)forwardPayment))), e, "processForwardPaymentFromWebhook", "error", "error", requestBody, responseBody);
            });
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    @Override
    public boolean annulPaymentRequestInPlatform(SibsPaymentRequest sibsPaymentRequest) {
        sibsPaymentRequest.setDigitalPaymentPlatformPendingForAnnulment(null);
        return true;
    }
}

