/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentpenalty;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanStateType;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxSettings;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxTreasuryEvent_Base;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.dto.PaymentPenaltyEntryBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.fenixframework.FenixFramework;

public class PaymentPenaltyTaxTreasuryEvent
extends PaymentPenaltyTaxTreasuryEvent_Base {
    public PaymentPenaltyTaxTreasuryEvent() {
    }

    protected PaymentPenaltyTaxTreasuryEvent(FinantialEntity finantialEntity, Product product, LocalizedString description, DebitEntry debitEntry) {
        this();
        super.init(finantialEntity, product, description);
        super.setDebtAccount(debitEntry.getDebtAccount());
        super.setOriginDebitEntry(debitEntry);
        this.checkRules();
    }

    public void checkRules() {
        super.checkRules();
        if (super.getDebtAccount() == null) {
            throw new TreasuryDomainException("error.PaymentPenaltyTaxTreasuryEvent.debtAccount.required", new String[0]);
        }
        if (super.getOriginDebitEntry() == null) {
            throw new TreasuryDomainException("error.PaymentPenaltyTaxTreasuryEvent.originDebitEntry.required", new String[0]);
        }
    }

    public String getERPIntegrationMetadata() {
        return "";
    }

    public LocalDate getTreasuryEventDate() {
        return super.getOriginDebitEntry().getLastPaymentDate().toLocalDate();
    }

    public String getDegreeCode() {
        if (super.getOriginDebitEntry().getTreasuryEvent() != null) {
            return super.getOriginDebitEntry().getTreasuryEvent().getDegreeCode();
        }
        return null;
    }

    public String getDegreeName() {
        if (super.getOriginDebitEntry().getTreasuryEvent() != null) {
            return super.getOriginDebitEntry().getTreasuryEvent().getDegreeName();
        }
        return null;
    }

    public String getExecutionYearName() {
        if (super.getOriginDebitEntry().getTreasuryEvent() != null) {
            return super.getOriginDebitEntry().getTreasuryEvent().getExecutionYearName();
        }
        return null;
    }

    public void copyDebitEntryInformation(DebitEntry sourceDebitEntry, DebitEntry copyDebitEntry) {
    }

    public Optional<Tariff> findMatchTariff(FinantialEntity finantialEntity, Product product, LocalDate when) {
        return Optional.empty();
    }

    public static Stream<? extends PaymentPenaltyTaxTreasuryEvent> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryEventsSet().stream().filter(e -> e instanceof PaymentPenaltyTaxTreasuryEvent).map(PaymentPenaltyTaxTreasuryEvent.class::cast);
    }

    public static Stream<? extends PaymentPenaltyTaxTreasuryEvent> find(DebitEntry originDebitEntry) {
        return originDebitEntry.getPaymentPenaltyTaxTreasuryEventSet().stream();
    }

    public static PaymentPenaltyEntryBean calculatePaymentPenaltyTax(DebitEntry originDebitEntry, LocalDate lastPaymentDate) {
        return PaymentPenaltyTaxTreasuryEvent.calculatePaymentPenaltyTax(originDebitEntry, lastPaymentDate, new LocalDate());
    }

    public static PaymentPenaltyEntryBean calculatePaymentPenaltyTax(DebitEntry originDebitEntry, LocalDate lastPaymentDate, LocalDate whenDebtCreationDate) {
        if (!PaymentPenaltyTaxTreasuryEvent.shouldPenaltyBeCreatedForDebitEntry(originDebitEntry, lastPaymentDate)) {
            return null;
        }
        PaymentPenaltyTaxSettings settings = PaymentPenaltyTaxSettings.findActiveForOriginDebitEntry(originDebitEntry).findFirst().orElse(null);
        Tariff tariff = null;
        tariff = originDebitEntry.getTreasuryEvent() != null ? (Tariff)originDebitEntry.getTreasuryEvent().findMatchTariff(settings.getFinantialEntity(), settings.getPenaltyProduct(), lastPaymentDate).orElse(null) : (Tariff)Tariff.find(settings.getPenaltyProduct(), lastPaymentDate.toDateTimeAtStartOfDay()).filter(t -> t.getFinantialEntity() == settings.getFinantialEntity()).filter(t -> t.isBroadTariffForFinantialEntity()).findFirst().orElse(null);
        if (tariff == null) {
            throw new TreasuryDomainException("error.PaymentPenaltyTaxTreasuryEvent.checkAndCreatePaymentPenaltyTax.tariff.not.found", new String[0]);
        }
        if (tariff.getFinantialEntity().getFinantialInstitution() != originDebitEntry.getDebtAccount().getFinantialInstitution()) {
            throw new TreasuryDomainException("error.PaymentPenaltyTaxTreasuryEvent.checkAndCreatePaymentPenaltyTax.finantialInstitution.does.not.match", new String[0]);
        }
        BigDecimal totalAmount = tariff.amountToPay();
        LocalDate dueDate = tariff.dueDate(lastPaymentDate);
        LocalizedString emolumentDescription = settings.buildEmolumentDescription(originDebitEntry);
        return new PaymentPenaltyEntryBean(originDebitEntry, emolumentDescription.getContent(TreasuryConstants.DEFAULT_LANGUAGE), dueDate, totalAmount);
    }

    public static DebitEntry checkAndCreatePaymentPenaltyTax(DebitEntry originDebitEntry, LocalDate lastPaymentDate, DebitNote debitNote, boolean preventSibsPaymentRequest) {
        return PaymentPenaltyTaxTreasuryEvent.checkAndCreatePaymentPenaltyTax(originDebitEntry, lastPaymentDate, new LocalDate(), debitNote, preventSibsPaymentRequest);
    }

    public static DebitEntry checkAndCreatePaymentPenaltyTax(DebitEntry originDebitEntry, LocalDate lastPaymentDate, LocalDate whenDebtCreationDate, DebitNote debitNote, boolean preventSibsPaymentRequest) {
        if (!PaymentPenaltyTaxTreasuryEvent.shouldPenaltyBeCreatedForDebitEntry(originDebitEntry, lastPaymentDate)) {
            return null;
        }
        PaymentPenaltyTaxSettings settings = PaymentPenaltyTaxSettings.findActiveForOriginDebitEntry(originDebitEntry).findFirst().orElse(null);
        PaymentPenaltyTaxTreasuryEvent paymentPenaltyTaxTreasuryEvent = PaymentPenaltyTaxTreasuryEvent.find(originDebitEntry).filter(t -> !t.isChargedWithDebitEntry()).findFirst().orElse(null);
        if (paymentPenaltyTaxTreasuryEvent == null) {
            LocalizedString emolumentDescription = settings.buildEmolumentDescription(originDebitEntry);
            paymentPenaltyTaxTreasuryEvent = new PaymentPenaltyTaxTreasuryEvent(settings.getFinantialEntity(), settings.getPenaltyProduct(), emolumentDescription, originDebitEntry);
        }
        Tariff tariff = null;
        if (originDebitEntry.getTreasuryEvent() != null) {
            tariff = originDebitEntry.getTreasuryEvent().findMatchTariff(settings.getFinantialEntity(), settings.getPenaltyProduct(), whenDebtCreationDate).orElse(null);
        }
        if (tariff == null) {
            tariff = Tariff.find(settings.getPenaltyProduct(), whenDebtCreationDate.toDateTimeAtStartOfDay()).filter(t -> t.getFinantialEntity() == settings.getFinantialEntity()).filter(t -> t.isBroadTariffForFinantialEntity()).findFirst().orElse(null);
        }
        if (tariff == null) {
            throw new TreasuryDomainException("error.PaymentPenaltyTaxTreasuryEvent.checkAndCreatePaymentPenaltyTax.tariff.not.found", new String[0]);
        }
        if (tariff.getFinantialEntity().getFinantialInstitution() != originDebitEntry.getDebtAccount().getFinantialInstitution()) {
            throw new TreasuryDomainException("error.PaymentPenaltyTaxTreasuryEvent.checkAndCreatePaymentPenaltyTax.finantialInstitution.does.not.match", new String[0]);
        }
        DebtAccount debtAccount = originDebitEntry.getDebtAccount();
        FinantialInstitution finantialInstitution = debtAccount.getFinantialInstitution();
        if (debitNote == null) {
            DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), finantialInstitution).get();
            debitNote = DebitNote.create(settings.getFinantialEntity(), debtAccount, null, documentNumberSeries, whenDebtCreationDate.toDateTimeAtStartOfDay(), whenDebtCreationDate, null, Collections.emptyMap(), null, null);
        }
        BigDecimal totalAmount = tariff.amountToPay();
        LocalDate dueDate = tariff.dueDate(lastPaymentDate);
        LocalDate effectiveWhen = lastPaymentDate;
        if (DueDateCalculationType.FIXED_DATE == tariff.getDueDateCalculationType() && dueDate.isBefore((ReadablePartial)lastPaymentDate)) {
            effectiveWhen = dueDate;
        }
        Vat vat = Vat.findActiveUnique(settings.getPenaltyProduct().getVatType(), finantialInstitution, effectiveWhen.toDateTimeAtStartOfDay()).get();
        DebitEntry penaltyDebitEntry = DebitEntry.create(tariff.getFinantialEntity(), debtAccount, (TreasuryEvent)((Object)paymentPenaltyTaxTreasuryEvent), vat, totalAmount, dueDate, Collections.emptyMap(), settings.getPenaltyProduct(), paymentPenaltyTaxTreasuryEvent.getDescription().getContent(TreasuryConstants.DEFAULT_LANGUAGE), BigDecimal.ONE, tariff.getInterestRate(), effectiveWhen.toDateTimeAtStartOfDay(), false, false, debitNote);
        Map map = penaltyDebitEntry.getPropertiesMap();
        map.put("LAST_PAYMENT_DATE", lastPaymentDate.toString("yyyy/MM/dd"));
        map.put("ORIGIN_DEBIT_ENTRY_DUE_DATE", originDebitEntry.getDueDate().toString("yyyy/MM/dd"));
        penaltyDebitEntry.editPropertiesMap(map);
        if (!preventSibsPaymentRequest && Boolean.TRUE.equals(settings.getCreatePaymentCode())) {
            HashSet<DebitEntry> debitEntriesSet = new HashSet<DebitEntry>();
            debitEntriesSet.add(penaltyDebitEntry);
            if (Boolean.TRUE.equals(settings.getIncludePendingInterestsToPaymentCode())) {
                debitEntriesSet.addAll(originDebitEntry.getInterestDebitEntriesSet().stream().filter(d -> d.isInDebt()).collect(Collectors.toSet()));
            }
            ISibsPaymentCodePoolService.getDefaultDigitalPaymentPlatform(tariff.getFinantialEntity()).createSibsPaymentRequest(debtAccount, debitEntriesSet, Collections.emptySet());
        }
        return penaltyDebitEntry;
    }

    private static boolean shouldPenaltyBeCreatedForDebitEntry(DebitEntry originDebitEntry, LocalDate lastPaymentDate) {
        if (PaymentPenaltyTaxSettings.findActiveForOriginDebitEntry(originDebitEntry).count() > 1L) {
            throw new TreasuryDomainException("error.PaymentPenaltyTaxTreasuryEvent.more.than.one.configuration.active.for.origin.debit.entry", new String[0]);
        }
        PaymentPenaltyTaxSettings settings = PaymentPenaltyTaxSettings.findActiveForOriginDebitEntry(originDebitEntry).findFirst().orElse(null);
        if (settings == null) {
            return false;
        }
        if (originDebitEntry.getOpenPaymentPlan() != null) {
            return false;
        }
        boolean hasSettlementInValidPaymentPlan = originDebitEntry.getSettlementEntriesSet().stream().filter(se -> !se.getFinantialDocument().isAnnulled()).filter(se -> se.getSettlementNote().getPaymentDate().toLocalDate().isEqual((ReadablePartial)lastPaymentDate)).flatMap(se -> se.getInstallmentSettlementEntriesSet().stream()).filter(ise -> !ise.getInstallmentEntry().getInstallment().getDueDate().isBefore((ReadablePartial)lastPaymentDate)).anyMatch(ise -> ise.getInstallmentEntry().getInstallment().getPaymentPlan().getState() != PaymentPlanStateType.ANNULED);
        if (hasSettlementInValidPaymentPlan) {
            return false;
        }
        if (originDebitEntry.getInterestRate() == null && !Boolean.TRUE.equals(settings.getApplyPenaltyOnDebitsWithoutInterest())) {
            return false;
        }
        if (!originDebitEntry.getDueDate().isBefore((ReadablePartial)lastPaymentDate)) {
            return false;
        }
        return !PaymentPenaltyTaxTreasuryEvent.find(originDebitEntry).anyMatch(t -> t.isChargedWithDebitEntry());
    }

    public static Set<DebitEntry> checkAndCreatePaymentPenaltyTaxesFromSettlementNote(SettlementNote settlementNote) {
        HashSet<DebitEntry> result = new HashSet<DebitEntry>();
        LocalDate now = new LocalDate();
        for (SettlementEntry s : settlementNote.getSettlemetEntries().collect(Collectors.toSet())) {
            DebitEntry penaltyDebitEntry;
            DateTime lastPaymentDate;
            DebitEntry d;
            InvoiceEntry invoiceEntry = s.getInvoiceEntry();
            if (!(invoiceEntry instanceof DebitEntry) || (d = (DebitEntry)((Object)invoiceEntry)).isInDebt() || (lastPaymentDate = d.getLastPaymentDate()) == null || PaymentPenaltyTaxTreasuryEvent.isDebitEntrySettledWithOwnCredit(s, settlementNote) || TreasuryDebtProcessMainService.isInterestCreationWhenTotalSettledPrevented(invoiceEntry) || (penaltyDebitEntry = PaymentPenaltyTaxTreasuryEvent.checkAndCreatePaymentPenaltyTax(d, lastPaymentDate.toLocalDate(), now, null, false)) != null) continue;
            result.add(penaltyDebitEntry);
        }
        return result;
    }

    private static boolean isDebitEntrySettledWithOwnCredit(SettlementEntry debitEntrySettlementEntry, SettlementNote settlementNote) {
        return settlementNote.getSettlemetEntries().filter(s -> s != debitEntrySettlementEntry).filter(s -> s.getInvoiceEntry().isCreditNoteEntry()).anyMatch(s -> ((CreditEntry)((Object)((Object)((Object)s.getInvoiceEntry())))).getDebitEntry() == debitEntrySettlementEntry.getInvoiceEntry());
    }
}

